/*
 * Decompiled with CFR 0.152.
 */
package com.sas.visuals.util;

import com.sas.visuals.util.XMLCommandEvent;
import com.sas.visuals.util.XMLCommandListener;
import com.sas.visuals.util.XMLHelpEvent;
import com.sas.visuals.util.XMLHelpListener;
import com.sas.visuals.util.XMLResourceLocator;
import com.sas.visuals.util.XMLSimpleLocator;
import com.sas.visuals.util.XMLToolFactory;
import com.sas.visuals.util.XMLToolItem;
import com.sas.visuals.util.XMLToolParent;
import com.sas.visuals.util.XMLUtility;
import com.sas.visuals.util.XMLVisualException;
import com.sas.visuals.util.XMLVisualRuntimeException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.event.EventListenerList;

public class XMLToolBar
extends JToolBar
implements XMLHelpListener,
XMLToolParent {
    public static final int DEFAULT = 0;
    public static final int FLAT = 1;
    XMLToolFactory toolFactory = null;
    EventListenerList listenerList = new EventListenerList();
    int toolbarStyle = 0;

    public XMLToolBar(String xmlFile, String xmlPath, String imgPath) throws XMLVisualException {
        try {
            this.toolFactory = new XMLToolFactory(XMLUtility.urlFromFile(xmlFile), new XMLSimpleLocator(imgPath), new XMLSimpleLocator(xmlPath), this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLToolBar(String xmlFile, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator) throws XMLVisualException {
        try {
            this.toolFactory = new XMLToolFactory(XMLUtility.urlFromFile(xmlFile), imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLToolBar(URL xmlStream, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator) throws XMLVisualException {
        try {
            this.toolFactory = new XMLToolFactory(xmlStream, imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLToolBar(String xmlFile, String xmlPath, String imgPath, int style) throws XMLVisualException {
        try {
            this.toolbarStyle = style;
            if (style == 1) {
                this.setRollover(true);
            }
            this.toolFactory = new XMLToolFactory(XMLUtility.urlFromFile(xmlFile), new XMLSimpleLocator(imgPath), new XMLSimpleLocator(xmlPath), this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLToolBar(String xmlFile, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator, int style) throws XMLVisualException {
        try {
            this.toolbarStyle = style;
            if (style == 1) {
                this.setRollover(true);
            }
            this.toolFactory = new XMLToolFactory(XMLUtility.urlFromFile(xmlFile), imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    public XMLToolBar(URL xmlStream, XMLResourceLocator xmlLocator, XMLResourceLocator imgLocator, int style) throws XMLVisualException {
        try {
            this.toolbarStyle = style;
            if (style == 1) {
                this.setRollover(true);
            }
            this.toolFactory = new XMLToolFactory(xmlStream, imgLocator, xmlLocator, this, this);
        }
        catch (Exception e) {
            throw new XMLVisualException(e.toString());
        }
    }

    @Override
    public void displayHelp(XMLHelpEvent e) {
        this.fireHelpListener(e, e.getHelp(), true);
    }

    @Override
    public void unDisplayHelp(XMLHelpEvent e) {
        this.fireHelpListener(e, e.getHelp(), false);
    }

    public void processCommand(ActionEvent e, String cmd) {
        this.fireCommandListener(e, cmd);
    }

    public void addCommandListener(XMLCommandListener l) {
        this.listenerList.add(XMLCommandListener.class, l);
    }

    public void removeCommandListener(XMLCommandListener l) {
        this.listenerList.remove(XMLCommandListener.class, l);
    }

    protected void fireCommandListener(ActionEvent e, String cmd) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != XMLCommandListener.class) continue;
            XMLCommandEvent ce = new XMLCommandEvent(e.getSource(), 0, cmd);
            ((XMLCommandListener)listeners[i + 1]).processCommand(ce);
        }
    }

    protected void fireHelpListener(ActionEvent e, String help, boolean display) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != XMLHelpListener.class) continue;
            XMLHelpEvent helpEvent = new XMLHelpEvent(e.getSource(), 0, help);
            if (display) {
                ((XMLHelpListener)listeners[i + 1]).displayHelp(helpEvent);
                continue;
            }
            ((XMLHelpListener)listeners[i + 1]).unDisplayHelp(helpEvent);
        }
    }

    public void addHelpListener(XMLHelpListener l) {
        this.listenerList.add(XMLHelpListener.class, l);
    }

    public void removeHelpListener(XMLHelpListener l) {
        this.listenerList.remove(XMLHelpListener.class, l);
    }

    public boolean getSelectedItemsState(String itemid) throws XMLVisualRuntimeException {
        ArrayList victor = this.toolFactory.getToolList();
        for (int i = 0; i < victor.size(); ++i) {
            XMLToolItem toolItem = (XMLToolItem)victor.get(i);
            if (toolItem.getItemId() == null || !toolItem.getItemId().equals(itemid)) continue;
            return toolItem.getState();
        }
        throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
    }

    public boolean getItemsState(String itemid) throws XMLVisualRuntimeException {
        ArrayList v = this.toolFactory.getToolList();
        for (int i = 0; i < v.size(); ++i) {
            XMLToolItem toolItem = (XMLToolItem)v.get(i);
            if (toolItem.getItemId() == null || !toolItem.getItemId().equals(itemid)) continue;
            return toolItem.getEnabled();
        }
        throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
    }

    public boolean getItemsVisible(String itemid) throws XMLVisualRuntimeException {
        ArrayList v = this.toolFactory.getToolList();
        for (int i = 0; i < v.size(); ++i) {
            XMLToolItem toolItem = (XMLToolItem)v.get(i);
            if (toolItem.getItemId() == null || !toolItem.getItemId().equals(itemid)) continue;
            return toolItem.isVisible();
        }
        throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
    }

    public void setSelectedItemsState(String itemid, boolean flag) throws XMLVisualRuntimeException {
        boolean itemFound = false;
        ArrayList victor = this.toolFactory.getToolList();
        for (int i = 0; i < victor.size(); ++i) {
            XMLToolItem toolItem = (XMLToolItem)victor.get(i);
            if (toolItem.getItemId() == null || !toolItem.getItemId().equals(itemid)) continue;
            toolItem.setState(flag);
            itemFound = true;
        }
        if (!itemFound) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
    }

    public void setItemsState(String itemid, boolean flag) throws XMLVisualRuntimeException {
        boolean itemFound = false;
        ArrayList victor = this.toolFactory.getToolList();
        if (victor == null) {
            return;
        }
        for (int i = 0; i < victor.size(); ++i) {
            XMLToolItem btn = (XMLToolItem)victor.get(i);
            if (btn.getItemId() == null || !btn.getItemId().equals(itemid)) continue;
            btn.setEnabled(flag);
            itemFound = true;
        }
        if (!itemFound) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
    }

    public void remove(String itemid) throws XMLVisualRuntimeException {
        boolean itemFound = false;
        ArrayList victor = this.toolFactory.getToolList();
        if (victor == null) {
            return;
        }
        for (int i = 0; i < victor.size(); ++i) {
            XMLToolItem btn = (XMLToolItem)victor.get(i);
            if (btn.getItemId() == null || !btn.getItemId().equals(itemid)) continue;
            this.remove((Component)((Object)btn));
            itemFound = true;
        }
        if (!itemFound) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
    }

    public void setItemsVisible(String id, boolean flag) throws XMLVisualRuntimeException {
        boolean itemFound = false;
        ArrayList victor = this.toolFactory.getToolList();
        if (victor == null) {
            return;
        }
        for (int i = 0; i < victor.size(); ++i) {
            XMLToolItem btn = (XMLToolItem)victor.get(i);
            if (btn.getItemId() == null || !btn.getItemId().equals(id)) continue;
            btn.setVisible(flag);
            itemFound = true;
        }
        if (!itemFound) {
            throw new XMLVisualRuntimeException("Item " + id + " not found.");
        }
    }

    public ArrayList getToolItems() {
        return this.toolFactory.getToolList();
    }

    public ArrayList getToolItemsById(String itemid) {
        ArrayList<XMLToolItem> toolItems = new ArrayList<XMLToolItem>();
        ArrayList victor = this.toolFactory.getToolList();
        for (int i = 0; i < victor.size(); ++i) {
            XMLToolItem toolItem = (XMLToolItem)victor.get(i);
            if (toolItem.getItemId() == null || !toolItem.getItemId().equals(itemid)) continue;
            toolItems.add(toolItem);
        }
        return toolItems;
    }

    public void addAction(String itemid, ActionListener action) throws XMLVisualRuntimeException {
        ArrayList a = this.getToolItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((XMLToolItem)a.get(i)).addActionListener(action);
        }
    }

    public void addActionListener(String itemid, ActionListener action) throws XMLVisualRuntimeException {
        ArrayList a = this.getToolItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((XMLToolItem)a.get(i)).addActionListener(action);
        }
    }

    public void removeActionListener(String itemid, ActionListener action) throws XMLVisualRuntimeException {
        ArrayList a = this.getToolItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((XMLToolItem)a.get(i)).removeActionListener(action);
        }
    }

    public void addAction(String itemid, Action action) throws XMLVisualRuntimeException {
        ArrayList a = this.getToolItemsById(itemid);
        if (a.size() < 1) {
            throw new XMLVisualRuntimeException("Item " + itemid + " not found.");
        }
        for (int i = 0; i < a.size(); ++i) {
            ((XMLToolItem)a.get(i)).setAction(action);
        }
    }

    public void addDynamicTool(String dynamicid, String xmlStream) throws XMLVisualRuntimeException {
        try {
            this.toolFactory.addDynamicTool(dynamicid, xmlStream);
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void addDynamicTool(String dynamicid, Component item) throws XMLVisualRuntimeException {
        try {
            this.toolFactory.addDynamicTool(dynamicid, item);
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void addDynamicTool(String dynamicid, Component item, int pos) throws XMLVisualRuntimeException {
        try {
            this.toolFactory.addDynamicTool(dynamicid, item, pos);
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void removeDynamicTool(String dynamicid) throws XMLVisualRuntimeException {
        try {
            this.toolFactory.removeDynamicTool(dynamicid);
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public void removeDynamicTool(String dynamicid, JComponent item) throws XMLVisualRuntimeException {
        try {
            this.toolFactory.removeDynamicTool(dynamicid, item);
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            throw new XMLVisualRuntimeException(e.toString());
        }
    }

    public int getDynamicToolPos(String dynamicid, JComponent item) {
        return this.toolFactory.getDynamicToolPos(dynamicid, item);
    }

    public int getToolbarStyle() {
        return this.toolbarStyle;
    }

    @Override
    public void addItem(Component component) {
        this.add(component);
    }
}

