/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.simple;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.messages.MIRProfilerPartnerSDK.PPSDK;
import MITI.sdk.MIRArgument;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataAttribute;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementMap;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperation;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRSummaryMap;
import MITI.sdk.MIRTransformation;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.ProfilerOptions;
import MITI.sdk.profiles.ReferenceProfileLink;
import MITI.sdk.profiles.SummaryLineageProfileLink;
import MITI.sdk.profiles.impl.memory.ProfilerImpl;
import MITI.sdk.profiles.impl.memory.StitchingResults;
import MITI.sdk.profiles.impl.memory.SynonymChain;
import MITI.sdk.profiles.impl.memory.SynonymIdentifier;
import MITI.sdk.profiles.impl.memory.TraverseModel;
import MITI.sdk.profiles.impl.memory.Util;
import MITI.sdk.profiles.impl.memory.simple.AggregationLinkProfiler;
import MITI.sdk.profiles.impl.memory.simple.DeferredLineageProfileLink;
import MITI.sdk.profiles.impl.memory.simple.MultiModelProfiler;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.stitching.Stitching;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.Stack;

public class SubModelProfiler {
    private MultiModelProfiler multiModelProfiler;
    private ProfilerImpl profiler;
    private MIRContent content;
    private ProfiledObject root;
    private ProfiledObject profiledModel;
    private AggregationLinkProfiler aggProfiler;
    private boolean isLoaded;
    private List<MIRConnection> suppliers = new ArrayList<MIRConnection>();
    private Set<ObjectIdentifier> validObjectIds;
    private Set<ProfiledObject> objectsWithReferenceLinks;
    private Queue<DeferredLineageProfileLink> deferredLinks = new LinkedList<DeferredLineageProfileLink>();
    private Map<String, MIRStoredProcedure> operationsById = new HashMap<String, MIRStoredProcedure>();

    public SubModelProfiler(MultiModelProfiler multiModelProfiler, MIRContent mIRContent, ProfiledObject profiledObject, ProfiledObject profiledObject2) {
        this.multiModelProfiler = multiModelProfiler;
        this.profiler = this.multiModelProfiler.getProfiler();
        this.content = mIRContent;
        this.root = profiledObject2;
        this.aggProfiler = null;
        this.isLoaded = false;
        this.validObjectIds = null;
    }

    public MIRContent getContent() {
        return this.content;
    }

    public void load() throws MIRException {
        if (!this.isLoaded) {
            this.multiModelProfiler.getProfiler().load(this.content);
            this.isLoaded = true;
        }
        MIRModel mIRModel = this.content.getModel();
        this.profiledModel = this.multiModelProfiler.getProfiler().getObject(mIRModel);
        if (this.profiledModel == null) {
            throw new MIRException(PRFLR.ERR_MODEL_NOT_IN_PROFILE.getMessage(this.root.toString()));
        }
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRModel, (short)67, "Operation Id", (byte)0, "ALL", "", "SQL_VARCHAR", false);
        if (mIRPropertyType != null) {
            for (MIRPropertyValue mIRPropertyValue : mIRPropertyType.getInstanciatedPropertyValues()) {
                String string = mIRPropertyValue.getValue();
                MIRElement mIRElement = mIRPropertyValue.getElement();
                if (!(mIRElement instanceof MIRStoredProcedure)) continue;
                this.operationsById.put(string, (MIRStoredProcedure)mIRElement);
            }
        }
    }

    public void unload() throws MIRException {
        if (this.isLoaded) {
            PPSDK.DBG_FREEING_MODEL.log(this.content.getName());
            this.multiModelProfiler.getStitcher().unload(this.content);
            this.multiModelProfiler.getProfiler().unload(this.content);
            this.operationsById.clear();
            this.isLoaded = false;
        }
    }

    public void addSupplier(MIRConnection mIRConnection) {
        this.suppliers.add(mIRConnection);
    }

    public List<MIRConnection> getSuppliers() {
        return this.suppliers;
    }

    private MIRConnection getSupplierConnection(String string) {
        for (MIRConnection mIRConnection : this.suppliers) {
            if (!string.equals(mIRConnection.getName())) continue;
            return mIRConnection;
        }
        return null;
    }

    public void processAggregationLinks(ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        PPSDK.INF_PROCESSING_AGGREGATION_LINKS.log(new Object[0]);
        this.aggProfiler = new AggregationLinkProfiler(this.multiModelProfiler, this.root, this.profiledModel, this.suppliers);
        this.aggProfiler.iterate(profileLinkProcessor);
        this.validObjectIds = this.aggProfiler.getObjectIds();
        this.objectsWithReferenceLinks = this.aggProfiler.getObjectsWithReferenceLinks();
    }

    public void processReferenceLinks(ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        PPSDK.INF_PROCESSING_REFERENCE_LINKS.log(new Object[0]);
        for (ProfiledObject profiledObject : this.objectsWithReferenceLinks) {
            this.processReferenceLinks(profiledObject, profileLinkProcessor);
        }
    }

    private void processReferenceLinks(ProfiledObject profiledObject, ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        ProfilerImpl profilerImpl = this.multiModelProfiler.getProfiler();
        MIRProfileEntity mIRProfileEntity = profilerImpl.getProfileEntity(profiledObject);
        MIRProfileGroup mIRProfileGroup = profilerImpl.getProfileGroup(profiledObject);
        ProfiledObject[] profiledObjectArray = profilerImpl.getLinks(profiledObject);
        if (profiledObjectArray != null) {
            for (int i = 0; i < profiledObjectArray.length; ++i) {
                ProfiledObject profiledObject2 = profiledObjectArray[i];
                if (profiledObject2.getLinkType() != 0 && profiledObject2.getLinkType() != 1) continue;
                MIRProfileLink mIRProfileLink = null;
                if (mIRProfileEntity != null) {
                    mIRProfileLink = mIRProfileEntity.getProfileLink(profiledObject2.getLinkId(), profilerImpl.getProfileEntity(profiledObject2));
                } else if (mIRProfileGroup != null) {
                    mIRProfileLink = mIRProfileGroup.getProfileLink(profiledObject2.getLinkId(), profilerImpl.getProfileEntity(profiledObject2));
                }
                if (!this.validObjectIds.contains(profiledObject2.getObjectDefinition())) continue;
                ReferenceProfileLink referenceProfileLink = new ReferenceProfileLink(profiledObject, profiledObject2, mIRProfileLink);
                profileLinkProcessor.process(referenceProfileLink);
            }
        }
    }

    private DeferredLineageProfileLink createDeferredLineageLink(MIRObject mIRObject, MIRObject mIRObject2, LineageProfileLink lineageProfileLink) {
        ObjectIdentifier objectIdentifier = this.profiler.getObjectIdentifier(mIRObject);
        ObjectIdentifier objectIdentifier2 = this.profiler.getObjectIdentifier(mIRObject2);
        DeferredLineageProfileLink deferredLineageProfileLink = new DeferredLineageProfileLink(objectIdentifier, objectIdentifier2, lineageProfileLink);
        return deferredLineageProfileLink;
    }

    public void processLineageLinks(ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        SequencedCollection<MIRElement> sequencedCollection;
        Object object;
        Cloneable cloneable;
        Cloneable cloneable2;
        Object object2;
        PPSDK.INF_PROCESSING_LINEAGE_LINKS.log(new Object[0]);
        MIRObject mIRObject = this.profiler.getMIRObject(this.root.getObjectDefinition());
        TraverseModel traverseModel = new TraverseModel();
        mIRObject.depthTraversal(traverseModel);
        ProfilerOptions profilerOptions = this.multiModelProfiler.getOptions();
        boolean bl = false;
        boolean bl2 = false;
        if (profilerOptions != null) {
            bl = profilerOptions.isSkipSummaryLineage();
            bl2 = profilerOptions.isSkipDetailedLineage();
        }
        Queue<MIRFeature> queue = traverseModel.getFeatures();
        if (!bl2) {
            object2 = traverseModel.getElementMaps();
            while (!object2.isEmpty()) {
                cloneable2 = object2.remove();
                cloneable = ((MIRElementMap)cloneable2).getClientElement();
                object = this.getValidProfiledObject((MIRObject)cloneable);
                if (object == null) continue;
                sequencedCollection = ((MIRElementMap)cloneable2).getSupplierElements();
                for (MIRElement mIRElement : sequencedCollection) {
                    Object object3;
                    ProfiledObject profiledObject = this.getValidProfiledObject(mIRElement);
                    MIRStoreConnection mIRStoreConnection = Util.getStoreConnection(mIRElement);
                    if (mIRStoreConnection != null) {
                        object3 = Util.getStoreConnectionName(mIRStoreConnection);
                        MIRConnection mIRConnection = this.getSupplierConnection((String)object3);
                        if (mIRConnection == null) continue;
                        LineageProfileLink lineageProfileLink = new LineageProfileLink(null, (ProfiledObject)object, ProfileLink.LINK_TYPE.SEMANTIC_LINK);
                        this.setLineageContext(lineageProfileLink, (MIRElement)cloneable2);
                        DeferredLineageProfileLink deferredLineageProfileLink = this.createDeferredLineageLink(mIRElement, (MIRObject)cloneable, lineageProfileLink);
                        this.deferredLinks.add(deferredLineageProfileLink);
                        continue;
                    }
                    if (profiledObject == null) continue;
                    object3 = new LineageProfileLink(profiledObject, (ProfiledObject)object, ProfileLink.LINK_TYPE.SEMANTIC_LINK);
                    this.setLineageContext((LineageProfileLink)object3, (MIRElement)cloneable2);
                    profileLinkProcessor.process((ProfileLink)object3);
                }
            }
        }
        while (!queue.isEmpty()) {
            object2 = queue.remove();
            cloneable2 = new Stack();
            cloneable = new Stack();
            object = new Stack();
            sequencedCollection = new Stack();
            Stack stack = new Stack();
            if (!bl2) {
                this.processLineageLinkDestinationFeatures(profileLinkProcessor, (MIRFeature)object2, (MIRFeature)object2, (Stack<String>)cloneable2, (Stack<String>)cloneable, (Stack<String>)object, (Stack<String>)sequencedCollection, stack, null);
            }
            if (bl) continue;
            this.processLineageLinkSummaryFeatures(profileLinkProcessor, (MIRFeature)object2, (MIRFeature)object2, (Stack<String>)cloneable2, (Stack<String>)cloneable, null);
        }
    }

    protected ProfiledObject getValidProfileObjectWithRedirection(MIRObject mIRObject) throws MIRException {
        ProfiledObject profiledObject = this.getValidProfiledObject(mIRObject);
        if (profiledObject != null) {
            return profiledObject;
        }
        if (mIRObject instanceof MIRFeature) {
            MIRClassifier mIRClassifier = ((MIRFeature)mIRObject).getClassifier();
            MIRStoredProcedure mIRStoredProcedure = null;
            if (mIRObject instanceof MIRDataAttribute && mIRClassifier instanceof MIRDataSet && (mIRStoredProcedure = ((MIRDataSet)mIRClassifier).getParametersOfStoredProcedure()) != null) {
                return this.getRepresentativeProcedureParameter(mIRStoredProcedure, (MIRDataAttribute)mIRObject);
            }
            return this.getRepresentativeClassifier((MIRFeature)mIRObject);
        }
        return profiledObject;
    }

    private ProfiledObject getRepresentativeProcedureParameter(MIRStoredProcedure mIRStoredProcedure, MIRDataAttribute mIRDataAttribute) throws MIRException {
        String string = mIRDataAttribute.getName();
        MIRArgument mIRArgument = mIRStoredProcedure.getArgument(string);
        if (mIRArgument != null) {
            return this.getValidProfiledObject(mIRArgument);
        }
        return null;
    }

    private ProfiledObject getRepresentativeClassifier(MIRFeature mIRFeature) throws MIRException {
        MIRClassifier mIRClassifier = mIRFeature.getClassifier();
        ProfiledObject profiledObject = this.getValidProfiledObject(mIRClassifier);
        if (mIRClassifier.getFeatureCount() > 1) {
            return null;
        }
        return profiledObject;
    }

    protected ProfiledObject getValidProfiledObject(MIRObject mIRObject) throws MIRException {
        ProfiledObject profiledObject = this.profiler.getObject(mIRObject);
        if (profiledObject == null || this.validObjectIds == null || !this.validObjectIds.contains(profiledObject.getObjectDefinition())) {
            return null;
        }
        return profiledObject;
    }

    private void processLineageLinkSummaryFeatures(ProfileLinkProcessor profileLinkProcessor, MIRFeature mIRFeature, MIRFeature mIRFeature2, Stack<String> stack, Stack<String> stack2, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        HashSet<MIRFeature> hashSet = new HashSet<MIRFeature>();
        this.processLineageLinkSummaryFeatures(profileLinkProcessor, mIRFeature, mIRFeature2, stack, stack2, hashSet, lINK_TYPE);
    }

    private void processLineageLinkSummaryFeatures(ProfileLinkProcessor profileLinkProcessor, MIRFeature mIRFeature, MIRFeature mIRFeature2, Stack<String> stack, Stack<String> stack2, Set<MIRFeature> set, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        MIRModelObject mIRModelObject;
        Object object5;
        Object object6;
        Object object7;
        if (set.contains(mIRFeature2)) {
            return;
        }
        set.add(mIRFeature2);
        ProfileLink.LINK_TYPE lINK_TYPE2 = lINK_TYPE == null ? ProfileLink.LINK_TYPE.SUMMARY_LINEAGE : lINK_TYPE;
        Iterator<MIRSummaryMap> iterator = mIRFeature2.getSourceOfSummaryMapIterator();
        while (iterator.hasNext()) {
            object7 = iterator.next();
            this.pushNonEmptyString(((MIRSummaryMap)object7).getOperation(), stack);
            this.pushNonEmptyString(((MIRElement)object7).getDescription(), stack2);
            object6 = ((MIRSummaryMap)object7).getExternalContentId().isEmpty() ? "" : this.profiler.getRuntimeTaskContentPath(((MIRSummaryMap)object7).getExternalContentId());
            object5 = ((MIRSummaryMap)object7).getDestinationFeature();
            if (object5 != null) {
                mIRModelObject = Util.getStoreConnection((MIRObject)object5);
                if (mIRModelObject != null) {
                    object4 = Util.getStoreConnectionName(mIRModelObject);
                    object3 = this.getSupplierConnection((String)object4);
                    if (object3 != null) {
                        object2 = new SummaryLineageProfileLink(null, null, stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_LINEAGE);
                        this.setLineageContext((LineageProfileLink)object2, (MIRElement)object7);
                        ((SummaryLineageProfileLink)object2).setRuntimePath((String)object6);
                        ((SummaryLineageProfileLink)object2).setDecorations(((MIRSummaryMap)object7).getDecorations());
                        object = this.createDeferredLineageLink(mIRFeature, (MIRObject)object5, (LineageProfileLink)object2);
                        this.deferredLinks.add((DeferredLineageProfileLink)object);
                    }
                } else {
                    object4 = this.getValidProfiledObject((MIRObject)object5);
                    if (object4 != null) {
                        object3 = Util.getStoreConnection(mIRFeature);
                        if (object3 == null) {
                            object2 = this.getValidProfiledObject(mIRFeature);
                            if (object2 != null) {
                                object = new SummaryLineageProfileLink((ProfiledObject)object2, (ProfiledObject)object4, stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_LINEAGE);
                                this.setLineageContext((LineageProfileLink)object, (MIRElement)object7);
                                ((SummaryLineageProfileLink)object).setRuntimePath((String)object6);
                                ((SummaryLineageProfileLink)object).setDecorations(((MIRSummaryMap)object7).getDecorations());
                                profileLinkProcessor.process((ProfileLink)object);
                            }
                        } else {
                            object2 = new SummaryLineageProfileLink(null, (ProfiledObject)object4, stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_LINEAGE);
                            this.setLineageContext((LineageProfileLink)object2, (MIRElement)object7);
                            ((SummaryLineageProfileLink)object2).setRuntimePath((String)object6);
                            ((SummaryLineageProfileLink)object2).setDecorations(((MIRSummaryMap)object7).getDecorations());
                            object = this.createDeferredLineageLink(mIRFeature, (MIRObject)object5, (LineageProfileLink)object2);
                            this.deferredLinks.add((DeferredLineageProfileLink)object);
                        }
                    } else {
                        this.processLineageLinkSummaryFeatures(profileLinkProcessor, mIRFeature, (MIRFeature)object5, stack, stack2, set, lINK_TYPE2);
                    }
                }
            }
            stack.pop();
            stack2.pop();
        }
        object7 = mIRFeature2.getControlOfSummaryMapIterator();
        while (object7.hasNext()) {
            object6 = (MIRSummaryMap)object7.next();
            this.pushNonEmptyString(((MIRSummaryMap)object6).getOperation(), stack);
            this.pushNonEmptyString(((MIRElement)object6).getDescription(), stack2);
            object5 = ((MIRSummaryMap)object6).getExternalContentId().isEmpty() ? "" : this.profiler.getRuntimeTaskContentPath(((MIRSummaryMap)object6).getExternalContentId());
            mIRModelObject = ((MIRSummaryMap)object6).getDestinationFeature();
            if (mIRModelObject != null) {
                Object object8;
                object4 = Util.getStoreConnection(mIRModelObject);
                if (object4 != null) {
                    object3 = Util.getStoreConnectionName((MIRStoreConnection)object4);
                    object2 = this.getSupplierConnection((String)object3);
                    if (object2 != null) {
                        object = new SummaryLineageProfileLink(null, null, stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE);
                        this.setLineageContext((LineageProfileLink)object, (MIRElement)object6);
                        ((SummaryLineageProfileLink)object).setRuntimePath((String)object5);
                        ((SummaryLineageProfileLink)object).setDecorations(((MIRSummaryMap)object6).getDecorations());
                        object8 = this.createDeferredLineageLink(mIRFeature, mIRModelObject, (LineageProfileLink)object);
                        this.deferredLinks.add((DeferredLineageProfileLink)object8);
                    }
                } else {
                    object3 = this.getValidProfiledObject(mIRModelObject);
                    if (object3 != null) {
                        object2 = Util.getStoreConnection(mIRFeature);
                        if (object2 == null) {
                            object = this.getValidProfiledObject(mIRFeature);
                            if (object != null) {
                                object8 = new SummaryLineageProfileLink((ProfiledObject)object, (ProfiledObject)object3, stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE);
                                this.setLineageContext((LineageProfileLink)object8, (MIRElement)object6);
                                ((SummaryLineageProfileLink)object8).setRuntimePath((String)object5);
                                ((SummaryLineageProfileLink)object8).setDecorations(((MIRSummaryMap)object6).getDecorations());
                                profileLinkProcessor.process((ProfileLink)object8);
                            }
                        } else {
                            object = new SummaryLineageProfileLink(null, (ProfiledObject)object3, stack, stack2, ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE);
                            this.setLineageContext((LineageProfileLink)object, (MIRElement)object6);
                            ((SummaryLineageProfileLink)object).setRuntimePath((String)object5);
                            ((SummaryLineageProfileLink)object).setDecorations(((MIRSummaryMap)object6).getDecorations());
                            object8 = this.createDeferredLineageLink(mIRFeature, mIRModelObject, (LineageProfileLink)object);
                            this.deferredLinks.add((DeferredLineageProfileLink)object8);
                        }
                    } else {
                        this.processLineageLinkSummaryFeatures(profileLinkProcessor, mIRFeature, (MIRFeature)mIRModelObject, stack, stack2, set, lINK_TYPE2);
                    }
                }
            }
            stack.pop();
            stack2.pop();
        }
    }

    private void processLineageLinkDestinationFeatures(ProfileLinkProcessor profileLinkProcessor, MIRFeature mIRFeature, MIRFeature mIRFeature2, Stack<String> stack, Stack<String> stack2, Stack<String> stack3, Stack<String> stack4, Stack<List<SynonymChain>> stack5, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        HashSet<MIRFeature> hashSet = new HashSet<MIRFeature>();
        this.processLineageLinkDestinationFeatures(profileLinkProcessor, mIRFeature, mIRFeature2, hashSet, stack, stack2, stack3, stack4, stack5, lINK_TYPE);
    }

    private void processLineageLinkDestinationFeatures(ProfileLinkProcessor profileLinkProcessor, MIRFeature mIRFeature, MIRFeature mIRFeature2, Set<MIRFeature> set, Stack<String> stack, Stack<String> stack2, Stack<String> stack3, Stack<String> stack4, Stack<List<SynonymChain>> stack5, ProfileLink.LINK_TYPE lINK_TYPE) throws MIRException {
        Object object;
        Object object2;
        MIRObject mIRObject;
        MIRModelObject mIRModelObject;
        MIRElement mIRElement;
        Object object3;
        if (set.contains(mIRFeature2)) {
            return;
        }
        set.add(mIRFeature2);
        ProfileLink.LINK_TYPE lINK_TYPE2 = lINK_TYPE == null ? ProfileLink.LINK_TYPE.DATA_LINEAGE : lINK_TYPE;
        Iterator<MIRFeatureMap> iterator = mIRFeature2.getSourceOfFeatureMapIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            mIRElement = ((MIRFeatureMap)object3).getDestinationFeature();
            this.addFeatureOperations((MIRFeatureMap)object3, stack, stack2);
            this.addClassifierOperations(((MIRFeatureMap)object3).getClassifierMap(), stack3, stack4);
            this.addClassifierSynonyms(((MIRFeatureMap)object3).getClassifierMap(), stack5, true);
            this.addClassifierSynonyms(((MIRFeatureMap)object3).getClassifierMap(), stack5, false);
            if (mIRElement != null) {
                Object object4;
                mIRModelObject = Util.getStoreConnection(mIRElement);
                if (mIRModelObject != null) {
                    object4 = Util.getStoreConnectionName((MIRStoreConnection)mIRModelObject);
                    mIRObject = this.getSupplierConnection((String)object4);
                    if (mIRObject != null) {
                        object2 = new LineageProfileLink(null, null, stack, stack2, stack3, stack4, lINK_TYPE2);
                        this.setLineageContext((LineageProfileLink)object2, (MIRElement)object3);
                        ((LineageProfileLink)object2).setSynonymChains(this.flattenSynonymChains(stack5));
                        object = this.createDeferredLineageLink(mIRFeature, mIRElement, (LineageProfileLink)object2);
                        this.deferredLinks.add((DeferredLineageProfileLink)object);
                    }
                } else {
                    object4 = this.getValidProfileObjectWithRedirection(mIRElement);
                    if (object4 != null) {
                        mIRObject = Util.getStoreConnection(mIRFeature);
                        if (mIRObject == null) {
                            object2 = this.getValidProfileObjectWithRedirection(mIRFeature);
                            if (object2 != null) {
                                object = new LineageProfileLink((ProfiledObject)object2, (ProfiledObject)object4, stack, stack2, stack3, stack4, lINK_TYPE2);
                                this.setLineageContext((LineageProfileLink)object, (MIRElement)object3);
                                ((LineageProfileLink)object).setSynonymChains(this.flattenSynonymChains(stack5));
                                profileLinkProcessor.process((ProfileLink)object);
                            }
                        } else {
                            object2 = new LineageProfileLink(null, (ProfiledObject)object4, stack, stack2, stack3, stack4, lINK_TYPE2);
                            this.setLineageContext((LineageProfileLink)object2, (MIRElement)object3);
                            ((LineageProfileLink)object2).setSynonymChains(this.flattenSynonymChains(stack5));
                            object = this.createDeferredLineageLink(mIRFeature, mIRElement, (LineageProfileLink)object2);
                            this.deferredLinks.add((DeferredLineageProfileLink)object);
                        }
                    } else {
                        this.processLineageLinkDestinationFeatures(profileLinkProcessor, mIRFeature, (MIRFeature)mIRElement, set, stack, stack2, stack3, stack4, stack5, lINK_TYPE2);
                    }
                }
            }
            stack.pop();
            stack2.pop();
            stack3.pop();
            stack4.pop();
            stack5.pop();
            stack5.pop();
        }
        object3 = mIRFeature2.getControlOfFeatureMapIterator();
        while (object3.hasNext()) {
            mIRElement = (MIRFeatureMap)object3.next();
            mIRModelObject = ((MIRFeatureMap)mIRElement).getDestinationFeature();
            boolean bl = mIRFeature2 instanceof MIRCondition && mIRModelObject.getClassifier() == mIRFeature2.getClassifier();
            this.addFeatureOperations((MIRFeatureMap)mIRElement, stack, stack2);
            if (!bl) {
                this.addClassifierOperations(((MIRFeatureMap)mIRElement).getClassifierMap(), stack3, stack4);
                this.addClassifierSynonyms(((MIRFeatureMap)mIRElement).getClassifierMap(), stack5, true);
                this.addClassifierSynonyms(((MIRFeatureMap)mIRElement).getClassifierMap(), stack5, false);
            }
            if (mIRModelObject != null) {
                Object object5;
                mIRObject = Util.getStoreConnection(mIRModelObject);
                if (mIRObject != null) {
                    object2 = Util.getStoreConnectionName(mIRObject);
                    object = this.getSupplierConnection((String)object2);
                    if (object != null) {
                        object5 = new LineageProfileLink(null, null, stack, stack2, stack3, stack4, ProfileLink.LINK_TYPE.CONTROL_LINEAGE);
                        this.setLineageContext((LineageProfileLink)object5, mIRElement);
                        ((LineageProfileLink)object5).setSynonymChains(this.flattenSynonymChains(stack5));
                        DeferredLineageProfileLink deferredLineageProfileLink = this.createDeferredLineageLink(mIRFeature, mIRModelObject, (LineageProfileLink)object5);
                        this.deferredLinks.add(deferredLineageProfileLink);
                    }
                } else {
                    object2 = this.getValidProfileObjectWithRedirection(mIRModelObject);
                    if (object2 != null) {
                        object = new LineageProfileLink(null, (ProfiledObject)object2, stack, stack2, stack3, stack4, ProfileLink.LINK_TYPE.CONTROL_LINEAGE);
                        this.setLineageContext((LineageProfileLink)object, mIRElement);
                        ((LineageProfileLink)object).setSynonymChains(this.flattenSynonymChains(stack5));
                        object5 = this.createDeferredLineageLink(mIRFeature, mIRModelObject, (LineageProfileLink)object);
                        this.deferredLinks.add((DeferredLineageProfileLink)object5);
                    } else {
                        this.processLineageLinkDestinationFeatures(profileLinkProcessor, mIRFeature, (MIRFeature)mIRModelObject, set, stack, stack2, stack3, stack4, stack5, ProfileLink.LINK_TYPE.CONTROL_LINEAGE);
                    }
                }
            }
            stack.pop();
            stack2.pop();
            if (bl) continue;
            stack3.pop();
            stack4.pop();
            stack5.pop();
            stack5.pop();
        }
    }

    private void addFeatureOperations(MIRFeatureMap mIRFeatureMap, Stack<String> stack, Stack<String> stack2) {
        this.pushNonEmptyString(mIRFeatureMap.getOperation(), stack);
        this.pushNonEmptyString(mIRFeatureMap.getDescription(), stack2);
    }

    private void addClassifierOperations(MIRClassifierMap mIRClassifierMap, Stack<String> stack, Stack<String> stack2) {
        this.pushNonEmptyString(mIRClassifierMap.getOperation(), stack);
        this.pushNonEmptyString(mIRClassifierMap.getDescription(), stack2);
    }

    protected void pushNonEmptyString(String string, Stack<String> stack) {
        if (string == null) {
            string = "";
        }
        stack.push(string);
    }

    private void addClassifierSynonyms(MIRClassifierMap mIRClassifierMap, Stack<List<SynonymChain>> stack, boolean bl) throws MIRException {
        MIRModel mIRModel = mIRClassifierMap.getRootModel();
        List<SynonymChain> list = this.getSynonymChains(mIRModel, mIRClassifierMap, bl ? "SourceSynonyms" : "DestinationSynonym");
        stack.push(list);
    }

    private List<SynonymChain> getSynonymChains(MIRModel mIRModel, MIRElement mIRElement, String string) throws MIRException {
        String[] stringArray;
        String string2;
        ArrayList<SynonymChain> arrayList = new ArrayList<SynonymChain>();
        MIRPropertyType mIRPropertyType = MIRUdpLib.fetchPropertyType(mIRModel, mIRElement.getElementType(), string, (byte)0, "Synonym Lineage", "", "SQL_VARCHAR", false, null);
        if (mIRPropertyType != null && (string2 = MIRUdpLib.getPropertyValueValue(mIRPropertyType, mIRElement)) != null && !string2.isEmpty() && (stringArray = string2.split("\r\n")) != null) {
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split("\u2028");
                SynonymChain synonymChain = new SynonymChain();
                if (stringArray2 != null) {
                    for (String string4 : stringArray2) {
                        ProfiledObject profiledObject;
                        MIRNamespaceElement mIRNamespaceElement;
                        SynonymIdentifier synonymIdentifier = SynonymIdentifier.parse(string4);
                        if (synonymIdentifier == null || !(mIRModel instanceof MIRStoreModel) || (mIRNamespaceElement = Util.lookupSynonymObject((MIRStoreModel)mIRModel, synonymIdentifier)) == null || (profiledObject = this.profiler.getObject(mIRNamespaceElement)) == null) continue;
                        synonymChain.addElement(profiledObject);
                    }
                }
                arrayList.add(synonymChain);
            }
        }
        return arrayList;
    }

    private List<List<ProfiledObject>> flattenSynonymChains(Stack<List<SynonymChain>> stack) {
        ArrayList<List<ProfiledObject>> arrayList = new ArrayList<List<ProfiledObject>>();
        for (List list : stack) {
            for (SynonymChain synonymChain : list) {
                arrayList.add(synonymChain.getElements());
            }
        }
        return arrayList;
    }

    private ProfiledObject getProcessNode(MIRFeatureMap mIRFeatureMap) throws MIRException {
        MIROperation mIROperation = mIRFeatureMap.getClassifierMap().getDatabaseOperation();
        if (mIROperation != null) {
            return this.profiler.getObject(mIROperation);
        }
        return null;
    }

    private ProfiledObject getTransformationNode(MIRFeatureMap mIRFeatureMap) throws MIRException {
        MIRTransformation mIRTransformation = mIRFeatureMap.getClassifierMap().getTransformation();
        if (mIRTransformation != null) {
            return this.profiler.getObject(mIRTransformation);
        }
        return null;
    }

    public void processDeferredLineageLinks(MIRConnection mIRConnection, Stitching stitching, SubModelProfiler subModelProfiler, ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        boolean bl = mIRConnection.getSupplierStoreContent().getConnectionOfDirectoryStructureModel() != null;
        boolean bl2 = this.profiler.getOptions().isMergeExternalConnections();
        boolean bl3 = bl ? bl2 : true;
        StitchingResults stitchingResults = new StitchingResults(mIRConnection.getName(), stitching);
        LinkedList<DeferredLineageProfileLink> linkedList = new LinkedList<DeferredLineageProfileLink>();
        while (!this.deferredLinks.isEmpty()) {
            DeferredLineageProfileLink deferredLineageProfileLink = this.deferredLinks.remove();
            DeferredLineageProfileLink.PartialNode partialNode = deferredLineageProfileLink.getSource();
            DeferredLineageProfileLink.PartialNode partialNode2 = deferredLineageProfileLink.getDestination();
            LineageProfileLink lineageProfileLink = deferredLineageProfileLink.getLink();
            this.setDatabaseOperationContext(lineageProfileLink, subModelProfiler);
            if (!partialNode.isResolved()) {
                this.resolveSource(mIRConnection, stitchingResults, subModelProfiler, partialNode, bl3);
            }
            if (!partialNode2.isResolved()) {
                this.resolveDestination(mIRConnection, stitchingResults, subModelProfiler, partialNode2, bl3);
            }
            if (partialNode.isResolved() && partialNode2.isResolved()) {
                for (ProfiledObject profiledObject : partialNode.getResolvedObjects()) {
                    for (ProfiledObject profiledObject2 : partialNode2.getResolvedObjects()) {
                        DeferredLineageProfileLink deferredLineageProfileLink2 = new DeferredLineageProfileLink(deferredLineageProfileLink);
                        LineageProfileLink lineageProfileLink2 = deferredLineageProfileLink2.getLink();
                        lineageProfileLink2.setSourceNode(profiledObject);
                        lineageProfileLink2.setDestinationNode(profiledObject2);
                        profileLinkProcessor.process(lineageProfileLink2);
                    }
                }
                continue;
            }
            linkedList.add(deferredLineageProfileLink);
        }
        this.deferredLinks.addAll(linkedList);
    }

    private void resolveSource(MIRConnection mIRConnection, StitchingResults stitchingResults, SubModelProfiler subModelProfiler, DeferredLineageProfileLink.PartialNode partialNode, boolean bl) throws MIRException {
        ObjectIdentifier objectIdentifier = partialNode.getIdentifier();
        MIRObject mIRObject = this.profiler.getMIRObject(objectIdentifier);
        ProfiledObject profiledObject = this.getValidProfiledObject(mIRObject);
        if (profiledObject == null) {
            MIRStoreConnection mIRStoreConnection = Util.getStoreConnection(mIRObject);
            if (mIRStoreConnection != null && this.matchesCurrentConnection(mIRStoreConnection, mIRConnection)) {
                List<MIRObject> list = stitchingResults.getSuppliers(mIRObject);
                if (list != null) {
                    for (MIRObject mIRObject2 : list) {
                        ProfiledObject profiledObject2 = subModelProfiler.getValidProfiledObject(mIRObject2);
                        if (profiledObject2 == null) continue;
                        partialNode.addResolvedObject(profiledObject2);
                    }
                }
                partialNode.setResolved();
            }
        } else {
            MIRStoreConnection mIRStoreConnection = Util.getStoreConnection(mIRObject);
            if (mIRStoreConnection != null) {
                if (this.matchesCurrentConnection(mIRStoreConnection, mIRConnection)) {
                    List<MIRObject> list = stitchingResults.getSuppliers(mIRObject);
                    if (list != null) {
                        for (MIRObject mIRObject3 : list) {
                            ProfiledObject profiledObject3 = subModelProfiler.getValidProfiledObject(mIRObject3);
                            if (profiledObject3 == null) continue;
                            if (bl) {
                                partialNode.addResolvedObject(profiledObject3);
                                continue;
                            }
                            partialNode.addResolvedObject(profiledObject);
                        }
                    }
                    partialNode.setResolved();
                }
            } else {
                partialNode.addResolvedObject(profiledObject);
                partialNode.setResolved();
            }
        }
    }

    private void resolveDestination(MIRConnection mIRConnection, StitchingResults stitchingResults, SubModelProfiler subModelProfiler, DeferredLineageProfileLink.PartialNode partialNode, boolean bl) throws MIRException {
        ObjectIdentifier objectIdentifier = partialNode.getIdentifier();
        MIRObject mIRObject = this.profiler.getMIRObject(objectIdentifier);
        ProfiledObject profiledObject = this.getValidProfiledObject(mIRObject);
        if (profiledObject == null) {
            MIRStoreConnection mIRStoreConnection = Util.getStoreConnection(mIRObject);
            if (mIRStoreConnection != null && this.matchesCurrentConnection(mIRStoreConnection, mIRConnection)) {
                List<MIRObject> list = stitchingResults.getSuppliers(mIRObject);
                if (list != null) {
                    for (MIRObject mIRObject2 : list) {
                        ProfiledObject profiledObject2 = subModelProfiler.getValidProfiledObject(mIRObject2);
                        if (profiledObject2 == null) continue;
                        partialNode.addResolvedObject(profiledObject2);
                    }
                }
                partialNode.setResolved();
            }
        } else {
            MIRStoreConnection mIRStoreConnection = Util.getStoreConnection(mIRObject);
            if (mIRStoreConnection != null) {
                if (this.matchesCurrentConnection(mIRStoreConnection, mIRConnection)) {
                    List<MIRObject> list = stitchingResults.getSuppliers(mIRObject);
                    if (list != null) {
                        for (MIRObject mIRObject3 : list) {
                            ProfiledObject profiledObject3 = subModelProfiler.getValidProfiledObject(mIRObject3);
                            if (profiledObject3 == null) continue;
                            if (bl) {
                                partialNode.addResolvedObject(profiledObject3);
                                continue;
                            }
                            partialNode.addResolvedObject(profiledObject);
                        }
                    }
                    partialNode.setResolved();
                }
            } else {
                partialNode.addResolvedObject(profiledObject);
                partialNode.setResolved();
            }
        }
    }

    private MIRStoredProcedure getOperationById(String string) {
        MIRStoredProcedure mIRStoredProcedure = this.operationsById.get(string);
        return mIRStoredProcedure;
    }

    private boolean matchesCurrentConnection(MIRStoreConnection mIRStoreConnection, MIRConnection mIRConnection) {
        String string = Util.getStoreConnectionName(mIRStoreConnection);
        return string.equals(mIRConnection.getName());
    }

    private void setDatabaseOperationContext(LineageProfileLink lineageProfileLink, SubModelProfiler subModelProfiler) throws MIRException {
        MIRStoredProcedure mIRStoredProcedure;
        String string;
        if (lineageProfileLink.getDatabaseOperation() == null && this.content.getElementType() == 283 && !(string = this.content.getNativeId()).isEmpty() && subModelProfiler != null && (mIRStoredProcedure = subModelProfiler.getOperationById(string)) != null) {
            ProfiledObject profiledObject = this.profiler.getObject(mIRStoredProcedure);
            lineageProfileLink.setDatabaseOperation(profiledObject);
        }
    }

    private void setLineageContext(LineageProfileLink lineageProfileLink, MIRElement mIRElement) throws MIRException {
        if (mIRElement instanceof MIRFeatureMap) {
            MIRFeatureMap mIRFeatureMap = (MIRFeatureMap)mIRElement;
            lineageProfileLink.setDatabaseOperation(this.getProcessNode(mIRFeatureMap));
            lineageProfileLink.setTransformation(this.getTransformationNode(mIRFeatureMap));
        } else if (mIRElement instanceof MIRSummaryMap || mIRElement instanceof MIRElementMap) {
            // empty if block
        }
        if (lineageProfileLink.getTransformationModel() == null && this.content.getElementType() == 283) {
            lineageProfileLink.setTransformationModel(this.profiledModel);
        }
    }

    public String toString() {
        return "SubModelProfiler [" + this.content.getName() + "]";
    }
}

