/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory.simple;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRProfiler.PRFLR;
import MITI.messages.MIRProfilerPartnerSDK.PPSDK;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.ProfilerOptions;
import MITI.sdk.profiles.impl.memory.ProfilerImpl;
import MITI.sdk.profiles.impl.memory.simple.AggregationLinkProfiler;
import MITI.sdk.profiles.impl.memory.simple.ProfilerModelCache;
import MITI.sdk.profiles.impl.memory.simple.ProfilerSimpleImpl;
import MITI.sdk.profiles.impl.memory.simple.SubModelProfiler;
import MITI.stitching.Stitching;
import MITI.stitching.memory.Stitcher;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MultiModelProfiler {
    private ProfilerSimpleImpl profilerImpl;
    private Stitcher stitcher;
    private AggregationLinkProfiler aggregationLinkProfiler;
    private Map<MIRContent, SubModelProfiler> subModelProfilers = new LinkedHashMap<MIRContent, SubModelProfiler>();

    public MultiModelProfiler(ProfilerSimpleImpl profilerSimpleImpl, ProfiledObject profiledObject) throws MIRException {
        this.profilerImpl = profilerSimpleImpl;
        this.stitcher = new Stitcher(profilerSimpleImpl.getCache());
        this.aggregationLinkProfiler = new AggregationLinkProfiler(this, null, profiledObject, null);
    }

    public ProfilerOptions getOptions() {
        return this.profilerImpl.getOptions();
    }

    protected ProfilerImpl getProfiler() {
        return this.profilerImpl;
    }

    protected Stitcher getStitcher() {
        return this.stitcher;
    }

    public void addSubModelProfiler(MIRContent mIRContent, ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        if (this.subModelProfilers.containsKey(mIRContent)) {
            return;
        }
        SubModelProfiler subModelProfiler = new SubModelProfiler(this, mIRContent, profiledObject, profiledObject2);
        this.subModelProfilers.put(mIRContent, subModelProfiler);
    }

    public SubModelProfiler getSubModelProfiler(MIRContent mIRContent) {
        return this.subModelProfilers.get(mIRContent);
    }

    public void iterate(ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        Comparable<MIR_Object> comparable;
        Object object;
        this.aggregationLinkProfiler.iterate(profileLinkProcessor);
        for (SubModelProfiler object32 : this.subModelProfilers.values()) {
            object = object32.getContent();
            for (MIRConnection n : ((MIRContent)object).getClientOfConnections()) {
                comparable = n.getSupplierStoreContent();
                SubModelProfiler n2 = this.getSubModelProfiler((MIRContent)comparable);
                if (n2 == null) continue;
                object32.addSupplier(n);
            }
        }
        this.printConnectionStatistics();
        Map<String, List<MIRContent>> map = this.detectLoops(true);
        this.printLoopStatistics(map);
        List<SubModelProfiler> list = this.sortSubModelIterators();
        object = this.getOptions();
        boolean bl = false;
        int n = 10;
        if (object != null) {
            bl = ((ProfilerOptions)object).isSkipLineage();
            n = ((ProfilerOptions)object).getCacheSize();
        }
        comparable = new StringBuffer();
        int n2 = 0;
        for (Object object2 : list) {
            Iterator<SubModelProfiler> iterator = ((SubModelProfiler)object2).getContent();
            if (n2 != 0) {
                ((StringBuffer)comparable).append(",");
            }
            ((StringBuffer)comparable).append("[").append(((MIRObject)((Object)iterator)).getName());
            ((StringBuffer)comparable).append("(").append(((MIRElement)((Object)iterator)).getNativeType()).append(")]");
            if (++n2 <= 30) continue;
            ((StringBuffer)comparable).append("...");
            break;
        }
        PRFLR.MSG_ITERATORS_ORDER.log(((StringBuffer)comparable).toString());
        int n3 = 0;
        for (Iterator<SubModelProfiler> iterator : list) {
            PRFLR.MSG_START_ITERATING_MODEL.log("(" + n3 + ") " + iterator);
            ((SubModelProfiler)((Object)iterator)).load();
            ((SubModelProfiler)((Object)iterator)).processAggregationLinks(profileLinkProcessor);
            ((SubModelProfiler)((Object)iterator)).processReferenceLinks(profileLinkProcessor);
            if (!bl) {
                ((SubModelProfiler)((Object)iterator)).processLineageLinks(profileLinkProcessor);
            }
            ((SubModelProfiler)((Object)iterator)).unload();
            ++n3;
        }
        if (!bl) {
            Object object2;
            object2 = new ProfilerModelCache(n);
            for (SubModelProfiler subModelProfiler : list) {
                MIRContent mIRContent = subModelProfiler.getContent();
                List<MIRConnection> list2 = subModelProfiler.getSuppliers();
                if (list2.isEmpty()) continue;
                ((ProfilerModelCache)object2).load(subModelProfiler);
                PPSDK.DBG_STITCHING_MODEL.log(mIRContent.getName());
                for (MIRConnection mIRConnection : list2) {
                    MIRStoreContent mIRStoreContent = mIRConnection.getSupplierStoreContent();
                    if (mIRStoreContent == mIRContent) continue;
                    SubModelProfiler subModelProfiler2 = this.getSubModelProfiler(mIRStoreContent);
                    ((ProfilerModelCache)object2).loadSupplier(subModelProfiler2);
                    try {
                        PPSDK.DBG_STITCHING_MODEL_CONNECTION.log(mIRContent.getName(), mIRConnection.getName());
                        Stitching mIRException = this.getStitcher().matchModels(mIRContent, mIRConnection, mIRStoreContent);
                        if (mIRException != null) {
                            subModelProfiler.processDeferredLineageLinks(mIRConnection, mIRException, subModelProfiler2, profileLinkProcessor);
                        }
                    }
                    catch (MIRException mIRException) {
                        PRFLR.ERR_STITCHING_ERROR.log(mIRException, mIRContent.getName(), mIRException.getMessage());
                    }
                    ((ProfilerModelCache)object2).unloadSupplier(subModelProfiler2);
                }
                ((ProfilerModelCache)object2).unload(subModelProfiler);
            }
            ((ProfilerModelCache)object2).clear();
        }
    }

    private List<SubModelProfiler> sortSubModelIterators() {
        List<MIRConnection> list;
        LinkedList<SubModelProfiler> linkedList = new LinkedList<SubModelProfiler>();
        for (SubModelProfiler subModelProfiler : this.subModelProfilers.values()) {
            list = subModelProfiler.getSuppliers();
            if (!list.isEmpty()) continue;
            linkedList.add(subModelProfiler);
        }
        for (SubModelProfiler subModelProfiler : this.subModelProfilers.values()) {
            list = subModelProfiler.getSuppliers();
            if (list.isEmpty()) continue;
            linkedList.add(subModelProfiler);
        }
        return linkedList;
    }

    private void printConnectionStatistics() {
        Object object;
        long l = 0L;
        for (SubModelProfiler subModelProfiler : this.subModelProfilers.values()) {
            object = subModelProfiler.getSuppliers();
            l += (long)object.size();
        }
        BLIB.DBG_DEBUG.log("Detected " + l + " Connection(s) among " + this.subModelProfilers.size() + " models.");
        double d = (double)l / (double)this.subModelProfilers.size();
        object = new DecimalFormat("0.0");
        ((DecimalFormat)object).setRoundingMode(RoundingMode.UP);
        BLIB.DBG_DEBUG.log("Average count of connections per model: " + ((NumberFormat)object).format(d));
    }

    private void printLoopStatistics(Map<String, List<MIRContent>> map) {
        if (!map.isEmpty()) {
            BLIB.DBG_DEBUG.log("Detected " + map.size() + " loop(s) among " + this.subModelProfilers.size() + " models.");
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
            for (List<MIRContent> list : map.values()) {
                long l = list.size();
                Long l2 = (Long)hashMap.get(l);
                if (l2 == null) {
                    hashMap.put(l, 1L);
                    continue;
                }
                hashMap.put(l, l2 + 1L);
            }
            for (List<MIRContent> list : hashMap.keySet()) {
                Long l = (Long)hashMap.get(list);
                BLIB.DBG_DEBUG.log("Detected " + l + " loop(s) of size " + list + "");
            }
        } else {
            BLIB.DBG_DEBUG.log("Detected no loops");
        }
    }

    private Map<String, List<MIRContent>> detectLoops(boolean bl) {
        HashMap<String, List<MIRContent>> hashMap = new HashMap<String, List<MIRContent>>();
        for (SubModelProfiler subModelProfiler : this.subModelProfilers.values()) {
            List<List<MIRContent>> list = this.detectLoops(subModelProfiler, bl);
            for (List<MIRContent> list2 : list) {
                String string = this.computeLoopIdentifier(list2);
                hashMap.put(string, list2);
            }
        }
        return hashMap;
    }

    private String computeLoopIdentifier(List<MIRContent> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (MIRContent mIRContent : list) {
            arrayList.add(mIRContent.getObjectId());
        }
        Collections.sort(arrayList);
        return ((Object)arrayList).toString();
    }

    private List<List<MIRContent>> detectLoops(SubModelProfiler subModelProfiler, boolean bl) {
        MIRContent mIRContent = subModelProfiler.getContent();
        LinkedList<List<MIRContent>> linkedList = new LinkedList<List<MIRContent>>();
        Stack<MIRContent> stack = new Stack<MIRContent>();
        stack.push(mIRContent);
        this.detectLoops(mIRContent, stack, linkedList, bl);
        stack.pop();
        return linkedList;
    }

    private void detectLoops(MIRContent mIRContent, Stack<MIRContent> stack, List<List<MIRContent>> list, boolean bl) {
        SubModelProfiler subModelProfiler = this.getSubModelProfiler(mIRContent);
        for (MIRConnection mIRConnection : subModelProfiler.getSuppliers()) {
            MIRStoreContent mIRStoreContent = mIRConnection.getSupplierStoreContent();
            if (!stack.contains(mIRStoreContent)) {
                stack.push(mIRStoreContent);
                this.detectLoops(mIRStoreContent, stack, list, bl);
                stack.pop();
            } else {
                ArrayList<MIRContent> arrayList = new ArrayList<MIRContent>(stack);
                list.add(arrayList);
            }
            if (list.isEmpty() || !bl) continue;
            break;
        }
    }
}

