/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.memory;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRObject;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIR_Object;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class MIRContentLoopDetector {
    public boolean detectLoops(MIRDirectoryStructureModel mIRDirectoryStructureModel, boolean bl) throws MIRException {
        Traversal traversal = new Traversal();
        mIRDirectoryStructureModel.depthTraversal(traversal);
        List<MIRStoreContent> list = traversal.getStoreContents();
        HashMap<String, List<MIRStoreContent>> hashMap = new HashMap<String, List<MIRStoreContent>>();
        for (MIRStoreContent mIRStoreContent : list) {
            List<List<MIRStoreContent>> list2 = this.detectLoops(mIRStoreContent, bl);
            for (List<MIRStoreContent> list3 : list2) {
                String string = this.computeLoopIdentifier(list3);
                hashMap.put(string, list3);
            }
        }
        this.printLoopStatistics(hashMap, list.size());
        int n = hashMap.keySet().size();
        return n > 0;
    }

    private List<List<MIRStoreContent>> detectLoops(MIRStoreContent mIRStoreContent, boolean bl) {
        LinkedList<List<MIRStoreContent>> linkedList = new LinkedList<List<MIRStoreContent>>();
        Stack<MIRStoreContent> stack = new Stack<MIRStoreContent>();
        stack.push(mIRStoreContent);
        this.detectLoops(mIRStoreContent, stack, linkedList, bl);
        stack.pop();
        return linkedList;
    }

    private void detectLoops(MIRStoreContent mIRStoreContent, Stack<MIRStoreContent> stack, List<List<MIRStoreContent>> list, boolean bl) {
        for (MIRConnection mIRConnection : mIRStoreContent.getClientOfConnections()) {
            MIRStoreContent mIRStoreContent2 = mIRConnection.getSupplierStoreContent();
            if (!stack.contains(mIRStoreContent2)) {
                stack.push(mIRStoreContent2);
                this.detectLoops(mIRStoreContent2, stack, list, bl);
                stack.pop();
            } else {
                ArrayList<MIRStoreContent> arrayList = new ArrayList<MIRStoreContent>(stack);
                list.add(arrayList);
            }
            if (list.isEmpty() || !bl) continue;
            break;
        }
    }

    private String computeLoopIdentifier(List<MIRStoreContent> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (MIRStoreContent mIRStoreContent : list) {
            arrayList.add(mIRStoreContent.getObjectId());
        }
        Collections.sort(arrayList);
        return ((Object)arrayList).toString();
    }

    private void printLoopStatistics(Map<String, List<MIRStoreContent>> map, int n) {
        if (!map.isEmpty()) {
            BLIB.DBG_DEBUG.log("Detected " + map.size() + " loop(s) among " + n + " models.");
            HashMap<Long, Long> hashMap = new HashMap<Long, Long>();
            for (List<MIRStoreContent> list : map.values()) {
                long l = list.size();
                Long l2 = (Long)hashMap.get(l);
                if (l2 == null) {
                    hashMap.put(l, 1L);
                    continue;
                }
                hashMap.put(l, l2 + 1L);
            }
            for (List<MIRStoreContent> list : hashMap.keySet()) {
                Long l = (Long)hashMap.get(list);
                BLIB.DBG_DEBUG.log("Detected " + l + " loop(s) of size " + list + "");
            }
        } else {
            BLIB.DBG_DEBUG.log("Detected no loops");
        }
    }

    private class Traversal
    implements MIR_Object.MIRTraversalOperation {
        private List<MIRStoreContent> contents = new LinkedList<MIRStoreContent>();

        private Traversal() {
        }

        @Override
        public boolean traverse(MIRObject mIRObject) throws MIRException, MIRException {
            return true;
        }

        @Override
        public void pre_process(MIRObject mIRObject, boolean bl) throws MIRException, MIRException {
            if (mIRObject instanceof MIRStoreContent) {
                boolean bl2;
                boolean bl3 = bl2 = ((MIRStoreContent)mIRObject).getConnectionOfDirectoryStructureModel() != null;
                if (!bl2) {
                    this.contents.add((MIRStoreContent)mIRObject);
                }
            }
        }

        @Override
        public void post_process(MIRObject mIRObject) throws MIRException, MIRException {
        }

        public List<MIRStoreContent> getStoreContents() {
            return this.contents;
        }
    }
}

