/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.sdk.profiles.impl.csv.CsvHeader;
import MITI.util.csv.SimpleCsvOptions;
import MITI.util.csv.SimpleCsvReader;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class ProfiledCsvFileReader
extends SimpleCsvReader {
    private int modelId;
    private String name;
    private CsvHeader header;

    public ProfiledCsvFileReader(File file, int n) throws IOException {
        super(file, SimpleCsvOptions.EXCEL_US);
        this.modelId = n;
        this.name = file.getName();
        int n2 = this.name.lastIndexOf(".");
        if (n2 != -1) {
            this.name = this.name.substring(0, n2);
        }
    }

    public CsvHeader readHeader() throws IOException {
        List<String> list = this.getNextLine();
        if (list != null) {
            this.header = new CsvHeader(list);
        }
        return this.header;
    }

    public CsvHeader getHeader() {
        return this.header;
    }

    public String getString(String string, List<String> list) {
        Integer n = this.header.getHeaderPosition(string);
        if (n != null && n < list.size()) {
            String string2 = list.get(n);
            return string2;
        }
        return null;
    }

    public int getInt(String string) {
        int n = 0;
        if (string != null && !string.isEmpty()) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public String toString() {
        return String.valueOf(this.modelId) + " " + this.name;
    }
}

