/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIR_Object;
import MITI.sdk.mpath.Parser;
import MITI.sdk.profiles.AggregationProfileLink;
import MITI.sdk.profiles.LineageProfileLink;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.MIRProfileLink;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.ReferenceProfileLink;
import MITI.sdk.profiles.SummaryLineageProfileLink;
import MITI.sdk.profiles.impl.csv.CsvObject;
import MITI.sdk.profiles.impl.csv.CsvProfileLink;
import MITI.sdk.profiles.impl.csv.CsvProfileLinks;
import MITI.sdk.profiles.impl.csv.CsvReference;
import MITI.server.services.common.mir.LinkIdentifier;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.server.services.common.mir.ProfiledObjectDefinition;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CsvUtil {
    public static AggregationProfileLink createAggregationLink(CsvObject csvObject, CsvObject csvObject2, CsvProfileLinks csvProfileLinks) throws MIRException {
        MIRProfileEntity mIRProfileEntity = null;
        MIRProfileEntity mIRProfileEntity2 = null;
        Integer n = csvObject2.getLinkId();
        String string = null;
        String string2 = null;
        String string3 = null;
        CsvProfileLink csvProfileLink = csvProfileLinks.get(n);
        if (csvProfileLink != null) {
            string = csvProfileLink.getGroupName();
            string2 = csvProfileLink.getRoleName();
            string3 = csvProfileLink.getPath();
        }
        ProfiledObject profiledObject = null;
        if (csvObject != null) {
            profiledObject = CsvUtil.buildProfiledObject(csvObject);
            profiledObject.getObjectDefinition().setGroupName(string);
            mIRProfileEntity = csvObject.getEntity();
        }
        ProfiledObject profiledObject2 = CsvUtil.buildProfiledObject(csvObject2);
        mIRProfileEntity2 = csvObject2.getEntity();
        profiledObject2.setAssociationDisplayName(string2);
        MIRProfileLink mIRProfileLink = CsvUtil.getProfileLink(mIRProfileEntity, string, string3, mIRProfileEntity2);
        AggregationProfileLink aggregationProfileLink = new AggregationProfileLink(profiledObject, profiledObject2, mIRProfileLink, profiledObject2.getObjectDefinition().getGroupName());
        return aggregationProfileLink;
    }

    public static ReferenceProfileLink createReferenceLink(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, CsvReference csvReference, CsvProfileLinks csvProfileLinks) throws MIRException {
        MIRProfileEntity mIRProfileEntity = csvReference.getSrcEntity();
        MIRProfile mIRProfile = mIRProfileEntity.getProfile();
        String string = csvReference.getDstEntity();
        MIRProfileEntity mIRProfileEntity2 = null;
        Integer n = csvReference.getLinkId();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        CsvProfileLink csvProfileLink = csvProfileLinks.get(n);
        if (csvProfileLink != null) {
            string2 = csvProfileLink.getGroupName();
            string3 = csvProfileLink.getRoleName();
            string4 = csvProfileLink.getPath();
            mIRProfileEntity2 = mIRProfile.getProfileEntity(string);
        }
        ProfiledObject profiledObject = CsvUtil.buildProfiledObject(objectIdentifier);
        ProfiledObject profiledObject2 = CsvUtil.buildProfiledObject(objectIdentifier2);
        profiledObject.setEntityName(mIRProfileEntity.getName());
        profiledObject2.setEntityName(string);
        MIRProfileLink mIRProfileLink = CsvUtil.getProfileLink(mIRProfileEntity, string2, string4, mIRProfileEntity2);
        profiledObject2.setAssociationDisplayName(string3);
        profiledObject2.setAssociationGroupName(string2);
        return new ReferenceProfileLink(profiledObject, profiledObject2, mIRProfileLink);
    }

    private static MIRProfileLink getProfileLink(MIRProfileEntity mIRProfileEntity, String string, String string2, MIRProfileEntity mIRProfileEntity2) throws MIRException {
        MIRProfileLink mIRProfileLink = null;
        if (mIRProfileEntity != null && string2 != null) {
            MIRProfileGroup mIRProfileGroup = CsvUtil.getGroup(mIRProfileEntity, string);
            LinkIdentifier linkIdentifier = Parser.parseLink(mIRProfileEntity.getElementType(), string2);
            mIRProfileLink = mIRProfileGroup != null ? mIRProfileGroup.getProfileLink(linkIdentifier, mIRProfileEntity2) : mIRProfileEntity.getProfileLink(linkIdentifier, mIRProfileEntity2);
        }
        return mIRProfileLink;
    }

    private static MIRProfileGroup getGroup(MIRProfileEntity mIRProfileEntity, String string) {
        HashMap<String, MIRProfileGroup> hashMap;
        MIRProfileGroup mIRProfileGroup = null;
        if (mIRProfileEntity != null && (hashMap = mIRProfileEntity.getGroups()) != null) {
            mIRProfileGroup = (MIRProfileGroup)hashMap.get(string);
        }
        return mIRProfileGroup;
    }

    public static LineageProfileLink createLineageLink(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, ProfileLink.LINK_TYPE lINK_TYPE, ObjectIdentifier objectIdentifier3, ObjectIdentifier objectIdentifier4, ObjectIdentifier objectIdentifier5) {
        LineageProfileLink lineageProfileLink;
        ProfiledObject profiledObject;
        ProfiledObject profiledObject2 = CsvUtil.buildProfiledObject(objectIdentifier);
        ProfiledObject profiledObject3 = CsvUtil.buildProfiledObject(objectIdentifier2);
        if (lINK_TYPE == ProfileLink.LINK_TYPE.SUMMARY_LINEAGE || lINK_TYPE == ProfileLink.LINK_TYPE.SUMMARY_CONTROL_LINEAGE) {
            profiledObject = null;
            List<String> list = null;
            lineageProfileLink = new SummaryLineageProfileLink(profiledObject2, profiledObject3, (List<String>)((Object)profiledObject), list, lINK_TYPE);
        } else {
            lineageProfileLink = new LineageProfileLink(profiledObject2, profiledObject3, lINK_TYPE);
        }
        if (objectIdentifier3 != null) {
            profiledObject = CsvUtil.buildProfiledObject(objectIdentifier3);
            lineageProfileLink.setDatabaseOperation(profiledObject);
        }
        if (objectIdentifier4 != null) {
            profiledObject = CsvUtil.buildProfiledObject(objectIdentifier4);
            lineageProfileLink.setTransformation(profiledObject);
        }
        if (objectIdentifier5 != null) {
            profiledObject = CsvUtil.buildProfiledObject(objectIdentifier5);
            lineageProfileLink.setTransformationModel(profiledObject);
        }
        return lineageProfileLink;
    }

    public static ProfiledObject buildProfiledObject(CsvObject csvObject) {
        ProfiledObject profiledObject = new ProfiledObject();
        ObjectDefinition objectDefinition = csvObject.getObjectDefinition();
        ProfiledObjectDefinition profiledObjectDefinition = new ProfiledObjectDefinition(objectDefinition);
        profiledObject.setObjectDefinition(profiledObjectDefinition);
        profiledObject.setEntityName(csvObject.getEntity().getName());
        return profiledObject;
    }

    public static ProfiledObject buildProfiledObject(ObjectIdentifier objectIdentifier) {
        ProfiledObject profiledObject = new ProfiledObject();
        ProfiledObjectDefinition profiledObjectDefinition = new ProfiledObjectDefinition(objectIdentifier, -1);
        profiledObject.setObjectDefinition(profiledObjectDefinition);
        return profiledObject;
    }

    public static Map<MIRProfileEntity, Set<MIRProfileEntity>> buildProfileChildren(MIRProfile mIRProfile) {
        HashMap<MIRProfileEntity, Set<MIRProfileEntity>> hashMap = new HashMap<MIRProfileEntity, Set<MIRProfileEntity>>();
        MIRProfileEntity[] mIRProfileEntityArray = mIRProfile.getProfileEntities();
        if (mIRProfileEntityArray != null) {
            for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
                Set<MIRProfileEntity> set = CsvUtil.buildProfileChildren(mIRProfileEntity);
                hashMap.put(mIRProfileEntity, set);
            }
        }
        return hashMap;
    }

    private static Set<MIRProfileEntity> buildProfileChildren(MIRProfileEntity mIRProfileEntity) {
        LinkedHashSet<MIRProfileEntity> linkedHashSet = new LinkedHashSet<MIRProfileEntity>();
        MIRProfileGroup[] mIRProfileGroupArray = mIRProfileEntity.getProfileGroups();
        if (mIRProfileGroupArray != null) {
            for (MIRProfileGroup mIRProfileGroup : mIRProfileGroupArray) {
                MIRProfileLink[] mIRProfileLinkArray = mIRProfileGroup.getProfileLinks();
                CsvUtil.buildProfileChildren(mIRProfileEntity, mIRProfileLinkArray, linkedHashSet);
            }
        }
        Object[] objectArray = mIRProfileEntity.getProfileLinks();
        CsvUtil.buildProfileChildren(mIRProfileEntity, (MIRProfileLink[])objectArray, linkedHashSet);
        return linkedHashSet;
    }

    private static void buildProfileChildren(MIRProfileEntity mIRProfileEntity, MIRProfileLink[] mIRProfileLinkArray, Set<MIRProfileEntity> set) {
        if (mIRProfileLinkArray != null) {
            for (MIRProfileLink mIRProfileLink : mIRProfileLinkArray) {
                String string = mIRProfileLink.getPath();
                MIRProfileEntity[] mIRProfileEntityArray = mIRProfileLink.getChildren();
                String string2 = CsvUtil.toString(mIRProfileEntityArray);
                if (string == null || string.isEmpty()) {
                    BLIB.DBG_DEBUG.log("Profile link with no path: " + mIRProfileEntity.getName() + " -> " + string2);
                }
                if (!mIRProfileLink.isChildLinkType() || mIRProfileEntityArray == null) continue;
                for (MIRProfileEntity mIRProfileEntity2 : mIRProfileEntityArray) {
                    set.add(mIRProfileEntity2);
                }
                if (mIRProfileEntityArray.length <= 1) continue;
            }
        }
    }

    private static String toString(MIRProfileEntity[] mIRProfileEntityArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (mIRProfileEntityArray != null) {
            boolean bl = true;
            for (MIRProfileEntity mIRProfileEntity : mIRProfileEntityArray) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(mIRProfileEntity.getName());
            }
        }
        return stringBuilder.toString();
    }

    public static boolean isModel(ObjectDefinition objectDefinition) {
        short s = objectDefinition.getObjectType();
        boolean bl = MIR_Object.isInstanceOf(s, (short)218);
        return bl;
    }

    public static boolean isContent(ObjectDefinition objectDefinition) {
        short s = objectDefinition.getObjectType();
        boolean bl = MIR_Object.isInstanceOf(s, (short)159);
        return bl;
    }
}

