/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.impl.csv.CsvFileTask;
import MITI.sdk.profiles.impl.csv.ProfiledCsvFileReader;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.io.File;
import java.util.List;

public class CsvReference {
    private static final String SOURCE_ID = "SourceId";
    private static final String DESTINATION_ID = "DestinationId";
    private static final String LINK_ID = "LinkId";
    private static final String DESTINATION_ENTITY = "DestinationEntity";
    private ObjectIdentifier src;
    private ObjectIdentifier dst;
    private MIRProfileEntity srcEntity;
    private String dstEntity;
    private int linkId;
    private boolean processed;

    public CsvReference(ObjectIdentifier objectIdentifier, ObjectIdentifier objectIdentifier2, int n, MIRProfileEntity mIRProfileEntity, String string) {
        this.src = objectIdentifier;
        this.dst = objectIdentifier2;
        this.linkId = n;
        this.srcEntity = mIRProfileEntity;
        this.dstEntity = string;
        this.processed = false;
    }

    public static CsvReference build(ProfiledCsvFileReader profiledCsvFileReader, List<String> list, int n, MIRProfileEntity mIRProfileEntity) {
        String string = profiledCsvFileReader.getString(SOURCE_ID, list);
        String string2 = profiledCsvFileReader.getString(DESTINATION_ID, list);
        String string3 = profiledCsvFileReader.getString(LINK_ID, list);
        String string4 = profiledCsvFileReader.getString(DESTINATION_ENTITY, list);
        ObjectIdentifier objectIdentifier = new ObjectIdentifier(n, profiledCsvFileReader.getInt(string));
        ObjectIdentifier objectIdentifier2 = new ObjectIdentifier(n, profiledCsvFileReader.getInt(string2));
        CsvReference csvReference = new CsvReference(objectIdentifier, objectIdentifier2, profiledCsvFileReader.getInt(string3), mIRProfileEntity, string4);
        return csvReference;
    }

    public ObjectIdentifier getSrc() {
        return this.src;
    }

    public ObjectIdentifier getDst() {
        return this.dst;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed() {
        this.processed = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.src != null) {
            stringBuilder.append(this.src.toString());
        }
        stringBuilder.append(" -> ");
        if (this.dst != null) {
            stringBuilder.append(this.dst.toString());
        }
        stringBuilder.append(" (").append(this.linkId).append(")");
        return stringBuilder.toString();
    }

    public int getLinkId() {
        return this.linkId;
    }

    public MIRProfileEntity getSrcEntity() {
        return this.srcEntity;
    }

    public String getDstEntity() {
        return this.dstEntity;
    }

    public static class Reader
    extends CsvFileTask<CsvReference> {
        private MIRProfileEntity entity;

        public Reader(File file, int n, MIRProfileEntity mIRProfileEntity) {
            super(file, n);
            this.entity = mIRProfileEntity;
        }

        @Override
        protected CsvReference build(List<String> list) {
            CsvReference csvReference = CsvReference.build(this.reader, list, this.modelId, this.entity);
            return csvReference;
        }
    }
}

