/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.MIRException;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRObject;
import MITI.sdk.profiles.MIRProfile;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileGroup;
import MITI.sdk.profiles.ProfileLink;
import MITI.sdk.profiles.ProfileLinkProcessor;
import MITI.sdk.profiles.ProfiledAttribute;
import MITI.sdk.profiles.ProfiledObject;
import MITI.sdk.profiles.Profiler;
import MITI.sdk.profiles.ProfilerOptions;
import MITI.sdk.profiles.impl.csv.CsvFileTask;
import MITI.sdk.profiles.impl.csv.CsvModelInfo;
import MITI.sdk.profiles.impl.csv.CsvModelProfiler;
import MITI.sdk.profiles.impl.csv.CsvObject;
import MITI.sdk.profiles.impl.csv.CsvProfileLink;
import MITI.sdk.profiles.impl.csv.CsvProfileLinks;
import MITI.sdk.profiles.impl.csv.CsvProfilerOptions;
import MITI.sdk.profiles.impl.csv.CsvUtil;
import MITI.server.services.common.mir.AttributeValue;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import MITI.server.services.common.mir.ProfiledObjectDefinition;
import MITI.util.thread.SimpleTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class CsvProfilerImpl
implements Profiler {
    private File rootDir;
    private ProfiledObject rootProfiledObject;
    private List<CsvModelInfo> modelInfos = new LinkedList<CsvModelInfo>();
    private CsvModelProfiler rootModelProfiler;
    private Map<Integer, CsvModelProfiler> modelProfilers = new TreeMap<Integer, CsvModelProfiler>();
    private CsvProfileLinks profileLinks = new CsvProfileLinks();
    private ProfilerOptions options;
    private boolean skipLineage;

    public CsvProfilerImpl(File file, CsvProfilerOptions csvProfilerOptions) throws MIRException {
        Object object2;
        this.rootDir = file;
        this.options = csvProfilerOptions;
        this.skipLineage = false;
        File file2 = new File(this.rootDir, "ModelInfo.csv");
        if (file2.exists() && file2.isFile()) {
            object2 = new CsvModelInfo.Reader(file2);
            ((SimpleTask)object2).call();
            if (!((SimpleTask)object2).isSuccessful()) {
                Exception exception = ((SimpleTask)object2).getException();
                throw new MIRException(exception.getMessage(), exception);
            }
        } else {
            String string = BLIB.WRN_FILE_NOT_FOUND.getMessage(file2.getPath());
            throw new MIRException(string);
        }
        this.modelInfos = ((CsvFileTask)object2).getObjects();
        object2 = new File(this.rootDir, "ProfileLinks.csv");
        if (((File)object2).exists() && ((File)object2).isFile()) {
            CsvProfileLink.Reader reader = new CsvProfileLink.Reader((File)object2);
            reader.call();
            if (reader.isSuccessful()) {
                List object3 = reader.getObjects();
                for (CsvProfileLink csvProfileLink : object3) {
                    this.profileLinks.add(csvProfileLink);
                }
            } else {
                Exception exception = reader.getException();
                throw new MIRException(exception.getMessage(), exception);
            }
        }
        for (CsvModelInfo csvModelInfo : this.modelInfos) {
            CsvModelProfiler csvModelProfiler = this.createModelProfiler(csvModelInfo);
            if (csvModelProfiler == null) continue;
            this.modelProfilers.put(csvModelInfo.getModelId(), csvModelProfiler);
        }
        this.rootModelProfiler = this.modelProfilers.get(0);
        this.rootModelProfiler.load();
        if (csvProfilerOptions != null) {
            this.skipLineage = csvProfilerOptions.isSkipLineage();
        }
    }

    @Override
    public MIRProfile getRootProfile() {
        if (this.rootModelProfiler != null) {
            return this.rootModelProfiler.getProfile();
        }
        return null;
    }

    @Override
    public Iterator<ProfileLink> createIterator(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public void iterate(ProfiledObject profiledObject, ProfileLinkProcessor profileLinkProcessor) throws MIRException {
        CsvModelProfiler csvModelProfiler;
        CsvObject csvObject;
        int n;
        TreeSet<ObjectIdentifier> treeSet = new TreeSet<ObjectIdentifier>();
        if (this.rootModelProfiler != null) {
            this.rootModelProfiler.iterate(profiledObject, null, profileLinkProcessor, treeSet);
            this.rootModelProfiler.close();
        }
        List<CsvObject> list = this.rootModelProfiler.getContents();
        TreeMap<Integer, CsvObject> treeMap = new TreeMap<Integer, CsvObject>();
        if (list != null) {
            for (CsvObject object : list) {
                treeMap.put(object.getObjectDefinition().getObjectId(), object);
            }
        }
        for (CsvModelInfo csvModelInfo : this.modelInfos) {
            n = csvModelInfo.getModelId();
            if (n == 0) continue;
            csvObject = (CsvObject)treeMap.get(n);
            csvModelProfiler = this.modelProfilers.get(n);
            if (csvModelProfiler == null) continue;
            csvModelProfiler.load();
            CsvObject csvObject2 = csvModelProfiler.getRootObject();
            ProfiledObject profiledObject2 = CsvUtil.buildProfiledObject(csvObject2);
            csvModelProfiler.iterate(profiledObject2, csvObject, profileLinkProcessor, treeSet);
            csvModelProfiler.close();
        }
        if (!this.skipLineage) {
            for (CsvModelInfo csvModelInfo : this.modelInfos) {
                n = csvModelInfo.getModelId();
                csvObject = (CsvObject)treeMap.get(n);
                csvModelProfiler = this.modelProfilers.get(n);
                if (csvModelProfiler == null) continue;
                csvModelProfiler.iterateLineage(csvObject, profileLinkProcessor);
            }
        }
    }

    @Override
    public String getObjectIdentity(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public boolean isRepeatableIdentity(ProfiledObject profiledObject) throws MIRException {
        return false;
    }

    @Override
    public String getProfiledObjectIdentity(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public ProfiledAttribute[] getAttributes(ProfiledObject profiledObject) throws MIRException {
        AttributeValue[] attributeValueArray;
        CsvObject csvObject;
        ArrayList<ProfiledAttribute> arrayList = new ArrayList<ProfiledAttribute>();
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        CsvModelProfiler csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getModelId());
        if (csvModelProfiler != null && (csvObject = csvModelProfiler.getObject(profiledObjectDefinition)) != null && (attributeValueArray = csvObject.buildAttributes()) != null) {
            for (AttributeValue attributeValue : attributeValueArray) {
                ProfiledAttribute profiledAttribute = new ProfiledAttribute(attributeValue);
                arrayList.add(profiledAttribute);
            }
        }
        return arrayList.toArray(new ProfiledAttribute[arrayList.size()]);
    }

    @Override
    public ProfiledObject[] getLinks(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public ProfiledObject getRootObject() {
        if (this.rootProfiledObject == null && this.rootModelProfiler != null) {
            CsvObject csvObject = this.rootModelProfiler.getRootObject();
            this.rootProfiledObject = CsvUtil.buildProfiledObject(csvObject);
        }
        return this.rootProfiledObject;
    }

    @Override
    public ProfiledObject getRootModel(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public ProfiledObject[] getObjectPath(ProfiledObject profiledObject, ProfiledObject profiledObject2) throws MIRException {
        return null;
    }

    @Override
    public ProfiledObject getParent(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public MIRProfileEntity getProfileEntity(ProfiledObject profiledObject) throws MIRException {
        String string = profiledObject.getEntityName();
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        CsvModelProfiler csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getModelId());
        if (csvModelProfiler != null) {
            return csvModelProfiler.getProfile().getProfileEntity(string);
        }
        return null;
    }

    @Override
    public MIRProfileGroup getProfileGroup(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public MIRObject getMIRObject(ObjectIdentifier objectIdentifier) throws MIRException {
        return null;
    }

    @Override
    public ObjectDefinition getObjectDefinition(MIRObject mIRObject) {
        return null;
    }

    @Override
    public ProfiledObject getClassifier(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public ProfiledObject getDataPackage(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public boolean isConnection(ProfiledObject profiledObject) throws MIRException {
        CsvModelProfiler csvModelProfiler = null;
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        if (CsvUtil.isModel(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getModelId());
        } else if (CsvUtil.isContent(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getObjectId());
        }
        if (csvModelProfiler != null) {
            return csvModelProfiler.getModelInfo().isConnection();
        }
        return false;
    }

    @Override
    public boolean isCaseSensitive(ProfiledObject profiledObject) throws MIRException {
        return false;
    }

    @Override
    public boolean isTemporary(ProfiledObject profiledObject) throws MIRException {
        return false;
    }

    @Override
    public Profiler.StoreType getStoreType(ProfiledObject profiledObject) throws MIRException {
        CsvModelProfiler csvModelProfiler = null;
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        if (CsvUtil.isModel(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getModelId());
        } else if (CsvUtil.isContent(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getObjectId());
        }
        int n = -1;
        if (csvModelProfiler != null) {
            n = csvModelProfiler.getModelInfo().getStoreType();
            if (n == 0) {
                return Profiler.StoreType.RELATIONAL;
            }
            if (n == 3) {
                return Profiler.StoreType.LOGICAL;
            }
            if (n == 2) {
                return Profiler.StoreType.FILE;
            }
            if (n == 1) {
                return Profiler.StoreType.OLAP;
            }
            if (n == 4) {
                return Profiler.StoreType.REPORT;
            }
        }
        return null;
    }

    @Override
    public String getSystemType(ProfiledObject profiledObject) throws MIRException {
        CsvModelProfiler csvModelProfiler = null;
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        if (CsvUtil.isModel(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getModelId());
        } else if (CsvUtil.isContent(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getObjectId());
        }
        if (csvModelProfiler != null) {
            return csvModelProfiler.getModelInfo().getSystemType();
        }
        return null;
    }

    @Override
    public ProfiledObject getReportItemParent(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public void setSkipOverOlapModels(boolean bl) {
    }

    @Override
    public String getNativeId(ProfiledObject profiledObject) throws MIRException {
        CsvObject csvObject;
        String string = null;
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        CsvModelProfiler csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getModelId());
        if (csvModelProfiler != null && (csvObject = csvModelProfiler.getObject(profiledObjectDefinition)) != null) {
            string = csvObject.getNativeId();
        }
        return string;
    }

    @Override
    public void setRootProfile(int n) throws MIRException {
    }

    @Override
    public ProfiledObject getSynonymTargetSchema(ProfiledObject profiledObject) throws MIRException {
        return null;
    }

    @Override
    public String getChecksum(ProfiledObject profiledObject) throws MIRException {
        CsvModelProfiler csvModelProfiler = null;
        ProfiledObjectDefinition profiledObjectDefinition = profiledObject.getObjectDefinition();
        if (CsvUtil.isModel(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getModelId());
        } else if (CsvUtil.isContent(profiledObjectDefinition)) {
            csvModelProfiler = this.modelProfilers.get(profiledObjectDefinition.getObjectId());
        }
        if (csvModelProfiler != null) {
            return csvModelProfiler.getModelInfo().getChecksum();
        }
        return null;
    }

    @Override
    public void setOptions(ProfilerOptions profilerOptions) {
        this.options = profilerOptions;
    }

    private CsvModelProfiler createModelProfiler(CsvModelInfo csvModelInfo) throws MIRException {
        int n;
        File file;
        CsvModelProfiler csvModelProfiler = this.modelProfilers.get(csvModelInfo.getModelId());
        if (csvModelProfiler == null && (file = new File(this.rootDir, String.valueOf(n = csvModelInfo.getModelId()))).exists() && file.isDirectory()) {
            csvModelProfiler = new CsvModelProfiler(file, csvModelInfo, this.profileLinks, this.options);
        }
        return csvModelProfiler;
    }
}

