/*
 * Decompiled with CFR 0.152.
 */
package MITI.sdk.profiles.impl.csv;

import MITI.sdk.MIR_Object;
import MITI.sdk.profiles.MIRProfileEntity;
import MITI.sdk.profiles.MIRProfileProperty;
import MITI.sdk.profiles.impl.csv.CsvFileTask;
import MITI.sdk.profiles.impl.csv.CsvHeader;
import MITI.sdk.profiles.impl.csv.ProfiledCsvFileReader;
import MITI.server.services.common.mir.AttributeIdentifier;
import MITI.server.services.common.mir.AttributeValue;
import MITI.server.services.common.mir.ObjectDefinition;
import MITI.server.services.common.mir.ObjectIdentifier;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class CsvObject {
    private static final String ID = "ObjectId";
    private static final String PARENT_ID = "ParentId";
    private static final String LINK_ID = "LinkId";
    private static final String SEQUENCE = "SequenceNumber";
    private static final String NAME = "Name";
    private static final int NAME_POSITION = 4;
    private static final String NATIVE_ID = "NativeId";
    private ObjectDefinition objDef;
    private MIRProfileEntity entity;
    private ObjectIdentifier parent;
    private List<String> row;
    private ProfiledCsvFileReader reader;
    private Integer linkId;
    private long sequence;
    private String nativeId;
    private static final AttributeIdentifier ELEMENT_NATIVEID = new AttributeIdentifier(206);
    private static final AttributeIdentifier NOTE_NATIVEID = new AttributeIdentifier(496);

    public CsvObject(ObjectDefinition objectDefinition, MIRProfileEntity mIRProfileEntity, ObjectIdentifier objectIdentifier, String string, long l, List<String> list, ProfiledCsvFileReader profiledCsvFileReader) {
        this.objDef = objectDefinition;
        this.entity = mIRProfileEntity;
        this.parent = objectIdentifier;
        this.linkId = null;
        if (string != null && !string.isEmpty()) {
            this.linkId = profiledCsvFileReader.getInt(string);
        }
        this.sequence = l;
        this.row = list;
        this.reader = profiledCsvFileReader;
        this.nativeId = profiledCsvFileReader.getString(NATIVE_ID, list);
        if (this.nativeId == null) {
            short s = objectDefinition.getObjectType();
            MIRProfileProperty mIRProfileProperty = null;
            if (MIR_Object.isInstanceOf(s, (short)0)) {
                mIRProfileProperty = mIRProfileEntity.getProfileAttribute(ELEMENT_NATIVEID);
            } else if (MIR_Object.isInstanceOf(s, (short)1)) {
                mIRProfileProperty = mIRProfileEntity.getProfileAttribute(NOTE_NATIVEID);
            }
            if (mIRProfileProperty != null) {
                this.nativeId = profiledCsvFileReader.getString(mIRProfileProperty.getName(), list);
            }
        }
    }

    public static CsvObject build(ProfiledCsvFileReader profiledCsvFileReader, List<String> list, int n, MIRProfileEntity mIRProfileEntity) {
        String string = profiledCsvFileReader.getString(ID, list);
        String string2 = profiledCsvFileReader.getString(PARENT_ID, list);
        String string3 = profiledCsvFileReader.getString(LINK_ID, list);
        String string4 = profiledCsvFileReader.getString(SEQUENCE, list);
        String string5 = profiledCsvFileReader.getString(NAME, list);
        int n2 = profiledCsvFileReader.getInt(string);
        short s = mIRProfileEntity != null ? (short)mIRProfileEntity.getElementType() : (short)-1;
        ObjectDefinition objectDefinition = new ObjectDefinition(n, n2, s, string5);
        ObjectIdentifier objectIdentifier = null;
        objectIdentifier = string2 != null && !string2.isEmpty() ? (objectDefinition.getObjectId() == 1 ? new ObjectIdentifier(0, n) : new ObjectIdentifier(n, profiledCsvFileReader.getInt(string2))) : null;
        CsvObject csvObject = new CsvObject(objectDefinition, mIRProfileEntity, objectIdentifier, string3, profiledCsvFileReader.getInt(string4), list, profiledCsvFileReader);
        return csvObject;
    }

    public ObjectDefinition getObjectDefinition() {
        return this.objDef;
    }

    public MIRProfileEntity getEntity() {
        return this.entity;
    }

    public ObjectIdentifier getParent() {
        return this.parent;
    }

    public CsvHeader getHeader() {
        return this.reader.getHeader();
    }

    public String getNativeId() {
        return this.nativeId;
    }

    public String toString() {
        return this.objDef.toString();
    }

    public long getSequence() {
        return this.sequence;
    }

    public AttributeValue[] buildAttributes() {
        ArrayList<AttributeValue> arrayList = new ArrayList<AttributeValue>();
        CsvHeader csvHeader = this.getHeader();
        List<String> list = csvHeader.getNames();
        int n = list.size();
        if (n > 4) {
            for (int i = 4; i < n; ++i) {
                String string = list.get(i);
                String string2 = this.reader.getString(string, this.row);
                AttributeValue attributeValue = new AttributeValue();
                attributeValue.setName(string);
                attributeValue.setValue(string2);
                arrayList.add(attributeValue);
            }
        }
        return arrayList.toArray(new AttributeValue[arrayList.size()]);
    }

    public Integer getLinkId() {
        return this.linkId;
    }

    public static class Reader
    extends CsvFileTask<CsvObject> {
        private MIRProfileEntity entity;

        public Reader(File file, int n, MIRProfileEntity mIRProfileEntity) {
            super(file, n);
            this.entity = mIRProfileEntity;
        }

        @Override
        protected CsvObject build(List<String> list) {
            CsvObject csvObject = CsvObject.build(this.reader, list, this.modelId, this.entity);
            return csvObject;
        }
    }
}

