/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.sfx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Util {
    private static final long serialVersionUID = 0L;
    protected static Vector<String> _properties = new Vector();
    protected static Vector<String> _mvsTypes = new Vector();
    protected static Vector<String> _defaultPropertyValues = new Vector();
    protected static ArrayList<String> _umaskMap = new ArrayList();
    private static String _description;
    private static String _schemaFilename;
    public static String INCLUDE;
    public static String NAME;
    public static String TYPE;
    public static String COMPARE_BY;
    public static String EQUATE;
    public static String PERMISSIONS;
    public static String OWNER;
    public static String GROUP;
    public static String BACKUP;
    public static String REGISTER;
    public static String SHARED;
    public static String REGISTRY_KEY;
    public static String REGISTRY_VALUE;
    public static String REBOOT;
    public static String UNINSTALL;
    public static String DATE;
    public static String EQUALS;
    public static String DEFAULT;
    public static String EMPTY;
    public static String FALSE;
    public static String TRUE;
    public static String[] compareValues;
    public static String[] typeValues;
    public static String[] equateValues;

    public static boolean getMVSType(String type) {
        String suffix = Util.getSuffix(type);
        return _mvsTypes.contains(suffix.toLowerCase());
    }

    public static Vector<String> getProperties() {
        return _properties;
    }

    public static Vector<String> getDefaultPropertyValues() {
        return _defaultPropertyValues;
    }

    public static void setDescription(String description) {
        _description = description;
    }

    public static String getDescription() {
        return _description;
    }

    public static String getInstallSchemaFilename() {
        return _schemaFilename;
    }

    public static void setInstallSchemaFilename(String filename) {
        _schemaFilename = filename;
    }

    public static String getPrefix(String name) {
        int index;
        String prefix = "";
        if (null != name && (index = name.lastIndexOf(46)) >= 0) {
            prefix = name.substring(0, index);
        }
        return prefix;
    }

    public static String getName(String pathToFile) {
        int index;
        String name = "";
        if (null != pathToFile && (index = pathToFile.lastIndexOf(File.separator)) >= 0) {
            name = pathToFile.substring(index++, pathToFile.length());
        }
        return name;
    }

    public static String getSuffix(String pathToFile) {
        int index;
        String suffix = "";
        if (null != pathToFile && (index = pathToFile.lastIndexOf(46)) >= 0) {
            suffix = pathToFile.substring(index++, pathToFile.length());
        }
        return suffix;
    }

    public static boolean isLink(File file) {
        try {
            if (file.exists()) {
                String canPath = file.getCanonicalPath();
                String absPath = file.getAbsolutePath();
                return !absPath.equals(canPath);
            }
        }
        catch (IOException ex) {
            System.out.println("isLink() Failed :" + ex);
            return true;
        }
        return false;
    }

    public static Vector<String> loadZip(File f) {
        Vector<String> data = new Vector<String>();
        try {
            ZipFile zip = new ZipFile(f);
            Enumeration<? extends ZipEntry> files = zip.entries();
            while (files.hasMoreElements()) {
                ZipEntry entry = files.nextElement();
                if (entry.isDirectory()) {
                    System.out.println("directory :" + entry.getName());
                }
                data.add(entry.getName());
            }
        }
        catch (Exception e) {
            System.out.println("loadZip Failed..." + e);
        }
        return data;
    }

    public static List<String> loadLocalList(File root) {
        ArrayList<String> allChildDirectories = new ArrayList<String>();
        try {
            allChildDirectories.add(root.getAbsolutePath());
            File[] allChildren = root.listFiles();
            for (int i = 0; i < allChildren.length; ++i) {
                if (!allChildren[i].isFile()) continue;
                allChildDirectories.add(allChildren[i].getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.out.println("loadLocalList() Failed :" + root.getAbsolutePath());
            e.printStackTrace();
        }
        return allChildDirectories;
    }

    public static boolean hasFiles(String path) {
        File directory = new File(path);
        return directory.exists() && directory.list().length > 0;
    }

    public static List<String> loadDirectoryList(File root) {
        ArrayList<String> allChildDirectories = new ArrayList<String>();
        try {
            allChildDirectories.add(root.getAbsolutePath());
            File[] allChildren = root.listFiles();
            if (allChildren == null) {
                System.out.println("loadDirectoryList: - there are no children for the specified root of " + root.getAbsolutePath());
                return allChildDirectories;
            }
            for (int i = 0; i < allChildren.length; ++i) {
                if (allChildren[i].isDirectory()) {
                    allChildDirectories.addAll(Util.loadDirectoryList(allChildren[i]));
                    continue;
                }
                allChildDirectories.add(allChildren[i].getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.out.println("loadDirectoryList() Failed :" + root.getAbsolutePath());
            e.printStackTrace();
        }
        return allChildDirectories;
    }

    public static List<String> loadDirectoryListIgnoreRoot(File root) {
        ArrayList<String> allChildDirectories = new ArrayList<String>();
        try {
            File[] allChildren = root.listFiles();
            for (int i = 0; i < allChildren.length; ++i) {
                if (allChildren[i].isDirectory()) {
                    allChildDirectories.addAll(Util.loadDirectoryList(allChildren[i]));
                    continue;
                }
                allChildDirectories.add(allChildren[i].getAbsolutePath());
            }
        }
        catch (Exception e) {
            System.out.println("loadDirectoryListIgnoreRoot() Failed :" + root.getAbsolutePath());
            e.printStackTrace();
        }
        return allChildDirectories;
    }

    public static List<String> loadFilteredDirectoryList(File root, String filter1, String filter2, String filter3) throws IOException {
        ArrayList<String> allChildDirectories = new ArrayList<String>();
        String combinedFilter = filter1;
        if (!filter2.equals("")) {
            combinedFilter = combinedFilter + "__" + filter2;
        }
        try {
            if (root.getAbsolutePath().contains(filter2) || root.getCanonicalPath().contains(combinedFilter)) {
                allChildDirectories.add(root.getCanonicalPath());
                File[] allChildren = root.listFiles();
                if (allChildren != null) {
                    for (int i = 0; i < allChildren.length; ++i) {
                        if (allChildren[i].isDirectory()) {
                            allChildDirectories.addAll(Util.loadFilteredDirectoryList(allChildren[i], filter1, filter2, filter3));
                            continue;
                        }
                        allChildDirectories.add(allChildren[i].getCanonicalPath());
                    }
                }
            } else {
                System.out.println("Util.loadFilteredDirectoryList() -absolute path does not contain " + filter2);
            }
        }
        catch (Exception e) {
            System.out.println("loadFilteredDirectoryList() Failed :" + root.getCanonicalPath());
            e.printStackTrace();
        }
        return allChildDirectories;
    }

    public static Vector<String> loadDirectory(File root) {
        Vector<String> data = new Vector<String>();
        try {
            List<File> l = Util.getAllChildDirectories(root);
            String rootName = root.getName();
            int rootLen = root.getName().length();
            for (File f : l) {
                String cp = f.getCanonicalPath();
                if ((cp = cp.substring(cp.indexOf(rootName) + rootLen, cp.length())).startsWith(File.separator)) {
                    cp = cp.substring(1, cp.length());
                }
                data.add(cp);
            }
        }
        catch (Exception e) {
            System.out.println("loadDirectory() - Failed - " + e.getMessage());
            e.printStackTrace();
        }
        return data;
    }

    public static void emptyDirectory(File root) {
        Vector<String> files = Util.loadDirectory(root);
        for (int index = 0; index < files.size(); ++index) {
            File f = new File(root.getAbsolutePath() + File.separator + files.get(index));
            if (!f.exists()) continue;
            f.delete();
        }
    }

    public static List<File> getAllChildDirectories(File root) throws IOException {
        ArrayList<File> allChildDirectories = new ArrayList<File>();
        try {
            File[] allChildren = root.listFiles();
            for (int i = 0; i < allChildren.length; ++i) {
                if (allChildren[i].isDirectory()) {
                    allChildDirectories.addAll(Util.getAllChildDirectories(allChildren[i]));
                    continue;
                }
                allChildDirectories.add(allChildren[i]);
            }
        }
        catch (Exception e) {
            System.out.println("getAllChildDirectories() Failed :" + root.getCanonicalPath());
            e.printStackTrace();
        }
        return allChildDirectories;
    }

    public static void copyFile(File in, File out) throws IOException {
        out.setLastModified(in.lastModified());
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            out.setLastModified(in.lastModified());
        }
        catch (IOException e) {
            System.out.println("Failed" + e.getMessage());
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void deleteSysReqFiles(File repositoryDirectory) {
        File[] files;
        for (File f : files = repositoryDirectory.listFiles()) {
            if (f.isDirectory()) {
                Util.deleteDirectory(f);
                continue;
            }
            if (f.getName().equalsIgnoreCase("install.xml") || f.getName().endsWith(".zpm")) continue;
            f.delete();
        }
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Util.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static ArrayList<String> getAllFiles(File repositoryDirectory) {
        String[] fileList;
        ArrayList<String> totalList = new ArrayList<String>();
        for (String s : fileList = repositoryDirectory.list()) {
            if (new File(repositoryDirectory.getAbsolutePath() + File.separator + s).isDirectory()) {
                totalList.addAll(Util.getAllFiles(new File(repositoryDirectory.getAbsolutePath() + File.separator + s)));
                continue;
            }
            totalList.add(repositoryDirectory.getAbsolutePath() + File.separator + s);
        }
        return totalList;
    }

    public static void copyDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                Util.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else if (!srcPath.exists()) {
            System.out.println("copyDirectory() - source path to " + srcPath + " does not exist.");
        } else {
            Util.copyFile(srcPath, dstPath);
        }
    }

    public static void copyFromDirectory(File srcPath, File dstPath) throws IOException {
        if (srcPath.isDirectory()) {
            if (!dstPath.exists()) {
                dstPath.mkdir();
            }
            String[] files = srcPath.list();
            for (int i = 0; i < files.length; ++i) {
                Util.copyDirectory(new File(srcPath, files[i]), new File(dstPath, files[i]));
            }
        } else if (!srcPath.exists()) {
            System.out.println("copyDirectory() - File or directory does not exist.");
        } else {
            Util.copyFile(srcPath, dstPath);
        }
    }

    public static String getMd5(String filename) {
        MessageDigest digester = null;
        FileInputStream fis = null;
        FilterInputStream dis = null;
        try {
            fis = new FileInputStream(filename);
            digester = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, digester);
            byte[] bytes = new byte[8192];
            int count = dis.read(bytes);
            while (count != -1 && count <= 8192) {
                count = dis.read(bytes);
            }
            fis.close();
            dis.close();
        }
        catch (Exception e) {
            try {
                fis.close();
                dis.close();
            }
            catch (Exception e2) {
                System.out.println("getMd5() - Could not close files for md5 scanner in exception handler");
            }
            return null;
        }
        return Util.md5sumToString(digester);
    }

    public static String md5sumToString(MessageDigest digester) {
        byte[] chk = digester.digest();
        String hexvalue = "";
        for (int i = 0; i < chk.length; ++i) {
            int bytevalue = chk[i] >= 0 ? chk[i] : 256 + chk[i];
            String hexvaluestring = Integer.toHexString(bytevalue);
            if (hexvaluestring.length() == 1) {
                hexvaluestring = "0" + hexvaluestring;
            }
            hexvalue = hexvalue + hexvaluestring;
        }
        return hexvalue;
    }

    public static String convertToXML(String data) {
        if (data != null) {
            data = data.replaceAll("'", "\"");
        }
        return data;
    }

    public static int getModeOf(String command) {
        int mode = 755;
        try {
            String line;
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (!line.startsWith("d") && !line.startsWith("-")) continue;
                mode = Util.getMode(line);
            }
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mode;
    }

    public static int getMode(String permissionString) {
        String mode = "755";
        if (permissionString != null) {
            return Integer.parseInt(String.valueOf(Util.getUmask(permissionString.substring(1, 4))) + String.valueOf(Util.getUmask(permissionString.substring(4, 7))) + String.valueOf(Util.getUmask(permissionString.substring(7, 10))));
        }
        return Integer.parseInt(mode);
    }

    private static int getUmask(String mode) {
        return _umaskMap.indexOf(mode);
    }

    public static String joinPath(String path1, String path2) {
        String sPath = "";
        String sTemp1 = path1;
        String sTemp2 = path2;
        while (sTemp1.endsWith(File.separator)) {
            sTemp1 = sTemp1.substring(0, sTemp1.length() - 1);
        }
        while (sTemp2.startsWith(File.separator)) {
            sTemp2 = sTemp2.substring(1, sTemp2.length());
        }
        sPath = sTemp1 + File.separator + sTemp2;
        return sPath;
    }

    static {
        _schemaFilename = null;
        INCLUDE = "include";
        NAME = "name";
        TYPE = "type";
        COMPARE_BY = "compareby";
        EQUATE = "equate";
        PERMISSIONS = "permissions";
        OWNER = "owner";
        GROUP = "group";
        BACKUP = "backup";
        REGISTER = "register";
        SHARED = "shared";
        REGISTRY_KEY = "registrykey";
        REGISTRY_VALUE = "registryval";
        REBOOT = "reboot";
        UNINSTALL = "uninstall";
        DATE = "DATE";
        EQUALS = "greaterthan";
        DEFAULT = "default";
        EMPTY = "";
        FALSE = "false";
        TRUE = "true";
        compareValues = new String[]{"NONE", "DATE", "VERSION", "CHECKSUM"};
        typeValues = new String[]{"file", "directory"};
        equateValues = new String[]{"equals", "lessthan", "lessthanequals", "greaterthan", "greaterthanequals"};
        _properties.add(COMPARE_BY);
        _properties.add(EQUATE);
        _properties.add(PERMISSIONS);
        _properties.add(OWNER);
        _properties.add(GROUP);
        _properties.add(BACKUP);
        _properties.add(REGISTER);
        _properties.add(SHARED);
        _properties.add(REGISTRY_KEY);
        _properties.add(REGISTRY_VALUE);
        _properties.add(REBOOT);
        _properties.add(UNINSTALL);
        _defaultPropertyValues.add(DATE);
        _defaultPropertyValues.add(EQUALS);
        _defaultPropertyValues.add(EMPTY);
        _defaultPropertyValues.add(DEFAULT);
        _defaultPropertyValues.add(DEFAULT);
        _defaultPropertyValues.add(TRUE);
        _defaultPropertyValues.add(FALSE);
        _defaultPropertyValues.add(FALSE);
        _defaultPropertyValues.add(EMPTY);
        _defaultPropertyValues.add(EMPTY);
        _defaultPropertyValues.add(FALSE);
        _defaultPropertyValues.add(TRUE);
        _umaskMap.add(0, "---");
        _umaskMap.add(1, "--x");
        _umaskMap.add(2, "-w-");
        _umaskMap.add(3, "-wx");
        _umaskMap.add(4, "r--");
        _umaskMap.add(5, "r-x");
        _umaskMap.add(6, "rw-");
        _umaskMap.add(7, "rwx");
        _mvsTypes.add(".sdl");
        _mvsTypes.add(".xrg");
        _mvsTypes.add(".seq");
        _mvsTypes.add(".xmt");
        _mvsTypes.add(".pax");
    }
}

