/*
 * Decompiled with CFR 0.152.
 */
package com.sas.tools.installs.builder.sfx;

import com.sas.tools.installs.builder.sfx.Command;
import com.sas.tools.installs.builder.sfx.Controller;
import com.sas.tools.installs.builder.sfx.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class SFXBuilder {
    private Command command;
    private List<String> _entry = new ArrayList<String>();
    static Logger logger = (Logger)LogManager.getLogger(SFXBuilder.class);
    private String _bundleName = "";
    private static String EOL = System.getProperty("line.separator");

    public SFXBuilder() {
    }

    public SFXBuilder(Command c) {
        this.command = c;
    }

    private long generatePackage(ZipOutputStream out, String relativePath, String realDestDir) {
        byte[] buf = new byte[4096];
        long size = 0L;
        try {
            logger.info("generatePackage() - loading " + this._entry.size() + " entries......");
            for (int i = 0; i < this._entry.size(); ++i) {
                int len;
                String relative = this._entry.get(i);
                File f = new File(relative);
                if (!f.isFile()) continue;
                FileInputStream in = new FileInputStream(relative);
                if ((relative = relative.substring(relative.indexOf(relativePath) + relativePath.length(), relative.length())).startsWith(File.separator)) {
                    relative = relative.substring(1, relative.length());
                }
                relative = relative.replaceAll("\\\\", "/");
                String unixRealDestDir = realDestDir.replaceAll("\\\\", "/");
                ZipEntry thisZipEntry = new ZipEntry(unixRealDestDir + "/" + relative);
                out.putNextEntry(thisZipEntry);
                if (relative.endsWith(".sh")) {
                    thisZipEntry.setUnixMode(493);
                }
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                    size += (long)len;
                }
                out.closeEntry();
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("generatePackage() - failed due to " + e.getMessage());
            return -1L;
        }
        return size;
    }

    private String getLauncherCommand(Command command, String launchCodePath) {
        String launchLocation = null;
        String launcherString = null;
        String launchCode = command.getExecuteScript();
        File f = new File(launchCode);
        if (!command.getPlatform().startsWith("w")) {
            launchLocation = command.getRealDestDir() + "/" + launchCode;
            launchLocation = launchLocation.replace("\\", "/");
        } else {
            launchLocation = command.getRealDestDir() + "\\" + launchCode;
            launchLocation = launchLocation.replace("/", "\\");
        }
        launcherString = "$AUTORUN$> " + launchLocation;
        logger.info("getLauncherCommand() - launcher string = " + launcherString);
        return launcherString;
    }

    private void getLauncher(Command command) {
        block5: {
            String launchCode = command.getExecuteScript();
            File f = new File(launchCode);
            if (f.exists()) {
                try {
                    File check = new File(command.getSourceDirectory() + File.separator + f.getName());
                    if (!check.exists()) {
                        Util.copyFile(f, new File(command.getSourceDirectory() + File.separator + f.getName()));
                        break block5;
                    }
                    logger.info("BundleBuilder - launcher script was found in source directory. Using the existing one.");
                }
                catch (IOException e) {
                    logger.error("BundleBuilder - failed to copy launch script " + launchCode + " reason - " + e.getMessage());
                    e.printStackTrace();
                }
            } else {
                logger.error("BundleBuilder -  could not find launcher specified by " + launchCode);
            }
        }
    }

    private String getExtractionCommand(String data_dir, String platform, String filename) {
        logger.info("BundleBuilder.getExtractionCommand() for platform = " + platform);
        String sfx = Controller.getSFX(platform);
        String extension = Controller.getSFXExtension(platform);
        String sfxCommandFilePath = data_dir;
        if ("".equals(sfxCommandFilePath)) {
            logger.error("getExtractionCommand() - unable to find the sfx_command script to run - defaulting to 'data'");
            sfxCommandFilePath = data_dir;
        }
        String extractionString = "sh -x " + sfxCommandFilePath + File.separator + "sfx_command " + data_dir + " " + sfxCommandFilePath + File.separator + sfx + " " + filename + ".zip " + filename + extension + " ";
        logger.info("BundleBuilder :extraction string = " + extractionString);
        return extractionString;
    }

    private String getWinOSExtractionCommand(String data_dir, String platform, String filename) {
        String sfx = Controller.getSFX(platform);
        String extension = Controller.getSFXExtension(platform);
        String sfxCommandFilePath = data_dir;
        if ("".equals(sfxCommandFilePath)) {
            logger.error("getWinOSExtractionCommand() - unable to find the sfx_command script to run - defaulting to 'data'");
            sfxCommandFilePath = data_dir;
        }
        String extractionString = "\"" + sfxCommandFilePath + File.separator + "sfx_win_command.bat\" \"" + data_dir + "\" \"" + sfxCommandFilePath + File.separator + sfx + "\" \"" + filename + ".zip\" \"" + filename + extension + "\"";
        logger.info("BundleBuilder :Windows OS extraction string = " + extractionString);
        return extractionString;
    }

    public int buildForUnix(Command command) {
        int success = -1;
        String repositoryLocation = command.getSourceDirectory();
        File f = new File(command.getDataDirectory() + File.separator + "make.sh");
        String script = f.getAbsolutePath();
        String executeScript = new File(command.getExecuteScript()).getName();
        String archiveCmd = script + " " + command.getDataDirectory() + " " + repositoryLocation + " " + command.getTargetDirectory() + " " + command.getName() + " " + command.getPlatform() + " " + executeScript;
        logger.debug("buildForUnix() - exec " + archiveCmd);
        Runtime rt = Runtime.getRuntime();
        try {
            String line;
            Process proc = rt.exec(archiveCmd);
            BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = input.readLine()) != null) {
                logger.debug("buildForUnix() - line: " + line);
            }
            input.close();
            logger.info("Waiting for process to signal done.");
            int rc = proc.waitFor();
            logger.info("execution complete with exit value " + rc);
            return proc.exitValue();
        }
        catch (Exception e) {
            logger.error(e);
            success = -1;
            return success;
        }
    }

    public long buildSFX(Command command) throws IOException {
        String outFilename = null;
        long success = 0L;
        ZipOutputStream outputStream = null;
        String relativePath = null;
        String realDestDir = null;
        this._entry = Util.loadDirectoryListIgnoreRoot(new File(command.getSourceDirectory()));
        String data_dir = command.getDataDirectory();
        String platform = command.getPlatform();
        ArrayList<String> filteredEntries = new ArrayList<String>();
        for (String entry : this._entry) {
            filteredEntries.add(entry);
        }
        this._entry = filteredEntries;
        if (outputStream == null) {
            outFilename = command.getTargetDirectory();
            new File(outFilename).mkdirs();
            outFilename = outFilename + File.separator + command.getName() + "_" + platform;
            outputStream = new ZipOutputStream(new FileOutputStream(outFilename + ".zip"));
        }
        this._bundleName = command.getName();
        logger.info("buildSFX() - Bundle name = " + this._bundleName);
        relativePath = command.getSourceDirectory();
        realDestDir = command.getRealDestDir();
        success += this.generatePackage(outputStream, relativePath, realDestDir);
        try {
            logger.info("buildSFX() - Adding the launcher codes now for " + outFilename);
            outputStream.setComment(this.getLauncherCommand(command, platform));
            outputStream.close();
            logger.info("buildSFX() - running the archive command for " + platform);
            String os = System.getProperty("os.name");
            String execString = os.contains("Windows") ? this.getWinOSExtractionCommand(data_dir, platform, outFilename) : this.getExtractionCommand(data_dir, platform, outFilename);
            logger.debug("buildSFX() - running command :" + execString);
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(execString);
            try {
                proc.waitFor();
            }
            catch (InterruptedException e) {
                logger.error(e);
                success = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("buildSFX() - bundling failed to to exception " + e.getMessage());
            success = 0L;
        }
        return success;
    }

    public Long execute() {
        long start = System.currentTimeMillis();
        long success = 0L;
        if (Controller.getPlatform(this.command.getPlatform()) != null) {
            if (this.command.getPlatform().startsWith("w")) {
                try {
                    this.buildSFX(this.command);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.buildSFX(this.command);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            logger.error("Unable to find the platform " + this.command.getPlatform() + " - no bundling performed");
        }
        logger.info("Finishing " + this.command.getName() + " :elapsed time: " + (System.currentTimeMillis() - start));
        return new Long(success);
    }
}

