/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.ssl;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.RB;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.io.File;
import java.util.ResourceBundle;

@SASScope
public final class SecurityKeyStore {
    private File _keyStoreFile;
    private String _keyStorePassword;

    SecurityKeyStore(String keyStoreFileName, String keyStorePassword) throws IllegalArgumentException {
        if (null == keyStoreFileName || keyStoreFileName.trim().length() == 0) {
            throw new IllegalArgumentException(RB.getStringResource("SecurityKeyStore.invalidKeyStoreFile.ex.txt"));
        }
        File keyStoreFile = new File(keyStoreFileName);
        if (!keyStoreFile.canRead()) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SecurityKeyStore.canNotReadKeyStoreFile.ex.fmt.txt", (Object)keyStoreFile.getAbsolutePath()));
        }
        this.setKeyStore(keyStoreFile);
        this.setKeyStorePassword(keyStorePassword);
    }

    SecurityKeyStore(File keyStoreFile, String keyStorePassword) throws IllegalArgumentException {
        if (null == keyStoreFile) {
            throw new IllegalArgumentException(RB.getStringResource("SecurityKeyStore.invalidKeyStoreFile.ex.txt"));
        }
        if (!keyStoreFile.canRead()) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SecurityKeyStore.canNotReadKeyStoreFile.ex.fmt.txt", (Object)keyStoreFile.getAbsolutePath()));
        }
        this.setKeyStore(keyStoreFile);
        this.setKeyStorePassword(keyStorePassword);
    }

    private void setKeyStore(File keyStoreFile) throws IllegalArgumentException {
        if (null == keyStoreFile) {
            throw new IllegalArgumentException(RB.getStringResource("SecurityKeyStore.inputStreamMustBeNonNull.ex.txt"));
        }
        this._keyStoreFile = keyStoreFile;
    }

    File getKeyStore() {
        return this._keyStoreFile;
    }

    char[] getKeyStorePassword() throws SasPasswordEncodingException {
        return SecurityKeyStore.getPassword(this._keyStorePassword);
    }

    private static char[] getPassword(String password) throws SasPasswordEncodingException {
        char[] passwordChars = null;
        if (null != password) {
            passwordChars = SasPasswordString.isEncoded((String)password) ? SasPasswordString.decode((String)password).toCharArray() : password.toCharArray();
        }
        return passwordChars;
    }

    private void setKeyStorePassword(String keyStorePassword) throws IllegalArgumentException {
        if (null != keyStorePassword) {
            if (SasPasswordString.isEncodedAndSupported((String)keyStorePassword)) {
                try {
                    new String(SasPasswordString.decode((String)keyStorePassword).toCharArray());
                }
                catch (SasPasswordEncodingException e) {
                    throw new IllegalArgumentException(e.getLocalizedMessage());
                }
            } else if (SasPasswordString.isEncoded((String)keyStorePassword)) {
                throw new IllegalArgumentException("The encoded password \"" + keyStorePassword + "\" is not supported.");
            }
        }
        this._keyStorePassword = keyStorePassword;
    }
}

