/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.ssl;

import com.sas.codepolicy.SASScope;
import com.sas.net.ssl.GetPropertyAction;
import com.sas.net.ssl.RB;
import com.sas.net.ssl.SSLRMIConfiguration;
import com.sas.net.ssl.SecurityKeyStore;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.LogManager;

@SASScope
public final class SSLRMIServerSocketFactory
implements RMIServerSocketFactory,
Serializable {
    private static final long serialVersionUID = 487646332453068374L;
    private static final int HASH_CODE_PRIME = 31;
    private transient SSLContext _sslContext;
    private Boolean _isReuseAddress;
    private boolean _isAuthenticatingClients;

    public SSLRMIServerSocketFactory(SecurityKeyStore securityKeyStore) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        this(securityKeyStore, false, null);
    }

    public SSLRMIServerSocketFactory(SecurityKeyStore securityKeyStore, boolean isAuthenticatingClients) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        this(securityKeyStore, isAuthenticatingClients, null);
    }

    public SSLRMIServerSocketFactory(SecurityKeyStore securityKeyStore, boolean isAuthenticatingClients, SecurityKeyStore securityTrustStore) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        this(securityKeyStore, securityTrustStore, KeyManagerFactory.getDefaultAlgorithm(), KeyStore.getDefaultType(), null, null, isAuthenticatingClients);
    }

    public SSLRMIServerSocketFactory(SecurityKeyStore securityKeyStore, boolean isAuthenticatingClients, SecurityKeyStore securityTrustStore, Boolean isReuseAddress) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        this(securityKeyStore, isAuthenticatingClients, securityTrustStore);
        this._isReuseAddress = isReuseAddress;
    }

    public SSLRMIServerSocketFactory(SecurityKeyStore securityKeyStore, SecurityKeyStore securityTrustStore, String algorithm, String keyStoreType, String socketProtocol, String socketProvider, boolean isAuthenticatingClients) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        this(securityKeyStore, securityTrustStore, algorithm, keyStoreType, socketProtocol, socketProvider, isAuthenticatingClients, null);
    }

    public SSLRMIServerSocketFactory(SecurityKeyStore securityKeyStore, SecurityKeyStore securityTrustStore, String algorithm, String keyStoreType, String socketProtocol, String socketProvider, boolean isAuthenticatingClients, Boolean isReuseAddress) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        this._isReuseAddress = isReuseAddress;
        this._isAuthenticatingClients = isAuthenticatingClients;
        String sslContextSocketProtocol = AccessController.doPrivileged(new GetPropertyAction("com.sas.net.ssl.protocol"));
        if (sslContextSocketProtocol == null) {
            sslContextSocketProtocol = socketProtocol == null ? SSLRMIConfiguration.getDefaultSocketProtocol() : socketProtocol;
        }
        KeyManagerFactory keyManagerFactory = SSLRMIServerSocketFactory.getKeyManagerFactory(algorithm, securityKeyStore, keyStoreType);
        TrustManagerFactory trustManagerFactory = securityTrustStore == null ? null : SSLRMIServerSocketFactory.getTrustManagerFactory(algorithm, securityTrustStore, keyStoreType);
        this.setSSLContext(keyManagerFactory, trustManagerFactory, sslContextSocketProtocol, socketProvider);
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException, IllegalArgumentException {
        boolean isReuseAddress;
        if (port < 0) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIServerSocketFactory.invalidPort.ex.fmt.txt", (Object)port));
        }
        SSLServerSocketFactory ssf = this._sslContext.getServerSocketFactory();
        ServerSocket socket = ssf.createServerSocket(port);
        if (this._isAuthenticatingClients && socket instanceof SSLServerSocket) {
            ((SSLServerSocket)socket).setNeedClientAuth(this._isAuthenticatingClients);
        }
        if (this._isReuseAddress != null && (isReuseAddress = this._isReuseAddress.booleanValue()) != socket.getReuseAddress()) {
            socket.setReuseAddress(isReuseAddress);
        }
        return socket;
    }

    private void setSSLContext(KeyManagerFactory keyManagerFactory, TrustManagerFactory trustManagerFactory, String socketProtocol, String socketProvider) throws GeneralSecurityException, IllegalArgumentException {
        SSLRMIServerSocketFactory.validateSocketProtocol(socketProtocol);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagers = trustManagerFactory == null ? null : trustManagerFactory.getTrustManagers();
        this._isAuthenticatingClients = null != trustManagers && trustManagers.length > 0;
        try {
            SSLContext sslContext = socketProvider == null ? SSLContext.getInstance(socketProtocol) : SSLContext.getInstance(socketProtocol, socketProvider);
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextInt();
            sslContext.init(keyManagers, trustManagers, secureRandom);
            this._sslContext = sslContext;
        }
        catch (GeneralSecurityException e) {
            LogManager.getLogger(SSLRMIServerSocketFactory.class).error(RB.getStringResource("SSLRMIServerSocketFactory.securityContext.ex.log"), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyManagerFactory getKeyManagerFactory(String algorithm, SecurityKeyStore sslKeyStore, String keyStoreType) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        KeyManagerFactory keyManagerFactory;
        if (sslKeyStore == null) {
            throw new IllegalArgumentException(RB.getStringResource("SecurityKeyStore.mustBeNonNull.ex.txt"));
        }
        SSLRMIServerSocketFactory.validateKeyStoreType(keyStoreType);
        InputStream inputStream = null;
        try {
            char[] passwordChars = sslKeyStore.getKeyStorePassword();
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            inputStream = new FileInputStream(sslKeyStore.getKeyStore());
            keyStore.load(inputStream, passwordChars);
            keyManagerFactory = KeyManagerFactory.getInstance(algorithm);
            keyManagerFactory.init(keyStore, passwordChars);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    inputStream = null;
                }
            }
        }
        return keyManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustManagerFactory getTrustManagerFactory(String algorithm, SecurityKeyStore sslTrustStore, String keyStoreType) throws GeneralSecurityException, IOException, SasPasswordEncodingException, IllegalArgumentException {
        SSLRMIServerSocketFactory.validateKeyStoreType(keyStoreType);
        TrustManagerFactory trustManagerFactory = null;
        InputStream inputStream = null;
        try {
            KeyStore trustStore = KeyStore.getInstance(keyStoreType);
            inputStream = new FileInputStream(sslTrustStore.getKeyStore());
            trustStore.load(inputStream, sslTrustStore.getKeyStorePassword());
            trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
            trustManagerFactory.init(trustStore);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    inputStream = null;
                }
            }
        }
        return trustManagerFactory;
    }

    public int hashCode() {
        int sslContextHash = this._sslContext != null ? this._sslContext.hashCode() : 0;
        int hashCode = 0x1F ^ Long.valueOf(487646332453068374L).hashCode() ^ sslContextHash + (this._isReuseAddress == null ? 0 : this._isReuseAddress.hashCode());
        return hashCode;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object != null) {
            if (object == this) {
                isEqual = true;
            } else {
                try {
                    SSLRMIServerSocketFactory other = (SSLRMIServerSocketFactory)object;
                    SSLContext sslContext = other._sslContext;
                    Boolean isReuseAddress = other._isReuseAddress;
                    isEqual = this._sslContext != null ? this._sslContext.equals(sslContext) : (sslContext == null && this._isReuseAddress != null ? this._isReuseAddress.equals(isReuseAddress) : isReuseAddress == null);
                }
                catch (ClassCastException e) {
                    isEqual = false;
                }
            }
        }
        return isEqual;
    }

    private static void validateSocketProtocol(String socketProtocol) throws IllegalArgumentException {
        if (socketProtocol == null) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIServerSocketFactory.invalidSocketProtocol.ex.fmt.txt", (Object)"null"));
        }
    }

    private static void validateKeyStoreType(String keyStoreType) throws IllegalArgumentException {
        if (keyStoreType == null) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIServerSocketFactory.invalidKeyStoreType.ex.fmt.txt", (Object)"null"));
        }
    }

    static {
        try {
            KeyManagerFactory.getDefaultAlgorithm();
        }
        catch (NoClassDefFoundError e) {
            System.err.println(RB.getStringResource("SSLRMIServerSocketFactory.jsseJarIsNotAvailableInJRE.ex.txt"));
            throw e;
        }
    }
}

