/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping.processors;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.AttributeProcessor;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PropertyProcessor
implements AttributeProcessor {
    public static final String PROPERTY_STRING = "StringPropertyValue";
    public static final String PROPERTY_BOOLEAN_PRIMITIVE = "booleanPropertyValue";
    public static final String PROPERTY_BOOLEAN_OBJECT = "BooleanPropertyValue";
    public static final String PROPERTY_DOUBLE_PRIMITIVE = "doublePropertyValue";
    public static final String PROPERTY_DOUBLE_OBJECT = "DoublePropertyValue";
    public static final String PROPERTY_INTEGER_PRIMITIVE = "intPropertyValue";
    public static final String PROPERTY_INTEGER_OBJECT = "IntegerPropertyValue";
    public static final String PROPERTY_LONG_PRIMITIVE = "longPropertyValue";
    public static final String PROPERTY_LONG_OBJECT = "LongPropertyValue";
    public static final String PROPERTY_DATE = "DatePropertyValue";

    @Override
    public Object getBrowseObject(AttributeMapping mapping, BrowseMetadata bmi, Map<String, ResultMapEntry> result) {
        List propertyList;
        String propertyName = mapping.getMetadataAttribute();
        if (propertyName.startsWith("&")) {
            int index = propertyName.indexOf(47);
            if (index < 0) {
                throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
            }
            String key = propertyName.substring(1, index);
            propertyName = propertyName.substring(index + 1);
            ResultMapEntry rme = result.get(key);
            if (rme == null) {
                return null;
            }
            bmi = (BrowseMetadata)rme.value;
        }
        if ((propertyList = (List)bmi.get("Properties")) != null && propertyList.size() > 0) {
            for (BrowseMetadata nextProperty : propertyList) {
                String nextPN = (String)nextProperty.get("PropertyName");
                String name = nextProperty.getName();
                if (!propertyName.equals(nextPN) && !propertyName.equals(name)) continue;
                return nextProperty.get("DefaultValue");
            }
        }
        return null;
    }

    @Override
    public Object getResultingObject(AttributeMapping mapping, CMetadata metadata, Map<String, ResultMapEntry> result) {
        String propertyName = mapping.getMetadataAttribute();
        if (propertyName.startsWith("&")) {
            int index = propertyName.indexOf(47);
            if (index < 0) {
                throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
            }
            String key = propertyName.substring(1, index);
            propertyName = propertyName.substring(index + 1);
            ResultMapEntry rme = result.get(key);
            if (rme == null) {
                return null;
            }
            metadata = (CMetadata)rme.value;
        }
        try {
            AssociationList properties = ((Root)metadata).getProperties();
            for (Property property : properties) {
                if (!propertyName.equals(property.getName()) && !propertyName.equals(property.getPropertyName())) continue;
                return property.getDefaultValue();
            }
        }
        catch (MdException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return null;
    }

    @Override
    public boolean prepareCall(Class[] args, Object[] parms, String argType, Object value) {
        if (PROPERTY_BOOLEAN_OBJECT.equals(argType)) {
            args[0] = Boolean.class;
            String stringValue = (String)value;
            parms[0] = stringValue.equalsIgnoreCase("true") || stringValue.equals("1") || stringValue.equalsIgnoreCase("yes") || stringValue.equalsIgnoreCase("y") ? Boolean.TRUE : Boolean.FALSE;
        } else if (PROPERTY_BOOLEAN_PRIMITIVE.equals(argType)) {
            String stringValue = (String)value;
            args[0] = Boolean.TYPE;
            parms[0] = stringValue.equalsIgnoreCase("true") || stringValue.equals("1") || stringValue.equalsIgnoreCase("yes") || stringValue.equalsIgnoreCase("y") ? Boolean.TRUE : Boolean.FALSE;
        } else if (PROPERTY_DATE.equals(argType)) {
            args[0] = Date.class;
            if (value instanceof Date) {
                parms[0] = (Date)value;
            } else {
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                try {
                    Date d = sdf.parse((String)value);
                    parms[0] = d;
                }
                catch (ParseException parseException) {}
            }
        } else if (PROPERTY_DOUBLE_OBJECT.equals(argType)) {
            args[0] = Double.class;
            parms[0] = Double.valueOf((String)value);
        } else if (PROPERTY_DOUBLE_PRIMITIVE.equals(argType)) {
            args[0] = Double.TYPE;
            parms[0] = Double.valueOf((String)value);
        } else if (PROPERTY_INTEGER_OBJECT.equals(argType)) {
            args[0] = Integer.class;
            parms[0] = Integer.valueOf((String)value);
        } else if (PROPERTY_INTEGER_PRIMITIVE.equals(argType)) {
            args[0] = Integer.TYPE;
            parms[0] = Integer.valueOf((String)value);
        } else if (PROPERTY_LONG_OBJECT.equals(argType)) {
            args[0] = Long.class;
            parms[0] = Long.valueOf((String)value);
        } else if (PROPERTY_LONG_PRIMITIVE.equals(argType)) {
            args[0] = Long.TYPE;
            parms[0] = Long.valueOf((String)value);
        } else if (PROPERTY_STRING.equals(argType)) {
            args[0] = String.class;
            parms[0] = (String)value;
        }
        return true;
    }

    @Override
    public void setAttribute(Object o, AttributeMapping map, CMetadata metadata, Map<String, ResultMapEntry> updateMap) {
        String propertyName = map.getMetadataAttribute();
        try {
            Property property = null;
            AssociationList properties = ((Root)metadata).getProperties();
            for (Property nextProperty : properties) {
                if (!propertyName.equals(nextProperty.getName()) && !propertyName.equals(nextProperty.getPropertyName())) continue;
                property = nextProperty;
            }
            if (o == null) {
                if (property != null) {
                    property.delete();
                }
            } else {
                if (property == null) {
                    MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
                    MdFactory factory = store.getFactory();
                    property = (Property)factory.createComplexMetadataObject(store, null, propertyName, "Property", metadata.getRepositoryID());
                    property.setPropertyName(propertyName);
                }
                property.setDefaultValue(o.toString());
                property.setAssociatedObject((Root)metadata);
            }
        }
        catch (MdException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

