/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping.processors;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.AttributeProcessor;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ObjectIdentityProcessor
implements AttributeProcessor {
    public static final String TYPE_STRING = "ObjectIdentityProcessor";
    private ObjectTypeService typeService = null;

    public void setObjectTypeService(ObjectTypeService typeService) {
        this.typeService = typeService;
    }

    @Override
    public Object getBrowseObject(AttributeMapping mapping, BrowseMetadata bmi, Map<String, ResultMapEntry> result) {
        List candidateList;
        ObjectIdentity value = new ObjectIdentity();
        String pathString = mapping.getMetadataAttribute();
        if (pathString.startsWith("&")) {
            int index = pathString.indexOf(47);
            if (index < 0) {
                throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
            }
            String key = pathString.substring(1, index);
            pathString = pathString.substring(index + 1);
            ResultMapEntry rme = result.get(key);
            if (rme == null) {
                return null;
            }
            bmi = (BrowseMetadata)rme.value;
        }
        if ((candidateList = (List)bmi.get(pathString)) != null && candidateList.size() > 0) {
            for (BrowseMetadata nextCandidate : candidateList) {
                value = new ObjectIdentity();
                String publicType = (String)nextCandidate.get("PublicType");
                if (publicType == null || publicType.trim().length() == 0) {
                    publicType = nextCandidate.getSmartType();
                }
                if (this.typeService != null) {
                    ObjectType objectType = this.typeService.getTypeByName(publicType);
                    if (objectType != null) {
                        value.setObjectType(objectType.getId());
                    } else {
                        value.setObjectType(0L);
                    }
                }
                value.setId(nextCandidate.getReposId() + "/" + nextCandidate.getNativeType());
            }
        }
        return value;
    }

    @Override
    public Object getResultingObject(AttributeMapping mapping, CMetadata metadata, Map<String, ResultMapEntry> result) {
        block26: {
            ObjectIdentity value = new ObjectIdentity();
            String pathString = mapping.getMetadataAttribute();
            if (pathString.startsWith("&")) {
                int index = pathString.indexOf(47);
                if (index < 0) {
                    throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
                }
                String key = pathString.substring(1, index);
                pathString = pathString.substring(index + 1);
                ResultMapEntry rme = result.get(key);
                if (rme == null) {
                    return null;
                }
                metadata = (CMetadata)rme.value;
            }
            try {
                String mapString = mapping.getAttributeName();
                Root candidate = null;
                Map associations = metadata.getAssocs();
                Object o = associations.get(pathString);
                if (o != null) {
                    if (o instanceof List) {
                        if (((List)o).size() > 0) {
                            candidate = (Root)((List)o).get(0);
                        }
                    } else {
                        candidate = (Root)o;
                    }
                }
                if (candidate == null) {
                    try {
                        String methodName = "get" + pathString;
                        Method method = metadata.getClass().getMethod(methodName, null);
                        o = method.invoke((Object)metadata, null);
                        if (o instanceof List) {
                            if (((List)o).size() > 0) {
                                candidate = (Root)((List)o).get(0);
                            }
                        } else {
                            candidate = (Root)o;
                        }
                    }
                    catch (NoSuchMethodException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                }
                if (candidate == null) break block26;
                String publicType = null;
                if (candidate instanceof PrimaryType) {
                    publicType = ((PrimaryType)candidate).getPublicType();
                }
                if (publicType == null || publicType.length() == 0) {
                    ResultMapEntry serverEntry = result.get("authserver");
                    ServerInterface server = (ServerInterface)serverEntry.value;
                    if (server != null) {
                        try {
                            MetadataInterface mi = server.factoryProcess((Object)candidate);
                            publicType = mi.getType();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (publicType != null && publicType.length() > 0) {
                    ObjectType objectType = this.typeService.getTypeByName(publicType);
                    if (objectType != null) {
                        value.setObjectType(objectType.getId());
                    } else {
                        value.setObjectType(-1L);
                    }
                } else {
                    value.setObjectType(-1L);
                }
                value.setId(candidate.getFQID() + "/" + candidate.getCMetadataType());
                return value;
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    @Override
    public boolean prepareCall(Class[] args, Object[] parms, String argType, Object value) {
        ObjectIdentity realValue = (ObjectIdentity)value;
        args[0] = ObjectIdentity.class;
        parms[0] = realValue;
        return true;
    }

    @Override
    public void setAttribute(Object o, AttributeMapping map, CMetadata metadata, Map<String, ResultMapEntry> updateMap) {
        ObjectIdentity value = (ObjectIdentity)o;
        String pathString = map.getMetadataAttribute();
        if (pathString.startsWith("&")) {
            int index = pathString.indexOf(47);
            if (index < 0) {
                throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
            }
            String key = pathString.substring(1, index);
            pathString = pathString.substring(index + 1);
            ResultMapEntry rme = updateMap.get(key);
            if (rme == null) {
                return;
            }
            metadata = (CMetadata)rme.value;
        }
        Object cm = null;
        if (value != null) {
            try {
                MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
                MdFactory factory = store.getFactory();
                String id = value.getId();
                int index = id.indexOf(47);
                String type = id.substring(index + 1);
                id = id.substring(0, index);
                int flags = 2056;
                cm = (Root)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, type, id, Collections.EMPTY_LIST, Collections.EMPTY_LIST, "", flags);
            }
            catch (MdException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        try {
            String methodName = "set" + pathString;
            Method method = null;
            Object[] parms = new Object[]{cm};
            if (cm == null) {
                method = this.getMethod(methodName, metadata.getClass());
            } else {
                Class[] args = new Class[]{cm.getClass()};
                method = metadata.getClass().getMethod(methodName, args);
            }
            method.invoke((Object)metadata, parms);
        }
        catch (NoSuchMethodException ex) {
            try {
                String methodName = "get" + pathString;
                Method method = metadata.getClass().getMethod(methodName, null);
                o = method.invoke((Object)metadata, null);
                if (o instanceof List) {
                    List mylist = (List)o;
                    mylist.clear();
                    if (cm != null) {
                        mylist.add(cm);
                    }
                }
            }
            catch (NoSuchMethodException ex2) {
                ex2.printStackTrace();
            }
            catch (InvocationTargetException ex2) {
                ex2.printStackTrace();
            }
            catch (IllegalAccessException ex2) {
                ex2.printStackTrace();
            }
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    private Method getMethod(String methodName, Class metadataclazz) {
        Method result = null;
        Method[] methods = metadataclazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(methodName)) continue;
            result = methods[i];
            break;
        }
        return result;
    }
}

