/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping.processors;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.AttributeProcessor;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ObjectIdentityListProcessor
implements AttributeProcessor {
    public static final String TYPE_STRING = "ObjectIdentityListProcessor";
    private ObjectTypeService typeService = null;

    public void setObjectTypeService(ObjectTypeService typeService) {
        this.typeService = typeService;
    }

    @Override
    public Object getBrowseObject(AttributeMapping mapping, BrowseMetadata bmi, Map<String, ResultMapEntry> result) {
        String pathString = mapping.getMetadataAttribute();
        if (pathString.startsWith("&")) {
            int index = pathString.indexOf(47);
            if (index < 0) {
                throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
            }
            String key = pathString.substring(1, index);
            pathString = pathString.substring(index + 1);
            ResultMapEntry rme = result.get(key);
            if (rme == null) {
                return null;
            }
            bmi = (BrowseMetadata)rme.value;
        }
        ArrayList<ObjectIdentity> value = new ArrayList<ObjectIdentity>();
        String mapString = mapping.getAttributeName();
        List candidateList = (List)bmi.get(pathString);
        if (candidateList != null && candidateList.size() > 0) {
            for (BrowseMetadata nextCandidate : candidateList) {
                ObjectIdentity od = new ObjectIdentity();
                String publicType = (String)nextCandidate.get("PublicType");
                if ((publicType == null || publicType.trim().length() == 0) && "Metadata".equals(publicType = nextCandidate.getSmartType())) {
                    publicType = nextCandidate.getNativeType();
                }
                if (this.typeService != null) {
                    ObjectType objectType = this.typeService.getTypeByName(publicType);
                    if (objectType != null) {
                        od.setObjectType(objectType.getId());
                    } else {
                        od.setObjectType(-1L);
                    }
                }
                od.setId(nextCandidate.getReposId() + "/" + nextCandidate.getNativeType());
                value.add(od);
            }
        }
        return value;
    }

    @Override
    public Object getResultingObject(AttributeMapping mapping, CMetadata metadata, Map<String, ResultMapEntry> result) {
        String pathString = mapping.getMetadataAttribute();
        if (pathString.startsWith("&")) {
            int index = pathString.indexOf(47);
            if (index < 0) {
                throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
            }
            String key = pathString.substring(1, index);
            pathString = pathString.substring(index + 1);
            ResultMapEntry rme = result.get(key);
            if (rme == null) {
                return null;
            }
            metadata = (CMetadata)rme.value;
        }
        try {
            ArrayList<ObjectIdentity> value = new ArrayList<ObjectIdentity>();
            Map associations = metadata.getAssocs();
            List candidateList = (List)associations.get(pathString);
            if (candidateList == null) {
                try {
                    String methodName = "get" + pathString;
                    Method method = metadata.getClass().getMethod(methodName, null);
                    Object o = method.invoke((Object)metadata, null);
                    if (o instanceof List) {
                        candidateList = (List)o;
                    }
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
            if (candidateList != null && candidateList.size() > 0) {
                for (Root nextCandidate : candidateList) {
                    ObjectIdentity od = new ObjectIdentity();
                    String publicType = null;
                    if (nextCandidate instanceof PrimaryType) {
                        publicType = ((PrimaryType)nextCandidate).getPublicType();
                    }
                    if (publicType == null || publicType.length() == 0) {
                        ResultMapEntry serverEntry = result.get("authserver");
                        ServerInterface server = (ServerInterface)serverEntry.value;
                        if (server != null) {
                            try {
                                MetadataInterface mi = server.factoryProcess((Object)nextCandidate);
                                publicType = mi.getType();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (publicType == null || publicType.length() == 0) {
                        publicType = nextCandidate.getCMetadataType();
                    }
                    if (publicType != null && publicType.length() > 0) {
                        ObjectType objectType = this.typeService.getTypeByName(publicType);
                        if (objectType != null) {
                            od.setObjectType(objectType.getId());
                        } else {
                            od.setObjectType(-1L);
                        }
                    } else {
                        od.setObjectType(-1L);
                    }
                    od.setId(nextCandidate.getFQID() + "/" + nextCandidate.getCMetadataType());
                    value.add(od);
                }
            }
            return value;
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean prepareCall(Class[] args, Object[] parms, String argType, Object value) {
        List realvalue = (List)value;
        args[0] = List.class;
        parms[0] = realvalue;
        return true;
    }

    @Override
    public void setAttribute(Object o, AttributeMapping map, CMetadata metadata, Map<String, ResultMapEntry> updateMap) {
        String pathString = map.getMetadataAttribute();
        if (pathString.startsWith("&")) {
            int index = pathString.indexOf(47);
            if (index < 0) {
                throw new RuntimeException("property metadata attribute should be property name or &key/propertyname");
            }
            String key = pathString.substring(1, index);
            pathString = pathString.substring(index + 1);
            ResultMapEntry rme = updateMap.get(key);
            if (rme == null) {
                return;
            }
            metadata = (CMetadata)rme.value;
        }
        try {
            List value = (List)o;
            Map associations = metadata.getAssocs();
            List candidateList = (List)associations.get(pathString);
            if (candidateList == null) {
                try {
                    String methodName = "get" + pathString;
                    Method method = metadata.getClass().getMethod(methodName, null);
                    Object ol = method.invoke((Object)metadata, null);
                    if (ol instanceof List) {
                        candidateList = (List)ol;
                    }
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            }
            if (candidateList == null) {
                return;
            }
            candidateList.clear();
            if (value != null) {
                MdObjectStore store = (MdObjectStore)metadata.getObjectStore();
                MdFactory factory = store.getFactory();
                for (ObjectIdentity nextIdentity : value) {
                    String id = nextIdentity.getId();
                    int index = id.indexOf(47);
                    String type = id.substring(index + 1);
                    id = id.substring(0, index);
                    int flags = 2056;
                    Root cm = (Root)factory.getOMIUtil().getMetadataAllDepths((MdStore)store, type, id, Collections.EMPTY_LIST, Collections.EMPTY_LIST, "", flags);
                    candidateList.add(cm);
                }
            }
        }
        catch (MdException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

