/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping.processors;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TextStore;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.AttributeProcessor;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class ConfigurationProcessor
implements AttributeProcessor {
    public static final String TYPE_STRING = "MetadataConfiguration";
    public static final String CONFIGURATION_PUBLIC = "Public";
    public static final String CONFIGURATION_PRIVATE = "Private";
    private static final String PRIVATE_CONFIGURATION_PROPERTIES = "Private Configuration Properties";
    private static final String PUBLIC_CONFIGURATION_PROPERTIES = "Public Configuration Properties";

    @Override
    public Object getBrowseObject(AttributeMapping mapping, BrowseMetadata bmi, Map<String, ResultMapEntry> result) {
        String configType = mapping.getMetadataAttribute();
        String configName = null;
        if (configType.equalsIgnoreCase(CONFIGURATION_PUBLIC)) {
            configName = PUBLIC_CONFIGURATION_PROPERTIES;
        } else if (configType.equalsIgnoreCase(CONFIGURATION_PRIVATE)) {
            configName = PRIVATE_CONFIGURATION_PROPERTIES;
        }
        if (configName == null) {
            throw new RuntimeException("Only a property of 'Public' or 'Private' is valid");
        }
        List noteList = (List)bmi.get("Notes");
        if (noteList == null || noteList.size() == 0) {
            return null;
        }
        BrowseMetadata textStore = null;
        for (BrowseMetadata nextNote : noteList) {
            if (!nextNote.getName().equals(configName)) continue;
            textStore = nextNote;
            break;
        }
        if (textStore == null) {
            return null;
        }
        String configText = (String)textStore.get("StoredText");
        Properties configuration = this.parseConfigText(configText);
        return configuration;
    }

    @Override
    public Object getResultingObject(AttributeMapping mapping, CMetadata metadata, Map<String, ResultMapEntry> result) {
        String configType = mapping.getMetadataAttribute();
        String configName = null;
        if (configType.equalsIgnoreCase(CONFIGURATION_PUBLIC)) {
            configName = PUBLIC_CONFIGURATION_PROPERTIES;
        } else if (configType.equalsIgnoreCase(CONFIGURATION_PRIVATE)) {
            configName = PRIVATE_CONFIGURATION_PROPERTIES;
        }
        if (configName == null) {
            throw new RuntimeException("Only a property of 'Public' or 'Private' is valid");
        }
        TextStore textStore = this.getConfigurationStore((Root)metadata, configName);
        if (textStore == null) {
            return null;
        }
        try {
            String configText = textStore.getStoredText();
            Properties configuration = this.parseConfigText(configText);
            return configuration;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    private TextStore getConfigurationStore(Root metadata, String name) {
        TextStore result = null;
        try {
            AssociationList noteList = metadata.getNotes();
            for (TextStore nextStore : noteList) {
                if (!name.equals(nextStore.getName())) continue;
                result = nextStore;
                break;
            }
        }
        catch (MdException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return result;
    }

    protected Properties parseConfigText(String text) {
        if (text == null) {
            return null;
        }
        Properties results = new Properties();
        StringTokenizer st = new StringTokenizer(text, "\n");
        while (st.hasMoreTokens()) {
            String value;
            String name;
            String nextToken = st.nextToken();
            int index = nextToken.indexOf(61);
            if (index < 0) {
                name = nextToken;
                value = "";
            } else {
                name = nextToken.substring(0, index);
                value = nextToken.substring(index + 1);
            }
            results.setProperty(name, value);
        }
        return results;
    }

    @Override
    public boolean prepareCall(Class[] args, Object[] parms, String argType, Object value) {
        args[0] = Properties.class;
        parms[0] = value;
        return true;
    }

    @Override
    public void setAttribute(Object o, AttributeMapping map, CMetadata metadata, Map<String, ResultMapEntry> updateMap) {
        String configType = map.getMetadataAttribute();
        String configName = null;
        if (configType.equalsIgnoreCase(CONFIGURATION_PUBLIC)) {
            configName = PUBLIC_CONFIGURATION_PROPERTIES;
        } else if (configType.equalsIgnoreCase(CONFIGURATION_PRIVATE)) {
            configName = PRIVATE_CONFIGURATION_PROPERTIES;
        }
        if (configName == null) {
            throw new RuntimeException("Only a property of 'Public' or 'Private' is valid");
        }
        if (o == null) {
            TextStore store = this.getConfigurationStore((Root)metadata, configName);
            if (store != null) {
                try {
                    store.delete();
                }
                catch (RemoteException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
        } else {
            Properties configurations = (Properties)o;
            String text = this.makeConfigText(configurations);
            TextStore store = this.getConfigurationStore((Root)metadata, configName);
            try {
                if (store == null) {
                    MdObjectStore mdstore = (MdObjectStore)metadata.getObjectStore();
                    MdFactory factory = mdstore.getFactory();
                    store = (TextStore)factory.createComplexMetadataObject(mdstore, null, configName, "TextStore", metadata.getRepositoryID());
                    ((Root)metadata).getNotes().add((Object)store);
                }
                store.setStoredText(text);
            }
            catch (MdException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    protected String makeConfigText(Properties values) {
        StringBuffer buffer = new StringBuffer();
        boolean isFirst = true;
        Set<Map.Entry<Object, Object>> valueSet = values.entrySet();
        for (Map.Entry<Object, Object> nextValue : valueSet) {
            if (!isFirst) {
                buffer.append("\n");
            }
            isFirst = false;
            buffer.append(nextValue.getKey() + "=" + nextValue.getValue());
        }
        return buffer.toString();
    }
}

