/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr.mapping;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.svcs.common.client.dao.omr.MetadataContentUtils;
import com.sas.svcs.common.client.dao.omr.mapping.AttributeMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ObjectMapping;
import com.sas.svcs.common.client.dao.omr.mapping.ResultMapEntry;
import com.sas.svcs.common.client.dao.omr.mapping.processors.AttributeProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.ContentPropertiesProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.CreatedModifiedByProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.IdentifierListProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.IdentifierProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.ObjectIdentityListProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.PathProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.PropertiesProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.PropertyProcessor;
import com.sas.svcs.common.client.dao.omr.mapping.processors.ReferenceProcessor;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DAOUtil
implements AttributeProcessor {
    public static final String KEY_AUTHSERVER = "authserver";
    public static final String KEY_DAOUTIL = "DAOUtil";
    private static final double SecondsInTheSixties = 3.156192E8;
    private MetadataContentUtils metadataContentUtils = new MetadataContentUtils();
    private PropertyProcessor propertyProcessor = null;
    private ObjectIdentityListProcessor objectIdentityListProcessor = null;
    private ObjectTypeService objectTypeService = null;
    private ServerInterface server = null;
    private Map<String, AttributeProcessor> processorMap = new HashMap<String, AttributeProcessor>();
    private Map<String, ObjectMapping> mappingMap = new HashMap<String, ObjectMapping>();
    private Logger log = LogManager.getLogger(DAOUtil.class);

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
        if (this.objectIdentityListProcessor != null) {
            this.objectIdentityListProcessor.setObjectTypeService(objectTypeService);
        }
    }

    public DAOUtil() {
        this.processorMap.put("Reference", new ReferenceProcessor());
        this.processorMap.put("ContentPath", new PathProcessor());
        this.processorMap.put("CreatedModifiedBy", new CreatedModifiedByProcessor());
        this.processorMap.put("MetadataIdentifier", new IdentifierProcessor());
        this.processorMap.put("IdentifierListProcessor", new IdentifierListProcessor());
        this.processorMap.put("Boolean", this);
        this.processorMap.put("boolean", this);
        this.processorMap.put("Date", this);
        this.processorMap.put("Double", this);
        this.processorMap.put("double", this);
        this.processorMap.put("Integer", this);
        this.processorMap.put("int", this);
        this.processorMap.put("Long", this);
        this.processorMap.put("long", this);
        this.processorMap.put("ObjectType", this);
        this.processorMap.put("String", this);
        this.propertyProcessor = new PropertyProcessor();
        this.processorMap.put("BooleanPropertyValue", this.propertyProcessor);
        this.processorMap.put("booleanPropertyValue", this.propertyProcessor);
        this.processorMap.put("DatePropertyValue", this.propertyProcessor);
        this.processorMap.put("DoublePropertyValue", this.propertyProcessor);
        this.processorMap.put("doublePropertyValue", this.propertyProcessor);
        this.processorMap.put("IntegerPropertyValue", this.propertyProcessor);
        this.processorMap.put("intPropertyValue", this.propertyProcessor);
        this.processorMap.put("LongPropertyValue", this.propertyProcessor);
        this.processorMap.put("longPropertyValue", this.propertyProcessor);
        this.processorMap.put("StringPropertyValue", this.propertyProcessor);
        this.processorMap.put("WildcardProperties", new PropertiesProcessor());
        this.objectIdentityListProcessor = new ObjectIdentityListProcessor();
        this.processorMap.put("ObjectIdentityListProcessor", this.objectIdentityListProcessor);
        this.processorMap.put("ContentProperties", new ContentPropertiesProcessor());
    }

    public void addProcessor(String type, AttributeProcessor processor) {
        this.processorMap.put(type, processor);
    }

    public void setServer(ServerInterface server) {
        this.server = server;
    }

    public void populateObjectFromResultMap(Object o, Map<String, ResultMapEntry> resultMap) {
        Set<String> keySet = resultMap.keySet();
        for (String nextKey : keySet) {
            Method setMethod;
            String methodName;
            Class<?> oclass;
            Object valueObject;
            ResultMapEntry rme = resultMap.get(nextKey);
            AttributeMapping mapping = rme.mapping;
            if (mapping == null || (valueObject = rme.value) == null) continue;
            String argType = mapping.getArgType();
            AttributeProcessor processor = this.processorMap.get(argType);
            Class[] args = new Class[1];
            Object[] parms = new Object[1];
            if (processor != null) {
                if (!processor.prepareCall(args, parms, argType, valueObject)) continue;
                oclass = o.getClass();
                methodName = "set" + nextKey;
                setMethod = null;
                try {
                    setMethod = oclass.getMethod(methodName, args);
                }
                catch (NoSuchMethodException ex) {
                    this.log.error("No method named " + methodName + " for class " + oclass.getName());
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                if (setMethod == null) continue;
                try {
                    setMethod.invoke(o, parms);
                    continue;
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex.getMessage(), ex.getCause());
                }
            }
            if (valueObject instanceof List) {
                args[0] = List.class;
                parms[0] = (List)valueObject;
            } else {
                Class<?> vclass;
                args[0] = vclass = valueObject.getClass();
                parms[0] = valueObject;
            }
            oclass = o.getClass();
            methodName = "set" + nextKey;
            setMethod = null;
            try {
                setMethod = oclass.getMethod(methodName, args);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            if (setMethod == null) continue;
            try {
                setMethod.invoke(o, parms);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex.getMessage(), ex.getCause());
            }
        }
    }

    public Map<String, ResultMapEntry> processMapBrowse(ObjectMapping objectMap, BrowseMetadata bmi) {
        HashMap<String, ResultMapEntry> result = new HashMap<String, ResultMapEntry>();
        if (this.server != null) {
            ResultMapEntry entry = new ResultMapEntry();
            entry.value = this.server;
            result.put(KEY_AUTHSERVER, entry);
        }
        List<AttributeMapping> attMapList = objectMap.mappingList;
        for (AttributeMapping nextAttributeMap : attMapList) {
            String argType = nextAttributeMap.getArgType();
            AttributeProcessor processor = this.processorMap.get(argType);
            if (processor == null) {
                ObjectMapping subMap = this.getMappingForClass(argType);
                if (subMap != null) {
                    Object resultEntry = null;
                    String metadataAttribute = nextAttributeMap.getMetadataAttribute();
                    Object o = bmi.get(metadataAttribute);
                    if (o == null) continue;
                    if (o instanceof List) {
                        resultEntry = new ArrayList();
                        for (BrowseMetadata subMetadata : (List)o) {
                            Map<String, ResultMapEntry> subResult = this.processMapBrowse(subMap, subMetadata);
                            Object subValue = this.newInstance(subMap.contentClass);
                            this.populateObjectFromResultMap(subValue, subResult);
                            ((List)resultEntry).add(subValue);
                        }
                    } else {
                        resultEntry = this.newInstance(subMap.contentClass);
                        Map<String, ResultMapEntry> subResult = this.processMapBrowse(subMap, (BrowseMetadata)o);
                        this.populateObjectFromResultMap(resultEntry, subResult);
                    }
                    ResultMapEntry rme = new ResultMapEntry();
                    rme.mapping = nextAttributeMap;
                    rme.value = resultEntry;
                    result.put(nextAttributeMap.getAttributeName(), rme);
                    continue;
                }
                throw new RuntimeException("I have no attribute processor for type " + argType);
            }
            Object o = processor.getBrowseObject(nextAttributeMap, bmi, result);
            if (o == null) continue;
            ResultMapEntry rme = new ResultMapEntry();
            rme.mapping = nextAttributeMap;
            rme.value = o;
            result.put(nextAttributeMap.getAttributeName(), rme);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, ResultMapEntry> processObjectMap(ObjectMapping objectMap, CMetadata metadata) {
        ResultMapEntry entry;
        try {
            this.log.debug("Begin processing object map for " + metadata.getName());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        HashMap<String, ResultMapEntry> result = new HashMap<String, ResultMapEntry>();
        if (this.server != null) {
            entry = new ResultMapEntry();
            entry.value = this.server;
            result.put(KEY_AUTHSERVER, entry);
        }
        entry = new ResultMapEntry();
        entry.value = this;
        result.put(KEY_DAOUTIL, entry);
        List<AttributeMapping> attMapList = objectMap.mappingList;
        for (AttributeMapping nextAttributeMap : attMapList) {
            long start = System.currentTimeMillis();
            String argType = nextAttributeMap.getArgType();
            AttributeProcessor processor = this.processorMap.get(argType);
            if (processor == null) {
                ObjectMapping subMap = this.mappingMap.get(argType);
                if (subMap == null) {
                    try {
                        Object subo = this.newInstance(argType);
                        Method m = subo.getClass().getMethod("getObjectMapping", new Class[0]);
                        subMap = (ObjectMapping)m.invoke(subo, null);
                        this.mappingMap.put(argType, subMap);
                    }
                    catch (ClassCastException ex) {
                        ex.printStackTrace();
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvocationTargetException ex) {
                        ex.printStackTrace();
                    }
                    catch (NoSuchMethodException ex) {
                        ex.printStackTrace();
                    }
                }
                if (subMap == null) throw new RuntimeException("I have no attribute processor for type " + argType);
                ArrayList resultEntry = null;
                String metadataAttribute = nextAttributeMap.getMetadataAttribute();
                Object o = this.getMetadataAssociation(metadata, metadataAttribute);
                if (o instanceof List) {
                    if (((List)o).size() > 0) {
                        resultEntry = new ArrayList();
                        for (CMetadata subMetadata : (List)o) {
                            Map<String, ResultMapEntry> subResult = this.processObjectMap(subMap, subMetadata);
                            Object subValue = this.newInstance(subMap.contentClass);
                            this.populateObjectFromResultMap(subValue, subResult);
                            ((List)resultEntry).add(subValue);
                        }
                    }
                } else {
                    resultEntry = this.newInstance(subMap.contentClass);
                    Map<String, ResultMapEntry> subResult = this.processObjectMap(subMap, (CMetadata)o);
                    this.populateObjectFromResultMap(resultEntry, subResult);
                }
                ResultMapEntry rme = new ResultMapEntry();
                rme.mapping = nextAttributeMap;
                rme.value = resultEntry;
                result.put(nextAttributeMap.getAttributeName(), rme);
            } else {
                Object o = processor.getResultingObject(nextAttributeMap, metadata, result);
                if (o != null) {
                    ResultMapEntry rme = new ResultMapEntry();
                    rme.mapping = nextAttributeMap;
                    rme.value = o;
                    result.put(nextAttributeMap.getAttributeName(), rme);
                }
            }
            long end = System.currentTimeMillis();
            this.log.debug("Processing " + nextAttributeMap.getAttributeName() + " took " + (end - start) + " milliseconds.");
        }
        return result;
    }

    @Override
    public Object getBrowseObject(AttributeMapping mapping, BrowseMetadata bmi, Map<String, ResultMapEntry> result) {
        String path = mapping.getMetadataAttribute();
        BrowseMetadata source = bmi;
        String attrName = null;
        if (path.startsWith("&")) {
            int index = path.indexOf("@");
            String sourceName = path.substring(1, index);
            attrName = path.substring(index + 1);
            ResultMapEntry rme = result.get(sourceName);
            if (rme == null) {
                return null;
            }
            Object o = rme.value;
            if (o == null) {
                return null;
            }
            source = (BrowseMetadata)o;
        } else {
            attrName = path.substring(1);
        }
        if (source == null) {
            return null;
        }
        String attrValue = (String)source.get(attrName);
        if (mapping.getArgType().equals("Date")) {
            try {
                NumberFormat nf = NumberFormat.getInstance(Locale.US);
                long corbaDateGMT = nf.parse(attrValue).longValue();
                Date dateValue = new Date(corbaDateGMT);
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                String dateString = sdf.format(dateValue);
                return dateString;
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        if (attrValue != null && attrValue.trim().length() > 0) {
            return attrValue;
        }
        return null;
    }

    public Object getMetadataAssociation(CMetadata candidate, String association) {
        try {
            List nextAssoc = (List)candidate.getAssocs().get(association);
            if (nextAssoc == null) {
                try {
                    String methodName = "get" + association;
                    Method method = candidate.getClass().getMethod(methodName, null);
                    Object o = method.invoke((Object)candidate, null);
                    return o;
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
                catch (InvocationTargetException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
            } else {
                return nextAssoc;
            }
            return null;
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void setMetadataAssociation(CMetadata candidate, String association, Object value) {
        try {
            Class[] args = new Class[]{value.getClass()};
            Object[] parms = new Object[]{value};
            String methodName = "set" + association;
            Method method = candidate.getClass().getMethod(methodName, args);
            Object object = method.invoke((Object)candidate, parms);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getResultingObject(AttributeMapping mapping, CMetadata metadata, Map<String, ResultMapEntry> result) {
        try {
            String path = mapping.getMetadataAttribute();
            CMetadata source = metadata;
            String attrName = null;
            if (path.startsWith("&")) {
                int index = path.indexOf("@");
                String sourceName = path.substring(1, index);
                attrName = path.substring(index + 1);
                ResultMapEntry rme = result.get(sourceName);
                if (rme == null) {
                    return null;
                }
                Object o = rme.value;
                if (o == null) {
                    return null;
                }
                source = (CMetadata)o;
            } else {
                attrName = path.substring(1);
            }
            Map attrMap = source.getAttrs();
            String attrValue = (String)attrMap.get(attrName);
            if (attrValue == null) return null;
            if (attrValue.trim().length() <= 0) return null;
            return attrValue;
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean prepareCall(Class[] args, Object[] parms, String argType, Object metaAttribute) {
        if ("Boolean".equals(argType)) {
            args[0] = Boolean.class;
            String boolString = (String)metaAttribute;
            parms[0] = boolString.equals("1") ? Boolean.TRUE : (boolString.equalsIgnoreCase("yes") ? Boolean.TRUE : (boolString.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE));
        } else if ("boolean".equals(argType)) {
            args[0] = Boolean.TYPE;
            String boolString = (String)metaAttribute;
            parms[0] = boolString.equals("1") ? Boolean.TRUE : (boolString.equalsIgnoreCase("yes") ? Boolean.TRUE : (boolString.equalsIgnoreCase("true") ? Boolean.TRUE : Boolean.FALSE));
        } else if ("Date".equals(argType)) {
            args[0] = Date.class;
            if (metaAttribute instanceof Date) {
                parms[0] = (Date)metaAttribute;
            } else {
                try {
                    parms[0] = this.metadataContentUtils.makeDateFromMetadataString((String)metaAttribute);
                }
                catch (ParseException boolString) {}
            }
        } else if ("Double".equals(argType)) {
            args[0] = Double.class;
            parms[0] = Double.valueOf((String)metaAttribute);
        } else if ("double".equals(argType)) {
            args[0] = Double.TYPE;
            parms[0] = Double.valueOf((String)metaAttribute);
        } else if ("Integer".equals(argType)) {
            args[0] = Integer.class;
            parms[0] = Integer.valueOf((String)metaAttribute);
        } else if ("int".equals(argType)) {
            args[0] = Integer.TYPE;
            parms[0] = Integer.valueOf((String)metaAttribute);
        } else if ("Long".equals(argType)) {
            args[0] = Long.class;
            parms[0] = Long.valueOf((String)metaAttribute);
        } else if ("long".equals(argType)) {
            args[0] = Long.TYPE;
            parms[0] = Long.valueOf((String)metaAttribute);
        } else if ("String".equals(argType)) {
            args[0] = String.class;
            parms[0] = (String)metaAttribute;
        } else if ("ObjectType".equals(argType)) {
            long result = -1L;
            args[0] = Long.TYPE;
            ObjectType objectType = this.objectTypeService.getTypeByName((String)metaAttribute);
            if (objectType != null) {
                result = objectType.getId();
            }
            parms[0] = result;
        }
        return true;
    }

    public Map<String, ResultMapEntry> makeUpdateMap(Object content, ObjectMapping mapping) {
        HashMap<String, ResultMapEntry> resultMap = new HashMap<String, ResultMapEntry>();
        List<AttributeMapping> attributeMap = mapping.mappingList;
        for (AttributeMapping nextMap : attributeMap) {
            String argType = nextMap.getArgType();
            String attrName = nextMap.getAttributeName();
            String methodName = null;
            if ("Reference".equals(argType)) break;
            methodName = "boolean".equals(argType) || "booleanPropertyValue".equals(argType) ? "is" + attrName : "get" + attrName;
            try {
                Method method = content.getClass().getMethod(methodName, null);
                Object o = method.invoke(content, null);
                ResultMapEntry rme = new ResultMapEntry();
                rme.mapping = nextMap;
                rme.value = o;
                resultMap.put(attrName, rme);
            }
            catch (NoSuchMethodException ex) {
                this.log.warn("No such method: " + methodName + " for class " + content.getClass().getName());
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace(System.out);
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace(System.out);
            }
        }
        return resultMap;
    }

    public void updateMetadataFromMap(CMetadata cm, Map<String, ResultMapEntry> updateMap, ObjectMapping mapping) {
        List<AttributeMapping> attributeMap = mapping.mappingList;
        for (AttributeMapping nextMap : attributeMap) {
            String argType = nextMap.getArgType();
            if (!argType.equals("Reference")) continue;
            ReferenceProcessor ap = (ReferenceProcessor)this.processorMap.get(argType);
            Object o = ap.getResultingObject(nextMap, cm, updateMap, true);
            ResultMapEntry rme = new ResultMapEntry();
            rme.mapping = nextMap;
            rme.value = o;
            updateMap.put(nextMap.getAttributeName(), rme);
        }
        Set<String> keySet = updateMap.keySet();
        for (String nextKey : keySet) {
            String metadataType;
            List<CMetadata> currentValues;
            ResultMapEntry rme = updateMap.get(nextKey);
            AttributeMapping map = rme.mapping;
            String argType = map.getArgType();
            AttributeProcessor processor = this.processorMap.get(argType);
            if (processor != null) {
                processor.setAttribute(rme.value, map, cm, updateMap);
                continue;
            }
            ObjectMapping subMapping = this.getMappingForClass(argType);
            if (subMapping == null) continue;
            if (rme.value == null || rme.value instanceof List) {
                List associationList = (List)this.getMetadataAssociation(cm, map.getMetadataAttribute());
                currentValues = new ArrayList(associationList);
                for (CMetadata currentCM : currentValues) {
                    try {
                        currentCM.delete();
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                }
                if (rme.value == null) continue;
                metadataType = this.getMetadataTypeForClass(argType);
                if (metadataType == null) {
                    throw new RuntimeException("A chained mapping class has to have a getMetadataType method.");
                }
                for (Object o : (List)rme.value) {
                    Map<String, ResultMapEntry> subMap = this.makeUpdateMap(o, subMapping);
                    try {
                        MdObjectStore mdstore = (MdObjectStore)cm.getObjectStore();
                        MdFactory factory = mdstore.getFactory();
                        String newObjectName = metadataType + "_" + System.currentTimeMillis();
                        CMetadata subCM = factory.createComplexMetadataObject(mdstore, null, newObjectName, metadataType, cm.getRepositoryID());
                        this.updateMetadataFromMap(subCM, subMap, subMapping);
                        associationList.add(subCM);
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                }
                continue;
            }
            Object associatedMetadata = this.getMetadataAssociation(cm, map.getMetadataAttribute());
            if (associatedMetadata instanceof List) {
                currentValues = (List)associatedMetadata;
                for (CMetadata currentCM : currentValues) {
                    try {
                        currentCM.delete();
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                }
                metadataType = this.getMetadataTypeForClass(argType);
                if (metadataType == null) {
                    throw new RuntimeException("A chained mapping class has to have a getMetadataType method.");
                }
                Map<String, ResultMapEntry> subMap = this.makeUpdateMap(rme.value, subMapping);
                try {
                    MdObjectStore mdstore = (MdObjectStore)cm.getObjectStore();
                    MdFactory factory = mdstore.getFactory();
                    String newObjectName = metadataType + "_" + System.currentTimeMillis();
                    CMetadata subCM = factory.createComplexMetadataObject(mdstore, null, newObjectName, metadataType, cm.getRepositoryID());
                    this.updateMetadataFromMap(subCM, subMap, subMapping);
                    currentValues.add(subCM);
                    continue;
                }
                catch (RemoteException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            CMetadata currentValue = (CMetadata)associatedMetadata;
            try {
                currentValue.delete();
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            String metadataType2 = this.getMetadataTypeForClass(argType);
            if (metadataType2 == null) {
                throw new RuntimeException("A chained mapping class has to have a getMetadataType method.");
            }
            Map<String, ResultMapEntry> subMap = this.makeUpdateMap(rme.value, subMapping);
            try {
                MdObjectStore mdstore = (MdObjectStore)cm.getObjectStore();
                MdFactory factory = mdstore.getFactory();
                String newObjectName = metadataType2 + "_" + System.currentTimeMillis();
                CMetadata subCM = factory.createComplexMetadataObject(mdstore, null, newObjectName, metadataType2, cm.getRepositoryID());
                this.updateMetadataFromMap(subCM, subMap, subMapping);
                this.setMetadataAssociation(cm, map.getMetadataAttribute(), subCM);
            }
            catch (RemoteException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    public ContentObject makeDefaultObject(ObjectMapping mapping) {
        ContentObject result = null;
        String classString = mapping.contentClass;
        result = (ContentObject)this.newInstance(classString);
        Map<String, Object> defaultsMap = mapping.getDefaultsMap();
        if (defaultsMap == null) {
            return result;
        }
        HashMap<String, ResultMapEntry> defaultUpdateMap = new HashMap<String, ResultMapEntry>();
        List<AttributeMapping> mappingList = mapping.mappingList;
        for (AttributeMapping nextMapping : mappingList) {
            String key = nextMapping.getAttributeName();
            Object o = defaultsMap.get(key);
            if (o == null) continue;
            ResultMapEntry rme = new ResultMapEntry();
            rme.mapping = nextMapping;
            rme.value = o;
            defaultUpdateMap.put(key, rme);
        }
        this.populateObjectFromResultMap(result, defaultUpdateMap);
        return result;
    }

    @Override
    public void setAttribute(Object o, AttributeMapping map, CMetadata metadata, Map<String, ResultMapEntry> updateMap) {
        CMetadata target = metadata;
        String argType = map.getArgType();
        String setting = null;
        if ("Boolean".equals(argType)) {
            setting = (Boolean)o != false ? "1" : "0";
        } else if ("boolean".equals(argType)) {
            setting = (Boolean)o != false ? "1" : "0";
        } else if ("Date".equals(argType)) {
            if (o != null) {
                Date d = (Date)o;
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
                setting = sdf.format(d);
            }
        } else if ("Double".equals(argType)) {
            if (o != null) {
                setting = ((Double)o).toString();
            }
        } else if ("double".equals(argType)) {
            setting = ((Double)o).toString();
        } else if ("Integer".equals(argType)) {
            if (o != null) {
                setting = ((Integer)o).toString();
            }
        } else if ("int".equals(argType)) {
            setting = ((Integer)o).toString();
        } else if ("Long".equals(argType)) {
            if (o != null) {
                setting = ((Long)o).toString();
            }
        } else if ("long".equals(argType)) {
            setting = ((Long)o).toString();
        } else if ("String".equals(argType)) {
            setting = (String)o;
        } else if ("ObjectType".equals(argType)) {
            return;
        }
        String path = map.getMetadataAttribute();
        String attrName = null;
        if (path.startsWith("&")) {
            int index = path.indexOf("@");
            String sourceName = path.substring(1, index);
            attrName = path.substring(index + 1);
            ResultMapEntry rme = updateMap.get(sourceName);
            if (rme == null) {
                throw new RuntimeException("No entry for " + sourceName + " was found.");
            }
            Object mapObject = rme.value;
            if (mapObject == null) {
                ReferenceProcessor rp = new ReferenceProcessor();
                rme.value = mapObject = rp.getResultingObject(rme.mapping, metadata, updateMap, true);
            }
            target = (CMetadata)mapObject;
        } else {
            attrName = path.substring(1);
        }
        try {
            String methodName = "set" + attrName;
            Class[] args = new Class[]{String.class};
            Object[] parms = new Object[]{setting};
            Method method = target.getClass().getMethod(methodName, args);
            method.invoke((Object)target, parms);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public ObjectMapping getMappingForClass(String argType) {
        ObjectMapping subMap = this.mappingMap.get(argType);
        if (subMap == null) {
            try {
                Object subo = this.newInstance(argType);
                Method m = subo.getClass().getMethod("getObjectMapping", new Class[0]);
                subMap = (ObjectMapping)m.invoke(subo, null);
                this.mappingMap.put(argType, subMap);
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InvocationTargetException ex) {
                ex.printStackTrace();
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
            }
        }
        return subMap;
    }

    public String getMetadataTypeForClass(String argType) {
        String result = null;
        try {
            Object subo = this.newInstance(argType);
            Method m = subo.getClass().getMethod("getMetadataType", new Class[0]);
            result = (String)m.invoke(subo, null);
        }
        catch (ClassCastException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Object newInstance(String className) {
        ClassLoader loader = this.getClass().getClassLoader();
        Class<?> objectClass = null;
        Object result = null;
        try {
            objectClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            Constructor<?> ctor = objectClass.getConstructor(null);
            result = ctor.newInstance(null);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }
}

