/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.svcs.common.client.dao.ContentNodeDAO;
import com.sas.svcs.common.client.dao.omr.BaseSmartObjectContentDAO;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SmartObjectContentNodeDAO<T extends ContentNode, S extends MetadataInterface>
extends BaseSmartObjectContentDAO<T, S>
implements ContentNodeDAO<T> {
    private static final Logger log = LogManager.getLogger(SmartObjectContentNodeDAO.class);

    public SmartObjectContentNodeDAO(Class<T> contentClazz, long objectType, String metadataType, String publicType, String omrModelType, String usageVersion) {
        super(contentClazz, objectType, metadataType, publicType, omrModelType, usageVersion);
    }

    public T create(ObjectIdentity parent, T object) throws ObjectNotFoundException, ObjectExistsException, ValidationException {
        String folderIdentity = parent.getId();
        ContentNode ret = null;
        FolderInterface folder = this.getMetadataTemplate().searchRequiredFolderById(folderIdentity);
        MetadataInterface metadata = this.getMetadataTemplate().makeNewMetadata(folder, object.getName(), this.getMetadataType(), this.getPublicType(), this.getUsageVersion());
        try {
            this.getMetadataUtils().updateContentObject((ContentObject)object, metadata);
            this.mapDescriptorToSmartObject(object, metadata);
            this.mapContentObjectToSmartObject(object, metadata);
            metadata.update();
            metadata.refresh();
        }
        catch (Exception e) {
            log.error("OMR Exception creating object.", (Throwable)e);
            throw new RuntimeException("OMR Exception creating object:" + e.getMessage());
        }
        ret = (ContentNode)this.getNewContentObject();
        this.getMetadataUtils().populateContentNodeFromMetadata(ret, metadata);
        try {
            this.mapSmartObjectToDescriptor(metadata, ret);
            this.mapSmartObjectToContentObject(metadata, ret);
            ret.setInternalVersion(this.getInternalVersion(metadata));
        }
        catch (Exception e) {
            log.error("OMR Exception populating content object.  The object has been updated, but could not be retrieved.", (Throwable)e);
            throw new RuntimeException("OMR Exception populating content object.  The object has been updated, but could not be retrieved: " + e.getMessage());
        }
        return (T)ret;
    }

    protected S getSmartObjectByPath(String path) {
        return (S)this.getMetadataTemplate().getMetadataObjectByPath(path + "(" + this.getPublicType() + ")");
    }

    public T findByPath(String path) {
        Object object = null;
        try {
            object = this.getSmartObjectByPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (object == null) {
            return null;
        }
        ContentNode ret = (ContentNode)this.getContentObjectFromSmartObject(object);
        try {
            String objPath = object.getPath(null);
            if (objPath != null && !objPath.startsWith("/")) {
                objPath = "/" + objPath;
            }
            ret.setPath(objPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return (T)ret;
    }

    public T findByPath(String path, String versionName) {
        return null;
    }
}

