/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.metadata.remote.PrimaryType;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.UserFolderType;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdFilter;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathFilter;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.FolderModelFactory;
import com.sas.services.information.sasfolders.ModelConfiguration;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.sasfolders.SASFoldersModelInterface;
import com.sas.services.information.search.ResultDetails;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.common.client.SASObjUri;
import com.sas.svcs.common.client.dao.omr.BrowseMetadataMapper;
import com.sas.svcs.common.client.dao.omr.MetadataContentUtils;
import com.sas.svcs.common.client.dao.omr.MutableSmartObjectMapper;
import com.sas.svcs.common.client.dao.omr.PathUtils;
import com.sas.svcs.common.client.dao.omr.PublicObjectMapper;
import com.sas.svcs.common.client.dao.omr.SmartObjectMapper;
import com.sas.svcs.common.client.dao.omr.UserSessionContextProvider;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.client.util.ContentTypeCompare;
import com.sas.svcs.content.framework.client.ContentRuntimeException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;

public class MetadataTemplate {
    private static final Logger log = LogManager.getLogger(MetadataTemplate.class);
    private static boolean isVersionOutput = false;
    private InformationServiceInterface infoService;
    private UserSessionContextProvider userSessionProvider;
    private ObjectTypeService objectTypeService;
    private MetadataContentUtils metadataUtils = new MetadataContentUtils();
    private String myFolderName;

    @Autowired
    public void setInformationService(@Qualifier(value="local") InformationServiceInterface infoService) {
        this.infoService = infoService;
    }

    public InformationServiceInterface getInformationService() {
        return this.infoService;
    }

    public UserSessionContextProvider getUserSessionContextProvider() {
        return this.userSessionProvider;
    }

    @Required
    public void setUserSessionContextProvider(UserSessionContextProvider userSessionProvider) {
        this.userSessionProvider = userSessionProvider;
    }

    @Autowired(required=false)
    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }

    public final ChildServerInterface createNewTransaction() {
        try {
            ChildServerInterface childServer = this.getServer().newChild(true);
            return childServer;
        }
        catch (ServiceException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public final void closeTransaction(ChildServerInterface server) {
        try {
            if (server != null) {
                server.rollback();
            }
        }
        catch (ServiceException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public final void commitTransaction(ChildServerInterface server) {
        try {
            if (server != null) {
                server.commit();
            }
        }
        catch (ServiceException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            throw new ContentRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public ServerInterface getServer() throws RemoteException, ServiceException {
        UserContextInterface user = this.getUserContext();
        return user.getAuthServer();
    }

    public String getMyFolderName() {
        if (this.myFolderName != null) {
            return this.myFolderName;
        }
        try {
            FolderInterface myFolder = this.getServer().getHomeFolder(null, UserFolderType.MYFOLDER, null, true);
            this.myFolderName = myFolder.getName();
        }
        catch (Exception e) {
            log.error("Exception getting MyFolder name", (Throwable)e);
            throw new RuntimeException("Exception getting MyFolder name - " + e.getMessage());
        }
        return this.myFolderName;
    }

    public String getMyFolderPath() {
        return "/" + this.getMyFolderName();
    }

    public void setMetadataContentUtils(MetadataContentUtils metadataUtils) {
        this.metadataUtils = metadataUtils;
    }

    private String getPublicTypeFromObjectType(long objectTypeId) {
        ObjectType type = this.objectTypeService.getTypeById(objectTypeId);
        return type == null ? null : type.getName();
    }

    private String getPublicObjectId(String contentId) {
        String tmpId = contentId.substring(0, contentId.indexOf("/"));
        return tmpId;
    }

    private boolean isCorrectType(PublicObjectInterface poi, String typeName) throws ServiceException, RemoteException {
        TypeDescriptorInterface tdi = poi.getTypeDescriptor();
        if (tdi == null) {
            return false;
        }
        return ContentTypeCompare.isTypeMatch((String)typeName, (String)tdi.getTypeName());
    }

    public BrowseMetadataInterface fetchBrowseMetadataById(String id, String template) {
        try {
            ServerInterface server = this.getServer();
            Filter filter = new Filter();
            filter.setOMRTemplate(template);
            BrowseMetadataInterface bmi = server.browseFetch(id, (FilterInterface)filter);
            return bmi;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public <T> T fetchBrowseMetadataById(String id, String template, BrowseMetadataMapper<T> browseMapper) {
        BrowseMetadataInterface bmi = this.fetchBrowseMetadataById(id, template);
        T ret = null;
        if (bmi != null) {
            ret = browseMapper.mapBrowseMetadata(bmi);
        }
        return ret;
    }

    public <T> List<T> searchBrowseMetadataAll(String publicType, String template, String omrModelType, BrowseMetadataMapper<T> browseMapper) {
        return this.searchBrowseMetadataAll(publicType, template, omrModelType, -1, browseMapper);
    }

    public <T> List<T> searchBrowseMetadataAll(String publicType, String template, String omrModelType, int omrFlags, BrowseMetadataMapper<T> browseMapper) {
        List<BrowseMetadataInterface> bmis = this.searchBrowseMetadataAll(publicType, template, omrModelType, omrFlags);
        ArrayList<T> ret = new ArrayList<T>(bmis.size());
        for (BrowseMetadataInterface bmi : bmis) {
            ret.add(browseMapper.mapBrowseMetadata(bmi));
        }
        return ret;
    }

    public List<BrowseMetadataInterface> searchBrowseMetadataAll(String publicType, String template, String omrModelType) {
        return this.searchBrowseMetadataAll(publicType, template, omrModelType, -1);
    }

    public List<BrowseMetadataInterface> searchBrowseMetadataAll(String publicType, String template, String omrModelType, int omrFlags) {
        try {
            ServerInterface server = this.getServer();
            Filter filter = new Filter("PublicType", 0, publicType);
            if (template != null) {
                filter.setOMRTemplate(template);
            }
            if (omrFlags >= 0) {
                filter.setOMRFlags(omrFlags);
            }
            filter.setType(omrModelType);
            long start1 = System.currentTimeMillis();
            List result = server.browseSearch((FilterInterface)filter);
            long end1 = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Retrieving all " + publicType + " browse objects took: " + (end1 - start1) + " milliseconds.");
            }
            return result;
        }
        catch (Exception e) {
            log.error("Exception getting all browse metadata objects of type: " + publicType, (Throwable)e);
            throw new RuntimeException("Exception getting all browse metadata objects of type: " + publicType + " - " + e.getMessage());
        }
    }

    public BrowseMetadataInterface searchBrowseMetadataById(String id, String template) {
        BrowseMetadataInterface bm = null;
        try {
            List browseList;
            ServerInterface server = this.getServer();
            if (log.isDebugEnabled()) {
                log.debug("ID FOR OBJECT LOOKUP: " + id);
            }
            OMRRepositoryKey reposKey = new OMRRepositoryKey(id);
            String ident = reposKey.getId();
            String type = reposKey.getType();
            Filter filter = new Filter("Id", 0, ident);
            filter.setOMRFlags(512);
            filter.setType(type);
            if (template != null) {
                filter.setOMRTemplate(template);
            }
            if ((browseList = server.browseSearch((FilterInterface)filter)).size() > 0) {
                bm = (BrowseMetadataInterface)browseList.get(0);
            }
        }
        catch (Exception e) {
            log.error("Exception getting metadata object: " + id, (Throwable)e);
            throw new RuntimeException("Exception getting metadata object: " + id + " - " + e.getMessage());
        }
        return bm;
    }

    public <T> T searchBrowseMetadataById(String id, String template, BrowseMetadataMapper<T> browseMapper) {
        BrowseMetadataInterface bmi = this.searchBrowseMetadataById(id, template);
        T ret = null;
        if (bmi != null) {
            ret = browseMapper.mapBrowseMetadata(bmi);
        }
        return ret;
    }

    public List<BrowseMetadataInterface> searchBrowseMetadataObjects(String xmlSelect, String template) {
        return this.searchBrowseMetadataObjects(xmlSelect, template, -1);
    }

    public List<BrowseMetadataInterface> searchBrowseMetadataObjects(String xmlSelect, String template, int omrFlags) {
        try {
            ServerInterface server = this.getServer();
            Filter filter = new Filter();
            if (omrFlags >= 0) {
                filter.setOMRFlags(omrFlags);
            }
            if (template != null) {
                filter.setOMRTemplate(template);
            }
            filter.setExplicitSearchString("omi", xmlSelect);
            List browseList = server.browseSearch((FilterInterface)filter);
            return browseList;
        }
        catch (Exception e) {
            log.error("Exception doing browse search with xmlselect: " + xmlSelect, (Throwable)e);
            throw new RuntimeException("Exception doing browse search with xmlselect: " + xmlSelect + " - " + e.getMessage());
        }
    }

    public <T> List<T> searchBrowseMetadataObjects(String xmlSelect, String template, BrowseMetadataMapper<T> browseMapper) {
        return this.searchBrowseMetadataObjects(xmlSelect, template, -1, browseMapper);
    }

    public <T> List<T> searchBrowseMetadataObjects(String xmlSelect, String template, int omrFlags, BrowseMetadataMapper<T> browseMapper) {
        List<BrowseMetadataInterface> bmiList = this.searchBrowseMetadataObjects(xmlSelect, template, omrFlags);
        ArrayList<T> ret = new ArrayList<T>(bmiList.size());
        for (BrowseMetadataInterface bmi : bmiList) {
            ret.add(browseMapper.mapBrowseMetadata(bmi));
        }
        return ret;
    }

    public BrowseMetadataInterface searchSingleBrowseMetadataObject(String xmlSelect, String template) {
        return this.searchSingleBrowseMetadataObject(xmlSelect, template, -1);
    }

    public BrowseMetadataInterface searchSingleBrowseMetadataObject(String xmlSelect, String template, int omrFlags) {
        List<BrowseMetadataInterface> bmiList = this.searchBrowseMetadataObjects(xmlSelect, template, omrFlags);
        if (bmiList == null || bmiList.size() == 0) {
            return null;
        }
        if (bmiList.size() > 1) {
            throw new RuntimeException("More than one search result for xmlselect: " + xmlSelect);
        }
        return bmiList.get(0);
    }

    public <T> T searchSingleBrowseMetadataObject(String xmlSelect, String template, BrowseMetadataMapper<T> browseMapper) {
        return this.searchSingleBrowseMetadataObject(xmlSelect, template, -1, browseMapper);
    }

    public <T> T searchSingleBrowseMetadataObject(String xmlSelect, String template, int omrFlags, BrowseMetadataMapper<T> browseMapper) {
        BrowseMetadataInterface bmi = this.searchSingleBrowseMetadataObject(xmlSelect, template, omrFlags);
        if (bmi == null) {
            return null;
        }
        return browseMapper.mapBrowseMetadata(bmi);
    }

    public <T> List<T> searchMetadataObjectAll(String publicType, String template, String omrModelType, SmartObjectMapper<T> smartObjectMapper) {
        List<MetadataInterface> mis = this.searchMetadataObjectAll(publicType, template, omrModelType);
        ArrayList<T> ret = new ArrayList<T>(mis.size());
        for (MetadataInterface mi : mis) {
            ret.add(smartObjectMapper.mapSmartObject(mi));
        }
        return ret;
    }

    public List<MetadataInterface> searchMetadataObjectAll(String publicType, String template, String omrModelType) {
        try {
            ServerInterface server = this.getServer();
            Filter filter = new Filter("PublicType", 0, publicType);
            if (template != null) {
                filter.setOMRTemplate(template);
            }
            filter.setType(omrModelType);
            filter.setOMRFlags(0x4000000);
            long start1 = System.currentTimeMillis();
            List results = server.search((FilterInterface)filter);
            long end1 = System.currentTimeMillis();
            if (log.isDebugEnabled()) {
                log.debug("Retrieving all " + publicType + " metadata objects took: " + (end1 - start1) + " milliseconds.");
            }
            return results;
        }
        catch (Exception e) {
            log.error("Exception getting all metadata objects of type: " + publicType, (Throwable)e);
            throw new RuntimeException("Exception getting all metadata objects of type: " + publicType + " - " + e.getMessage());
        }
    }

    public MetadataInterface searchMetadataObjectByObjectId(ObjectIdentity objectId) {
        try {
            MetadataInterface mi = this.searchMetadataObjectById(objectId.getId());
            if (mi == null) {
                return null;
            }
            TypeDescriptorInterface tdi = mi.getTypeDescriptor();
            if (tdi == null) {
                return null;
            }
            ObjectType objectType = this.objectTypeService.getTypeById(objectId.getObjectType());
            if (objectType == null) {
                return null;
            }
            if (!objectType.getName().equals(tdi.getTypeName())) {
                return null;
            }
            return mi;
        }
        catch (ServiceException e) {
            log.error("Finding " + objectId, (Throwable)e);
            throw new RuntimeException("Renaming " + objectId + ": " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Finding " + objectId, (Throwable)e);
            throw new RuntimeException("Renaming " + objectId + ": " + e.getMessage());
        }
    }

    public MetadataInterface searchMetadataObjectById(String id) {
        return this.searchMetadataObjectById(id, (String)null);
    }

    public <T> T searchMetadataObjectById(String id, SmartObjectMapper<T> smartObjectMapper) {
        return this.searchMetadataObjectById(id, null, smartObjectMapper);
    }

    public List<MetadataInterface> searchMetadataObjects(String xmlSelect) {
        ServerInterface server;
        try {
            server = this.getServer();
        }
        catch (ServiceException e) {
            log.error("Calling getServer()", (Throwable)e);
            throw new RuntimeException("Calling getServer(): " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Calling getServer()", (Throwable)e);
            throw new RuntimeException("Calling getServer(): " + e.getMessage());
        }
        return this.searchMetadataObjects(server, xmlSelect);
    }

    public List<MetadataInterface> searchMetadataObjects(ServerInterface server, String xmlSelect) {
        Filter filter = new Filter();
        filter.setExplicitSearchString("omi", xmlSelect);
        filter.setOMRFlags(0x4000000);
        try {
            List miList = server.search((FilterInterface)filter);
            return miList;
        }
        catch (ServiceException e) {
            log.error("Searching " + xmlSelect, (Throwable)e);
            throw new RuntimeException("Searching " + xmlSelect + ": " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Searching " + xmlSelect, (Throwable)e);
            throw new RuntimeException("Searching " + xmlSelect + ": " + e.getMessage());
        }
    }

    public <T> List<T> searchMetadataObjects(String xmlSelect, SmartObjectMapper<T> smartObjectMapper) {
        List<MetadataInterface> miList = this.searchMetadataObjects(xmlSelect);
        ArrayList<T> ret = new ArrayList<T>(miList.size());
        for (MetadataInterface mi : miList) {
            ret.add(smartObjectMapper.mapSmartObject(mi));
        }
        return ret;
    }

    public MetadataInterface searchSingleMetadataObject(String xmlSelect) {
        ServerInterface server;
        try {
            server = this.getServer();
        }
        catch (ServiceException e) {
            log.error("Calling getServer()", (Throwable)e);
            throw new RuntimeException("Calling getServer(): " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Calling getServer()", (Throwable)e);
            throw new RuntimeException("Calling getServer(): " + e.getMessage());
        }
        return this.searchSingleMetadataObject(server, xmlSelect);
    }

    public MetadataInterface searchSingleMetadataObject(ServerInterface server, String xmlSelect) {
        List<MetadataInterface> miList = this.searchMetadataObjects(server, xmlSelect);
        if (miList == null || miList.size() == 0) {
            return null;
        }
        if (miList.size() > 1) {
            throw new RuntimeException("More than one search result for xmlselect: " + xmlSelect);
        }
        return miList.get(0);
    }

    public <T> T searchSingleMetadataObject(String xmlSelect, SmartObjectMapper<T> smartObjectMapper) {
        MetadataInterface mi = this.searchSingleMetadataObject(xmlSelect);
        if (mi == null) {
            return null;
        }
        return smartObjectMapper.mapSmartObject(mi);
    }

    public MetadataInterface searchMetadataObjectById(String id, String template) {
        try {
            ServerInterface server = this.getServer();
            return this.searchMetadataObjectById(server, id, template);
        }
        catch (Exception e) {
            log.error("Exception getting metadata object: " + id, (Throwable)e);
            throw new RuntimeException("Exception getting metadata object: " + id + " - " + e.getMessage());
        }
    }

    public MetadataInterface searchMetadataObjectById(ServerInterface server, String id, String template) {
        if (server == null) {
            throw new IllegalArgumentException("Invalid server instance");
        }
        MetadataInterface mi = null;
        try {
            List miList;
            if (log.isDebugEnabled()) {
                log.debug("ID FOR OBJECT LOOKUP: " + id);
            }
            OMRRepositoryKey reposKey = new OMRRepositoryKey(id);
            String ident = reposKey.getId();
            String type = reposKey.getType();
            Filter filter = new Filter("Id", 0, ident);
            filter.setOMRFlags(0x4000200);
            filter.setType(type);
            if (template != null) {
                filter.setOMRTemplate(template);
            }
            if ((miList = server.search((FilterInterface)filter)).size() > 0) {
                mi = (MetadataInterface)miList.get(0);
            }
        }
        catch (Exception e) {
            log.error("Exception getting metadata object: " + id, (Throwable)e);
            throw new RuntimeException("Exception getting metadata object: " + id + " - " + e.getMessage());
        }
        return mi;
    }

    public <T> T searchMetadataObjectById(String id, String template, SmartObjectMapper<T> smartObjectMapper) {
        MetadataInterface mi = this.searchMetadataObjectById(id, template);
        T ret = null;
        if (mi != null) {
            ret = smartObjectMapper.mapSmartObject(mi);
        }
        return ret;
    }

    public MetadataInterface getMetadataObjectByPath(String path) {
        try {
            ServerInterface server = this.getServer();
            String pathUrl = "SBIP://METASERVER" + path;
            log.debug("PATH FOR FOLDER LOOKUP: " + pathUrl);
            MetadataInterface ret = server.getObjectByPath(new PathUrl(pathUrl));
            return ret;
        }
        catch (Exception e) {
            log.error("Getting metadata on " + path, (Throwable)e);
            throw new RuntimeException("Getting metadata on " + path + ": " + e.getMessage());
        }
    }

    public <T> T getMetadataObjectByPath(String path, SmartObjectMapper<T> smartObjectMapper) {
        MetadataInterface mi = this.getMetadataObjectByPath(path);
        T ret = null;
        if (mi != null) {
            ret = smartObjectMapper.mapSmartObject(mi);
        }
        return ret;
    }

    public PublicObjectInterface getPublicObjectById(ObjectIdentity objectId) {
        String publicType = this.getPublicTypeFromObjectType(objectId.getObjectType());
        return this.getPublicObjectById(objectId, publicType);
    }

    public PublicObjectInterface getPublicObjectById(ObjectIdentity objectId, String publicType) {
        try {
            SASFoldersModelInterface model = this.getSASFoldersModel();
            if (publicType == null) {
                return null;
            }
            PublicObjectNodeInterface ret = model.getObject(this.getPublicObjectId(objectId.getId()), publicType);
            return ret != null && this.isCorrectType((PublicObjectInterface)ret, publicType) ? ret : null;
        }
        catch (Exception e) {
            log.error("Getting public object:" + objectId, (Throwable)e);
            throw new RuntimeException("Getting public object " + objectId + ": " + e.getMessage());
        }
    }

    public <T> T getPublicObjectById(ObjectIdentity objectId, PublicObjectMapper<T> mapper) {
        PublicObjectInterface poi = this.getPublicObjectById(objectId);
        return poi == null ? null : (T)mapper.mapPublicObject(poi);
    }

    public PublicObjectInterface getPublicObjectByPath(String path, long objectType) {
        String publicType = this.getPublicTypeFromObjectType(objectType);
        if (publicType == null) {
            return null;
        }
        return this.getPublicObjectByPath(path, publicType, objectType);
    }

    public PublicObjectInterface getPublicObjectByPath(String path, String publicType, long objectType) {
        try {
            PublicObjectNodeInterface ret;
            SASFoldersModelInterface model = this.getSASFoldersModel();
            if ("/".equals(path) && publicType == "RootFolder") {
                return model.getRootFolder();
            }
            String myFolderPath = this.getMyFolderPath();
            if (path.startsWith(myFolderPath)) {
                boolean shouldSubstitutePath = true;
                if (path.equals(myFolderPath) && objectType != 85L) {
                    shouldSubstitutePath = false;
                }
                if (shouldSubstitutePath) {
                    FolderInterface home = this.getServer().getHomeFolder(null, UserFolderType.MYFOLDER, null, true);
                    path = path.replaceFirst(this.getMyFolderName(), home.getPath(null));
                }
            }
            return (ret = model.getObjectByPath(path + "(" + publicType + ")")) != null && this.isCorrectType((PublicObjectInterface)ret, publicType) ? ret : null;
        }
        catch (Exception e) {
            log.error("Getting public object:" + path, (Throwable)e);
            throw new RuntimeException("Getting public object " + path + ": " + e.getMessage());
        }
    }

    public <T> T getPublicObjectByPath(String path, long objectType, PublicObjectMapper<T> mapper) {
        PublicObjectInterface poi = this.getPublicObjectByPath(path, objectType);
        return poi == null ? null : (T)mapper.mapPublicObject(poi);
    }

    private SASFoldersModelInterface getSASFoldersModel() throws ServiceException, RemoteException {
        if (!isVersionOutput) {
            log.warn("Getting version 2 of SASFoldersModel.");
            isVersionOutput = true;
        }
        ServerInterface server = this.getServer();
        SASFoldersModelInterface model = FolderModelFactory.createSASFoldersModel2((ServerInterface)server);
        ModelConfiguration config = model.getConfiguration();
        ResultDetails objectDetails = config.getObjectDetails();
        objectDetails.setDatesIncluded(true);
        objectDetails.setDescriptionIncluded(true);
        objectDetails.setKeywordsIncluded(true);
        objectDetails.setResponsiblePartiesIncluded(true);
        config.setIncludeEmptyValues(true);
        config.setBypassingCache(true);
        return model;
    }

    public SessionContextInterface getSessionContext() {
        SessionContextInterface sessionContext = this.userSessionProvider.getSessionContext();
        if (sessionContext == null) {
            throw new RuntimeException("Failed to get a session context");
        }
        return sessionContext;
    }

    public UserContextInterface getUserContext() {
        try {
            return this.getSessionContext().getUserContext();
        }
        catch (RemoteException e) {
            log.error((Object)e);
            throw new RuntimeException("Failed to get User Context due to RemoteException", e);
        }
    }

    public <T, S extends MetadataInterface> T makeNewMetadata(T contentObject, FolderInterface parent, String name, String metadataType, String publicType, String usageVersion, MutableSmartObjectMapper<T, S> mapper) {
        String typeToUse = publicType == null || publicType.length() == 0 ? metadataType : publicType;
        MetadataInterface smartObject = this.makeNewMetadata(parent, name, metadataType, typeToUse, usageVersion);
        mapper.mapToSmartObject(contentObject, smartObject);
        try {
            smartObject.update();
            smartObject.refresh();
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("ServiceException : " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("RemoteException : " + e.getMessage());
        }
        return mapper.mapSmartObject(smartObject);
    }

    public MetadataInterface makeNewMetadata(FolderInterface parent, String name, String metadataType, String publicType, String usageVersion) {
        try {
            String typeToUse = publicType == null || publicType.length() == 0 ? metadataType : publicType;
            MetadataInterface ret = this.getInformationService().newMetadataInFolder(parent, parent.getRepository(), typeToUse, name);
            if (publicType != null) {
                PrimaryType root = (PrimaryType)ret.getRepositoryEntity();
                root.setPublicType(publicType);
                root.setUsageVersion(usageVersion);
            }
            return ret;
        }
        catch (ServiceException ex) {
            log.error("Service exception", (Throwable)ex);
            throw new RuntimeException("ServiceException : " + this.getBaseCauseString((Exception)((Object)ex)));
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public MetadataInterface makeNewMetadata(FolderInterface parent, String name, String metadataType) {
        try {
            return this.getInformationService().newMetadataInFolder(parent, parent.getRepository(), metadataType, name);
        }
        catch (ServiceException ex) {
            log.error("Service Exception", (Throwable)ex);
            throw new RuntimeException("Service Exception: " + this.getBaseCauseString((Exception)((Object)ex)));
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public MetadataInterface makeNewMetadata(RepositoryInterface repository, String name, String metadataType) {
        try {
            return this.getInformationService().newMetadata(null, name, repository, metadataType);
        }
        catch (ServiceException ex) {
            log.error("Service Exception", (Throwable)ex);
            throw new RuntimeException("Service Exception: " + this.getBaseCauseString((Exception)((Object)ex)));
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public MetadataInterface makeNewMetadata(RepositoryInterface repository, String name, String metadataType, String publicType, String usageVersion) {
        String typeToUse = publicType == null || publicType.length() == 0 ? metadataType : publicType;
        MetadataInterface mi = this.makeNewMetadata(repository, name, typeToUse);
        try {
            if (publicType != null) {
                PrimaryType root = (PrimaryType)mi.getRepositoryEntity();
                root.setPublicType(publicType);
                root.setUsageVersion(usageVersion);
            }
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return mi;
    }

    public <T, S extends MetadataInterface> T makeNewMetadata(T contentObject, RepositoryInterface repository, String name, String metadataType, String publicType, String usageVersion, MutableSmartObjectMapper<T, S> mapper) {
        String typeToUse = publicType == null || publicType.length() == 0 ? metadataType : publicType;
        MetadataInterface mi = this.makeNewMetadata(repository, name, typeToUse);
        try {
            PrimaryType root = (PrimaryType)mi.getRepositoryEntity();
            root.setPublicType(publicType);
            root.setUsageVersion(usageVersion);
            mapper.mapToSmartObject(contentObject, mi);
            mi.update();
            mi.refresh();
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("ServiceException : " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("RemoteException : " + e.getMessage());
        }
        return mapper.mapSmartObject(mi);
    }

    public <T, S extends MetadataInterface> T updateMetadataById(String id, T contentObject, MutableSmartObjectMapper<T, S> mapper) throws ObjectNotFoundException {
        MetadataInterface smartObject = this.searchMetadataObjectById(id);
        if (smartObject == null) {
            throw new ObjectNotFoundException("Object not found: " + contentObject, id);
        }
        mapper.mapToSmartObject(contentObject, smartObject);
        try {
            smartObject.update();
            smartObject.refresh();
        }
        catch (ServiceException e) {
            log.error("Service exception", (Throwable)e);
            throw new RuntimeException("ServiceException : " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Remote exception", (Throwable)e);
            throw new RuntimeException("RemoteException : " + e.getMessage());
        }
        return mapper.mapSmartObject(smartObject);
    }

    public MetadataInterface getMetadataObjectBySASUri(SASObjUri uri) {
        try {
            ServerInterface server = this.getServer();
            PathUrl pathUrl = PathUtils.makePathUrlFromSASObjUri(uri, server);
            log.debug("PATH FOR FOLDER LOOKUP: " + pathUrl);
            MetadataInterface ret = server.getObjectByPath(pathUrl);
            return ret;
        }
        catch (Exception e) {
            log.error("Getting metadata on " + uri.toString(), (Throwable)e);
            throw new RuntimeException("Getting metadata on " + uri.toString() + ": " + e.getMessage());
        }
    }

    public FolderInterface searchFolderById(String id) {
        MetadataInterface mi = this.searchMetadataObjectById(id);
        if (!(mi instanceof FolderInterface)) {
            return null;
        }
        return (FolderInterface)mi;
    }

    public FolderInterface searchRequiredFolderById(String id) throws ObjectNotFoundException {
        FolderInterface ret = this.searchFolderById(id);
        if (ret == null) {
            throw new ObjectNotFoundException("Folder not found: " + id, id);
        }
        return ret;
    }

    public boolean existsByPath(String path, String publicTypeName) {
        try {
            PathUrl pathUrl;
            PathFilter filter;
            if (path == null) {
                return false;
            }
            String pathUrlStr = "SBIP://METASERVER" + path + "(" + publicTypeName + ")";
            MetadataServerInterface server = (MetadataServerInterface)this.getServer();
            int count = server.getCountNoSecurity((Filter)(filter = new PathFilter(pathUrl = new PathUrl(pathUrlStr), server)), "");
            return count > 0;
        }
        catch (Exception e) {
            log.error("Checking existence of " + path, (Throwable)e);
            throw new RuntimeException("Checking existence of " + path + ": " + e.getMessage());
        }
    }

    public boolean existsById(String id, String objectTypeName) {
        try {
            if (id == null) {
                return false;
            }
            if (id != null && id.indexOf(".$") > -1) {
                return true;
            }
            MetadataServerInterface server = (MetadataServerInterface)this.getServer();
            String fqid = id.substring(0, id.indexOf("/"));
            String type = id.substring(id.indexOf("/") + 1);
            String reposId = "A0000001." + fqid.substring(0, 8);
            IdFilter filter = new IdFilter(fqid);
            filter.setOMRRepository(reposId);
            filter.setType(type);
            int count = server.getCountNoSecurity((Filter)filter, "");
            return count > 0;
        }
        catch (Exception e) {
            log.error("Checking existence of " + id, (Throwable)e);
            throw new RuntimeException("Checking existence of " + id + ": " + e.getMessage());
        }
    }

    private MetadataInterface searchRequiredMetadataObjectByObjectId(ObjectIdentity objectId) throws ObjectNotFoundException {
        MetadataInterface mi = this.searchMetadataObjectByObjectId(objectId);
        if (mi == null) {
            throw new ObjectNotFoundException("Metadata object not found: " + objectId, objectId.getId());
        }
        return mi;
    }

    public void deleteByObjectId(ObjectIdentity objectId) throws ObjectNotFoundException {
        MetadataInterface mi = this.searchRequiredMetadataObjectByObjectId(objectId);
        try {
            mi.delete();
        }
        catch (ServiceException e) {
            log.error("Deleting " + objectId, (Throwable)e);
            throw new RuntimeException("Deleting " + objectId + ": " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Deleting " + objectId, (Throwable)e);
            throw new RuntimeException("Deleting " + objectId + ": " + e.getMessage());
        }
    }

    private void rename(MetadataInterface mi, String newName) throws ObjectNotFoundException, ValidationException {
        this.metadataUtils.validateName(newName);
        try {
            mi.setName(newName);
            mi.update();
            mi.refresh();
        }
        catch (ServiceException e) {
            log.error("Renaming " + mi, (Throwable)e);
            throw new RuntimeException("Renaming " + mi + ": " + this.getBaseCauseString((Exception)((Object)e)));
        }
        catch (RemoteException e) {
            log.error("Renaming " + mi, (Throwable)e);
            throw new RuntimeException("Renaming " + mi + ": " + e.getMessage());
        }
    }

    public void renameByObjectId(ObjectIdentity objectId, String newName) throws ObjectNotFoundException, ValidationException {
        MetadataInterface mi = this.searchRequiredMetadataObjectByObjectId(objectId);
        this.rename(mi, newName);
    }

    public <T> T renameByObjectId(ObjectIdentity objectId, String newName, SmartObjectMapper<T> mapper) throws ObjectNotFoundException, ValidationException {
        MetadataInterface mi = this.searchRequiredMetadataObjectByObjectId(objectId);
        this.rename(mi, newName);
        return mapper.mapSmartObject(mi);
    }

    private String getBaseCauseString(Exception ex) {
        Throwable cause;
        for (cause = ex; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
        }
        return cause.getMessage();
    }
}

