/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.commons.expr.BaseVisitor;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.Function;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.util.XMLUtil;
import com.sas.svcs.common.client.AttributeMapper;
import com.sas.svcs.common.client.FieldMapper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class MetadataExpressionVisitor
extends BaseVisitor {
    private static final String OPERATOR_EQUALS = "eq";
    private static final String OPERATOR_NE = "ne";
    private static final String OPERATOR_LT = "lt";
    private static final String OPERATOR_LTE = "le";
    private static final String OPERATOR_GT = "gt";
    private static final String OPERATOR_GTE = "ge";
    private static final String OPERATOR_CONTAINS = "contains";
    private static final String OPERATOR_STARTSWITH = "startsWith";
    private static final String OPERATOR_ENDSWITH = "endsWith";
    private static final String OPERATOR_IN = "in";
    private static final String OPERATOR_AND = "and";
    private static final String OPERATOR_OR = "or";
    private static Map<String, Integer> supportedOperators = new HashMap<String, Integer>();
    private Map<String, FieldMapper> fieldMappings;
    private Stack<FilterComponent> componentStack;

    public MetadataExpressionVisitor() {
        supportedOperators.put(OPERATOR_EQUALS, 0);
        supportedOperators.put(OPERATOR_NE, 11);
        supportedOperators.put(OPERATOR_LT, 6);
        supportedOperators.put(OPERATOR_LTE, 7);
        supportedOperators.put(OPERATOR_GT, 8);
        supportedOperators.put(OPERATOR_GTE, 9);
        supportedOperators.put(OPERATOR_CONTAINS, 1);
        supportedOperators.put(OPERATOR_STARTSWITH, 2);
        supportedOperators.put(OPERATOR_ENDSWITH, 3);
        this.componentStack = new Stack();
    }

    public MetadataExpressionVisitor(Map<String, FieldMapper> fieldMappings) {
        this();
        this.fieldMappings = fieldMappings;
    }

    public void setBaseFilterComponent(FilterComponent baseComponent) {
        if (baseComponent != null) {
            this.componentStack.add(baseComponent);
        }
    }

    public Filter getFilter() {
        Filter filter = new Filter();
        filter.setFilterComponent((FilterComponent)this.componentStack.firstElement());
        return filter;
    }

    public Expression visitFunction(Function function) {
        String name = function.getFunctionName();
        if (OPERATOR_AND.equalsIgnoreCase(name)) {
            this.parseLogicalFunction(function, 0);
        } else if (OPERATOR_OR.equalsIgnoreCase(name)) {
            this.parseLogicalFunction(function, 1);
        } else if (OPERATOR_IN.equalsIgnoreCase(name)) {
            this.parseInFunction(function, name);
        } else if (supportedOperators.containsKey(name)) {
            this.parseArguments(function, name, supportedOperators.get(name));
        } else {
            for (Expression expr : function.getArguments()) {
                expr.accept((ExpressionVisitor)this);
            }
        }
        return function;
    }

    private void parseInFunction(Function function, String name) {
        FilterComponent component = new FilterComponent();
        FilterComponent parentComponent = null;
        if (!this.componentStack.isEmpty()) {
            parentComponent = (FilterComponent)this.componentStack.lastElement();
            parentComponent.addComponent(component);
        }
        this.componentStack.add(component);
        component.setAggregation(1);
        this.parseArguments(function, name, 0);
        if (this.componentStack.size() > 1) {
            this.componentStack.pop();
        }
    }

    private void parseLogicalFunction(Function function, int aggregator) {
        FilterComponent component = new FilterComponent();
        FilterComponent parentComponent = null;
        if (!this.componentStack.isEmpty()) {
            parentComponent = (FilterComponent)this.componentStack.lastElement();
            parentComponent.addComponent(component);
        }
        this.componentStack.add(component);
        component.setAggregation(aggregator);
        for (Expression expr : function.getArguments()) {
            expr.accept((ExpressionVisitor)this);
        }
        if (this.componentStack.size() > 1) {
            this.componentStack.pop();
        }
    }

    private void parseArguments(Function function, String name, int operator) {
        this.parseArguments(function, name, operator, null);
    }

    private void parseArguments(Function function, String name, int operator, Integer aggregator) {
        FilterComponent component;
        List args = function.getArguments();
        this.validateArgs(name, args);
        if (this.componentStack.isEmpty()) {
            component = new FilterComponent();
            this.componentStack.add(component);
        } else {
            component = (FilterComponent)this.componentStack.lastElement();
        }
        if (aggregator != null) {
            component.setAggregation(aggregator.intValue());
        }
        String key = this.decodeString(((Expression)args.get(0)).toString());
        int index = 0;
        LinkedHashSet<String> values = new LinkedHashSet<String>(args.size() - 1);
        for (Expression arg : args) {
            if (index++ == 0) continue;
            String value = this.decodeString(arg.toString());
            values.add(value);
        }
        for (String value : values) {
            FieldMapper mapper;
            FieldMapper fieldMapper = mapper = this.fieldMappings == null ? null : this.fieldMappings.get(key);
            if (mapper == null) {
                this.addAttributeFilter(key, operator, value, component);
                continue;
            }
            if (!(mapper instanceof AttributeMapper)) continue;
            AttributeMapper am = (AttributeMapper)mapper;
            String fieldName = am.getAttributeName();
            FilterComponent attrComponent = this.addAttributeFilter(fieldName, operator, value, component);
            if (am.getAlternateAttributeNames() == null) continue;
            attrComponent.setAggregation(1);
            for (String attr : am.getAlternateAttributeNames()) {
                this.addAttributeFilter(attr, operator, value, attrComponent);
            }
        }
    }

    private FilterComponent addAttributeFilter(String fieldName, int operator, String value, FilterComponent component) {
        value = XMLUtil.normalize((String)value);
        FilterComponent subComponent = new FilterComponent();
        subComponent.setFilter(fieldName, operator, value);
        component.addComponent(subComponent);
        return subComponent;
    }

    private void validateArgs(String name, List<Expression> args) {
        if (args == null || args.size() <= 1) {
            throw new IllegalArgumentException("Invalid argument list.  Arguments must be provided for the " + name + " function.");
        }
        if (OPERATOR_NE.equalsIgnoreCase(name) && args.size() != 2) {
            throw new IllegalArgumentException("Invalid argument list.  The \"ne\" function only supports two arguments.");
        }
    }

    private String decodeString(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        if (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'') {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }
}

