/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.svcs.common.client.FieldMapper;
import com.sas.svcs.common.client.dao.omr.MetadataExpressionVisitor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataExpressionParser {
    private Map<String, FieldMapper> mappings = new HashMap<String, FieldMapper>();
    private FilterComponent baseComponent;

    public void addFieldMapping(FieldMapper mapper) {
        this.mappings.put(mapper.getFieldName(), mapper);
    }

    public void addFieldMappings(List<FieldMapper> mappers) {
        for (FieldMapper mapper : mappers) {
            this.addFieldMapping(mapper);
        }
    }

    public void setBaseFilterComponent(FilterComponent baseComponent) {
        this.baseComponent = baseComponent;
    }

    public Filter parseExpression(Expression expr) {
        MetadataExpressionVisitor visitor = new MetadataExpressionVisitor(this.mappings);
        if (this.baseComponent != null) {
            visitor.setBaseFilterComponent(this.baseComponent);
        }
        expr.accept((ExpressionVisitor)visitor);
        return visitor.getFilter();
    }

    public String parseExpressionAsString(Expression expr) {
        Filter filter = this.parseExpression(expr);
        return filter.getExplicitSearchString();
    }
}

