/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.browse.BrowseMetadataUtil;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.IdentityInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PersonInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.services.information.publicobject.DetailsProcessorInterface;
import com.sas.services.information.publicobject.PublicObjectInterface;
import com.sas.services.information.publicobject.ResponsibilityDetails;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.information.sasfolders.PublicObjectNodeInterface;
import com.sas.services.information.util.OMRRepositoryKey;
import com.sas.services.util.Names;
import com.sas.svcs.common.client.Assignable;
import com.sas.svcs.common.client.Extendable;
import com.sas.svcs.common.client.Keyable;
import com.sas.svcs.common.client.Responsibility;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.common.client.dao.omr.PathUtils;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.Node;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.navigation.client.NavigationNode;
import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MetadataContentUtils {
    private static final Logger log = LogManager.getLogger(MetadataContentUtils.class);
    private static final double SecondsInTheSixties = 3.156192E8;
    @Deprecated
    public static final String ROOT_FOLDER_ID = "ROOT_FOLDER_ID";
    private MetadataTemplate metadataTemplate;

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
    }

    public void populateContentObjectFromMetadata(ContentObject contentObject, MetadataInterface metadata) {
        this.populateContentComponentFromMetadata((ContentComponent)contentObject, metadata);
    }

    public void populateContentComponentFromMetadata(ContentComponent component, MetadataInterface metadata) {
        try {
            component.setCreationDate(metadata.getCreateDate());
            component.setModifiedDate(metadata.getModifyDate());
            component.setCreatedBy(metadata.getCreatedBy());
            component.setModifiedBy(metadata.getModifiedBy());
            component.setDescription(metadata.getDescription());
            component.setObjectTypeName(metadata.getType());
            component.setInternalVersion(-1L);
            component.setName(metadata.getName());
            String id = metadata.getReposKey();
            component.setId(id);
            if (component instanceof Assignable) {
                ((Assignable)component).setResponsibilities(this.getResponsibilitiesFromMetadata(metadata));
            }
            if (component instanceof Extendable) {
                ((Extendable)component).setExtendedAttributes(this.getExtendedAttributesFromMetadata(metadata));
            }
            if (component instanceof Keyable) {
                ((Keyable)component).setKeywords(new ArrayList(metadata.getKeywords()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void populateContentObjectFromBrowseMetadata(ContentObject contentObject, BrowseMetadata bm) {
        this.populateContentComponentFromBrowseMetadata((ContentComponent)contentObject, bm);
    }

    public void populateContentComponentFromBrowseMetadata(ContentComponent component, BrowseMetadata bmi) {
        try {
            component.setCreationDate(bmi.getCreateDateAsDate());
            component.setModifiedDate(bmi.getModifyDateAsDate());
            component.setCreatedBy(BrowseMetadataUtil.getCreatedBy((BrowseMetadataInterface)bmi));
            component.setModifiedBy(BrowseMetadataUtil.getModifiedBy((BrowseMetadataInterface)bmi));
            component.setDescription(bmi.getDescription());
            component.setId(bmi.getReposId() + "/" + bmi.getNativeType());
            component.setInternalVersion(-1L);
            component.setName(bmi.getName());
            component.setObjectTypeName(this.getBrowseType(bmi));
            if (component instanceof Assignable) {
                ((Assignable)component).setResponsibilities(this.getResponsibilitiesFromBrowseMetadata((BrowseMetadataInterface)bmi));
            }
            if (component instanceof Extendable) {
                ((Extendable)component).setExtendedAttributes(this.getExtendedAttributesFromBrowseMetadata((BrowseMetadataInterface)bmi));
            }
            if (component instanceof Keyable) {
                ((Keyable)component).setKeywords(this.getKeywordsFromBrowseMetadata((BrowseMetadataInterface)bmi));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getBrowseType(BrowseMetadata bmi) {
        String tmpType;
        String type = bmi.getSmartType();
        if (type == "Metadata" && (tmpType = (String)bmi.get("PublicType")) != null) {
            type = tmpType;
        }
        return type;
    }

    public String getPathFromBrowseMetadata(BrowseMetadataInterface bmi) {
        String path;
        BrowseMetadataInterface parent;
        if (bmi.isAFolder()) {
            return this.getFolderPath(bmi);
        }
        List treeList = (List)bmi.get("Trees");
        if (treeList != null && (parent = (BrowseMetadataInterface)treeList.get(0)) != null && (path = this.getFolderPath(parent)) != null) {
            return path + "/" + bmi.getName();
        }
        return null;
    }

    private String getFolderPath(BrowseMetadataInterface bmi) {
        List treeList = (List)bmi.get("ParentTree");
        if (treeList == null) {
            List scList = (List)bmi.get("SoftwareComponents");
            if (scList == null) {
                return null;
            }
            for (BrowseMetadataInterface scBmi : scList) {
                if (!scBmi.getName().equals("BIP Service") || !scBmi.get("ClassIdentifier").equals("E5F27790-2149-11D6-8828-AA0004006D06")) continue;
                return "/" + bmi.getName();
            }
            return null;
        }
        for (BrowseMetadataInterface nextBmi : treeList) {
            String path = this.getPathFromBrowseMetadata(nextBmi);
            if (path == null) continue;
            return path + '/' + bmi.getName();
        }
        return null;
    }

    public void populateContentNodeFromMetadata(ContentNode contentNode, MetadataInterface metadata) {
        try {
            this.populateContentObjectFromMetadata((ContentObject)contentNode, metadata);
            String path = metadata.getPath(null);
            if (path != null && !path.startsWith("/")) {
                path = "/" + path;
            }
            contentNode.setPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void populateContentNodeFromBrowseMetadata(ContentNode node, BrowseMetadata bmi) {
        this.populateContentObjectFromBrowseMetadata((ContentObject)node, bmi);
        node.setPath(PathUtils.pathToRoot(bmi));
    }

    public void updateContentComponent(ContentComponent component, MetadataInterface metadata) {
        try {
            if (!metadata.getDescription().equals(component.getDescription())) {
                metadata.setDescription(component.getDescription());
            }
            if (component instanceof Keyable) {
                List compKeywords = ((Keyable)component).getKeywords();
                this.setKeywordsOnMetadata(metadata, compKeywords);
            }
            if (component instanceof Extendable) {
                Properties compProps = ((Extendable)component).getExtendedAttributes();
                this.setExtendedAttributesOnMetadata(metadata, compProps);
            }
            if (component instanceof Assignable) {
                List compRps = ((Assignable)component).getResponsibilities();
                this.setResponsibilitiesOnMetadata(metadata, compRps);
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void setKeywordsOnMetadata(MetadataInterface metadata, List<String> keywords) {
        try {
            List miKeywords = metadata.getKeywords();
            if (keywords == null) {
                if (miKeywords != null) {
                    metadata.setKeywords(Collections.EMPTY_LIST);
                }
            } else if (miKeywords == null || miKeywords.size() != keywords.size() || !miKeywords.containsAll(keywords)) {
                metadata.setKeywords(keywords);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public void updateContentObject(ContentObject content, MetadataInterface metadata) {
        this.updateContentComponent((ContentComponent)content, metadata);
    }

    public void updateContentNode(ContentNode content, MetadataInterface metadata) {
        this.updateContentObject((ContentObject)content, metadata);
    }

    public ObjectIdentity getParentId(MetadataInterface mi) {
        ObjectIdentity ret = null;
        try {
            FolderInterface parent = mi.getParent();
            if (parent != null) {
                ret = parent instanceof RootFolderInterface ? new ObjectIdentity(29L, ROOT_FOLDER_ID) : new ObjectIdentity(28L, parent.getReposKey());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return ret;
    }

    public void populateNavigationNodeFromMetadata(NavigationNode node, MetadataInterface mi) {
        ContentComponent component = node.getContentObject();
        if (component instanceof ContentNode) {
            this.populateContentNodeFromMetadata((ContentNode)component, mi);
        } else if (component instanceof ContentObject) {
            this.populateContentObjectFromMetadata((ContentObject)component, mi);
        } else {
            this.populateContentComponentFromMetadata(component, mi);
        }
        node.setParentId(this.getParentId(mi));
    }

    public void validateName(String name) throws ValidationException {
        if (!Names.validateOMRObjectName((String)name, (boolean)false)) {
            log.error("Invalid name: " + name);
            throw new ValidationException("Invalid name", name);
        }
    }

    public void populateContentComponentFromPublicObject(PublicObjectInterface poi, ContentComponent component) {
        try {
            DetailsProcessorInterface dpi = (DetailsProcessorInterface)poi.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
            component.setCreationDate(dpi.getCreateDate());
            component.setDescription(dpi.getDescription());
            component.setModifiedDate(dpi.getModifyDate());
            component.setCreatedBy(dpi.getCreatedBy());
            component.setModifiedBy(dpi.getModifiedBy());
            component.setName(dpi.getName());
            component.setId(this.getContentId(poi));
            component.setInternalVersion(-1L);
            if (component instanceof Assignable) {
                ((Assignable)component).setResponsibilities(this.getResponsibilitiesFromPublicObject(poi));
            }
            if (component instanceof Extendable) {
                // empty if block
            }
            if (component instanceof Keyable) {
                ((Keyable)component).setKeywords(new ArrayList(dpi.getKeywords()));
            }
        }
        catch (Exception e) {
            log.error("Populating content component from public object:" + poi, (Throwable)e);
            throw new RuntimeException("Populating content component from public object " + poi + ": " + e.getMessage());
        }
    }

    public void populateContentObjectFromPublicObject(PublicObjectInterface poi, ContentObject obj) {
        this.populateContentComponentFromPublicObject(poi, (ContentComponent)obj);
    }

    public void populateContentNodeFromPublicObject(PublicObjectInterface poi, ContentNode node) {
        try {
            if (poi instanceof PublicObjectNodeInterface) {
                node.setPath(((PublicObjectNodeInterface)poi).getDisplayPath());
            }
            this.populateContentComponentFromPublicObject(poi, (ContentComponent)node);
        }
        catch (Exception e) {
            log.error("Populating content component from public object:" + poi, (Throwable)e);
            throw new RuntimeException("Populating content component from public object " + poi + ": " + e.getMessage());
        }
    }

    public String getContentId(PublicObjectInterface poi) {
        try {
            TypeDescriptorInterface tdi = poi.getTypeDescriptor();
            String metadataType = tdi != null ? tdi.getMetadataType() : null;
            return poi.getIdentifier() + "/" + metadataType;
        }
        catch (Exception e) {
            log.error("Getting type from public object:" + poi, (Throwable)e);
            throw new RuntimeException("Getting type from public object " + poi + ": " + e.getMessage());
        }
    }

    public boolean isRepositoryRoot(FolderInterface miFolder, ServerInterface server) {
        try {
            RepositoryInterface foundationRepository = server.getFoundationRepository();
            String foundationBase = foundationRepository.getBase();
            RepositoryInterface folderRepository = miFolder.getRepository();
            String folderBase = folderRepository.getBase();
            if (foundationBase.equals(folderBase)) {
                return false;
            }
            FolderInterface parent = miFolder.getParent();
            if (!(parent instanceof RootFolderInterface)) {
                return false;
            }
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return true;
    }

    public boolean isMetadataFresh(MetadataInterface mi) {
        boolean result = false;
        try {
            RepositoryInterface ri = mi.getRepository();
            ServerInterface server = ri.getServer();
            String metadataKey = mi.getReposKey();
            OMRRepositoryKey reposKey = new OMRRepositoryKey(metadataKey);
            String type = reposKey.getType();
            String template = "<Templates><" + type + " MetadataUpdated=\"\"/></Templates>";
            Filter filter = new Filter();
            filter.setOMRTemplate(template);
            filter.setOMRFlags(-2080374524);
            BrowseMetadata bmi = (BrowseMetadata)server.browseFetch(metadataKey, (FilterInterface)filter);
            Date miDate = mi.getModifyDate();
            Date bmiDate = bmi.getModifyDateAsDate();
            if (miDate.getTime() >= bmiDate.getTime()) {
                result = true;
            }
        }
        catch (ServiceException ex) {
            log.error("Service exception", (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            log.error("Remote exception", (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return result;
    }

    public void ensureMetadataFresh(MetadataInterface mi) {
        if (!this.isMetadataFresh(mi)) {
            this.refreshMetadata(mi);
        }
    }

    public void refreshMetadata(MetadataInterface mi) {
        try {
            mi.refresh();
        }
        catch (ServiceException ex) {
            log.error("Service exception", (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            log.error("Remote exception", (Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public List<String> getKeywordsFromBrowseMetadata(BrowseMetadataInterface bmi) {
        return BrowseMetadataUtil.getKeywords((BrowseMetadataInterface)bmi);
    }

    public Properties getExtendedAttributesFromBrowseMetadata(BrowseMetadataInterface bmi) {
        Properties result = new Properties();
        Map extensions = BrowseMetadataUtil.getExtendedAttributes((BrowseMetadataInterface)bmi);
        if (extensions != null && !extensions.isEmpty()) {
            for (String ext : extensions.keySet()) {
                result.setProperty(ext, (String)extensions.get(ext));
            }
        }
        return result;
    }

    public List<Responsibility> getResponsibilitiesFromBrowseMetadata(BrowseMetadataInterface bmi) {
        ArrayList<Responsibility> result = new ArrayList<Responsibility>();
        List responsibilities = BrowseMetadataUtil.getResponsibilities((BrowseMetadataInterface)bmi);
        if (responsibilities != null && !responsibilities.isEmpty()) {
            for (ResponsibilityDetails resp : responsibilities) {
                result.add(new Responsibility(resp.getName(), resp.getUserName(), resp.getRole()));
            }
        }
        return result;
    }

    public void setExtendedAttributesOnMetadata(MetadataInterface mi, Properties extendedAttributes) {
        try {
            Root joma = (Root)mi.getRepositoryEntity();
            AssociationList miExtensions = joma.getExtensions(true);
            if (extendedAttributes == null || extendedAttributes.size() == 0) {
                if (miExtensions.size() > 0) {
                    ArrayList toRemove = new ArrayList(miExtensions);
                    miExtensions.clear();
                    for (Extension nextExtension : toRemove) {
                        nextExtension.delete();
                    }
                }
            } else {
                Properties existingProps = new Properties();
                ArrayList<Extension> toRemoveExts = new ArrayList<Extension>();
                Properties incomingProps = new Properties();
                incomingProps.putAll((Map<?, ?>)extendedAttributes);
                for (Extension miExt : miExtensions) {
                    String key = miExt.getName();
                    String val = miExt.getValue();
                    if (incomingProps.containsKey(key) && incomingProps.getProperty(key).equals(val)) {
                        existingProps.setProperty(key, val);
                        continue;
                    }
                    toRemoveExts.add(miExt);
                }
                for (Object key : existingProps.keySet()) {
                    incomingProps.remove(key);
                }
                for (Extension miExt : toRemoveExts) {
                    miExtensions.remove(miExt);
                    miExt.delete();
                }
                mi.update();
                miExtensions = joma.getExtensions(true);
                for (Object key : incomingProps.keySet()) {
                    OMIRepositoryInterface omirepos = (OMIRepositoryInterface)mi.getRepository();
                    Extension ext = (Extension)omirepos.createMetadata((String)key, "Extension");
                    ext.setValue(incomingProps.getProperty((String)key));
                    miExtensions.add(ext);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public Properties getExtendedAttributesFromMetadata(MetadataInterface mi) {
        Properties result = new Properties();
        try {
            Root joma = (Root)mi.getRepositoryEntity();
            AssociationList extensions = joma.getExtensions();
            if (extensions.size() > 0) {
                for (Extension nextExtension : extensions) {
                    result.setProperty(nextExtension.getName(), nextExtension.getValue());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return result;
    }

    public List<Responsibility> getResponsibilitiesFromMetadata(MetadataInterface metadata) {
        return this.getResponsibilitiesFromPublicObject((PublicObjectInterface)metadata);
    }

    public List<Responsibility> getResponsibilitiesFromPublicObject(PublicObjectInterface poi) {
        try {
            ArrayList<Responsibility> result = new ArrayList<Responsibility>();
            DetailsProcessorInterface dpi = (DetailsProcessorInterface)poi.getProcessorInterface("com.sas.services.information.publicobject.DetailsProcessorInterface");
            List poiResponsibilities = dpi.getResponsibilities();
            if (poiResponsibilities != null && !poiResponsibilities.isEmpty()) {
                for (ResponsibilityDetails resp : poiResponsibilities) {
                    result.add(new Responsibility(resp.getName(), resp.getUserName(), resp.getRole()));
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error("Exception getting responsible parties from public object", (Throwable)e);
            throw new RuntimeException("Exception getting responsible parties from public object: " + e.getMessage());
        }
    }

    public void setResponsibilitiesOnMetadata(MetadataInterface metadata, List<Responsibility> responsibilities) {
        try {
            List miRps = metadata.getResponsibleParties();
            if (responsibilities == null || responsibilities.size() == 0) {
                if (miRps != null) {
                    for (com.sas.services.information.publicobject.Responsibility miResp : miRps) {
                        metadata.removeResponsibleParty(miResp);
                    }
                }
            } else {
                ArrayList<Responsibility> existingRps = new ArrayList<Responsibility>(miRps.size());
                ArrayList<com.sas.services.information.publicobject.Responsibility> toRemoveRps = new ArrayList<com.sas.services.information.publicobject.Responsibility>();
                ArrayList<Responsibility> incomingRps = new ArrayList<Responsibility>(responsibilities);
                for (com.sas.services.information.publicobject.Responsibility miResp : miRps) {
                    if (miResp.getRole().equalsIgnoreCase("Modified By")) continue;
                    Responsibility rp = new Responsibility(miResp.getPerson().getName(), miResp.getPerson().getDisplayName(), miResp.getRole());
                    if (!responsibilities.contains(rp)) {
                        toRemoveRps.add(miResp);
                        continue;
                    }
                    existingRps.add(rp);
                }
                for (com.sas.services.information.publicobject.Responsibility miResp : toRemoveRps) {
                    metadata.removeResponsibleParty(miResp);
                }
                incomingRps.removeAll(existingRps);
                for (Responsibility compRp : incomingRps) {
                    PersonInterface person = (PersonInterface)this.metadataTemplate.searchSingleMetadataObject("<XMLSelect search=\"*[@PublicType='User' and @Name='" + compRp.getUsername() + "']\"/>");
                    com.sas.services.information.publicobject.Responsibility resp = new com.sas.services.information.publicobject.Responsibility((IdentityInterface)person, compRp.getRole());
                    metadata.addResponsibleParty(resp);
                }
            }
        }
        catch (ServiceException e) {
            log.error("Exception setting responsible parties from smart object", (Throwable)e);
            throw new RuntimeException("Exception getting responsible parties from public object: " + e.getMessage());
        }
        catch (RemoteException e) {
            log.error("Exception setting responsible parties from smart object", (Throwable)e);
            throw new RuntimeException("Exception getting responsible parties from public object: " + e.getMessage());
        }
    }

    public void populateNodeFromMetadata(Node node, MetadataInterface metadata) throws ServiceException, RemoteException {
        String id = metadata.getReposKey();
        node.setId(id);
    }

    public Date makeDateFromMetadataString(String dateString) throws ParseException {
        if (dateString.indexOf(58) > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("ddMMMyyyy:HH:mm:ss", Locale.US);
            sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
            Date d = sdf.parse(dateString);
            return d;
        }
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        double time = nf.parse(dateString).doubleValue();
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        long javaDate = (long)((time - 3.156192E8) * 1000.0 - (double)timezone.getRawOffset());
        Date result = new Date(javaDate);
        return result;
    }
}

