/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.commons.expr.Expression;
import com.sas.commons.restsupport.query.QueryOptions;
import com.sas.commons.restsupport.query.QueryResult;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterComponent;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.common.client.AttributeMapper;
import com.sas.svcs.common.client.ContentComparator;
import com.sas.svcs.common.client.FieldMapper;
import com.sas.svcs.common.client.dao.BaseContentDAO;
import com.sas.svcs.common.client.dao.omr.MetadataContentUtils;
import com.sas.svcs.common.client.dao.omr.MetadataExpressionParser;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectModifiedException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseSmartObjectContentDAO<T extends ContentObject, S extends MetadataInterface>
implements BaseContentDAO<T> {
    private static final Logger log = LogManager.getLogger(BaseSmartObjectContentDAO.class);
    private Class<T> contentClazz;
    private String metadataType;
    private String omrModelType;
    private String publicType;
    private String usageVersion;
    private long objectType;
    private MetadataTemplate metadataTemplate;
    private MetadataContentUtils metadataUtils = new MetadataContentUtils();

    public BaseSmartObjectContentDAO(Class<T> contentClazz, long objectType, String metadataType, String publicType, String omrModelType, String usageVersion) {
        this.contentClazz = contentClazz;
        this.metadataType = metadataType;
        this.omrModelType = omrModelType;
        this.publicType = publicType;
        this.usageVersion = usageVersion;
        this.objectType = objectType;
    }

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate metadataTemplate) {
        this.metadataTemplate = metadataTemplate;
        this.metadataUtils.setMetadataTemplate(metadataTemplate);
    }

    public void setMetadataContentUtils(MetadataContentUtils metadataUtils) {
        this.metadataUtils = metadataUtils;
    }

    protected MetadataTemplate getMetadataTemplate() {
        return this.metadataTemplate;
    }

    protected MetadataContentUtils getMetadataUtils() {
        return this.metadataUtils;
    }

    protected Class<T> getContentClazz() {
        return this.contentClazz;
    }

    protected String getMetadataType() {
        return this.metadataType;
    }

    protected String getOmrModelType() {
        return this.omrModelType;
    }

    protected String getPublicType() {
        return this.publicType;
    }

    protected String getUsageVersion() {
        return this.usageVersion;
    }

    protected long getObjectType() {
        return this.objectType;
    }

    public T findById(String id) {
        S object = null;
        T ret = null;
        if (this.isBrowseSupported()) {
            String template = this.getTemplate();
            BrowseMetadata bm = (BrowseMetadata)this.metadataTemplate.searchBrowseMetadataById(id, template);
            if (bm == null) {
                return null;
            }
            ret = this.getContentObjectFromBrowseMetadata(bm);
        } else {
            try {
                object = this.getSmartObjectById(id);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (object == null) {
                return null;
            }
            ret = this.getContentObjectFromSmartObject(object);
        }
        return ret;
    }

    public List<FieldMapper> getFieldMappers() {
        ArrayList<FieldMapper> mappers = new ArrayList<FieldMapper>();
        mappers.add((FieldMapper)new AttributeMapper("objectTypeName", "type"));
        mappers.add((FieldMapper)new AttributeMapper("creationDate", "createDate", "MetadataCreated"));
        mappers.add((FieldMapper)new AttributeMapper("modifiedDate", "modifyDate", "MetadataUpdated"));
        return mappers;
    }

    protected Comparator<S> getComparator(QueryOptions request, Class type) {
        ContentComparator result = new ContentComparator(request.getSortKeys(), type);
        result.addFieldMappings(this.getFieldMappers());
        return result;
    }

    public QueryResult<T> findFiltered(QueryOptions request) {
        QueryResult result = null;
        Filter filter = null;
        Expression expression = request.getFilter();
        List sortKeys = request.getSortKeys();
        long start = request.getStart();
        int limit = request.getLimit();
        if (expression != null) {
            MetadataExpressionParser parser = new MetadataExpressionParser();
            parser.setBaseFilterComponent(new FilterComponent("PublicType", 0, this.publicType));
            parser.addFieldMappings(this.getFieldMappers());
            filter = parser.parseExpression(expression);
            filter.setType(this.omrModelType);
        } else {
            filter = new Filter("PublicType", 0, this.publicType);
            filter.setType(this.omrModelType);
        }
        try {
            UserContextInterface user = this.metadataTemplate.getUserContext();
            ServerInterface server = user.getAuthServer();
            if (this.isBrowseSupported()) {
                List candidateList = server.browseSearch((FilterInterface)filter);
                ArrayList<T> resultList = new ArrayList<T>(limit > candidateList.size() ? candidateList.size() : limit);
                if (candidateList.size() > 1 && sortKeys != null) {
                    ContentComparator comparator = new ContentComparator(sortKeys, BrowseMetadata.class);
                    Collections.sort(candidateList, comparator);
                }
                if (start < 0L) {
                    start = 0L;
                }
                for (int i = 0; i < candidateList.size() && (long)i <= start + (long)limit - 1L; ++i) {
                    if ((long)i < start) continue;
                    BrowseMetadata nextCandidate = (BrowseMetadata)candidateList.get(i);
                    T nextResult = this.getDescriptorFromBrowseObject(nextCandidate);
                    resultList.add(nextResult);
                }
                result = new QueryResult(request, resultList, candidateList.size());
            } else {
                List candidateList = server.search((FilterInterface)filter);
                ArrayList<T> resultList = new ArrayList<T>(limit > candidateList.size() ? candidateList.size() : limit);
                if (candidateList.size() > 1 && sortKeys != null) {
                    MetadataInterface sample = (MetadataInterface)candidateList.get(0);
                    Comparator<S> comparator = this.getComparator(request, sample.getClass());
                    Collections.sort(candidateList, comparator);
                }
                if (start < 0L) {
                    start = 0L;
                }
                if (limit == 0) {
                    limit = candidateList.size();
                }
                for (int i = 0; i < candidateList.size() && (long)i <= start + (long)limit - 1L; ++i) {
                    if ((long)i < start) continue;
                    MetadataInterface nextCandidate = (MetadataInterface)candidateList.get(i);
                    T nextResult = this.getDescriptorFromSmartObject(nextCandidate);
                    resultList.add(nextResult);
                }
                result = new QueryResult(request, resultList, candidateList.size());
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    public List<T> findAll() {
        ArrayList<T> ret = null;
        if (this.isBrowseSupported()) {
            List<BrowseMetadataInterface> bmis = this.metadataTemplate.searchBrowseMetadataAll(this.publicType, this.getTemplate(), this.omrModelType);
            ret = new ArrayList<T>(bmis.size());
            for (BrowseMetadataInterface bm : bmis) {
                ret.add(this.getDescriptorFromBrowseObject((BrowseMetadata)bm));
            }
        } else {
            List<MetadataInterface> mis = this.metadataTemplate.searchMetadataObjectAll(this.publicType, this.getTemplate(), this.omrModelType);
            ret = new ArrayList(mis.size());
            for (MetadataInterface mi : mis) {
                ret.add(this.getDescriptorFromSmartObject(mi));
            }
        }
        return ret;
    }

    public T findDescriptorById(String id) {
        S object = null;
        T ret = null;
        if (this.isBrowseSupported()) {
            String template = this.getTemplate();
            BrowseMetadata bm = (BrowseMetadata)this.metadataTemplate.searchBrowseMetadataById(id, template);
            if (bm == null) {
                return null;
            }
            ret = this.getDescriptorFromBrowseObject(bm);
        } else {
            try {
                object = this.getSmartObjectById(id);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (object == null) {
                return null;
            }
            ret = this.getDescriptorFromSmartObject(object);
        }
        return ret;
    }

    public boolean delete(T contentObject) throws ObjectNotFoundException {
        this.metadataTemplate.deleteByObjectId(new ObjectIdentity(this.getObjectType(), contentObject.getId()));
        return true;
    }

    public boolean deleteById(String id) throws ObjectNotFoundException {
        this.metadataTemplate.deleteByObjectId(new ObjectIdentity(this.getObjectType(), id));
        return true;
    }

    protected long getInternalVersion(BrowseMetadata bm) {
        long iversion = -1L;
        Date modifyDate = bm.getModifyDateAsDate();
        if (modifyDate != null) {
            iversion = modifyDate.getTime();
        }
        return iversion;
    }

    protected long getInternalVersion(MetadataInterface metadata) {
        long iversion = -1L;
        try {
            Date modifyDate = metadata.getModifyDate();
            if (modifyDate != null) {
                iversion = modifyDate.getTime();
            }
        }
        catch (ServiceException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (RemoteException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return iversion;
    }

    public T update(T contentObject) throws ObjectNotFoundException, ObjectModifiedException {
        String identifier = contentObject.getId();
        S metadata = this.getSmartObjectById(identifier);
        if (metadata == null) {
            throw new ObjectNotFoundException("Object with identity " + identifier + " was not found.", identifier);
        }
        if (contentObject.getInternalVersion() != this.getInternalVersion((MetadataInterface)metadata)) {
            throw new ObjectModifiedException("Internal Version mismatch, merge changes and retry.", identifier);
        }
        try {
            this.metadataUtils.updateContentObject((ContentObject)contentObject, (MetadataInterface)metadata);
            this.mapDescriptorToSmartObject(contentObject, metadata);
            this.mapContentObjectToSmartObject(contentObject, metadata);
            metadata.update();
            metadata.refresh();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        T ret = this.getContentObjectFromSmartObject(metadata);
        return ret;
    }

    public T findById(String id, String versionName) {
        return null;
    }

    public T rename(T contentObject, String newName) throws ObjectNotFoundException, ObjectExistsException, ObjectModifiedException, ValidationException {
        this.validateName(newName);
        String identifier = contentObject.getId();
        S metadata = this.getSmartObjectById(identifier);
        if (metadata == null) {
            throw new ObjectNotFoundException("Object with identity " + identifier + " was not found.", identifier);
        }
        if (contentObject.getInternalVersion() != this.getInternalVersion((MetadataInterface)metadata)) {
            throw new ObjectModifiedException("Internal Version mismatch, merge changes and retry.", identifier);
        }
        try {
            metadata.setName(newName);
            metadata.update();
            metadata.refresh();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        T ret = this.getContentObjectFromSmartObject(metadata);
        return ret;
    }

    private T getDescriptorFromBrowseObject(BrowseMetadata bm) {
        T ret = this.getNewContentObject();
        ret.setDescriptor(true);
        this.metadataUtils.populateContentObjectFromBrowseMetadata((ContentObject)ret, bm);
        ret.setInternalVersion(this.getInternalVersion(bm));
        this.mapBrowseMetadataToDescriptor(bm, ret);
        return ret;
    }

    private T getDescriptorFromSmartObject(S smartObject) {
        T ret = this.getNewContentObject();
        ret.setDescriptor(true);
        this.metadataUtils.populateContentObjectFromMetadata((ContentObject)ret, (MetadataInterface)smartObject);
        ret.setInternalVersion(this.getInternalVersion((MetadataInterface)smartObject));
        try {
            this.mapSmartObjectToDescriptor(smartObject, ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return ret;
    }

    protected T getContentObjectFromBrowseMetadata(BrowseMetadata bm) {
        T ret = this.getNewContentObject();
        this.metadataUtils.populateContentObjectFromBrowseMetadata((ContentObject)ret, bm);
        this.mapBrowseMetadataToDescriptor(bm, ret);
        this.mapBrowseMetadataToContentObject(bm, ret);
        ret.setInternalVersion(this.getInternalVersion(bm));
        return ret;
    }

    protected T getContentObjectFromSmartObject(S smartObject) {
        T ret = this.getNewContentObject();
        this.metadataUtils.populateContentObjectFromMetadata((ContentObject)ret, (MetadataInterface)smartObject);
        ret.setInternalVersion(this.getInternalVersion((MetadataInterface)smartObject));
        try {
            this.mapSmartObjectToDescriptor(smartObject, ret);
            this.mapSmartObjectToContentObject(smartObject, ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return ret;
    }

    protected T getNewContentObject() {
        try {
            ContentObject ret = (ContentObject)this.contentClazz.newInstance();
            ret.setObjectType(this.objectType);
            return (T)ret;
        }
        catch (Exception e) {
            log.error("Exception instantiating class: " + this.contentClazz.getName(), (Throwable)e);
            throw new RuntimeException("Exception instantiating class: " + this.contentClazz.getName() + ": " + e.getMessage());
        }
    }

    protected S getSmartObjectById(String id) {
        return (S)this.metadataTemplate.searchMetadataObjectById(id);
    }

    protected boolean isBrowseSupported() {
        return false;
    }

    protected String getTemplate() {
        return null;
    }

    protected void mapBrowseMetadataToContentObject(BrowseMetadata bm, T contentObject) {
    }

    protected abstract void mapSmartObjectToContentObject(S var1, T var2) throws RemoteException, ServiceException;

    protected void mapBrowseMetadataToDescriptor(BrowseMetadata bm, T descriptor) {
    }

    protected void validateName(String name) throws ValidationException {
        this.metadataUtils.validateName(name);
    }

    protected abstract void mapSmartObjectToDescriptor(S var1, T var2) throws RemoteException, ServiceException;

    protected abstract void mapContentObjectToSmartObject(T var1, S var2) throws ServiceException, RemoteException;

    protected abstract void mapDescriptorToSmartObject(T var1, S var2) throws ServiceException, RemoteException;
}

