/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.common.client.dao.omr;

import com.sas.services.ServiceException;
import com.sas.services.information.InformationServiceInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.browse.BrowseMetadata;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.common.client.dao.omr.MetadataContentUtils;
import com.sas.svcs.common.client.dao.omr.MetadataTemplate;
import com.sas.svcs.common.client.dao.omr.PathUtils;
import com.sas.svcs.content.framework.client.ContentComponent;
import com.sas.svcs.content.framework.client.ContentNode;
import com.sas.svcs.content.framework.client.ContentObject;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.objecttype.client.ObjectType;
import com.sas.svcs.content.objecttype.client.ObjectTypeService;
import java.rmi.RemoteException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractMetadataDAO {
    private MetadataTemplate omrTemplate;
    private ObjectTypeService typeService;
    private MetadataContentUtils metadataContentUtils = new MetadataContentUtils();

    @Autowired
    public void setMetadataTemplate(@Qualifier(value="currentUserMetadataTemplate") MetadataTemplate omrTemplate) {
        this.omrTemplate = omrTemplate;
    }

    protected MetadataTemplate getMetadataTemplate() {
        return this.omrTemplate;
    }

    public void setMetadataUtils(MetadataContentUtils metadataContentUtils) {
        this.metadataContentUtils = metadataContentUtils;
    }

    protected MetadataContentUtils getMetadataUtils() {
        return this.metadataContentUtils;
    }

    protected InformationServiceInterface getInformationService() {
        return this.omrTemplate.getInformationService();
    }

    @Autowired
    public void setObjectTypeService(ObjectTypeService typeService) {
        this.typeService = typeService;
    }

    protected ObjectTypeService getObjectTypeService() {
        return this.typeService;
    }

    protected long getObjectTypeId(String typeName) {
        ObjectType type = this.typeService.getTypeByName(typeName);
        return type == null ? -1L : type.getId();
    }

    protected String getObjectTypeName(long id) {
        ObjectType type = this.typeService.getTypeById(id);
        return type == null ? "Unknown" : type.getName();
    }

    protected MetadataInterface getMetadataObjectById(String id) {
        return this.omrTemplate.searchMetadataObjectById(id);
    }

    protected BrowseMetadata getBrowseMetadataById(String id, String template) {
        return (BrowseMetadata)this.omrTemplate.searchBrowseMetadataById(id, template);
    }

    protected MetadataInterface getMetadataObjectById(String id, String template) {
        return this.omrTemplate.searchMetadataObjectById(id, template);
    }

    protected ServerInterface getServer() throws RemoteException, ServiceException {
        return this.omrTemplate.getServer();
    }

    protected MetadataInterface getMetadataObject(String path) {
        return this.omrTemplate.getMetadataObjectByPath(path);
    }

    protected SessionContextInterface getSessionContext() {
        return this.omrTemplate.getSessionContext();
    }

    protected UserContextInterface getUserContext() {
        return this.omrTemplate.getUserContext();
    }

    protected FolderInterface getOmrFolder(String id) {
        return this.omrTemplate.searchFolderById(id);
    }

    protected FolderInterface getOmrFolderException(String id) throws ObjectNotFoundException {
        return this.omrTemplate.searchRequiredFolderById(id);
    }

    protected void populateContentComponentFromBrowseMetadata(ContentComponent component, BrowseMetadata bm) {
        this.metadataContentUtils.populateContentComponentFromBrowseMetadata(component, bm);
    }

    protected void populateContentComponentFromMetadata(ContentComponent component, MetadataInterface metadata) {
        this.metadataContentUtils.populateContentComponentFromMetadata(component, metadata);
    }

    protected void populateContentObjectFromBrowseMetadata(ContentObject contentObject, BrowseMetadata bm) {
        this.metadataContentUtils.populateContentObjectFromBrowseMetadata(contentObject, bm);
        this.populateObjectType(contentObject);
    }

    private void populateObjectType(ContentObject contentObject) {
        String typeName = contentObject.getObjectTypeName();
        if (typeName != null) {
            ObjectType objectType = this.typeService.getTypeByName(typeName);
            if (objectType != null) {
                contentObject.setObjectType(objectType.getId());
            } else {
                contentObject.setObjectType(-1L);
            }
        }
    }

    protected void populateContentObjectFromMetadata(ContentObject contentObject, MetadataInterface metadata) {
        this.metadataContentUtils.populateContentObjectFromMetadata(contentObject, metadata);
        this.populateObjectType(contentObject);
    }

    protected void populateContentNodeFromMetadata(ContentNode contentNode, MetadataInterface metadata) {
        this.metadataContentUtils.populateContentNodeFromMetadata(contentNode, metadata);
    }

    protected void updateContentComponent(ContentComponent component, MetadataInterface metadata) {
        this.metadataContentUtils.updateContentComponent(component, metadata);
    }

    protected void updateContentObject(ContentObject content, MetadataInterface metadata) {
        this.metadataContentUtils.updateContentObject(content, metadata);
    }

    protected String pathToRoot(BrowseMetadataInterface bmi) {
        return PathUtils.pathToRoot((BrowseMetadata)bmi);
    }

    protected void validateName(String name) throws ValidationException {
        this.metadataContentUtils.validateName(name);
    }
}

