/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.workspace.WAPropertyTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;

public class ValidationOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ValidationOptionsTab.class);
    private UserOptions m_userOptions;
    private JCheckBox m_showWarnings = new JCheckBox(m_bundle.getString("ValidationOptionsTab.ShowWarnings.txt"));
    private JCheckBox m_errorOnDeleteFailure = new JCheckBox(m_bundle.getString("ValidationOptionsTab.ErrorOnDeleteFailure.txt"));
    private JCheckBox m_showFlowWarnings = new JCheckBox(m_bundle.getString("ValidationOptionsTab.ShowFlowWarnings.txt"));
    private JCheckBox m_checkFilenames = new JCheckBox(m_bundle.getString("ValidationOptionsTab.CheckFilenames.txt"));
    private JCheckBox m_warnOnlyInvalidFilenames = new JCheckBox(m_bundle.getString("ValidationOptionsTab.WarnOnlyInvalidFilenames.txt"));

    public ValidationOptionsTab(UserOptions userOptions) {
        this.m_userOptions = userOptions;
        this.setName(m_bundle.getString("ValidationOptionsTab.Name.txt"));
        this.setHelpProduct("scheduler");
        this.setHelpTopic("validation_tab");
        this._initialize();
    }

    public void moveDataToView() {
        this.m_showWarnings.setSelected(this.m_userOptions.showWarnings());
        this.m_errorOnDeleteFailure.setSelected(this.m_userOptions.errorOnDeletionFromScheduler());
        this.m_showFlowWarnings.setSelected(this.m_userOptions.showFlowWarnings());
        boolean checkfilenames = this.m_userOptions.sourceFilenameCheckCharacters();
        this.m_checkFilenames.setSelected(checkfilenames);
        this.m_warnOnlyInvalidFilenames.setSelected(this.m_userOptions.sourceFilenameCheckWarning());
        this.m_warnOnlyInvalidFilenames.setEnabled(checkfilenames);
    }

    public void moveDataToStore() {
        this.m_userOptions.setShowWarnings(this.m_showWarnings.isSelected());
        this.m_userOptions.setErrorOnDeletionFromScheduler(this.m_errorOnDeleteFailure.isSelected());
        this.m_userOptions.setShowFlowWarnings(this.m_showFlowWarnings.isSelected());
        this.m_userOptions.setSourceFilenameCheckCharacters(this.m_checkFilenames.isSelected());
        this.m_userOptions.setSourceFilenameCheckWarning(this.m_warnOnlyInvalidFilenames.isSelected());
        this.m_userOptions.saveExisting();
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    private void _initialize() {
        this.m_showWarnings.setToolTipText(m_bundle.getString("ValidationOptionsTab.ShowWarnings.ToolTip.txt"));
        this.m_errorOnDeleteFailure.setToolTipText(m_bundle.getString("ValidationOptionsTab.ErrorOnDeleteFailure.ToolTip.txt"));
        this.m_showFlowWarnings.setToolTipText(m_bundle.getString("ValidationOptionsTab.ShowFlowWarnings.ToolTip.txt"));
        this.m_checkFilenames.setToolTipText(m_bundle.getString("ValidationOptionsTab.CheckFilenames.ToolTip.txt"));
        this.m_warnOnlyInvalidFilenames.setToolTipText(m_bundle.getString("ValidationOptionsTab.WarnOnlyInvalidFilenames.ToolTip.txt"));
        this.m_checkFilenames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValidationOptionsTab.this.m_warnOnlyInvalidFilenames.setEnabled(ValidationOptionsTab.this.m_checkFilenames.isSelected());
            }
        });
        JLabel information1 = new JLabel(m_bundle.getString("ValidationOptionsTab.InformationSubmitHeader.txt"));
        JLabel information2 = new JLabel(m_bundle.getString("ValidationOptionsTab.InformationSaveHeader.txt"));
        JLabel information3 = new JLabel(m_bundle.getString("ValidationOptionsTab.InformationAddJobHeader.txt"));
        JLabel lblSeperator1 = new JLabel();
        lblSeperator1.setBorder(new EtchedBorder());
        JLabel lblSeperator2 = new JLabel();
        lblSeperator2.setBorder(new EtchedBorder());
        this.setLayout(new GridBagLayout());
        this.add(information1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_showWarnings, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_errorOnDeleteFailure, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(lblSeperator1, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(information2, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_showFlowWarnings, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(lblSeperator2, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(information3, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_checkFilenames, new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_warnOnlyInvalidFilenames, new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 17, 2, new Insets(5, 25, 0, 0), 0, 0));
    }
}

