/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.NewSchedulingServerAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.SchedulerServerPanel;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SetSchedulerServerDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SetSchedulerServerDialog.class);
    private ScheduleManager m_schmgr;
    private Object[] m_elementList;
    private SchedulerServerPanel m_mainPanel;
    private SchedulerServerInfo m_scheduler;

    public SetSchedulerServerDialog(ScheduleManager plugin, Object[] elementList) throws RemoteException {
        super(plugin.getMainFrame(), m_bundle.getString("SetSchedulerServerDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.m_elementList = elementList;
        this.__initialize();
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_scheduling_server");
    }

    public void dispose() {
        super.dispose();
        this.m_schmgr = null;
        this.m_elementList = null;
        this.m_mainPanel = null;
        this.m_scheduler = null;
    }

    private void __initialize() {
        ArrayList<SchedulerServerInfo> serverList = new ArrayList<SchedulerServerInfo>();
        List<SchedulerServerInfo> list = null;
        if (this.hasVADesignerFlows(this.m_elementList)) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("SetSchedulerServerDialog.VADesigner.Msg.txt"), (String)m_bundle.getString("SetSchedulerServerDialog.Title.txt"), (int)2, (int)-1);
            list = this.m_schmgr.getSchedulerServers(106);
        } else {
            list = this.m_schmgr.getSchedulerServers(100);
        }
        if (list != null) {
            serverList.addAll(list);
        }
        serverList.add(0, new SchedulerServerInfo(m_bundle.getString("SetSchedulerServerDialog.SelectOne.txt"), ""));
        SchedulerServerInfo defaultsch = null;
        if (this.m_elementList.length == 1) {
            defaultsch = ((ServerFlowInfo)this.m_elementList[0]).getInfo().getScheduler();
        }
        this.m_mainPanel = new SchedulerServerPanel(serverList, defaultsch);
        this.m_mainPanel.addNewButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSchedulingServerAction nssa = new NewSchedulingServerAction(SetSchedulerServerDialog.this.m_schmgr);
                nssa.runWizard();
                SchedulerServerInfo sinfo = nssa.getServerInfo();
                if (sinfo != null) {
                    SetSchedulerServerDialog.this.m_mainPanel.addServer(sinfo);
                }
            }
        });
        this.setMainPanel((StandardPanel)this.m_mainPanel);
    }

    private boolean hasVADesignerFlows(Object[] elementList) {
        for (int i = 0; i < elementList.length; ++i) {
            JobInfo j;
            BatchServerInfo bsi;
            DisplayInfo jinfo;
            List jobs;
            FlowInfo info = ((ServerFlowInfo)this.m_elementList[i]).getInfo();
            SchedulerServerInfo ssi = info.getScheduler();
            if (!ssi.getClassId().equals("c8b4baf0-5f9f-488e-ba76-1201e1e81aef") || (jobs = info.getJobs()).size() != 1 || !((jinfo = (DisplayInfo)jobs.get(0)) instanceof JobInfo) || (bsi = (j = (JobInfo)jinfo).getBatchServer()).getType() != 2 || bsi.getSubType() != 26) continue;
            return true;
        }
        return false;
    }

    public boolean validateData() throws SchedulerException {
        if (!this.m_mainPanel.validateData()) {
            return false;
        }
        this.m_scheduler = this.m_mainPanel.getSelectedServer();
        if (this.m_scheduler == null || this.m_scheduler.getName().compareTo(m_bundle.getString("SetSchedulerServerDialog.SelectOne.txt")) == 0) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("SetSchedulerServerDialog.NoScheduler.Msg.txt"), (String)m_bundle.getString("SetSchedulerServerDialog.Title.txt"), (int)0, (int)-1);
            return false;
        }
        if (!this.m_schmgr.isValidScheduler(this.m_scheduler)) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("SetSchedulerServerDialog.InvalidScheduler.Msg.txt"), (String)m_bundle.getString("SetSchedulerServerDialog.Title.txt"), (int)0, (int)-1);
            return false;
        }
        return true;
    }

    public boolean onOK() throws SchedulerException {
        boolean rc = false;
        if (super.onOK() && this.validateData()) {
            try {
                int flows = this.m_elementList.length;
                for (int index = 0; index < flows; ++index) {
                    ServerFlowInfo info = (ServerFlowInfo)this.m_elementList[index];
                    if (info.isFlowSubmitted() && (!this.m_schmgr.connectToSchedulingServer(info) || this.m_schmgr.getServerUtilities().removeScheduledFlow(info) != 0)) {
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("FlowPropertiesAttributesTab.UnableToRemoveFromScheduler.txt"), (String)m_bundle.getString("SetSchedulerServerDialog.Title.txt"), (int)2);
                    }
                    info.setScheduler(this.m_scheduler);
                    rc = info.commitChangesToOMR();
                    if (!rc) continue;
                    this.m_schmgr.refreshNodeFromInfo((DisplayInfo)info);
                }
            }
            catch (RuntimeException ex) {
                rc = false;
            }
        }
        return rc;
    }
}

