/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.AssociatedJobPanel;
import com.sas.scheduler.visuals.swing.ConfirmCheckboxDialog;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.swing.JOptionPane;

public class SetJobDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SetJobDialog.class);
    private Object[] m_elementList;
    private AssociatedJobPanel m_mainPanel;
    private ScheduleManager m_schmgr;

    public SetJobDialog(ScheduleManager plugin, Object[] elementList) throws RemoteException {
        super(plugin.getMainFrame(), m_bundle.getString("SetJobDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.m_elementList = elementList;
        this.__initialize();
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_set_associated_job");
    }

    public void dispose() {
        super.dispose();
        this.m_elementList = null;
        this.m_mainPanel = null;
    }

    private void __initialize() {
        try {
            DisplayInfo info;
            SortedSet<DisplayInfo> list = this.m_schmgr.getNonAssociatedJobsFromRepository();
            if (list.size() < 1) {
                int response = JOptionPane.showConfirmDialog(this.m_schmgr.getMainFrame(), m_bundle.getString("SetJobDialog.NoJobsNotAssociated.Msg.txt"), m_bundle.getString("SetJobDialog.Title.txt"), 0);
                if (1 == response) {
                    throw new NoSuchElementException();
                }
                list = this.m_schmgr.getJobObjectsFromRepository();
            }
            ArrayList<DisplayInfo> jobList = new ArrayList<DisplayInfo>(list);
            JobInfo defaultjob = null;
            if (this.m_elementList.length == 1 && (info = ((ServerJobInfo)this.m_elementList[0]).getJobInfo()) instanceof JobInfo) {
                defaultjob = (JobInfo)info;
            }
            this.m_mainPanel = new AssociatedJobPanel(this.m_schmgr.getMainFrame(), jobList, defaultjob);
        }
        catch (RemoteException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("SetJobDialog.Title.txt"), (int)0);
        }
        catch (SchedulerException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("SetJobDialog.Title.txt"), (int)0);
        }
        catch (NoSuchElementException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("SetJobDialog.Title.txt"), (int)0);
        }
        this.setMainPanel((StandardPanel)this.m_mainPanel);
    }

    public boolean validateData() {
        return this.m_mainPanel.validateData();
    }

    public boolean onOK() throws SchedulerException {
        boolean rc = false;
        if (super.onOK() && this.validateData()) {
            try {
                boolean confirm = true;
                int jobs = this.m_elementList.length;
                for (int index = 0; index < jobs; ++index) {
                    ServerJobInfo jobinfo = (ServerJobInfo)this.m_elementList[index];
                    DisplayInfo info = this.m_mainPanel.getSelectedJob();
                    if (confirm) {
                        ConfirmCheckboxDialog dia = new ConfirmCheckboxDialog(this.m_schmgr.getMainFrame(), m_bundle.getString("SetJobDialog.Title.txt"), m_bundle.messageString("SetJobDialog.Confirmation.Msg.fmt", (Object)jobinfo.getName(), (Object)info.getName()));
                        dia.makeVisible();
                        confirm = dia.stillConfirm();
                        if (2 == dia.getReturnValue()) {
                            if (confirm) {
                                continue;
                            }
                            break;
                        }
                    }
                    if (rc = jobinfo.setJob(info)) {
                        rc = jobinfo.commitChangesToOMR();
                    }
                    if (rc) {
                        jobinfo.refreshIcon();
                        jobinfo.reevaluateErrors();
                    }
                    if (rc) continue;
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("SetJobDialog.UnableToSaveChange.Msg.fmt", (Object)jobinfo.errorConditions()), (String)m_bundle.getString("SetJobDialog.Title.txt"), (int)0, (int)-1);
                }
            }
            catch (RuntimeException ex) {
                rc = false;
            }
        }
        return rc;
    }
}

