/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.NewBatchServerAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.BatchServerPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class SetBatchServerDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SetBatchServerDialog.class);
    private ScheduleManager m_schmgr;
    private Object[] m_elementList;
    private BatchServerPanel m_mainPanel;
    private BatchServerInfo m_batchserver;

    public SetBatchServerDialog(ScheduleManager plugin, Object[] elementList) throws RemoteException {
        super(plugin.getMainFrame(), m_bundle.getString("SetBatchServerDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.m_elementList = elementList;
        this.__initialize();
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_batch_server");
    }

    public void dispose() {
        super.dispose();
        this.m_elementList = null;
        this.m_mainPanel = null;
        this.m_batchserver = null;
    }

    private void __initialize() {
        DisplayInfo info;
        ArrayList<BatchServerInfo> serverList = new ArrayList<BatchServerInfo>();
        List<BatchServerInfo> list = this.m_schmgr.getBatchServers(-1, -1);
        if (list != null) {
            serverList.addAll(list);
        }
        serverList.add(0, new BatchServerInfo(m_bundle.getString("SetBatchServerDialog.SelectOne.txt"), ""));
        BatchServerInfo defaultbs = null;
        if (this.m_elementList.length == 1 && (info = ((ServerJobInfo)this.m_elementList[0]).getJobInfo()) instanceof JobInfo) {
            defaultbs = ((JobInfo)info).getBatchServer();
        }
        this.m_mainPanel = new BatchServerPanel(serverList, defaultbs);
        this.m_mainPanel.addNewButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewBatchServerAction nbsa = new NewBatchServerAction(SetBatchServerDialog.this.m_schmgr);
                nbsa.runWizard();
                BatchServerInfo sinfo = nbsa.getServerInfo();
                if (sinfo != null) {
                    SetBatchServerDialog.this.m_mainPanel.addServer(sinfo);
                }
            }
        });
        this.setMainPanel((StandardPanel)this.m_mainPanel);
    }

    public boolean validateData() {
        if (!this.m_mainPanel.validateData()) {
            return false;
        }
        this.m_batchserver = this.m_mainPanel.getSelectedServer();
        if (this.m_batchserver.getName().compareTo(m_bundle.getString("SetBatchServerDialog.SelectOne.txt")) == 0) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("SetBatchServerDialog.NoBatchServer.Msg.txt"), (String)m_bundle.getString("SetBatchServerDialog.Title.txt"), (int)0, (int)-1);
            return false;
        }
        try {
            if (!this.m_schmgr.isValidBatchServer(this.m_batchserver)) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("SetBatchServerDialog.InvalidBatchServer.Msg.txt"), (String)m_bundle.getString("SetBatchServerDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean onOK() throws SchedulerException {
        boolean rc = true;
        if (super.onOK() && this.validateData()) {
            try {
                int jobs = this.m_elementList.length;
                for (int index = 0; index < jobs; ++index) {
                    ServerJobInfo job = (ServerJobInfo)this.m_elementList[index];
                    job.setBatchServer(this.m_batchserver);
                    job.resetCommandLine();
                    if (!job.commitChangesToOMR()) {
                        MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("SetBatchServerDialog.UnableToSaveChange.Msg.fmt", (Object)job.errorConditions()), (String)m_bundle.getString("SetBatchServerDialog.Title.txt"), (int)0, (int)-1);
                        rc = false;
                        continue;
                    }
                    this.m_schmgr.refreshNodeFromInfo((DisplayInfo)job);
                }
            }
            catch (RuntimeException ex) {
                if (ScheduleManager.isDebug()) {
                    ex.printStackTrace();
                }
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("SetBatchServerDialog.UnableToSaveChange.Msg.fmt", (Object)ex.toString()), (String)m_bundle.getString("SetBatchServerDialog.Title.txt"), (int)0, (int)-1);
                rc = false;
            }
        }
        return rc;
    }
}

