/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.ScheduledFlowInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ScheduledFlowsPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ScheduledFlowsPanel.class);
    private JList m_list;
    private DefaultListModel m_model;
    private JScrollPane m_pane = null;
    private ActionListener m_callback = null;
    private ArrayList<ActionListener> m_actionList = null;
    private ActionListener m_actionTrigger = null;
    private ActionListener m_actionHold = null;
    private ActionListener m_actionRelease = null;
    private ActionListener m_actionDelete = null;
    private ActionListener m_actionRefresh = null;
    private List<ScheduledFlowInfo> m_flows;

    public ScheduledFlowsPanel(List<ScheduledFlowInfo> flows, ActionListener triggerAL, ActionListener holdAL, ActionListener releaseAL, ActionListener deleteAL, ActionListener refreshAL) {
        this.m_flows = flows;
        this.m_actionTrigger = triggerAL;
        this.m_actionHold = holdAL;
        this.m_actionRelease = releaseAL;
        this.m_actionDelete = deleteAL;
        this.m_actionRefresh = refreshAL;
        this.initialize();
    }

    public List<ActionListener> getContextMenuActions() {
        if (this.m_actionList == null) {
            this.m_actionList = new ArrayList();
            this.m_actionList.add(this.m_actionTrigger);
            this.m_actionList.add(this.m_actionHold);
            this.m_actionList.add(this.m_actionRelease);
            this.m_actionList.add(this.m_actionDelete);
            this.m_actionList.add(this.m_actionRefresh);
        }
        return this.m_actionList;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_flows = null;
        this.m_actionTrigger = null;
        this.m_actionHold = null;
        this.m_actionRelease = null;
        this.m_actionDelete = null;
        this.m_actionRefresh = null;
    }

    public boolean removeFlow(ScheduledFlowInfo flow) {
        boolean rc = false;
        if (this.m_flows.remove(flow)) {
            rc = this.m_model.removeElement(flow);
            this.resizeWindow();
        }
        return rc;
    }

    public boolean setFlows(List<ScheduledFlowInfo> flows) {
        this.m_flows = flows;
        this.m_model = new DefaultListModel();
        if (this.m_flows != null) {
            for (ScheduledFlowInfo info : this.m_flows) {
                this.m_model.addElement(info);
            }
        }
        this.m_list.setModel(this.m_model);
        this.resizeWindow();
        return true;
    }

    public void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    public void setListener(ActionListener acl) {
        this.m_callback = acl;
    }

    public void removeListener() {
        this.m_callback = null;
    }

    public ScheduledFlowInfo getSelectedFlow() {
        Object obj = this.m_list.getSelectedValue();
        if (obj instanceof ScheduledFlowInfo) {
            return (ScheduledFlowInfo)obj;
        }
        return null;
    }

    private void initialize() {
        JPanel topPanel = new JPanel();
        TitledBorder border = new TitledBorder(m_bundle.getString("ScheduledFlowsPanel.BorderTitle.txt"));
        topPanel.setBorder(border);
        this.setDataChanged(false);
        this.m_list = new JList();
        this.setFlows(this.m_flows);
        this.m_list.setSelectionMode(0);
        this.m_list.addMouseListener(new cMouseListener());
        this.m_list.setCellRenderer(new MyListCellRenderer());
        this.m_pane = new JScrollPane(this.m_list, 20, 30);
        this.m_pane.setPreferredSize(new Dimension(350, 340));
        this.m_list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object obj;
                if (ScheduledFlowsPanel.this.m_callback != null && (obj = ScheduledFlowsPanel.this.m_list.getSelectedValue()) != null) {
                    ActionEvent ae = new ActionEvent(obj, 1001, null);
                    ScheduledFlowsPanel.this.m_callback.actionPerformed(ae);
                }
            }
        });
        topPanel.add(this.m_pane);
        topPanel.setPreferredSize(new Dimension(350, 360));
        this.add(topPanel);
    }

    public boolean validateData() {
        return true;
    }

    public boolean moveDataToView() {
        return true;
    }

    public boolean onParentOK() {
        return super.onParentOK();
    }

    public boolean onParentCancel() {
        return super.onParentCancel();
    }

    private class SetMyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        ActionListener m_action;
        ScheduledFlowInfo m_flow;

        public SetMyAction(ScheduledFlowInfo flow, ActionListener action, String title) {
            this.m_action = action;
            this.m_flow = flow;
            this.setMenuItem(title);
        }

        private void setMenuItem(String title) {
            this.putValue("Name", Util.getLabelWithoutMnemonic((String)title));
            this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)title));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ActionEvent e = new ActionEvent(this.m_flow, 1001, null);
            this.m_action.actionPerformed(e);
        }
    }

    private class cMouseListener
    implements MouseListener {
        private cMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0) {
                this.popMenu(e);
            }
        }

        private void popMenu(MouseEvent e) {
            int selectedRow = ScheduledFlowsPanel.this.m_list.getSelectedIndex();
            if (selectedRow != -1) {
                ScheduledFlowInfo flow = (ScheduledFlowInfo)ScheduledFlowsPanel.this.m_list.getSelectedValue();
                JPopupMenu popMenu = this._buildPopupMenu(flow);
                popMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected JPopupMenu _buildPopupMenu(ScheduledFlowInfo flow) {
            ToolTipStrippingJPopupMenu popMenu = new ToolTipStrippingJPopupMenu();
            if (flow == null) {
                return popMenu;
            }
            SetMyAction triggerAction = new SetMyAction(flow, ScheduledFlowsPanel.this.m_actionTrigger, m_bundle.getString("ScheduledFlowsPanel.Action.Trigger.txt"));
            popMenu.add(triggerAction);
            if (!flow.isDisplayOnly()) {
                SetMyAction holdAction = new SetMyAction(flow, ScheduledFlowsPanel.this.m_actionHold, m_bundle.getString("ScheduledFlowsPanel.Action.Hold.txt"));
                popMenu.add(holdAction);
            }
            if (flow.isDisplayOnly()) {
                SetMyAction releaseAction = new SetMyAction(flow, ScheduledFlowsPanel.this.m_actionRelease, m_bundle.getString("ScheduledFlowsPanel.Action.Release.txt"));
                popMenu.add(releaseAction);
            }
            SetMyAction deleteAction = new SetMyAction(flow, ScheduledFlowsPanel.this.m_actionDelete, m_bundle.getString("ScheduledFlowsPanel.Action.Delete.txt"));
            popMenu.add(deleteAction);
            SetMyAction refreshAction = new SetMyAction(flow, ScheduledFlowsPanel.this.m_actionRefresh, m_bundle.getString("ScheduledFlowsPanel.Action.Refresh.txt"));
            popMenu.add(refreshAction);
            return popMenu;
        }
    }

    class MyListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7799441088157759804L;
        private JLabel m_label = new JLabel();
        private Color m_selectedBackground;
        private Color m_selectedText;
        private Color m_background;
        private Color m_text;

        MyListCellRenderer() {
            this.m_label.setOpaque(true);
            this.m_selectedBackground = UIManager.getColor("List.selectionBackground");
            this.m_selectedText = UIManager.getColor("List.selectionForeground");
            this.m_background = UIManager.getColor("List.background");
            this.m_text = UIManager.getColor("List.foreground");
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean expanded) {
            ScheduledFlowInfo flow = (ScheduledFlowInfo)value;
            if (flow.isDisplayOnly()) {
                this.m_label.setIcon((Icon)IconUtil.getIcon((String)"GIF_16/Time_paused.gif"));
            } else {
                this.m_label.setIcon((Icon)IconUtil.getIcon((String)FlowInfo.getIconName((boolean)true, (boolean)false)));
            }
            if (selected) {
                this.m_label.setBackground(this.m_selectedBackground);
                this.m_label.setForeground(this.m_selectedText);
            } else {
                this.m_label.setBackground(this.m_background);
                this.m_label.setForeground(this.m_text);
            }
            this.m_label.setText(flow.toString());
            this.m_label.setToolTipText(flow.getLocation());
            return this.m_label;
        }
    }
}

