/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.servers.sasjfs.SASJFScheduler;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.visuals.swing.EnvironmentVariablesPanel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SASJFSAdvancePropertiesPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SASJFSAdvancePropertiesPanel.class);
    private static String m_selectOne = m_bundle.getString("SASJFSAdvancePropertiesPanel.SelectOne.txt");
    private ScheduleManager m_schmgr;
    private JobInfo m_job = null;
    private SASJFScheduler m_scheduler = null;
    private JTextField m_command = new JTextField();
    private JComboBox m_queues = new JComboBox();
    private EnvironmentVariablesPanel m_envVars;
    private String m_queue = m_selectOne;
    private boolean m_restartable = false;
    private Map<String, String> m_environmentVars = new HashMap<String, String>();
    private List<String> m_requiredTags = new ArrayList<String>();
    private Map<String, Double> m_requiredResources = new HashMap<String, Double>();
    private Map<String, Double> m_consumedResources = new HashMap<String, Double>();
    private Map<String, Double> m_limits = new HashMap<String, Double>();

    public SASJFSAdvancePropertiesPanel(ScheduleManager plugin, JobInfo job, SASJFScheduler sch) {
        this.m_schmgr = plugin;
        this.m_job = job;
        this.m_scheduler = sch;
        this.initialize();
    }

    private void initialize() {
        String text = m_bundle.getString("SASJFSAdvancePropertiesPanel.CommandLabel.txt");
        JLabel label = new JLabel(Util.getLabelWithoutMnemonic((String)text));
        label.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)text));
        label.setLabelFor(this.m_command);
        String queueText = m_bundle.getString("SASJFSAdvancePropertiesPanel.Queues.txt");
        this.m_queues.setToolTipText(m_bundle.getString("SASJFSAdvancePropertiesPanel.Queues.ToolTip.txt"));
        JLabel lblqueues = new JLabel(Util.getLabelWithoutMnemonic((String)queueText));
        lblqueues.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)queueText));
        lblqueues.setLabelFor(this.m_queues);
        List queues = this.m_scheduler.getQueues();
        if (queues != null && queues.size() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(m_selectOne);
            list.addAll(queues);
            this.m_queues.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
            this.m_queues.setSelectedItem(m_selectOne);
            lblqueues.setEnabled(true);
            this.m_queues.setEnabled(true);
        } else {
            lblqueues.setEnabled(false);
            this.m_queues.setModel(new DefaultComboBoxModel());
            this.m_queues.setEnabled(false);
        }
        this.m_queues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SASJFSAdvancePropertiesPanel.this.m_queue = (String)SASJFSAdvancePropertiesPanel.this.m_queues.getSelectedItem();
            }
        });
        String definition = this.m_job.getSchedulerResources();
        List list = null;
        String token = this.m_scheduler.getDefinitionString(definition, "Variables:");
        if (token != null) {
            list = this.m_scheduler.getStringListFromDefinitionString(token);
        }
        this.m_envVars = new EnvironmentVariablesPanel(this.m_schmgr.getMainFrame(), list);
        GridBagConstraints gbc1 = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc2 = new GridBagConstraints(1, 0, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc3 = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc4 = new GridBagConstraints(1, 1, 10, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc5 = new GridBagConstraints(1, 2, 11, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.m_command.setPreferredSize(new Dimension(300, 20));
        this.add(label, gbc1);
        this.add(this.m_command, gbc2);
        this.add(lblqueues, gbc3);
        this.add(this.m_queues, gbc4);
        this.add((Component)this.m_envVars, gbc5);
    }

    public String getCommandLine() {
        return this.m_command.getText();
    }

    public boolean setCommandLine(String text) {
        this.m_command.setText(text);
        return true;
    }

    public String getRunAs() {
        return this.m_job.getUserId();
    }

    public boolean setRunAs(String text) {
        this.m_job.setUserId(text);
        return true;
    }

    public String getSchedulerResource() {
        String queue = this.m_queue != null && !this.m_queue.equals(m_selectOne) ? this.m_queue : null;
        this.m_environmentVars = this.m_envVars.getVariableMap();
        return this.m_scheduler.createSchedulerResource(queue, this.m_restartable, this.m_environmentVars, this.m_requiredTags, this.m_requiredResources, this.m_consumedResources, this.m_limits);
    }

    public boolean setSchedulerResource(String text) {
        String consumedResourcesString;
        String requiredResourcesString;
        String requiredTagsString;
        String envString;
        String restartableString;
        if (text == null) {
            return false;
        }
        String queue = this.m_scheduler.getDefinitionString(text, "Queue:");
        if (queue != null) {
            this.m_queues.setSelectedItem(queue);
        }
        if ((restartableString = this.m_scheduler.getDefinitionString(text, "Restartable:")) != null && restartableString.equals("true")) {
            this.m_restartable = true;
        }
        if ((envString = this.m_scheduler.getDefinitionString(text, "Variables:")) != null) {
            this.m_environmentVars = this.m_scheduler.getStringMapFromDefinitionString(envString);
        }
        if ((requiredTagsString = this.m_scheduler.getDefinitionString(text, "Tags:")) != null) {
            this.m_requiredTags = this.m_scheduler.getStringListFromDefinitionString(requiredTagsString);
        }
        if ((requiredResourcesString = this.m_scheduler.getDefinitionString(text, "RequiredResources:")) != null) {
            this.m_requiredResources = this.m_scheduler.getDoubleMapFromDefinitionString(requiredResourcesString);
        }
        if ((consumedResourcesString = this.m_scheduler.getDefinitionString(text, "ConsumedResources:")) != null) {
            this.m_consumedResources = this.m_scheduler.getDoubleMapFromDefinitionString(consumedResourcesString);
        }
        return true;
    }

    public void setEditable(boolean flag) {
        this.m_command.setEditable(flag);
    }

    public boolean onParentOK() {
        if (super.onParentOK()) {
            this.m_job = null;
            return true;
        }
        return false;
    }

    public boolean onParentCancel() {
        if (super.onParentCancel()) {
            this.m_job = null;
            return true;
        }
        return false;
    }
}

