/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.RunHistory;
import com.sas.scheduler.schmgr.model.RunHistoryTableModel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RunningJobsPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(RunningJobsPanel.class);
    private WsTable m_table;
    private RunHistoryTableModel m_model;
    private JScrollPane m_pane = null;
    private ActionListener m_actionStdout = null;
    private ActionListener m_actionStderr = null;
    private ActionListener m_actionRefresh = null;
    private List<RunHistory> m_jobs;

    public RunningJobsPanel(List<RunHistory> jobs, ActionListener refreshAL, ActionListener stdoutAL, ActionListener stderrAL, ActionListener killAL) {
        this.m_jobs = jobs;
        this.m_actionRefresh = refreshAL;
        this.m_actionStdout = stdoutAL;
        this.m_actionStderr = stderrAL;
        this.initialize();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
    }

    public boolean setJobs(List<RunHistory> jobs) {
        this.m_jobs = jobs;
        this.m_model.clear();
        if (this.m_jobs != null) {
            for (RunHistory info : this.m_jobs) {
                this.m_model.addRow(info);
            }
        }
        this.resizeWindow();
        return true;
    }

    private void initialize() {
        JPanel topPanel = new JPanel();
        TitledBorder border = new TitledBorder(m_bundle.getString("RunningJobsPanel.BorderTitle.txt"));
        topPanel.setBorder(border);
        this.m_model = new RunHistoryTableModel();
        this.setJobs(this.m_jobs);
        this.m_table = new WsTable(this.m_model){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                Object tip = null;
                if (rowIndex >= 0 && colIndex >= 0) {
                    try {
                        tip = this.getValueAt(rowIndex, colIndex);
                    }
                    catch (RuntimeException ex) {
                        tip = ex.getLocalizedMessage();
                    }
                }
                return tip != null ? tip.toString() : "";
            }
        };
        this.m_table.addMouseListener((MouseListener)new cMouseListener());
        this.m_table.setEditable(false);
        this.m_table.setRowHeaderVisible(false);
        this.m_table.setSelectionMode(0);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setCellSelectionEnabled(false);
        this.m_table.setColumnHidingEnabled(false);
        this.m_table.setColumnHoldingEnabled(false);
        this.m_pane = new JScrollPane((Component)this.m_table, 20, 30);
        this.m_pane.setPreferredSize(new Dimension(350, 220));
        this.m_table.getRowModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
            }
        });
        topPanel.add(this.m_pane);
        topPanel.setPreferredSize(new Dimension(350, 240));
        this.add(topPanel);
    }

    public boolean validateData() {
        return true;
    }

    public boolean moveDataToView() {
        return true;
    }

    public boolean onParentOK() {
        return super.onParentOK();
    }

    public boolean onParentCancel() {
        return super.onParentCancel();
    }

    public void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    private class SetMyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        ActionListener m_action;
        RunHistory m_job;

        public SetMyAction(RunHistory job, ActionListener action, String title) {
            this.m_action = action;
            this.m_job = job;
            this.setMenuItem(title);
        }

        private void setMenuItem(String title) {
            this.putValue("Name", Util.getLabelWithoutMnemonic((String)title));
            this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)title));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ActionEvent e = new ActionEvent(this.m_job, 1001, null);
            this.m_action.actionPerformed(e);
        }
    }

    private class cMouseListener
    implements MouseListener {
        private cMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if ((e.getModifiers() & 4) != 0) {
                RunHistory job = new RunHistory();
                int selectedRow = RunningJobsPanel.this.m_table.getSelectedRow();
                if (selectedRow != -1) {
                    job = (RunHistory)RunningJobsPanel.this.m_jobs.get(selectedRow);
                }
                JPopupMenu popMenu = this._buildPopupMenu(job);
                popMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        protected JPopupMenu _buildPopupMenu(RunHistory job) {
            ToolTipStrippingJPopupMenu popMenu = new ToolTipStrippingJPopupMenu();
            SetMyAction refreshAction = new SetMyAction(job, RunningJobsPanel.this.m_actionRefresh, m_bundle.getString("RunningJobsPanel.Action.Refresh.txt"));
            popMenu.add(refreshAction);
            if (!job.getItemNameDataBinding().isEmpty()) {
                SetMyAction stdoutAction = new SetMyAction(job, RunningJobsPanel.this.m_actionStdout, m_bundle.getString("RunningJobsPanel.Action.Stdout.txt"));
                popMenu.add(stdoutAction);
                SetMyAction stderrAction = new SetMyAction(job, RunningJobsPanel.this.m_actionStderr, m_bundle.getString("RunningJobsPanel.Action.Stderr.txt"));
                popMenu.add(stderrAction);
            }
            return popMenu;
        }
    }
}

