/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.visuals.swing.MaxDimension;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class ReportFlowDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ReportFlowDialog.class);
    public static final int XML = 0;
    public static final int SAS = 1;
    public static final int CSV = 2;
    private ScheduleManager m_schmgr;
    private cReportFlowPanel m_mainPanel;
    private int m_type = 0;
    private String m_name;
    private DirectoryInfo m_selectedDirectory = null;
    private SASAppServer m_selectedServer = null;

    public ReportFlowDialog(ScheduleManager plugin) {
        super(plugin.getMainFrame(), m_bundle.getString("ReportFlowDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_report_flow");
        this.__initialize();
    }

    public void dispose() {
        if (this.m_mainPanel != null) {
            this.m_selectedServer = this.m_mainPanel.getSelectedServer();
            this.m_selectedDirectory = this.m_mainPanel.getSelectedDirectory();
            this.m_type = this.m_mainPanel.getType();
            this.m_name = this.m_mainPanel.getName();
        }
        super.dispose();
        this.m_mainPanel = null;
    }

    public String getName() {
        if (this.m_mainPanel != null) {
            this.m_name = this.m_mainPanel.getName();
        }
        return this.m_name;
    }

    public void setName(String name) {
        if (this.m_mainPanel != null) {
            this.m_mainPanel.setName(name);
        }
    }

    public SASAppServer getSelectedServer() {
        if (this.m_mainPanel != null) {
            this.m_selectedServer = this.m_mainPanel.getSelectedServer();
        }
        return this.m_selectedServer;
    }

    public DirectoryInfo getSelectedDirectory() {
        if (this.m_mainPanel != null) {
            this.m_selectedDirectory = this.m_mainPanel.getSelectedDirectory();
        }
        return this.m_selectedDirectory;
    }

    public int getReportType() {
        if (this.m_mainPanel != null) {
            this.m_type = this.m_mainPanel.getType();
        }
        return this.m_type;
    }

    private boolean __initialize() {
        try {
            ScheduleManager schmgr = ScheduleManager.getScheduleManager();
            List<SASAppServer> servers = schmgr.getAppServersWithDeployedDirectories();
            this.m_mainPanel = new cReportFlowPanel(servers);
            this.setMainPanel(this.m_mainPanel);
            return true;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private class cReportFlowPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private SASAppServer mc_server;
        private List<?> mc_servers;
        private String mc_errormsg;
        private JComboBox mc_comboServers = new JComboBox();
        private JComboBox mc_directories = new JComboBox();
        private JButton mc_newdir = new JButton();
        private JLabel mc_namelabel = new JLabel();
        private JTextField mc_name = new JTextField();
        private JRadioButton mc_xmlReport;
        private JRadioButton mc_sasReport;
        private JRadioButton mc_csvReport;
        private static final int FIELD_WIDTH = 350;
        private static final int FIELD_HEIGHT = 20;

        public cReportFlowPanel(List<?> servers) {
            this.setName(m_bundle.getString("ReportFlowPanel.Title.txt"));
            this.mc_servers = servers;
            this._initialize();
        }

        public void saveSettingsAndCleanUp() {
            super.saveSettingsAndCleanUp();
            this.mc_servers = null;
            this.mc_comboServers = null;
            this.mc_newdir = null;
        }

        public SASAppServer getSelectedServer() {
            this.serverSelectionChanged();
            return this.mc_server;
        }

        public DirectoryInfo getSelectedDirectory() {
            return (DirectoryInfo)this.mc_directories.getSelectedItem();
        }

        public String getName() {
            return this.mc_name.getText();
        }

        public void setName(String name) {
            this.mc_name.setText(name);
            this.mc_namelabel.setVisible(name != null);
            this.mc_name.setVisible(name != null);
        }

        public int getType() {
            if (this.mc_csvReport.isSelected()) {
                return 2;
            }
            if (this.mc_sasReport.isSelected()) {
                return 1;
            }
            return 0;
        }

        public boolean validateData() {
            try {
                DirectoryInfo directory = this.getSelectedDirectory();
                if (directory == null || directory.getPath().length() <= 0) {
                    this.mc_errormsg = m_bundle.getString("ReportFlowPanel.Error.Invalid_DirName.txt");
                    MessageUtil.displayMessage((Frame)ReportFlowDialog.this.m_schmgr.getMainFrame(), (String)this.mc_errormsg, (String)m_bundle.getString("ReportFlowDialog.Title.txt"), (int)0, (int)-1);
                    return false;
                }
                this.mc_errormsg = null;
                return true;
            }
            catch (RuntimeException ex) {
                this.mc_errormsg = ex.getLocalizedMessage();
                if (this.mc_errormsg == null || this.mc_errormsg.length() == 0) {
                    this.mc_errormsg = ex.toString();
                }
                MessageUtil.displayMessage((Frame)ReportFlowDialog.this.m_schmgr.getMainFrame(), (String)this.mc_errormsg, (String)m_bundle.getString("ReportFlowDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
        }

        private void _initialize() {
            for (SASAppServer server : this.mc_servers) {
                this.mc_comboServers.addItem(server);
            }
            this.mc_comboServers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cReportFlowPanel.this.serverSelectionChanged();
                }
            });
            String serverText = m_bundle.getString("ReportFlowPanel.AppServerLabel.txt");
            JLabel serverlabel = new JLabel(Util.getLabelWithoutMnemonic((String)serverText));
            serverlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)serverText));
            serverlabel.setLabelFor(this.mc_comboServers);
            String dirText = m_bundle.getString("ReportFlowPanel.DirectoryLabel.txt");
            JLabel dirlabel = new JLabel(Util.getLabelWithoutMnemonic((String)dirText));
            dirlabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirText));
            dirlabel.setLabelFor(this.mc_directories);
            this.mc_newdir.setText(m_bundle.getString("ReportFlowPanel.NewDir.txt"));
            String nameText = m_bundle.getString("ReportFlowPanel.NameLabel.txt");
            this.mc_namelabel.setText(Util.getLabelWithoutMnemonic((String)nameText));
            this.mc_namelabel.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)nameText));
            this.mc_namelabel.setLabelFor(this.mc_name);
            this.mc_namelabel.setVisible(false);
            this.mc_name.setVisible(false);
            JLabel reportlabel = new JLabel(m_bundle.getString("ReportFlowPanel.ReportLabel.txt"));
            this.mc_xmlReport = new JRadioButton(m_bundle.getString("ReportFlowPanel.XMLReport.Option.txt"), true);
            this.mc_sasReport = new JRadioButton(m_bundle.getString("ReportFlowPanel.SASReport.Option.txt"), false);
            this.mc_csvReport = new JRadioButton(m_bundle.getString("ReportFlowPanel.CSVReport.Option.txt"), false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.mc_xmlReport);
            buttonGroup.add(this.mc_sasReport);
            buttonGroup.add(this.mc_csvReport);
            MaxDimension dim = new MaxDimension(0, 0);
            dim.max(this.mc_newdir.getPreferredSize());
            this.mc_newdir.setPreferredSize((Dimension)dim);
            GridBagConstraints gbc_serversLabel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_servers = new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_directoriesLabel = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_directories = new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 18, 0, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_newdir = new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_nameLabel = new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_name = new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 18, 2, new Insets(7, 0, 0, 5), 0, 0);
            GridBagConstraints gbc_reportlabel = new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(7, 0, 0, 0), 0, 0);
            GridBagConstraints gbc_xmlreport = new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0);
            GridBagConstraints gbc_sasreport = new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0);
            GridBagConstraints gbc_csvreport = new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0);
            Dimension fielddim = new Dimension(350, 20);
            this.mc_comboServers.setPreferredSize(fielddim);
            this.mc_directories.setPreferredSize(fielddim);
            this.mc_directories.setAutoscrolls(true);
            this.mc_directories.setRenderer(new MyCellRenderer());
            this.setLayout(new GridBagLayout());
            this.add(serverlabel, gbc_serversLabel);
            this.add(this.mc_comboServers, gbc_servers);
            this.add(dirlabel, gbc_directoriesLabel);
            this.add(this.mc_directories, gbc_directories);
            this.add(this.mc_newdir, gbc_newdir);
            this.add(this.mc_namelabel, gbc_nameLabel);
            this.add(this.mc_name, gbc_name);
            this.add(reportlabel, gbc_reportlabel);
            this.add(this.mc_xmlReport, gbc_xmlreport);
            this.add(this.mc_sasReport, gbc_sasreport);
            this.add(this.mc_csvReport, gbc_csvreport);
            this.mc_newdir.setVisible(false);
            this.serverSelectionChanged();
        }

        private void serverSelectionChanged() {
            Window parentWindow;
            SASAppServer oSelectedItem = (SASAppServer)this.mc_comboServers.getSelectedItem();
            if (this.mc_server != oSelectedItem) {
                this.mc_server = (SASAppServer)this.mc_comboServers.getSelectedItem();
                this.mc_directories.removeAllItems();
                for (Object obj : this.mc_server.getDirectories()) {
                    if (!(obj instanceof DirectoryInfo)) continue;
                    DirectoryInfo dir = (DirectoryInfo)obj;
                    this.mc_directories.addItem(dir);
                }
            }
            if ((parentWindow = (Window)this.getTopLevelAncestor()) != null) {
                parentWindow.pack();
            }
        }

        private class MyCellRenderer
        extends JLabel
        implements ListCellRenderer {
            private static final long serialVersionUID = 1L;

            public MyCellRenderer() {
                this.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DirectoryInfo dir = (DirectoryInfo)value;
                if (dir != null) {
                    this.setText(dir.getName());
                    Color highlight = new Color(1);
                    this.setForeground(isSelected ? Color.WHITE : highlight);
                    this.setBackground(isSelected ? highlight : Color.WHITE);
                    this.setToolTipText(isSelected ? dir.getPath() : "");
                } else {
                    this.setText("");
                }
                return this;
            }
        }
    }
}

