/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.console.plugins.NodeInterface;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class ReadLogfileDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ReadLogfileDialog.class);
    private ScheduleManager m_schmgr;
    private Object[] m_elementList;
    private NodeInterface m_parentNode;

    public ReadLogfileDialog(ScheduleManager plugin, Object[] elementList, NodeInterface parentNode) {
        super(plugin.getMainFrame(), m_bundle.getString("ReadLogfileDialog.Title.txt"), true);
        this.setCancelButtonVisible(false);
        this.m_schmgr = plugin;
        this.m_elementList = elementList;
        this.m_parentNode = parentNode;
        this.__initialize();
        this.setHelpProduct("scheduler");
        this.setHelpButtonVisible(false);
    }

    public void dispose() {
        super.dispose();
        this.m_schmgr = null;
        this.m_elementList = null;
        this.m_parentNode = null;
    }

    private void __initialize() {
        int numSelected = this.m_elementList.length;
        JScrollPane[] panels = new JScrollPane[numSelected];
        String[] tabs = new String[numSelected];
        int count = 0;
        for (int i = 0; i < numSelected; ++i) {
            String tab;
            if (!(this.m_elementList[i] instanceof ServerJobInfo)) continue;
            ServerJobInfo info = (ServerJobInfo)this.m_elementList[i];
            String logfile = info.getLogFilePath();
            if (logfile == null) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("ReadLogfileDialog.ErrorMsg.NoLogfile.fmt", (Object)info.getName()), (String)m_bundle.getString("ReadLogfileDialog.Title.txt"), (int)0, (int)-1);
                continue;
            }
            int index = logfile.lastIndexOf("/");
            if (index < 0) {
                index = logfile.lastIndexOf("\\");
            }
            if ((index = (tab = logfile.substring(index + 1)).lastIndexOf(".")) > 0) {
                tab = tab.substring(0, index);
            }
            tabs[count++] = tab;
            ServerFlowInfo flow = null;
            JobNode node = this.m_schmgr.getNodeFromInfo(info, this.m_parentNode);
            flow = node instanceof FlowNode ? ((FlowNode)((Object)node)).getFlowInfo() : ((FlowNode)((Object)node.getParent())).getFlowInfo();
            StringBuffer buffer = info.readLogfile(flow, (PromptCallbackInterface)this.m_schmgr);
            panels[i] = buffer != null ? new JScrollPane(new JTextArea(buffer.toString())) : new JScrollPane();
        }
        if (count > 0) {
            ReadlogPanel mainpanel = new ReadlogPanel(panels, tabs);
            this.setMainPanel(mainpanel);
        } else {
            StandardPanel panel = new StandardPanel();
            JLabel text = new JLabel(m_bundle.getString("ReadLogfileDialog.ErrorMsg.NoLogfiles.txt"));
            panel.add((Component)new JScrollPane(text));
            this.setMainPanel(panel);
        }
    }

    private class ReadlogPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;

        public ReadlogPanel(JScrollPane[] panels, String[] tabs) {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.setPreferredSize(new Dimension(550, 300));
            int numPanels = panels.length;
            for (int i = 0; i < numPanels; ++i) {
                if (tabs[i] == null) continue;
                tabbedPane.add(tabs[i], panels[i]);
            }
            this.add(tabbedPane);
        }
    }
}

