/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAIntTextField;
import com.sas.workspace.WAPropertyTab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;

public class OSSchedulerOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(OSSchedulerOptionsTab.class);
    private ScheduleManager m_schmgr;
    private UserOptions m_userOptions;
    private WAIntTextField m_maxHistory;
    private WAIntTextField m_maxHistoryPerFlow;

    public OSSchedulerOptionsTab(ScheduleManager plugin, UserOptions userOptions) {
        this.m_schmgr = plugin;
        this.m_userOptions = userOptions;
        this.setName(m_bundle.getString("OSSchedulerOptionsTab.Name.txt"));
        this.setHelpProduct("scheduler");
        this.setHelpTopic("os_sched_tab");
        this._initialize();
    }

    public void moveDataToView() {
        this.m_maxHistory.setValue(this.m_userOptions.getMaxFlowHistory());
        this.m_maxHistoryPerFlow.setValue(this.m_userOptions.getMaxHistoryForFlow());
    }

    public void moveDataToStore() {
        this.m_userOptions.saveExisting();
    }

    public boolean validateData() {
        try {
            this.m_userOptions.setMaxFlowHistory(this.m_maxHistory.getValue2());
            this.m_userOptions.setMaxHistoryForFlow(this.m_maxHistoryPerFlow.getValue2());
            return true;
        }
        catch (WAIntTextField.IllegalIntegerException iie) {
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)iie.getLocalizedMessage(), (String)m_bundle.getString("OSSchedulerOptionsTab.Name.txt"), (int)0, (int)-1);
            return false;
        }
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    private void _initialize() {
        this.m_maxHistory = new WAIntTextField(false);
        this.m_maxHistory.setToolTipText(m_bundle.getString("OSSchedulerOptionsTab.MaxHistory.ToolTip.txt"));
        String label1Text = m_bundle.getString("OSSchedulerOptionsTab.MaxHistoryLabel.txt");
        JLabel label1 = new JLabel(Util.getLabelWithoutMnemonic((String)label1Text));
        label1.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)label1Text));
        label1.setToolTipText(m_bundle.getString("OSSchedulerOptionsTab.MaxHistory.ToolTip.txt"));
        label1.setLabelFor((Component)this.m_maxHistory);
        this.m_maxHistoryPerFlow = new WAIntTextField(false);
        this.m_maxHistoryPerFlow.setToolTipText(m_bundle.getString("OSSchedulerOptionsTab.MaxHistoryPerFlow.ToolTip.txt"));
        String label2Text = m_bundle.getString("OSSchedulerOptionsTab.MaxHistoryPerFlowLabel.txt");
        JLabel label2 = new JLabel(Util.getLabelWithoutMnemonic((String)label2Text));
        label2.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)label2Text));
        label2.setToolTipText(m_bundle.getString("OSSchedulerOptionsTab.MaxHistoryPerFlow.ToolTip.txt"));
        label2.setLabelFor((Component)this.m_maxHistoryPerFlow);
        this.setLayout(new GridBagLayout());
        this.add(label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_maxHistory, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(label2, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_maxHistoryPerFlow, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0));
    }
}

