/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ListOfJobs;
import com.sas.scheduler.schmgr.NewSchedulingServerAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.NewFlowPanel;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NewFlowDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(NewFlowDialog.class);
    private static Map<String, ListOfJobs> m_cache = Collections.synchronizedMap(new HashMap());
    private ScheduleManager m_schmgr;
    private Frame m_frame;
    private NewFlowPanel m_mainPanel;
    private SASFolder m_folder;
    protected String m_initfolder = null;
    private FlowInfo m_flow = null;

    public NewFlowDialog(ScheduleManager plugin) throws RemoteException {
        super(plugin.getMainFrame(), m_bundle.getString("NewFlowDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.m_frame = plugin.getMainFrame();
        this.__initialize();
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_newflow");
    }

    public void dispose() {
        super.dispose();
        this.m_mainPanel = null;
    }

    public static void clearCache() {
        m_cache.clear();
    }

    private void __initialize() {
        String name;
        String key = String.valueOf(this.m_schmgr.getRootNode().hashCode());
        ListOfJobs jobs = m_cache.get(key);
        if (jobs == null) {
            String str1 = m_bundle.getString("NewFlowDialog.BuildMetadataProgressIndicator.Message.txt");
            String str2 = m_bundle.getString("NewFlowDialog.BuildMetadataProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator(this.m_frame, str1, str2);
            jobs = new ListOfJobs(this.m_schmgr, null);
            request.execute((Runnable)jobs);
            if (!jobs.isError()) {
                m_cache.put(key, jobs);
            }
        }
        if (jobs.isError()) {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)jobs.getErrorMessage(), (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0, (int)-1);
        }
        List<SchedulerServerInfo> list = this.m_schmgr.getSchedulerServers(100);
        ArrayList<SchedulerServerInfo> serverList = new ArrayList<SchedulerServerInfo>();
        serverList.add(new SchedulerServerInfo(m_bundle.getString("NewFlowDialog.SelectOne.txt"), ""));
        for (SchedulerServerInfo sinfo : list) {
            serverList.add(sinfo);
        }
        this.m_mainPanel = new NewFlowPanel(this.m_frame, jobs.getList(), serverList);
        this.m_mainPanel.addNewServerButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSchedulingServerAction nssa = new NewSchedulingServerAction(NewFlowDialog.this.m_schmgr);
                nssa.runWizard();
                SchedulerServerInfo sinfo = nssa.getServerInfo();
                if (sinfo != null) {
                    NewFlowDialog.this.m_mainPanel.addServer(sinfo);
                }
            }
        });
        this.m_mainPanel.addJobPropertyButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block2: {
                    try {
                        NewFlowDialog.this.btnPropertiesOnclicked();
                    }
                    catch (Exception ex) {
                        if (!ScheduleManager.isDebug()) break block2;
                        ex.printStackTrace();
                    }
                }
            }
        });
        ActionListener selectFolderListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SASFolder folder = NewFlowDialog.this.m_schmgr.selectFolders(NewFlowDialog.this.m_initfolder, NewFlowDialog.this.m_folder, m_bundle.getString("NewFlowDialog.BrowseFolder.txt"));
                    if (folder != null) {
                        NewFlowDialog.this.m_folder = folder;
                        NewFlowDialog.this.m_mainPanel.setFolder(NewFlowDialog.this.m_folder.toString());
                    }
                }
                catch (RemoteException ex) {
                    if (ScheduleManager.isDebug()) {
                        ex.printStackTrace();
                    }
                    NewFlowDialog.this.m_folder = null;
                    NewFlowDialog.this.m_mainPanel.setFolder("");
                }
            }
        };
        this.m_mainPanel.addSelectFolderButtonListener(selectFolderListener);
        if (this.m_folder == null && this.setDefaultFolder(name = this.m_schmgr.getLastFlowFolderLocation())) {
            this.m_mainPanel.setFolder(this.m_initfolder);
        }
        this.setMainPanel((StandardPanel)this.m_mainPanel);
    }

    public FlowInfo getNewFlow() {
        return this.m_flow;
    }

    public boolean setDefaultScheduler(String id) {
        if (id != null) {
            return this.m_mainPanel.setServer(id);
        }
        return true;
    }

    public boolean setDefaultFolder(String initfolder) {
        if (initfolder == null) {
            this.m_folder = null;
        } else if (this.m_initfolder == null || this.m_initfolder.compareTo(initfolder) != 0) {
            this.m_initfolder = initfolder;
            this.m_folder = this.m_initfolder.compareTo("My Folder") == 0 ? this.m_schmgr.getMyFolder() : this.m_schmgr.getFolder(this.m_initfolder);
        }
        if (this.m_folder == null) {
            this.m_initfolder = null;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateData() {
        String flowname = this.m_mainPanel.getFlowName();
        SchedulerServerInfo sinfo = this.m_mainPanel.getServer();
        try {
            if (!this.m_mainPanel.validateData()) {
                return false;
            }
            if (sinfo.getName().compareTo(m_bundle.getString("NewFlowDialog.SelectOne.txt")) == 0) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("NewFlowDialog.NoScheduler.Msg.txt"), (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0, (int)-1);
                return false;
            }
            if (!this.m_schmgr.isValidFlowName(flowname, sinfo)) {
                String errorMessage = m_bundle.getString("NewFlowDialog.InvalidChars.Message.txt");
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                return false;
            }
            if (!this.isUniqueName(flowname)) {
                MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.messageString("NewFlowDialog.NonUnique.Message.txt"), (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                return false;
            }
            if (this.m_folder == null) {
                String message = m_bundle.getString("NewFlowDialog.ErrorMsg.NoFolderAssignedToFlow.txt");
                MessageUtil.displayMessage((Frame)this.m_frame, (String)message, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                return false;
            }
        }
        catch (RemoteException ex) {
            return false;
        }
        ArrayList<String> jobsProcessed = new ArrayList<String>();
        Iterator i = this.m_mainPanel.getJobs().iterator();
        while (i.hasNext()) {
            try {
                String errorMessage;
                String invalidchars;
                JobInfo job = (JobInfo)i.next();
                String jobname = job.getName();
                if (jobsProcessed.contains(jobname)) {
                    String errorMessage2 = m_bundle.messageString("NewFlowDialog.DuplicateJobname.Message.fmt", (Object)jobname);
                    MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage2, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                    return false;
                }
                jobsProcessed.add(jobname);
                UserOptions userOptions = new UserOptions();
                if (userOptions.sourceFilenameCheckCharacters()) {
                    if (this.m_schmgr.isJobSourceFile(job)) {
                        if (!this.m_schmgr.isValidJobSourceFile(job)) {
                            invalidchars = this.m_schmgr.getInvalidCharsFile();
                            if (!userOptions.sourceFilenameCheckWarning()) {
                                errorMessage = m_bundle.messageString("NewFlowDialog.SourceFile.InvalidChars.Error.Message.fmt", (Object)jobname, (Object)invalidchars);
                                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                                return false;
                            }
                            errorMessage = m_bundle.messageString("NewFlowDialog.SourceFile.InvalidChars.Warning.Message.fmt", (Object)jobname, (Object)invalidchars);
                            MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)2);
                        }
                    } else if (BatchServerInfo.requiresSourceFile((String)job.getBatchServer().getClassId())) {
                        String errorMessage3 = m_bundle.messageString("NewFlowDialog.SourceFile.Missing.Error.Message.fmt", (Object)jobname);
                        MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage3, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                        return false;
                    }
                }
                if (this.m_schmgr.isValidJobName(job, sinfo)) continue;
                invalidchars = this.m_schmgr.getInvalidCharsJob(sinfo);
                errorMessage = m_bundle.messageString("NewFlowDialog.JobName.InvalidChars.Message.fmt", (Object)jobname, (Object)invalidchars);
                MessageUtil.displayMessage((Frame)this.m_frame, (String)errorMessage, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)2);
            }
            catch (NullPointerException ex) {
                return true;
            }
        }
        return true;
    }

    public boolean isUniqueName(String flowname) throws RemoteException {
        return this.m_schmgr.isUniqueFlow(flowname, "");
    }

    public boolean onOK() throws SchedulerException {
        boolean rc = false;
        if (super.onOK()) {
            String msg = m_bundle.getString("NewFlowDialog.CreateMetadataProgressIndicator.Message.txt");
            ProgressIndicator request = new ProgressIndicator(this.m_frame, msg, m_bundle.getString("NewFlowDialog.Title.txt"));
            request.setDelayBeforeProgressCancelDialog(5);
            cRunnable_CreateFlow doit = new cRunnable_CreateFlow(this.m_mainPanel, this.m_folder);
            request.execute((Runnable)doit);
            rc = doit.getReturncode();
        }
        return rc;
    }

    private void btnPropertiesOnclicked() throws SchedulerException {
        DisplayInfo jinfo = this.m_mainPanel.getSelectedJob();
        ServerJobInfo job = null;
        if (jinfo != null) {
            job = new ServerJobInfo(jinfo, null, this.m_schmgr.getServerUtilities());
            job.generateAllInformation(false);
        }
        if (job != null) {
            this.m_schmgr.showJobProperties(m_bundle.getString("NewFlowDialog.Title.txt"), job, null);
        } else {
            MessageUtil.displayMessage((Frame)this.m_frame, (String)m_bundle.getString("Common.NoJobSelected.txt"), (String)m_bundle.getString("Common.NoJobSelected.Title.txt"), (int)0);
        }
    }

    private class cRunnable_CreateFlow
    implements Runnable {
        private NewFlowPanel mc_panel;
        private SASFolder mc_folder;
        private boolean mc_rc;

        public cRunnable_CreateFlow(NewFlowPanel panel, SASFolder folder) {
            this.mc_panel = panel;
            this.mc_folder = folder;
        }

        public boolean getReturncode() {
            return this.mc_rc;
        }

        @Override
        public void run() {
            try {
                ArrayList<DisplayInfo> list = new ArrayList<DisplayInfo>(this.mc_panel.getJobs());
                NewFlowDialog.this.m_flow = NewFlowDialog.this.m_schmgr.createFlow(this.mc_panel.getFlowName().trim(), this.mc_panel.getServer(), this.mc_folder, list);
                this.mc_rc = true;
            }
            catch (SchedulerException e) {
                String message = e.getMessage();
                if (message == null || message.length() == 0) {
                    message = e.toString();
                }
                MessageUtil.displayMessage((Frame)NewFlowDialog.this.m_frame, (String)message, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                this.mc_rc = false;
            }
            catch (Exception ex) {
                String message;
                if (ScheduleManager.isDebug()) {
                    ex.printStackTrace();
                }
                if ((message = ex.getMessage()) == null || message.length() == 0) {
                    message = ex.toString();
                }
                MessageUtil.displayMessage((Frame)NewFlowDialog.this.m_frame, (String)message, (String)m_bundle.getString("NewFlowDialog.Title.txt"), (int)0);
                this.mc_rc = false;
            }
        }
    }
}

