/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFTimeEvent;
import com.platform.LSFJobFlow.ui.JFTimeEventBean;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.oma.TimeEvent;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.scheduler.visuals.swing.TimeEventInterface;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;

public class LSFTimeEventDialog
extends StandardDialog
implements TimeEventInterface {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(LSFTimeEventDialog.class);
    private StandardPanel m_pnlTimeEvent;
    private JFTimeEventBean m_lsfbean;
    private LSFScheduler m_scheduler;
    private TimeEventInfo m_timeEventInfo = null;
    private ScheduleManager m_schmgr;

    public LSFTimeEventDialog(ScheduleManager plugin, LSFScheduler scheduler) throws SchedulerException {
        this(plugin, "", scheduler, null);
    }

    public LSFTimeEventDialog(ScheduleManager plugin, String title, LSFScheduler scheduler) throws SchedulerException {
        this(plugin, title, scheduler, new TimeEventInfo());
    }

    public LSFTimeEventDialog(ScheduleManager plugin, String title, LSFScheduler scheduler, TimeEventInfo event) throws SchedulerException {
        super(plugin.getMainFrame(), title, true);
        this.m_schmgr = plugin;
        this.setModal(true);
        this.m_scheduler = scheduler;
        this.m_timeEventInfo = event;
        this.initialize();
        super.setMainPanel(this.m_pnlTimeEvent);
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_edittime");
    }

    public TimeEventInterface getInstance(TimeEventInfo event) {
        try {
            return new LSFTimeEventDialog(this.m_schmgr, this.getTitle(), this.m_scheduler, event);
        }
        catch (Exception e) {
            this.setTimeEvent(event);
            return this;
        }
    }

    public void setFrame(Frame frame) {
        this.m_frame = frame;
    }

    public TimeEventInfo getTimeEvent() {
        return this.m_timeEventInfo;
    }

    public void setTimeEvent(TimeEventInfo info) {
        this.m_timeEventInfo = info;
        try {
            JFTimeEvent event;
            if (this.m_timeEventInfo.getRecurrence() != null && (event = this.m_scheduler.createTimeEvent(this.m_timeEventInfo)) != null) {
                this.m_lsfbean.setEvent((JFEvent)event);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dispose() {
        if (this.m_pnlTimeEvent != null) {
            this.m_pnlTimeEvent.saveSettingsAndCleanUp();
        }
        super.dispose();
        this.m_pnlTimeEvent = null;
        this.m_frame = null;
    }

    public boolean validateData() throws SchedulerException {
        try {
            if (!this.m_pnlTimeEvent.validateData()) {
                String message = m_bundle.getString("TimeEventDialog.UnableToValidate.txt");
                SchedulerException ex = new SchedulerException(message);
                throw ex;
            }
            JFTimeEvent event = (JFTimeEvent)this.m_lsfbean.getEvent();
            String conditionString = this.m_scheduler.createConditionString(event.getCalendarName(), event.getUser(), event.getHour(), event.getMinute(), event.getDuration(), event.getOccurrences(), event.getTimeZoneID());
            TimeEvent te = new TimeEvent();
            te.initFromCondition((Scheduler)this.m_scheduler, conditionString);
            if (this.m_timeEventInfo != null) {
                TimeEventInfo temp = te.getInfo();
                this.m_timeEventInfo.setScheduler(temp.getScheduler());
                this.m_timeEventInfo.setRecurrence(temp.getRecurrence());
                this.m_timeEventInfo.setUser(temp.getUser());
                this.m_timeEventInfo.setHours(temp.getHours());
                this.m_timeEventInfo.setMinutes(temp.getMinutes());
                this.m_timeEventInfo.setDuration(temp.getDuration());
                this.m_timeEventInfo.setOccur(temp.getOccur());
                this.m_timeEventInfo.setTimezone(temp.getTimezone());
            } else {
                this.m_timeEventInfo = te.getInfo();
            }
            this.m_timeEventInfo.setDescription(event.getAttribute("Description"));
            return true;
        }
        catch (SchedulerException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            SchedulerException ex = new SchedulerException(m_bundle.getString("TimeEventDialog.UnableToValidate.txt"));
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private void initialize() throws SchedulerException {
        try {
            this.m_pnlTimeEvent = new StandardPanel();
            JFTimeEvent event = null;
            if (this.m_timeEventInfo != null) {
                event = this.m_scheduler.createTimeEvent(this.m_timeEventInfo);
            }
            this.m_lsfbean = new JFTimeEventBean();
            this.m_lsfbean.setEditable(true);
            if (event != null) {
                this.m_lsfbean.setEvent((JFEvent)event);
            }
            this.m_pnlTimeEvent.setLayout((LayoutManager)new GridBagLayout());
            this.m_pnlTimeEvent.add((Component)this.m_lsfbean.getBeanPanel(), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
            SchedulerException ex = new SchedulerException(m_bundle.getString("TimeEventDialog.UnableToInitialize.txt"));
            ex.initCause((Throwable)e);
            throw ex;
        }
    }
}

