/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdEvent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.oma.DeployedJob;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.visuals.WAGeneralPanel;
import com.sas.workspace.visuals.WAGeneralPropertyTab;
import java.awt.Frame;
import java.rmi.RemoteException;

public class JobPropertiesGeneralTab
extends WAGeneralPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(JobPropertiesGeneralTab.class);
    protected WAGeneralPanel mc_generalPanel;
    protected WATextField mc_txtName;
    protected WATextArea mc_description;
    private Root mc_localObject;
    private DeployedJob m_djob;
    private Frame mc_frame;
    public static final String NAMECHANGE_EVENT = "NAME";
    public static final String WRITE_EVENT = "WRITECHANGE";
    public static final String GATHER_FULL_METADATA = "GATHERMETADATA";

    public JobPropertiesGeneralTab(ScheduleManager plugin, ServerJobInfo info) throws RemoteException {
        super((CMetadata)info.getMetadataObject(plugin.getServerUtilities()), null, false, false, true, true);
        String msg;
        this.m_djob = info.getDeployedJob();
        this.mc_frame = plugin.getMainFrame();
        this.setHelpProduct("shared");
        this.setHelpTopic("tab_job_general");
        if (info.hasErrors() && !(msg = info.errorConditions()).isEmpty()) {
            MessageUtil.displayMessage((Frame)plugin.getMainFrame(), (String)msg, (String)m_bundle.getString("SchMgrJobInfo.Title.txt"), (int)0);
        }
        this.mc_localObject = info.getMetadataObject(plugin.getServerUtilities());
        if (this.getComponentCount() > 0 && this.getComponent(0) instanceof WAGeneralPanel) {
            this.mc_generalPanel = (WAGeneralPanel)this.getComponent(0);
            this.mc_generalPanel.setSelectFolderEnabled(true);
            this.mc_txtName = (WATextField)this.mc_generalPanel.getNameComponent();
            this.mc_description = (WATextArea)this.mc_generalPanel.getDescriptionComponent();
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.mc_generalPanel.saveSettingsAndCleanUp();
        this.mc_generalPanel = null;
        this.mc_txtName = null;
        this.mc_description = null;
    }

    public boolean validateData() {
        String jobName = "";
        if (this.mc_txtName != null) {
            jobName = this.mc_txtName.getText();
        }
        if (super.validateData()) {
            if (!DeployedJob.isValidName((String)jobName)) {
                this.displayInvalidJobNameMessage();
                if (this.mc_txtName != null) {
                    this.mc_txtName.grabFocus();
                }
                return false;
            }
            try {
                boolean writechanges = false;
                boolean updateDesc = false;
                if (this.m_djob.getName().compareTo(jobName) != 0) {
                    this.mc_localObject.setName(jobName);
                    this.mc_localObject.fireMdObjectModified(new MdEvent((Object)NAMECHANGE_EVENT));
                    writechanges = true;
                }
                if (this.m_djob.getDescription().compareTo(this.mc_description.getText()) != 0) {
                    String desc = MetaUtilities.replaceString((String)this.mc_description.getText(), (String)"\n", (String)" ");
                    this.m_djob.setDescription(desc);
                    updateDesc = true;
                }
                Tree folder = this.mc_generalPanel.getOwningTree();
                Tree f = this.m_djob.getFolder();
                if (f == null || f.getFQID().compareTo(folder.getFQID()) != 0) {
                    this.m_djob.setFolder(folder);
                    writechanges = true;
                }
                if (writechanges) {
                    this.m_djob.updateChanges();
                    this.mc_localObject.fireMdObjectModified(new MdEvent((Object)WRITE_EVENT));
                } else if (updateDesc) {
                    this.m_djob.updateChanges();
                }
            }
            catch (MdException ex) {
                String errorMessage = m_bundle.messageString("SchMgrJobInfo.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.mc_frame, (String)errorMessage, (String)m_bundle.getString("SchMgrJobInfo.Title.txt"), (int)0);
                return false;
            }
            catch (RemoteException ex) {
                String errorMessage = m_bundle.messageString("SchMgrJobInfo.UnexpectedError.Message.fmt", (Object)ex.getLocalizedMessage());
                MessageUtil.displayMessage((Frame)this.mc_frame, (String)errorMessage, (String)m_bundle.getString("SchMgrJobInfo.Title.txt"), (int)0);
                return false;
            }
            catch (RuntimeException ex) {
                String errorMessage = m_bundle.messageString("SchMgrJobInfo.UnexpectedError.Message.fmt", (Object)ex.toString());
                MessageUtil.displayMessage((Frame)this.mc_frame, (String)errorMessage, (String)m_bundle.getString("SchMgrJobInfo.Title.txt"), (int)0);
                return false;
            }
            return true;
        }
        String errorMessage = m_bundle.messageString("SchMgrJobInfo.ValidationFailure.Message.txt");
        MessageUtil.displayMessage((Frame)this.mc_frame, (String)errorMessage, (String)m_bundle.getString("SchMgrJobInfo.Title.txt"), (int)0);
        return false;
    }

    public void displayInvalidJobNameMessage() {
        String errorMessage = m_bundle.messageString("SchMgrJobInfo.InvalidChars.Message.fmt", (Object)DeployedJob.getInvalidChars());
        MessageUtil.displayMessage((Frame)this.mc_frame, (String)errorMessage, (String)m_bundle.getString("SchMgrJobInfo.Title.txt"), (int)0);
    }
}

