/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.RootNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.workspace.WAPropertyTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.EtchedBorder;

public class GeneralOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(GeneralOptionsTab.class);
    private UserOptions m_userOptions;
    private ScheduleManager m_schmgr;
    private JCheckBox m_prefixLogfile = new JCheckBox(m_bundle.getString("GeneralOptionsTab.PrefixLogfileWithFlowname.txt"));
    private JCheckBox m_outputfile = new JCheckBox(m_bundle.getString("GeneralOptionsTab.Outputfile.txt"));
    private JCheckBox m_autoSubmitFlow = new JCheckBox(m_bundle.getString("GeneralOptionsTab.AutoSubmitChangedFlow.txt"));
    private JCheckBox m_filterAllFlows = new JCheckBox(m_bundle.getString("GeneralOptionsTab.FilterAllFlows.txt"));
    private JCheckBox m_filterAllJobs = new JCheckBox(m_bundle.getString("GeneralOptionsTab.FilterAllJobs.txt"));

    public GeneralOptionsTab(UserOptions userOptions, ScheduleManager schmgr) {
        this.m_userOptions = userOptions;
        this.m_schmgr = schmgr;
        this.setName(m_bundle.getString("GeneralOptionsTab.Name.txt"));
        this.setHelpProduct("scheduler");
        this.setHelpTopic("sched_general_tab");
        this._initialize();
    }

    public void moveDataToView() {
        this.m_autoSubmitFlow.setSelected(this.m_userOptions.isAutoRescheduleFlow());
        this.m_prefixLogfile.setSelected(this.m_userOptions.isLogfilePrefixedWithFlowname());
        this.m_outputfile.setSelected(this.m_userOptions.isOutputfile());
        this.m_filterAllFlows.setSelected(this.m_userOptions.isDefaultFlowsAll());
        this.m_filterAllJobs.setSelected(this.m_userOptions.isDefaultJobsAll());
    }

    public void moveDataToStore() {
        this.m_userOptions.setAutoRescheduleFlow(this.m_autoSubmitFlow.isSelected());
        this.m_userOptions.setLogfilePrefixedWithFlowname(this.m_prefixLogfile.isSelected());
        this.m_userOptions.setOutputfile(this.m_outputfile.isSelected());
        this.m_userOptions.setDefaultFlowsRule(this.m_filterAllFlows.isSelected());
        RootNode rootNode = (RootNode)this.m_schmgr.getRootNode();
        rootNode.setFilter(this.m_schmgr.getDefaultFlowsRule());
        this.m_userOptions.setDefaultJobsRule(this.m_filterAllJobs.isSelected());
        this.m_userOptions.saveExisting();
    }

    public boolean validateData() {
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        return true;
    }

    private void _initialize() {
        this.m_prefixLogfile.setToolTipText(m_bundle.getString("GeneralOptionsTab.PrefixLogfileWithFlowname.ToolTip.txt"));
        this.m_outputfile.setToolTipText(m_bundle.getString("GeneralOptionsTab.Outputfile.ToolTip.txt"));
        this.m_autoSubmitFlow.setToolTipText(m_bundle.getString("GeneralOptionsTab.AutoSubmitChangedFlow.ToolTip.txt"));
        this.m_filterAllFlows.setToolTipText(m_bundle.getString("GeneralOptionsTab.FilterAllFlows.ToolTip.txt"));
        this.m_filterAllJobs.setToolTipText(m_bundle.getString("GeneralOptionsTab.FilterAllJobs.ToolTip.txt"));
        JLabel lblSeperator1 = new JLabel();
        lblSeperator1.setBorder(new EtchedBorder());
        JLabel lblSeperator2 = new JLabel();
        lblSeperator2.setBorder(new EtchedBorder());
        this.setLayout(new GridBagLayout());
        this.add(this.m_prefixLogfile, new GridBagConstraints(0, 0, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_outputfile, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_autoSubmitFlow, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(lblSeperator2, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, -2));
        this.add(this.m_filterAllFlows, new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_filterAllJobs, new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
    }
}

