/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.FlowCompletionPanel;
import com.sas.scheduler.visuals.swing.FlowEmailNotificationPanel;
import com.sas.scheduler.visuals.swing.SchedulerServerPanel;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.workspace.WAPropertyTab;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class FlowPropertiesAttributesTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowPropertiesAttributesTab.class);
    private SchedulerServerPanel m_pnlSchedulerServerPanel;
    private FlowEmailNotificationPanel m_pnlEmailNotificationPanel;
    private StandardPanel m_pnlCheckBoxes;
    private JCheckBox m_chkboxExclusive;
    private JCheckBox m_chkboxSaveLayout;
    private FlowCompletionPanel m_pnlFlowCompletionPanel;
    private ScheduleManager m_schmgr;
    private Frame m_frame;
    private ServerFlowInfo m_info;
    private String m_message = "";
    private ArrayList<SchedulerServerInfo> m_serverList = new ArrayList();
    private WAPropertyTab m_dependentTab = null;

    public FlowPropertiesAttributesTab(ScheduleManager plugin, ServerFlowInfo flow) throws SchedulerException {
        this.m_schmgr = plugin;
        this.m_frame = plugin.getMainFrame();
        this.m_info = flow;
        this.setHelpProduct("shared");
        this.setHelpTopic("attr_tab");
        this.initialize();
        this.layOutWidgets();
        this.setFlowCompleteEnabled();
        this.setEmailNotificationEnabled();
        this.setExclusiveEnabled();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_pnlSchedulerServerPanel.saveSettingsAndCleanUp();
        this.m_pnlSchedulerServerPanel = null;
        this.m_pnlEmailNotificationPanel = null;
        this.m_pnlFlowCompletionPanel = null;
        this.m_pnlCheckBoxes = null;
        this.m_chkboxExclusive = null;
        this.m_chkboxSaveLayout = null;
        this.m_frame = null;
        this.m_info = null;
        this.m_message = null;
        this.m_serverList = null;
    }

    public void initialize() {
        block5: {
            try {
                List list = this.m_info.getListOfSchedulers();
                String t = this.m_info.getServerName();
                SchedulerServerInfo dinfo = null;
                for (SchedulerServerInfo sinfo : list) {
                    this.m_serverList.add(sinfo);
                    if (t == null || !t.equalsIgnoreCase(sinfo.getName())) continue;
                    dinfo = sinfo;
                }
                this.m_pnlSchedulerServerPanel = new SchedulerServerPanel(this.m_serverList, dinfo);
                this.m_pnlSchedulerServerPanel.setEnabled(false);
                FlowInfo info = this.m_info.getInfo();
                this.m_pnlFlowCompletionPanel = new FlowCompletionPanel(this.m_frame, info);
                this.m_pnlCheckBoxes = new StandardPanel();
                this.m_pnlCheckBoxes.setBorder((Border)new EtchedBorder());
                this.m_pnlCheckBoxes.setLayout((LayoutManager)new GridBagLayout());
                this.m_chkboxExclusive = new JCheckBox(m_bundle.getString("FlowPropertiesAttributesTab.Exclusive.txt"));
                this.m_chkboxSaveLayout = new JCheckBox(m_bundle.getString("FlowPropertiesAttributesTab.SaveLayout.txt"));
                this.m_pnlCheckBoxes.add((Component)this.m_chkboxExclusive, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.m_pnlCheckBoxes.add((Component)new JLabel(), (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.m_pnlCheckBoxes.add((Component)this.m_chkboxSaveLayout, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.m_pnlCheckBoxes.add((Component)new JLabel(), (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
                this.m_pnlEmailNotificationPanel = new FlowEmailNotificationPanel(this.m_frame, info);
            }
            catch (RemoteException ex) {
                this.m_message = ex.getLocalizedMessage();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                this.m_message = m_bundle.getString("FlowPropertiesAttributesTab.UnableToReadFlowInformation.txt");
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
                this.m_message = ex.getLocalizedMessage();
                if (this.m_message != null) break block5;
                this.m_message = ex.toString();
            }
        }
    }

    private void layOutWidgets() {
        GridBagConstraints scheduler_gbc = new GridBagConstraints(0, 0, 7, 1, 1.0, 1.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints completion_gbc = new GridBagConstraints(0, 1, 4, 10, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints checkboxes_gbc = new GridBagConstraints(4, 1, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints email_gbc = new GridBagConstraints(4, 2, 3, 9, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlSchedulerServerPanel, scheduler_gbc);
        this.add((Component)this.m_pnlFlowCompletionPanel, completion_gbc);
        this.add((Component)this.m_pnlCheckBoxes, checkboxes_gbc);
        this.add((Component)this.m_pnlEmailNotificationPanel, email_gbc);
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            this.moveDataToStore();
        } else {
            this.populateStore();
            this.moveDataToView();
        }
        return true;
    }

    public void populateStore() {
        if (this.isStorePopulated()) {
            return;
        }
        this.setListeningForChanges(false);
        this.setStorePopulated(true);
        this.setListeningForChanges(true);
    }

    public void moveDataToView() {
        this.setDataChanged(false);
        this.m_pnlFlowCompletionPanel.moveDataToView();
        this.m_pnlEmailNotificationPanel.moveDataToView();
        this.m_chkboxExclusive.setSelected(this.m_info.getInfo().hasExclusive());
        this.m_chkboxSaveLayout.setSelected(this.m_info.getInfo().saveLayout());
        this.setFlowCompleteEnabled();
        this.setEmailNotificationEnabled();
        this.setExclusiveEnabled();
    }

    public void moveDataToStore() {
        this.m_pnlEmailNotificationPanel.moveViewToData();
        FlowInfo info = this.m_pnlEmailNotificationPanel.getInfo();
        this.m_info.setEmailNotification(info);
        this.m_pnlFlowCompletionPanel.moveViewToData();
        FlowInfo info2 = this.m_pnlFlowCompletionPanel.getInfo();
        this.m_info.setCompletionLevel(info2);
        this.m_info.setExclusive(this.m_chkboxExclusive.isSelected());
        this.m_info.setSaveLayout(this.m_chkboxSaveLayout.isSelected());
        this.m_info.commitChangesToOMR();
    }

    public boolean validateData() {
        if (this.m_pnlSchedulerServerPanel.validateData()) {
            SchedulerServerInfo ssi = this.m_pnlSchedulerServerPanel.getSelectedServer();
            if (ssi != null && ssi.isEmailNotificationSupported() && !this.m_pnlEmailNotificationPanel.validateData()) {
                return false;
            }
            return ssi == null || !ssi.isAdvanceFlowCompletionCriteriaSupported() || this.m_pnlFlowCompletionPanel.validateData();
        }
        return false;
    }

    public void onParentCancel() {
        super.onParentCancel();
        if (this.m_bDataChanged) {
            try {
                this.m_info.refresh();
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
            catch (SchedulerException ex) {
                ex.printStackTrace();
            }
            this.setDataChanged(true);
        }
    }

    public void onParentOK() {
        super.onParentOK();
    }

    public void setDependentTab(WAPropertyTab tab) {
        this.m_dependentTab = tab;
    }

    public void setDataChanged(boolean bDataChanged) {
        if (bDataChanged) {
            this.m_schmgr.checkSchedulerConnectionForFlowEvents(this.m_info);
            this.setFlowCompleteEnabled();
            this.setEmailNotificationEnabled();
            this.setExclusiveEnabled();
            if (this.m_dependentTab != null) {
                this.m_dependentTab.setDataChanged(bDataChanged);
            }
        }
        super.setDataChanged(bDataChanged);
    }

    private void setFlowCompleteEnabled() {
        SchedulerServerInfo ssi = this.m_pnlSchedulerServerPanel.getSelectedServer();
        if (ssi != null && ssi.isAdvanceFlowCompletionCriteriaSupported()) {
            this.m_pnlFlowCompletionPanel.setEnabled(true);
        } else {
            this.m_pnlFlowCompletionPanel.setEnabled(false);
        }
    }

    private void setEmailNotificationEnabled() {
        SchedulerServerInfo ssi = this.m_pnlSchedulerServerPanel.getSelectedServer();
        if (ssi != null && ssi.isEmailNotificationSupported()) {
            this.m_pnlEmailNotificationPanel.setEnabled(true);
        } else {
            this.m_pnlEmailNotificationPanel.setEnabled(false);
        }
    }

    private void setExclusiveEnabled() {
        SchedulerServerInfo ssi = this.m_pnlSchedulerServerPanel.getSelectedServer();
        if (ssi != null && ssi.isExclusiveSupported()) {
            this.m_chkboxExclusive.setEnabled(true);
        } else {
            this.m_chkboxExclusive.setEnabled(false);
        }
    }
}

