/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.GeneralUtilities;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Dimension;
import java.awt.Window;
import java.io.StringWriter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class FlowDefinitionPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowDefinitionPanel.class);
    private JTextArea m_definition = new JTextArea();
    private JScrollPane m_pane = null;
    private String m_text = "";

    public FlowDefinitionPanel() {
        this(null);
    }

    public FlowDefinitionPanel(String text) {
        this.m_text = text;
        this.initialize();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
    }

    public boolean setText(String info) {
        if (info != null && !info.isEmpty()) {
            try {
                Document doc = GeneralUtilities.parseXML((String)info);
                DOMSource source = new DOMSource(doc);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.setOutputProperty("method", "xml");
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                xformer.setOutputProperty("omit-xml-declaration", "yes");
                StreamResult result = new StreamResult(new StringWriter());
                xformer.transform(source, result);
                this.m_text = result.getWriter().toString();
            }
            catch (SchedulerException ex) {
                this.m_text = info;
            }
            catch (TransformerConfigurationException e) {
                this.m_text = info;
            }
            catch (TransformerFactoryConfigurationError e) {
                this.m_text = info;
            }
            catch (TransformerException e) {
                this.m_text = info;
            }
        } else {
            this.m_text = "";
        }
        this.m_definition.setText(this.m_text);
        this.resizeWindow();
        return true;
    }

    private void initialize() {
        JPanel topPanel = new JPanel();
        TitledBorder border = new TitledBorder(m_bundle.getString("FlowDefinitionPanel.BorderTitle.txt"));
        topPanel.setBorder(border);
        this.setText(this.m_text);
        this.setDataChanged(false);
        this.m_pane = new JScrollPane(this.m_definition, 20, 30);
        this.m_pane.setPreferredSize(new Dimension(350, 220));
        topPanel.add(this.m_pane);
        topPanel.setPreferredSize(new Dimension(350, 240));
        this.add(topPanel);
    }

    public boolean validateData() {
        return true;
    }

    public boolean moveDataToView() {
        return true;
    }

    public boolean onParentOK() {
        return super.onParentOK();
    }

    public boolean onParentCancel() {
        return super.onParentCancel();
    }

    public void resizeWindow() {
        Window parentWindow = (Window)this.getTopLevelAncestor();
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }
}

