/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.iom.SAS.IWorkspace;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.model.DirectoriesTableModel;
import com.sas.scheduler.visuals.swing.ButtonsLayout;
import com.sas.scheduler.visuals.swing.DirectoryPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.IFileServiceSelectorPanel;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeploymentDirectoriesPanel
extends StandardPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(DeploymentDirectoriesPanel.class);
    private ScheduleManager m_schmgr;
    private StandardDialog m_dlgParent;
    private JComboBox m_cmbAppservers;
    private WsTable m_tblDirectories;
    private DirectoriesTableModel m_mdlDirectories2;
    private JButton m_btnNew;
    private JButton m_btnEdit;
    private JButton m_btnDelete;
    private SASAppServer m_oSelectedAppserver;

    public DeploymentDirectoriesPanel(ScheduleManager plugin, StandardDialog dlgParent) {
        this.m_schmgr = plugin;
        this.m_dlgParent = dlgParent;
        this.initialize();
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_dlgParent = null;
        this.m_cmbAppservers = null;
        this.m_tblDirectories = null;
        this.m_mdlDirectories2 = null;
        this.m_btnNew = null;
        this.m_btnEdit = null;
        this.m_btnDelete = null;
        this.m_oSelectedAppserver = null;
    }

    private void initialize() {
        cNewAction actNew = new cNewAction();
        cEditAction actEdit = new cEditAction();
        cDeleteAction actDelete = new cDeleteAction();
        this.m_btnNew = DeploymentDirectoriesPanel.createTextButton(actNew);
        this.m_btnEdit = DeploymentDirectoriesPanel.createTextButton(actEdit);
        this.m_btnDelete = DeploymentDirectoriesPanel.createTextButton(actDelete);
        StandardPanel pnlButtons = new StandardPanel(new ButtonsLayout(1, 1));
        pnlButtons.add((Component)this.m_btnNew);
        pnlButtons.add((Component)this.m_btnEdit);
        pnlButtons.add((Component)this.m_btnDelete);
        this.enableButtons(false);
        this.m_cmbAppservers = new JComboBox();
        String appText = m_bundle.getString("DeploymentDirectoriesPanel.AppserverLabel.txt");
        JLabel lblAppserver = new JLabel(Util.getLabelWithoutMnemonic((String)appText));
        lblAppserver.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)appText));
        lblAppserver.setLabelFor(this.m_cmbAppservers);
        this.m_mdlDirectories2 = new DirectoriesTableModel(this.m_schmgr);
        this.m_tblDirectories = new WsTable(this.m_mdlDirectories2){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                Object tip = null;
                if (rowIndex >= 0 && colIndex >= 0) {
                    try {
                        tip = this.getValueAt(rowIndex, colIndex);
                    }
                    catch (RuntimeException ex) {
                        tip = ex.getLocalizedMessage();
                    }
                }
                return tip != null ? tip.toString() : "";
            }
        };
        this.m_tblDirectories.setEditable(false);
        this.m_tblDirectories.setRowHeaderVisible(false);
        this.m_tblDirectories.setSelectionMode(0);
        this.m_tblDirectories.setRowSelectionAllowed(true);
        this.m_tblDirectories.setCellSelectionEnabled(false);
        this.m_tblDirectories.setColumnHidingEnabled(false);
        this.m_tblDirectories.setColumnHoldingEnabled(false);
        String dirText = m_bundle.getString("DeploymentDirectoriesPanel.DirectoriesLabel.txt");
        JLabel lblDirectories = new JLabel(Util.getLabelWithoutMnemonic((String)dirText));
        lblDirectories.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)dirText));
        lblDirectories.setLabelFor((Component)this.m_tblDirectories);
        JScrollPane scrDirectories = new JScrollPane((Component)this.m_tblDirectories);
        scrDirectories.setPreferredSize(new Dimension(284, 150));
        lblDirectories.setLabelFor((Component)this.m_tblDirectories);
        this.m_cmbAppservers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DeploymentDirectoriesPanel.this.appserverSelectionChanged();
            }
        });
        this.m_tblDirectories.getRowModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DeploymentDirectoriesPanel.this.m_tblDirectories.getSelectedRowCount() == 0) {
                    DeploymentDirectoriesPanel.this.enableButtons(false);
                } else {
                    DeploymentDirectoriesPanel.this.enableButtons(true);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(lblAppserver, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add(lblDirectories, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_cmbAppservers, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(scrDirectories, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)pnlButtons, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void appserverSelectionChanged() {
        SASAppServer oSelectedItem = (SASAppServer)this.m_cmbAppservers.getSelectedItem();
        if (this.m_oSelectedAppserver != oSelectedItem) {
            this.m_oSelectedAppserver = (SASAppServer)this.m_cmbAppservers.getSelectedItem();
            this.m_mdlDirectories2.setDirectories(this.m_oSelectedAppserver.getDirectories());
            this.m_mdlDirectories2.moveDataToModel();
        }
        if (null == oSelectedItem) {
            this.m_btnNew.setEnabled(false);
        } else {
            this.m_btnNew.setEnabled(true);
        }
    }

    private void enableButtons(boolean bEnable) {
        this.m_btnEdit.setEnabled(bEnable);
        this.m_btnDelete.setEnabled(bEnable);
    }

    public boolean moveViewToData() {
        this.m_mdlDirectories2.moveDataToStore();
        int size = this.m_cmbAppservers.getItemCount();
        for (int i = 0; i < size; ++i) {
            this.m_schmgr.updateAppServerDirectories((SASAppServer)this.m_cmbAppservers.getItemAt(i));
        }
        return true;
    }

    public boolean moveDataToView() {
        try {
            List<SASAppServer> appservers = this.m_schmgr.getAppServersWithDeployedDirectories();
            for (SASAppServer server : appservers) {
                this.m_cmbAppservers.addItem(server);
            }
            this.appserverSelectionChanged();
            if (this.m_mdlDirectories2.getRowCount() > 0) {
                this.m_tblDirectories.selectCell(0, 0);
            }
            return true;
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean validateData() {
        return true;
    }

    private static JButton createTextButton(AbstractAction act) {
        JButton btn = new JButton(act);
        btn.setIcon(null);
        Integer iMnem = (Integer)act.getValue("MnemonicIndex");
        if (iMnem != null && iMnem != -1) {
            btn.setDisplayedMnemonicIndex(iMnem);
        }
        return btn;
    }

    private String launchDirChooser() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Frame frame = this.m_schmgr.getMainFrame();
            IWorkspace iworkspace = null;
            SASAppServer oSelectedItem = (SASAppServer)this.m_cmbAppservers.getSelectedItem();
            try {
                iworkspace = this.m_schmgr.checkConnectionToWorkspaceServer(oSelectedItem);
            }
            catch (SchedulerException e) {
                String message = m_bundle.messageString("DeploymentDirectoriesPanel.ErrorMsg.NoConnectionToWorkspaceServer.fmt", (Object)oSelectedItem.getName());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), (int)0);
                this.setCursor(Cursor.getDefaultCursor());
                return null;
            }
            if (iworkspace == null) {
                String message = m_bundle.messageString("DeploymentDirectoriesPanel.ErrorMsg.NoConnectionToWorkspaceServer.fmt", (Object)oSelectedItem.getName());
                MessageUtil.displayMessage((Frame)frame, (String)message, (String)m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), (int)0);
                this.setCursor(Cursor.getDefaultCursor());
                return null;
            }
            String msg = m_bundle.getString("DeploymentDirectoriesPanel.BuildFileSelectorProgressIndicator.Message.txt");
            String title = m_bundle.getString("DeploymentDirectoriesPanel.BuildFileSelectorProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator(frame, msg, title);
            request.setDelayBeforeProgressCancelDialog(200);
            cRunnable_Dirs selector = new cRunnable_Dirs(iworkspace, null);
            request.execute((Runnable)selector);
            if (request.hasErrors()) {
                MessageUtil.displayMessage((Frame)frame, (String)request.getErrors(), (String)m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), (int)0, (int)-1);
            }
            IFileServiceSelectorPanel pnlSelector = selector.getSelector();
            ArrayList alFileList = (ArrayList)IFileServiceSelectorPanel.showDialog((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.getString("DeploymentDirectoriesPanel.RemoteFileSelectorTitle.txt"), (boolean)true, (int)0, null, (IWorkspace)iworkspace, (boolean)true, (boolean)false, (IFileServiceSelectorPanel)pnlSelector);
            if (alFileList != null && alFileList.size() > 0) {
                this.setCursor(Cursor.getDefaultCursor());
                return (String)alFileList.get(0);
            }
        }
        catch (RemoteException re) {
            String message = re.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("DeploymentDirectoriesPanel.Exception.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), (int)0);
        }
        catch (RuntimeException ae) {
            String message = ae.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("DeploymentDirectoriesPanel.Exception.txt");
            }
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), (int)0);
        }
        this.setCursor(Cursor.getDefaultCursor());
        return null;
    }

    private class cBrowseAction
    implements ActionListener {
        DirectoryPanel mc_panel;

        public cBrowseAction(DirectoryPanel panel) {
            this.mc_panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = DeploymentDirectoriesPanel.this.launchDirChooser();
            if (text != null) {
                this.mc_panel.setDirectoryText(text);
            }
        }
    }

    protected class cRunnable_Dirs
    implements Runnable {
        IWorkspace mc_iworkspace = null;
        String mc_initialpath = null;
        IFileServiceSelectorPanel mc_selector = null;

        cRunnable_Dirs(IWorkspace iworkspace, String initpath) {
            this.mc_iworkspace = iworkspace;
            this.mc_initialpath = initpath;
        }

        public IFileServiceSelectorPanel getSelector() {
            return this.mc_selector;
        }

        @Override
        public void run() {
            try {
                LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
                fileTypes.put(m_bundle.getString("DeploymentDirectoriesPanel.RemoteFileSelectorFileTypeText.txt"), "*");
                this.mc_selector = new IFileServiceSelectorPanel(this.mc_initialpath, this.mc_iworkspace, fileTypes, 2);
                this.mc_selector.setSelectionMode(BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY);
                this.mc_selector.setMultiSelectionEnabled(false);
            }
            catch (RuntimeException ae) {
                DeploymentDirectoriesPanel.this.setCursor(Cursor.getDefaultCursor());
                String message = ae.getLocalizedMessage();
                if (message == null || message.length() == 0) {
                    message = m_bundle.getString("DeploymentDirectoriesPanel.Exception.txt");
                }
                MessageUtil.displayMessage((Frame)DeploymentDirectoriesPanel.this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), (int)0);
            }
        }
    }

    private class cDeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public cDeleteAction() {
            String nameText = m_bundle.getString("DeploymentDirectoriesPanel.Delete.txt");
            this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
            this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
            this.putValue("ShortDescription", m_bundle.getString("DeploymentDirectoriesPanel.Delete.ShortDescription.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int returnValue = JOptionPane.showConfirmDialog((Component)DeploymentDirectoriesPanel.this.m_dlgParent, m_bundle.getString("DeploymentDirectoriesPanel.SelectedDelete.txt"), m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), 2, 2);
            if (returnValue == 2 || returnValue == -1) {
                return;
            }
            int[] aSelectedRows = DeploymentDirectoriesPanel.this.m_tblDirectories.getSelectedRowsFromSelectedCells();
            int iSelectedRow = DeploymentDirectoriesPanel.this.m_tblDirectories.convertRowIndexToModel(aSelectedRows[0]);
            DirectoryInfo directory = (DirectoryInfo)DeploymentDirectoriesPanel.this.m_mdlDirectories2.getValueAt(iSelectedRow, 2);
            if (directory.getId() != null && !DeploymentDirectoriesPanel.this.m_schmgr.okayToDeleteDirectory(directory)) {
                MessageUtil.displayMessage((Frame)DeploymentDirectoriesPanel.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("DeploymentDirectoriesPanel.CannotDelete.txt"), (String)m_bundle.getString("DeploymentDirectoriesPanel.Title.txt"), (int)1);
                return;
            }
            DeploymentDirectoriesPanel.this.m_oSelectedAppserver.deleteDirectory(iSelectedRow);
            DeploymentDirectoriesPanel.this.m_mdlDirectories2.deleteRow(iSelectedRow);
            DeploymentDirectoriesPanel.this.enableButtons(false);
        }
    }

    private class cEditAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public cEditAction() {
            String nameText = m_bundle.getString("DeploymentDirectoriesPanel.Edit.txt");
            this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
            this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
            this.putValue("ShortDescription", m_bundle.getString("DeploymentDirectoriesPanel.Edit.ShortDescription.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DirectoryInfo updatedDirectory;
            int[] aSelectedRows = DeploymentDirectoriesPanel.this.m_tblDirectories.getSelectedRowsFromSelectedCells();
            int iSelectedRow = DeploymentDirectoriesPanel.this.m_tblDirectories.convertRowIndexToModel(aSelectedRows[0]);
            DirectoryInfo directory = (DirectoryInfo)DeploymentDirectoriesPanel.this.m_mdlDirectories2.getValueAt(iSelectedRow, 2);
            StandardDialog dlg = new StandardDialog((Dialog)DeploymentDirectoriesPanel.this.m_dlgParent, m_bundle.getString("DeploymentDirectoriesPanel.EditDirectory.txt"), true);
            DirectoryPanel panel = new DirectoryPanel(directory, DeploymentDirectoriesPanel.this.m_schmgr.getMainFrame());
            panel.addBrowseListener((ActionListener)new cBrowseAction(panel));
            dlg.setMainPanel((StandardPanel)panel);
            dlg.setHelpProduct("scheduler");
            dlg.setHelpTopic("window_editdeploymentdir");
            dlg.makeVisible();
            if (1 == dlg.getReturnValue() && (updatedDirectory = panel.getDirectory()) != null) {
                DeploymentDirectoriesPanel.this.m_mdlDirectories2.setValueAt(updatedDirectory.getName(), iSelectedRow, 0);
                DeploymentDirectoriesPanel.this.m_mdlDirectories2.setValueAt(updatedDirectory.getPath(), iSelectedRow, 1);
                DeploymentDirectoriesPanel.this.m_mdlDirectories2.setValueAt(updatedDirectory, iSelectedRow, 2);
                DeploymentDirectoriesPanel.this.m_mdlDirectories2.fireTableRowsUpdated(iSelectedRow, iSelectedRow);
            }
        }
    }

    private class cNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public cNewAction() {
            String nameText = m_bundle.getString("DeploymentDirectoriesPanel.New.txt");
            this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
            this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
            this.putValue("ShortDescription", m_bundle.getString("DeploymentDirectoriesPanel.New.ShortDescription.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                StandardDialog dlg = new StandardDialog((Dialog)DeploymentDirectoriesPanel.this.m_dlgParent, m_bundle.getString("DeploymentDirectoriesPanel.NewDirectory.txt"), true);
                DirectoryPanel panel = new DirectoryPanel(DeploymentDirectoriesPanel.this.m_schmgr.getDirectories((SASAppServer)DeploymentDirectoriesPanel.this.m_cmbAppservers.getSelectedItem()), DeploymentDirectoriesPanel.this.m_schmgr.getMainFrame());
                panel.addBrowseListener((ActionListener)new cBrowseAction(panel));
                dlg.setMainPanel((StandardPanel)panel);
                dlg.setHelpProduct("scheduler");
                dlg.setHelpTopic("window_newdeploymentdir");
                dlg.makeVisible();
                if (1 == dlg.getReturnValue()) {
                    DeploymentDirectoriesPanel.this.m_mdlDirectories2.getRowCount();
                    DirectoryInfo newDirectory = panel.getDirectory();
                    if (newDirectory != null) {
                        DeploymentDirectoriesPanel.this.m_oSelectedAppserver.addDirectory(newDirectory);
                        DeploymentDirectoriesPanel.this.m_mdlDirectories2.addRow(newDirectory);
                    }
                }
            }
            catch (RemoteException ex) {
                MessageUtil.displayMessage((Frame)DeploymentDirectoriesPanel.this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("DeploymentDirectoriesPanel.Exception.txt"), (int)0);
            }
        }
    }
}

