/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.NodeInterface;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.RootNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class DeleteJobDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(DeleteJobDialog.class);
    private static final int FLOWNAME_DISPLAYLIMIT = 32;
    private ScheduleManager m_schmgr;
    private Object[] m_elementList;
    private NodeInterface m_parentNode;
    private boolean m_isRemoved = false;
    private JScrollPane m_scrollpane;
    private JTree m_tree;
    private JCheckBox m_destroyFromAllBox;
    private JRadioButton m_removeFromAllButton;

    public DeleteJobDialog(ScheduleManager plugin, Object[] elementList, NodeInterface parentNode) {
        super(plugin.getMainFrame(), m_bundle.getString("DeleteJobDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.m_elementList = elementList;
        this.m_parentNode = parentNode;
        this.__initialize();
    }

    public void dispose() {
        super.dispose();
        this.m_schmgr = null;
        this.m_elementList = null;
        this.m_parentNode = null;
        this.m_scrollpane = null;
        this.m_tree = null;
        this.m_destroyFromAllBox = null;
        this.m_removeFromAllButton = null;
    }

    public boolean isRemoved() {
        return this.m_isRemoved;
    }

    private void __initialize() {
        String flowName;
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_delete");
        StandardPanel mainPanel = new StandardPanel();
        JLabel textmsg = new JLabel(m_bundle.getString("DeleteJobDialog.Info.txt"));
        this.m_destroyFromAllBox = new JCheckBox(m_bundle.getString("DeleteJobDialog.DestroyAllOption.txt"), true);
        this.m_destroyFromAllBox.setEnabled(false);
        String string = flowName = this.m_parentNode != null ? this.m_parentNode.getName() : "";
        if (flowName.length() > 32) {
            String truncString = m_bundle.messageString("DeleteJobDialog.Truncation.Indicator.txt");
            flowName = flowName.substring(0, 32 - truncString.length()) + truncString;
        }
        String selectedFlowString = m_bundle.messageString("DeleteJobDialog.RemoveSelectedOption.fmt", (Object)flowName);
        JRadioButton removeFromSelectedButton = new JRadioButton(selectedFlowString, true);
        removeFromSelectedButton.setToolTipText(this.m_parentNode != null ? this.m_parentNode.getName() : "");
        removeFromSelectedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JRadioButton b = (JRadioButton)ae.getSource();
                DeleteJobDialog.this.m_destroyFromAllBox.setEnabled(!b.isSelected());
            }
        });
        this.m_removeFromAllButton = new JRadioButton(m_bundle.getString("DeleteJobDialog.RemoveAllOption.txt"), false);
        this.m_removeFromAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JRadioButton b = (JRadioButton)ae.getSource();
                DeleteJobDialog.this.m_destroyFromAllBox.setEnabled(b.isSelected());
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(removeFromSelectedButton);
        buttonGroup.add(this.m_removeFromAllButton);
        try {
            String str1 = m_bundle.getString("DeleteJobDialog.BuildMetadataProgressIndicator.Message.txt");
            String str2 = m_bundle.getString("DeleteJobDialog.BuildMetadataProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator(this.m_schmgr.getMainFrame(), str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            request.execute((Runnable)new cRunnable());
        }
        catch (RuntimeException ex) {
            String message = ex.toString();
            String lmessage = ex.getLocalizedMessage();
            if (lmessage != null && lmessage.length() > 0) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)lmessage, (String)m_bundle.getString("DeleteJobDialog.ErrorMsg.Title.txt"), (int)0, (int)-1);
            }
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("DeleteJobDialog.ErrorMsg.Title.txt"), (int)0, (int)-1);
        }
        mainPanel.setLayout((LayoutManager)new GridBagLayout());
        mainPanel.add((Component)textmsg, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 10, 5, 0), 0, 0));
        mainPanel.add((Component)this.m_scrollpane, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 5, 0), 0, 0));
        mainPanel.add((Component)removeFromSelectedButton, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0));
        mainPanel.add((Component)this.m_removeFromAllButton, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 10, 0, 0), 0, 0));
        mainPanel.add((Component)this.m_destroyFromAllBox, (Object)new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 25, 0, 0), 0, 0));
        this.setMainPanel(mainPanel);
    }

    protected boolean onOK() throws SchedulerException {
        if (!super.onOK()) {
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (this.m_elementList == null) {
            return true;
        }
        try {
            String str1 = m_bundle.getString("DeleteJobDialog.WriteMetadataProgressIndicator.Message.txt");
            String str2 = m_bundle.getString("DeleteJobDialog.WriteMetadataProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator(this.m_schmgr.getMainFrame(), str1, str2);
            request.setDelayBeforeProgressCancelDialog(200);
            request.execute((Runnable)new cRunnable2());
        }
        catch (RuntimeException ex) {
            String message = ex.toString();
            String lmessage = ex.getLocalizedMessage();
            if (lmessage != null && lmessage.length() > 0) {
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)lmessage, (String)m_bundle.getString("DeleteJobDialog.ErrorMsg.Title.txt"), (int)0, (int)-1);
            }
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("DeleteJobDialog.ErrorMsg.Title.txt"), (int)0, (int)-1);
        }
        this.setCursor(null);
        return true;
    }

    private class cRunnable2
    implements Runnable {
        cRunnable2() {
        }

        @Override
        public void run() {
            boolean deleteFromServer = DeleteJobDialog.this.m_removeFromAllButton.isSelected() && !DeleteJobDialog.this.m_destroyFromAllBox.isSelected();
            boolean removeAll = DeleteJobDialog.this.m_removeFromAllButton.isSelected();
            int jobs = DeleteJobDialog.this.m_elementList.length;
            String id = null;
            for (int index = 0; index < jobs; ++index) {
                FlowNode flowNode;
                Object obj = DeleteJobDialog.this.m_elementList[index];
                JobNode node = null;
                if (obj instanceof ServerJobInfo) {
                    ServerJobInfo job = (ServerJobInfo)obj;
                    id = job.getId();
                    node = DeleteJobDialog.this.m_schmgr.getNodeFromInfo(job, DeleteJobDialog.this.m_parentNode);
                    try {
                        DeleteJobDialog.this.m_isRemoved = this._removeJob(job, removeAll, deleteFromServer);
                    }
                    catch (RemoteException ex) {
                        DeleteJobDialog.this.m_isRemoved = false;
                    }
                } else if (obj instanceof ServerFlowInfo) {
                    ServerFlowInfo subflow = (ServerFlowInfo)obj;
                    id = subflow.getId();
                    node = DeleteJobDialog.this.m_schmgr.getNodeFromInfo(subflow, DeleteJobDialog.this.m_parentNode);
                    try {
                        DeleteJobDialog.this.m_isRemoved = this._removeSubflow(subflow, removeAll, deleteFromServer);
                    }
                    catch (SchedulerException ex) {
                        DeleteJobDialog.this.m_isRemoved = false;
                    }
                    catch (RemoteException ex) {
                        DeleteJobDialog.this.m_isRemoved = false;
                    }
                }
                if (!DeleteJobDialog.this.m_isRemoved) {
                    return;
                }
                if (!removeAll) {
                    if (!(DeleteJobDialog.this.m_parentNode instanceof FlowNode)) continue;
                    flowNode = (FlowNode)DeleteJobDialog.this.m_parentNode;
                    Vector<JobNode> jobNodeList = flowNode.getNodeList();
                    int indexToRemove = jobNodeList.indexOf((Object)node);
                    flowNode.remove(indexToRemove);
                    continue;
                }
                RootNode topNode = (RootNode)DeleteJobDialog.this.m_schmgr.getRootNode();
                Vector<FlowNode> allFlowNodes = topNode.getListofFlows();
                int numFlows = allFlowNodes.size();
                for (int i = 0; i < numFlows; ++i) {
                    flowNode = allFlowNodes.get(i);
                    Vector<JobNode> jobNodeList = flowNode.getNodeList();
                    for (int j = 0; j < (jobNodeList != null ? jobNodeList.size() : 0); ++j) {
                        JobNode jobNode;
                        if (jobNodeList == null || !(jobNode = jobNodeList.get(j)).getID().equalsIgnoreCase(id)) continue;
                        ServerFlowInfo flow = flowNode.getFlowInfo();
                        ServerJobInfo jobinfo = jobNode.getJobInfo();
                        if (jobinfo != null) {
                            flow.removeJob(jobinfo);
                        } else {
                            ServerFlowInfo subflow = jobNode.getFlowInfo();
                            flow.removeJob(subflow);
                        }
                        int indexToRemove = jobNodeList.indexOf((Object)jobNode);
                        flowNode.remove(indexToRemove);
                    }
                }
            }
        }

        private boolean _removeJob(ServerJobInfo job, boolean allflows, boolean permanently) throws RemoteException {
            try {
                ServerFlowInfo flow = null;
                JobNode node = DeleteJobDialog.this.m_schmgr.getNodeFromInfo(job, DeleteJobDialog.this.m_parentNode);
                if (node.getParent() instanceof FlowNode) {
                    flow = ((FlowNode)((Object)node.getParent())).getFlowInfo();
                }
                if (allflows) {
                    job.removeAll();
                    if (permanently) {
                        job.delete();
                        DeleteJobDialog.this.m_schmgr.removeJobFromList(job.m_info.getId());
                    }
                } else if (flow != null) {
                    return job.remove(flow);
                }
            }
            catch (SchedulerException ex) {
                MessageUtil.displayMessage((Frame)DeleteJobDialog.this.m_schmgr.getMainFrame(), (String)m_bundle.getString("DeleteJobDialog.ErrorMsg.Title.txt"), (String)ex.getMessage(), (int)0);
                return false;
            }
            return true;
        }

        private boolean _removeSubflow(ServerFlowInfo subflow, boolean allflows, boolean permanently) throws SchedulerException, RemoteException {
            ServerFlowInfo flow = null;
            AbstractNode node = DeleteJobDialog.this.m_schmgr.getNodeFromInfo(subflow);
            if (node.getParent() instanceof FlowNode) {
                flow = ((FlowNode)((Object)node.getParent())).getFlowInfo();
            }
            if (allflows) {
                subflow.removeThisSubFlowFromAllFlows();
                if (permanently) {
                    subflow.delete();
                    DeleteJobDialog.this.m_schmgr.removeJobFromList(subflow.getId());
                }
            } else if (flow != null) {
                return subflow.remove(flow);
            }
            return true;
        }
    }

    private class cMyRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasfocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasfocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node.getUserObject() instanceof FlowInfo) {
                FlowInfo flow = (FlowInfo)node.getUserObject();
                try {
                    this.setIcon((Icon)IconUtil.getIcon((String)FlowInfo.getIconName((boolean)flow.isFlowSubmitted(), (boolean)flow.hasErrors())));
                }
                catch (RuntimeException ex) {
                    this.setIcon((Icon)IconUtil.getIcon((String)IconUtil.NODE_Flow));
                }
            } else if (node.getUserObject() instanceof ServerJobInfo) {
                ServerJobInfo job = (ServerJobInfo)node.getUserObject();
                this.setIcon(job.getIcon());
            } else if (node.getUserObject() instanceof ServerFlowInfo) {
                ServerFlowInfo subflow = (ServerFlowInfo)node.getUserObject();
                this.setIcon(subflow.getIcon());
            }
            return this;
        }
    }

    private class cRunnable
    implements Runnable {
        cRunnable() {
        }

        @Override
        public void run() {
            int len = DeleteJobDialog.this.m_elementList.length;
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(m_bundle.getString("DeleteJobDialog.TreeTopName.txt"));
            for (int i = 0; i < len; ++i) {
                ServerFlowInfo flow;
                int j;
                int num;
                List flows;
                DefaultMutableTreeNode jobNode;
                Object obj = DeleteJobDialog.this.m_elementList[i];
                if (obj instanceof ServerJobInfo) {
                    ServerJobInfo job = (ServerJobInfo)DeleteJobDialog.this.m_elementList[i];
                    jobNode = null;
                    try {
                        jobNode = new DefaultMutableTreeNode(job);
                        top.add(jobNode);
                        flows = job.getListOfFlows();
                        num = flows.size();
                        for (j = 0; j < num; ++j) {
                            flow = (ServerFlowInfo)flows.get(j);
                            DefaultMutableTreeNode flowNode = new DefaultMutableTreeNode(flow);
                            jobNode.add(flowNode);
                        }
                        continue;
                    }
                    catch (SchedulerException re) {
                        jobNode = new DefaultMutableTreeNode(m_bundle.getString("DeleteJobDialog.AbortMessage.txt"));
                        top.add(jobNode);
                        DefaultMutableTreeNode flowNode = new DefaultMutableTreeNode(re.getMessage());
                        jobNode.add(flowNode);
                        break;
                    }
                }
                if (!(obj instanceof ServerFlowInfo)) continue;
                ServerFlowInfo subflow = (ServerFlowInfo)DeleteJobDialog.this.m_elementList[i];
                jobNode = null;
                try {
                    jobNode = new DefaultMutableTreeNode(subflow);
                    top.add(jobNode);
                    flows = subflow.getListOfFlows();
                    num = flows.size();
                    for (j = 0; j < num; ++j) {
                        flow = null;
                        Object o = flows.get(j);
                        if (o instanceof ServerFlowInfo) {
                            flow = ((ServerFlowInfo)flows.get(j)).getInfo();
                        } else if (o instanceof FlowInfo) {
                            flow = (FlowInfo)flows.get(j);
                        }
                        DefaultMutableTreeNode flowNode = new DefaultMutableTreeNode(flow);
                        jobNode.add(flowNode);
                    }
                    continue;
                }
                catch (SchedulerException re) {
                    jobNode = new DefaultMutableTreeNode(m_bundle.getString("DeleteJobDialog.AbortMessage.txt"));
                    top.add(jobNode);
                    DefaultMutableTreeNode flowNode = new DefaultMutableTreeNode(re.getMessage());
                    jobNode.add(flowNode);
                    break;
                }
            }
            DeleteJobDialog.this.m_tree = new JTree(top, false);
            DeleteJobDialog.this.m_tree.setEditable(false);
            DeleteJobDialog.this.m_tree.setFocusable(false);
            DeleteJobDialog.this.m_tree.setScrollsOnExpand(true);
            DeleteJobDialog.this.m_tree.setCellRenderer(new cMyRenderer());
            DeleteJobDialog.this.m_scrollpane = new JScrollPane(DeleteJobDialog.this.m_tree, 20, 30);
            DeleteJobDialog.this.m_scrollpane.setPreferredSize(new Dimension(300, 150));
        }
    }
}

