/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.ListOfJobs;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.JobSelectionPanel;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.StandardDialog;
import com.sas.scheduler.visuals.swing.StandardPanel;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;

public class AddJobDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(AddJobDialog.class);
    private AddJobPanel m_mainPanel;
    private ServerFlowInfo m_flow;
    private ArrayList<ServerJobInfo> m_addedJobs = new ArrayList();
    private boolean m_success = false;
    private ScheduleManager m_schmgr;

    public AddJobDialog(ScheduleManager plugin, ServerFlowInfo flow, ArrayList<?> jobList) throws RemoteException {
        super(plugin.getMainFrame(), m_bundle.getString("AddJobDialog.Title.txt"), true);
        this.m_schmgr = plugin;
        this.m_flow = flow;
        this.m_mainPanel = new AddJobPanel(jobList);
        this.setMainPanel(this.m_mainPanel);
        this.setHelpProduct("scheduler");
        this.setHelpTopic("window_addjob");
    }

    public void dispose() {
        super.dispose();
        this.m_mainPanel = null;
        this.m_flow = null;
    }

    public List<ServerJobInfo> getAddedJobs() {
        return this.m_addedJobs;
    }

    public boolean isJobAdded() {
        return this.m_success;
    }

    private class cRunnable
    implements Runnable {
        List<?> mc_addedJobs;

        cRunnable(List<?> addedJobs) {
            this.mc_addedJobs = addedJobs;
        }

        @Override
        public void run() {
            try {
                Iterator<?> i = this.mc_addedJobs.iterator();
                while (i.hasNext()) {
                    ServerJobInfo djob = new ServerJobInfo((DisplayInfo)i.next(), AddJobDialog.this.m_flow, AddJobDialog.this.m_schmgr.getServerUtilities());
                    djob.generateAllInformation(false);
                    AddJobDialog.this.m_addedJobs.add(djob);
                    AddJobDialog.this.m_flow.addJob(djob);
                }
                AddJobDialog.this.m_success = AddJobDialog.this.m_flow.commitChangesToOMR();
            }
            catch (InvalidParameterException ipe) {
                MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)ipe.getLocalizedMessage(), (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)0);
                AddJobDialog.this.m_success = false;
            }
            catch (RemoteException ex) {
                MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)0);
                AddJobDialog.this.m_success = false;
            }
            catch (SchedulerException ex) {
                MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)0);
                AddJobDialog.this.m_success = false;
            }
        }
    }

    protected class AddJobPanel
    extends StandardPanel {
        private static final long serialVersionUID = 1L;
        private JobSelectionPanel mc_pnljobSelection;
        private JButton mc_btnProperties;

        public AddJobPanel(ArrayList<?> jobList) throws RemoteException {
            this.__initialize(jobList);
        }

        public void saveSettingsAndCleanUp() {
            this.mc_pnljobSelection = null;
            this.mc_btnProperties = null;
        }

        private void __initialize(ArrayList<?> jobList) throws RemoteException {
            String str1 = m_bundle.getString("AddJobDialog.BuildMetadataProgressIndicator.Message.txt");
            String str2 = m_bundle.getString("AddJobDialog.BuildMetadataProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator(AddJobDialog.this.m_schmgr.getMainFrame(), str1, str2);
            this.setListeningForChanges(false);
            ListOfJobs jobs = new ListOfJobs(AddJobDialog.this.m_schmgr, jobList);
            request.execute((Runnable)jobs);
            if (jobs.isError()) {
                MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)jobs.getErrorMessage(), (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)0, (int)-1);
            }
            this.setListeningForChanges(true);
            this.mc_pnljobSelection = new JobSelectionPanel(AddJobDialog.this.m_schmgr.getMainFrame(), new ArrayList<JobInfo>(jobs.getList()));
            String propertiesText = m_bundle.getString("AddJobDialog.JobProperties.txt");
            this.mc_btnProperties = new JButton(Util.getLabelWithoutMnemonic((String)propertiesText));
            this.mc_btnProperties.setMnemonic(Util.getDisplayedMnemonic((String)propertiesText));
            this.mc_btnProperties.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)propertiesText));
            this.mc_btnProperties.setToolTipText(m_bundle.getString("AddJobDialog.JobProperties.ToolTip.txt"));
            this.mc_btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    block2: {
                        try {
                            AddJobPanel.this.btnPropertiesOnclicked();
                        }
                        catch (Exception ex) {
                            if (!ScheduleManager.isDebug()) break block2;
                            ex.printStackTrace();
                        }
                    }
                }
            });
            this.setLayout(new GridBagLayout());
            this.add((Component)this.mc_pnljobSelection, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this.mc_btnProperties, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        }

        public boolean moveDataToView() {
            this.setListeningForChanges(true);
            return this.mc_pnljobSelection.moveDataToView();
        }

        public boolean moveViewToData() {
            ArrayList addedJobs = new ArrayList(this.mc_pnljobSelection.getSelectedJobList());
            if (addedJobs.size() == 0) {
                return false;
            }
            return this._writeMetadata(addedJobs);
        }

        private boolean _writeMetadata(List<?> addedJobs) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                String str1 = m_bundle.getString("AddJobDialog.WriteMetadataProgressIndicator.Message.txt");
                String str2 = m_bundle.getString("AddJobDialog.WriteMetadataProgressIndicator.Title.txt");
                ProgressIndicator request = new ProgressIndicator(AddJobDialog.this.m_schmgr.getMainFrame(), str1, str2);
                request.setDelayBeforeProgressCancelDialog(200);
                request.execute((Runnable)new cRunnable(addedJobs));
            }
            catch (RuntimeException ex) {
                String message = ex.toString();
                String lmessage = ex.getLocalizedMessage();
                if (lmessage != null && lmessage.length() > 0) {
                    MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)lmessage, (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)0, (int)-1);
                } else {
                    MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)0, (int)-1);
                }
                return false;
            }
            this.setCursor(null);
            return AddJobDialog.this.m_success;
        }

        public boolean validateData() {
            AddJobDialog.this.m_addedJobs.clear();
            if (!this.mc_pnljobSelection.validateData()) {
                return false;
            }
            Iterator i = this.mc_pnljobSelection.getSelectedJobList().iterator();
            while (i.hasNext()) {
                try {
                    ServerJobInfo job = new ServerJobInfo((DisplayInfo)((JobInfo)i.next()), AddJobDialog.this.m_flow, AddJobDialog.this.m_schmgr.getServerUtilities());
                    String jobname = job.getName();
                    UserOptions userOptions = new UserOptions();
                    if (userOptions.sourceFilenameCheckCharacters()) {
                        String filename = job.getSourceFileName();
                        try {
                            job.checkSourcFileName(filename);
                        }
                        catch (InvalidParameterException ex) {
                            if (userOptions.sourceFilenameCheckWarning()) {
                                MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)2);
                            }
                            MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)0);
                            return false;
                        }
                    }
                    try {
                        AddJobDialog.this.m_flow.checkJobname(jobname);
                    }
                    catch (InvalidParameterException ex) {
                        MessageUtil.displayMessage((Frame)AddJobDialog.this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("AddJobDialog.Title.txt"), (int)2);
                    }
                }
                catch (NullPointerException ex) {
                    return true;
                }
            }
            return true;
        }

        private void btnPropertiesOnclicked() throws RemoteException, SchedulerException {
            DisplayInfo jinfo = this.mc_pnljobSelection.getSelectedJob();
            if (jinfo != null) {
                if (jinfo instanceof JobInfo) {
                    ServerJobInfo job = new ServerJobInfo(jinfo, AddJobDialog.this.m_flow, AddJobDialog.this.m_schmgr.getServerUtilities());
                    job.generateAllInformation(false);
                    String title = m_bundle.messageString("AddJobDialog.Properties.Title.fmt", (Object)job.getName());
                    AddJobDialog.this.m_schmgr.showJobProperties(title, job, AddJobDialog.this.m_flow);
                } else if (jinfo instanceof FlowInfo) {
                    ServerFlowInfo subflow = new ServerFlowInfo((FlowInfo)jinfo, AddJobDialog.this.m_schmgr.getServerUtilities(), (PromptCallbackInterface)AddJobDialog.this.m_schmgr);
                    subflow.generateAllInformation(false);
                    String title = m_bundle.messageString("AddJobDialog.Properties.Title.fmt", (Object)subflow.getName());
                    AddJobDialog.this.m_schmgr.showSubflowProperties(title, subflow, AddJobDialog.this.m_flow);
                }
            }
        }
    }
}

