/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr.model;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowHistory;
import com.sas.scheduler.schmgr.model.CompareDateString;
import com.sas.scheduler.schmgr.model.CompareLongString;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDateTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class FlowHistoryTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FlowHistoryTableModel.class);
    private List<FlowHistory> m_alHistories;
    public static final int ID_COL = 0;
    public static final int NAME_COL = 1;
    public static final int START_COL = 2;
    public static final int ERROR_COL = 3;
    public static final int STATE_COL = 4;
    public static final int STATUS_COL = 5;
    public static final int FINISH_COL = 6;
    public static final int INSTANCENAME_COL = 7;
    public static final int SCHFLOWNAME_COL = 8;
    protected static final int W_ID_COL = 60;
    protected static final int W_NAME_COL = 120;
    protected static final int W_START_COL = 120;
    protected static final int W_ERROR_COL = 60;
    protected static final int W_STATE_COL = 60;
    protected static final int W_STATUS_COL = 60;
    protected static final int W_FINISH_COL = 120;
    protected static final int W_INSTANCENAME_COL = 120;
    protected static final int W_SCHFLOWNAME_COL = 120;
    protected static final int TOTAL_COLS = 9;
    protected static final int TOTAL_HIDDEN_COLS = 2;

    public FlowHistoryTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, m_bundle.getString("FlowHistoryTableModel.IdHeader.txt"), 60);
        this.m_aColumns[0].setComparator((Comparator)new CompareLongString(Locale.getDefault()));
        this.m_aColumns[1] = new WsStringTableColumn(1, m_bundle.getString("FlowHistoryTableModel.NameHeader.txt"), 120);
        this.m_aColumns[2] = new WsDateTableColumn(2, m_bundle.getString("FlowHistoryTableModel.StartlHeader.txt"), 120);
        this.m_aColumns[2].setComparator((Comparator)new CompareDateString(Locale.getDefault()));
        this.m_aColumns[3] = new WsIntegerTableColumn(3, m_bundle.getString("FlowHistoryTableModel.ErrorCodeHeader.txt"), 60);
        this.m_aColumns[4] = new WsStringTableColumn(4, m_bundle.getString("FlowHistoryTableModel.StateHeader.txt"), 60);
        this.m_aColumns[5] = new WsIntegerTableColumn(5, m_bundle.getString("FlowHistoryTableModel.StatusHeader.txt"), 60);
        this.m_aColumns[6] = new WsDateTableColumn(6, m_bundle.getString("FlowHistoryTableModel.FinishHeader.txt"), 120);
        this.m_aColumns[6].setComparator((Comparator)new CompareDateString(Locale.getDefault()));
        this.m_aColumns[7] = new WsStringTableColumn(7, m_bundle.getString("FlowHistoryTableModel.InstanceNameHeader.txt"), 120);
        this.m_aColumns[8] = new WsStringTableColumn(8, m_bundle.getString("FlowHistoryTableModel.SchedulerFlowNameHeader.txt"), 120);
    }

    public int getColumnCount() {
        return 9;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }

    public void addRow(FlowHistory info) {
        ArrayList<Object> newRow = new ArrayList<Object>();
        newRow.add(info.getID());
        newRow.add(info.getFlowName());
        if (info.getStart() != null) {
            newRow.add(((GregorianCalendar)info.getStart()).getTime());
        } else {
            newRow.add(null);
        }
        newRow.add(info.getErrorCode());
        newRow.add(this.getState(info.getState()));
        newRow.add(info.getStatus());
        if (info.getFinish() != null) {
            newRow.add(((GregorianCalendar)info.getFinish()).getTime());
        } else {
            newRow.add(null);
        }
        newRow.add(info.getInstanceName());
        newRow.add(info.getSchedulerFlowName());
        this.m_lData.add(newRow);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
        ++this.m_nRowInstances;
    }

    public void deleteRow(int nRow) {
        List lRowData = this.getRowValues(nRow);
        this.m_lData.remove(lRowData);
        this.fireTableRowDeleted(nRow, lRowData);
    }

    public void populateStore() {
    }

    public void moveDataToModel() {
        int oldRowCount = this.m_lData.size();
        this.m_lData.clear();
        if (oldRowCount > 0) {
            this.fireTableRowsDeleted(0, oldRowCount - 1);
        }
        int nRows = 0;
        Iterator<FlowHistory> it = this.m_alHistories.iterator();
        while (it.hasNext()) {
            ArrayList<Object> newRow = new ArrayList<Object>();
            FlowHistory obj = it.next();
            if (!(obj instanceof FlowHistory)) continue;
            FlowHistory info = obj;
            newRow.add(info.getID());
            newRow.add(info.getFlowName());
            if (info.getStart() != null) {
                newRow.add(((GregorianCalendar)info.getStart()).getTime());
            } else {
                newRow.add(null);
            }
            newRow.add(info.getErrorCode());
            newRow.add(this.getState(info.getState()));
            newRow.add(info.getStatus());
            if (info.getFinish() != null) {
                newRow.add(((GregorianCalendar)info.getFinish()).getTime());
            } else {
                newRow.add(null);
            }
            newRow.add(info.getInstanceName());
            newRow.add(info.getSchedulerFlowName());
            this.m_lData.add(newRow);
            ++nRows;
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() {
    }

    public List<?> getHistories() {
        return this.m_alHistories;
    }

    public void setHistories(List<FlowHistory> list) {
        this.m_alHistories = list;
    }

    private String getState(int state) {
        String stateStr = "";
        switch (state) {
            case 0: {
                stateStr = m_bundle.getString("FlowHistoryTableModel.State.Done.txt");
                break;
            }
            case 1: {
                stateStr = m_bundle.getString("FlowHistoryTableModel.State.Exit.txt");
                break;
            }
            case 2: {
                stateStr = m_bundle.getString("FlowHistoryTableModel.State.Killed.txt");
                break;
            }
            case 3: {
                stateStr = m_bundle.getString("FlowHistoryTableModel.State.Running.txt");
                break;
            }
            case 4: {
                stateStr = m_bundle.getString("FlowHistoryTableModel.State.Suspended.txt");
                break;
            }
            case 5: {
                stateStr = m_bundle.getString("FlowHistoryTableModel.State.Waiting.txt");
                break;
            }
            default: {
                stateStr = m_bundle.getString("FlowHistoryTableModel.State.Unknown.txt");
            }
        }
        return stateStr;
    }
}

