/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.SchedulerConsoleDialog;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

public class SchedulerConsoleAction
extends AbstractAction {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(SchedulerConsoleAction.class);
    private static final long serialVersionUID = 1L;
    private Frame m_frame = null;
    private ScheduleManager m_plugin;

    public SchedulerConsoleAction(ScheduleManager plugin, UserContextInterface userContext) {
        this.m_frame = plugin.getMainFrame();
        this.m_plugin = plugin;
        String nameText = m_bundle.getString("SchedulerConsoleAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_SchedulerConsole));
        this.putValue("ShortDescription", m_bundle.getString("SchedulerConsoleAction.ShortDescription.txt"));
    }

    public void dispose() {
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            ArrayList<SchedulerServerInfo> schedulers = new ArrayList<SchedulerServerInfo>();
            List<SchedulerServerInfo> list = this.m_plugin.getSchedulerServers(100);
            if (list != null) {
                for (SchedulerServerInfo ssi : list) {
                    if (!ssi.isConsoleSupported()) continue;
                    schedulers.add(ssi);
                }
            }
            SchedulerConsoleDialog dlg = new SchedulerConsoleDialog(this.m_plugin, schedulers);
            dlg.makeVisible();
            if (dlg.getReturnValue() == 1) {
                // empty if block
            }
            this.m_plugin.saveUserOptions();
        }
        catch (Exception e) {
            if (ScheduleManager.isDebug()) {
                e.printStackTrace();
            }
            MessageUtil.displayMessage((Frame)this.m_frame, (String)e.getLocalizedMessage(), (String)m_bundle.getString("SchedulerConsoleAction.Title.txt"), (int)0, (int)-1);
        }
    }
}

