/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.ConsoleChangeEvent;
import com.sas.console.ConsoleChangeListener;
import com.sas.console.ConsoleInterface;
import com.sas.console.plugins.AbstractNavigationPlugin;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginChangeEvent;
import com.sas.console.plugins.PluginChangeListener;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.utils.WindowUtil;
import com.sas.filter.model.FilterSelector;
import com.sas.iom.SAS.IWorkspace;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.net.crypto.SealedString;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.api.oma.MetaUtilities;
import com.sas.scheduler.api.servers.Scheduler;
import com.sas.scheduler.api.servers.ip.DIPServiceProxy;
import com.sas.scheduler.api.servers.lsf.LSFScheduler;
import com.sas.scheduler.model.BatchServerInfo;
import com.sas.scheduler.model.DeployedJobCodeGenerationInterface;
import com.sas.scheduler.model.DirectoryInfo;
import com.sas.scheduler.model.DisplayInfo;
import com.sas.scheduler.model.FileEventInfo;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobDeployerInterface;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SASAppServer;
import com.sas.scheduler.model.SASFolder;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.model.SchedulerResultSet;
import com.sas.scheduler.model.SchedulerServerInfo;
import com.sas.scheduler.model.TimeEventInfo;
import com.sas.scheduler.schmgr.AboutScheduler;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.JobNode;
import com.sas.scheduler.schmgr.RootNode;
import com.sas.scheduler.schmgr.UserOptions;
import com.sas.scheduler.schmgr.visuals.AdvancePropertiesDialog;
import com.sas.scheduler.schmgr.visuals.LSFTimeEventDialog;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.visuals.swing.DeployedJobDialog;
import com.sas.scheduler.visuals.swing.FileEventDialog;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.LoginDialog;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.scheduler.visuals.swing.RedeployedJobDialog;
import com.sas.scheduler.visuals.swing.TimeEventDialog;
import com.sas.scheduler.visuals.swing.TimeEventInterface;
import com.sas.scheduler.visuals.swing.TriggerEventDialog;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.CallbackCancelledException;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.security.authentication.omr.client.AuthenticationClientHelper;
import com.sas.swing.visuals.remotefileselector2.BaseRemoteFileSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.IFileServiceSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.InformationServicesSelectorPanel;
import com.sas.swing.visuals.remotefileselector2.RemoteFileSelectorDialog;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.mgmt.visuals.Server;
import com.sas.workspace.mgmt.visuals.ServerWizard;
import com.sas.workspace.plugins.AboutInterface;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.rmi.RemoteException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScheduleManager
extends AbstractNavigationPlugin
implements PromptCallbackInterface,
ConsoleChangeListener {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ScheduleManager.class);
    private static ScheduleManager m_this;
    private ConsoleInterface m_sasmc = null;
    private ServerUtilities m_serverUtil = null;
    private UserOptions m_userOptions = null;
    private List<JobInfo> m_fulljfjoblist = null;
    private static Object critsect;
    boolean m_listAvailable;
    private static final Logger LOGGER;
    public static final int OKAY = 0;
    public static final int NOT_REMOVED_FROM_SCHEDULER = 1;
    public static final int NOT_REMOVED_FROM_METADATA = 2;
    public static final String Tzclient = "client";
    public static final String Tzserver = "server";

    public ScheduleManager(ConsoleInterface console) {
        super(console);
        System.setProperty("DIP_RunningInsideScheduleManager", Boolean.toString(true));
        m_this = this;
        try {
            SessionContextInterface sessionContext = this.m_console.getSessionContext();
            if (sessionContext != null) {
                UserContextInterface userContext = sessionContext.getUserContext();
                this.m_serverUtil = new ServerUtilities(sessionContext, userContext);
                this.m_serverUtil.setDefaultSessionContext(sessionContext);
            } else {
                this.m_serverUtil = new ServerUtilities((PromptCallbackInterface)this);
            }
        }
        catch (RemoteException re) {
            this.m_serverUtil = new ServerUtilities((PromptCallbackInterface)this);
        }
        catch (SchedulerException re) {
            this.m_serverUtil = new ServerUtilities((PromptCallbackInterface)this);
        }
        this.m_userOptions = new UserOptions();
        this.m_userOptions.setManager(this);
        this.m_sasmc = console;
        this.setName(m_bundle.getString("ScheduleManager.PluginNode.txt"));
        this.setDescription(m_bundle.getString("ScheduleManager.PluginNodeDescription.txt"));
        this._setCategoryID("Environment");
        this.setIcon(IconUtil.getImageIcon((String)IconUtil.NODE_Schmgr));
        this.setRootNode((NodeInterface)new RootNode((PluginNavigationInterface)this, this.getName()));
        this.m_sasmc.addConsoleListener((ConsoleChangeListener)this);
        this.m_serverUtil.setAllowFlowPrefixForLogfile(this.m_userOptions.isLogfilePrefixedWithFlowname());
        this.m_serverUtil.setOutputfile(this.m_userOptions.isOutputfile());
        if (ScheduleManager.isDebug()) {
            String message = MessageUtil.messageString((String)"{0} ({1})", (Object)m_bundle.getString("AboutScheduler.Name.txt"), (Object)m_bundle.getString("AboutScheduler.Version.txt"));
            System.out.println(message);
        }
    }

    public static String getDefaultFolder() {
        return "/Shared Data";
    }

    public SASFolder getMyFolder() {
        return this.m_serverUtil.getMyFolder();
    }

    public SASFolder getFolder(String defaultDefaultFolder) {
        return this.m_serverUtil.getFolder(defaultDefaultFolder);
    }

    public void secondaryInitialization(boolean reset) {
        String userDefaultFolder;
        String defaultDefaultFolder;
        String repos;
        if (reset && (repos = ScheduleManager.getRepositoryID(this.m_sasmc)) != null) {
            this.m_serverUtil.secondaryInitialization(reset, ScheduleManager.isDebug(), "ScheduleManager", repos);
        }
        if ((defaultDefaultFolder = ScheduleManager.getDefaultFolder()).equals(userDefaultFolder = this.m_userOptions.getLastFlowFolderLocation())) {
            this.m_serverUtil.setDefaultFolder(userDefaultFolder);
        }
        this.m_serverUtil.setDefaultUserContext();
        this.m_serverUtil.setAppServerResource(this.m_userOptions.isAppServerResource());
    }

    public static ScheduleManager getScheduleManager() {
        return m_this;
    }

    public Frame getMainFrame() {
        return Workspace.getWorkspace();
    }

    public static void setStatusText(String message) {
        Workspace.getWorkspace().setStatusText(message);
    }

    public boolean clearChallengeCallbackHandler() {
        return this.m_serverUtil.clearChallengeCallbackHandler();
    }

    public boolean refreshNodeFromInfo(DisplayInfo info) {
        if (info instanceof ServerFlowInfo) {
            ServerFlowInfo finfo = (ServerFlowInfo)info;
            AbstractNode node = this.getNodeFromInfo(finfo);
            return this.refreshNodeFromInfo(node, info);
        }
        if (info instanceof ServerJobInfo) {
            JobNode node = this.getNodeFromInfo((ServerJobInfo)info);
            return this.refreshNodeFromInfo(node, info);
        }
        return false;
    }

    public boolean refreshNodeFromInfo(AbstractNode node, DisplayInfo info) {
        if (info instanceof ServerFlowInfo) {
            ServerFlowInfo finfo = (ServerFlowInfo)info;
            if (node != null) {
                block20: {
                    node.refresh();
                    if (this.isAutoReschedule() && finfo.isFlowSubmitted()) {
                        try {
                            if (!this.interactiveAutoSubmit(finfo)) {
                                MessageUtil.displayMessage((Frame)this.getMainFrame(), (String)m_bundle.messageString("ScheduleManager.ErrorMsg.ReSubmitFlowFailed.msg.fmt", (Object)finfo.getName()), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)2);
                            }
                        }
                        catch (SchedulerException se) {
                            if (!ScheduleManager.isDebug()) break block20;
                            se.printStackTrace();
                        }
                    }
                }
                return true;
            }
        } else if (info instanceof ServerJobInfo) {
            if (node != null) {
                block21: {
                    node.refresh();
                    try {
                        NodeInterface parentNode = (NodeInterface)node.getParent();
                        if (parentNode != null) {
                            ServerFlowInfo parent_info = ((FlowNode)parentNode).getFlowInfo();
                            if (this.isAutoReschedule() && parent_info != null && parent_info.isFlowSubmitted() && !this.interactiveAutoSubmit(parent_info)) {
                                MessageUtil.displayMessage((Frame)this.getMainFrame(), (String)m_bundle.messageString("ScheduleManager.ErrorMsg.ReSubmitFlowFailed.msg.fmt", (Object)parent_info.getName()), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)2);
                            }
                        }
                    }
                    catch (SchedulerException se) {
                        if (!ScheduleManager.isDebug()) break block21;
                        se.printStackTrace();
                    }
                }
                return true;
            }
        } else if (node != null) {
            node.refresh();
            if (info instanceof FlowInfo) {
                block22: {
                    ServerFlowInfo finfo = ((FlowNode)node).getFlowInfo();
                    if (this.isAutoReschedule() && finfo.isFlowSubmitted()) {
                        try {
                            if (!this.interactiveAutoSubmit(finfo)) {
                                MessageUtil.displayMessage((Frame)this.getMainFrame(), (String)m_bundle.messageString("ScheduleManager.ErrorMsg.ReSubmitFlowFailed.msg.fmt", (Object)finfo.getName()), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)2);
                            }
                        }
                        catch (SchedulerException se) {
                            if (!ScheduleManager.isDebug()) break block22;
                            se.printStackTrace();
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public AbstractNode getNodeFromInfo(ServerFlowInfo info) {
        return this.getNodeFromInfo(info, null);
    }

    public AbstractNode getNodeFromInfo(ServerFlowInfo info, NodeInterface parent) {
        if (info.getId() == null) {
            return null;
        }
        RootNode root = (RootNode)this.getRootNode();
        for (int x = 0; x < root.getChildCount(); ++x) {
            if (parent != null && parent != root) {
                AbstractNode subnode;
                FlowNode p = (FlowNode)parent;
                String id = p.getFlowInfo() != null ? p.getFlowInfo().getId() : info.getId();
                AbstractNode node = this.findNode(id, (AbstractNode)root.getChildAt(x), false);
                if (parent != node || (subnode = this.findNode(info.getId(), node)) == null) continue;
                return subnode;
            }
            AbstractNode node = this.findNode(info.getId(), (AbstractNode)root.getChildAt(x), false);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public JobNode getNodeFromInfo(ServerJobInfo info) {
        return this.getNodeFromInfo(info, null);
    }

    public JobNode getNodeFromInfo(ServerJobInfo info, NodeInterface parent) {
        if (info.getId() == null) {
            return null;
        }
        RootNode root = (RootNode)this.getRootNode();
        for (int x = 0; x < root.getChildCount(); ++x) {
            if (parent != null) {
                AbstractNode node;
                AbstractNode flownode = (AbstractNode)root.getChildAt(x);
                if (parent != flownode || !((node = this.findNode(info.getId(), flownode)) instanceof JobNode)) continue;
                return (JobNode)node;
            }
            AbstractNode node = this.findNode(info.getId(), (AbstractNode)root.getChildAt(x));
            if (!(node instanceof JobNode)) continue;
            return (JobNode)node;
        }
        return null;
    }

    private AbstractNode findNode(String jfjobId, AbstractNode node) {
        return this.findNode(jfjobId, node, true);
    }

    private AbstractNode findNode(String jfjobId, AbstractNode node, boolean checkSubNodes) {
        if (node instanceof FlowNode) {
            String id = ((FlowNode)node).getFlowInfo().getId();
            if (jfjobId.compareTo(id) == 0) {
                return node;
            }
            if (checkSubNodes) {
                for (int x = 0; x < node.getChildCount(); ++x) {
                    AbstractNode cnode = this.findNode(jfjobId, (AbstractNode)node.getChildAt(x));
                    if (cnode == null) continue;
                    return cnode;
                }
            }
        } else if (node instanceof JobNode) {
            String id;
            ServerJobInfo d = ((JobNode)node).getJobInfo();
            ServerFlowInfo s = ((JobNode)node).getFlowInfo();
            String string = d != null ? d.getId() : (id = s != null ? s.getId() : "missing");
            if (jfjobId.compareTo(id) == 0) {
                return node;
            }
        }
        return null;
    }

    public List<SASAppServer> getAppServersWithDeployedDirectories() throws RemoteException {
        return this.m_serverUtil.getAppServersWithDeployedDirectories();
    }

    public List<DirectoryInfo> getDirectories(SASAppServer server) {
        return this.m_serverUtil.getDirectories(server);
    }

    public boolean okayToDeleteDirectory(DirectoryInfo dinfo) {
        return this.m_serverUtil.okayToDeleteDirectory(dinfo);
    }

    public boolean isUniqueDirectory(String name) {
        return this.m_serverUtil.isUniqueDirectory(name);
    }

    public String getHelpProduct() {
        return "scheduler";
    }

    public void setServerUtilities(ServerUtilities serverUtil) {
        if (this.m_serverUtil != null && this.m_serverUtil != serverUtil) {
            this.m_serverUtil.dispose();
        }
        this.m_serverUtil = serverUtil;
        this.m_serverUtil.setPromptCallbackInterface((PromptCallbackInterface)this);
    }

    public ServerUtilities getServerUtilities() {
        return this.m_serverUtil;
    }

    public SortedSet<DisplayInfo> getNonAssociatedJobsFromRepository() throws RemoteException, SchedulerException {
        return this.m_serverUtil.getNonAssociatedJobsFromRepository();
    }

    public SortedSet<DisplayInfo> getJobObjectsFromRepository() throws RemoteException, SchedulerException {
        return this.m_serverUtil.getJobObjectsFromRepository();
    }

    public boolean delete(DisplayInfo info) {
        if (info instanceof DirectoryInfo) {
            return this.m_serverUtil.deleteDirectory((DirectoryInfo)info);
        }
        if (info instanceof JobInfo) {
            return false;
        }
        if (info instanceof FlowInfo) {
            return this.m_serverUtil.deleteFlowFromMetadata(new ServerFlowInfo((FlowInfo)info, this.m_serverUtil, (PromptCallbackInterface)this));
        }
        return false;
    }

    public List<JobInfo> getDeployedJobs(List filter, boolean displayOnly) throws SchedulerException {
        return this.m_serverUtil.getDeployedJobs(filter, displayOnly);
    }

    public boolean isValidJobName(JobInfo jinfo, SchedulerServerInfo ssi) {
        return this.m_serverUtil.isValidJobName(jinfo.getName(), ssi);
    }

    public boolean isJobSourceFile(JobInfo jinfo) {
        return this.m_serverUtil.isJobSourceFile(jinfo);
    }

    public boolean isValidJobSourceFile(JobInfo jinfo) {
        return this.m_serverUtil.isValidJobSourceFile(jinfo);
    }

    public String getInvalidCharsJob(SchedulerServerInfo ssi) {
        return this.m_serverUtil.getInvalidCharsJob(ssi);
    }

    public String getInvalidCharsFile() {
        return ServerUtilities.INVALIDFILENAMECHARACTERS;
    }

    public int getMaxJobPriority(SchedulerServerInfo ssi) {
        return this.m_serverUtil.getMaxJobPriorityFromScheduler(ssi);
    }

    public static boolean isDebug() {
        return Workspace.isDebug();
    }

    public WorkspaceFile getWorkspaceFile() {
        return this.m_userOptions;
    }

    public boolean isAllowPasswordCache() {
        return this.m_serverUtil.isAllowPasswordCache();
    }

    public boolean isImportActivated() {
        return this.m_userOptions.isImportActivated();
    }

    public boolean isValidateCmdlineActivated() {
        return this.m_userOptions.isValidateCmdlineActivated();
    }

    public boolean isConsoleActivated() {
        return this.m_userOptions.isConsoleActivated();
    }

    public boolean showWarnings() {
        return this.m_userOptions.showWarnings();
    }

    public boolean errorOnFlowDeletionFailure() {
        return this.m_userOptions.errorOnDeletionFromScheduler();
    }

    public int getMaximumPredecessorsPerJob() {
        return this.m_userOptions.getMaximumPredecessorsPerJob();
    }

    public List<FilterSelector> getFlowFilters() {
        return this.m_userOptions.getFlowFilters();
    }

    public FilterSelector getFlowFilter(String name) {
        return this.m_userOptions.getFlowFilter(name);
    }

    public List<FilterSelector> getJobFilters() {
        return this.m_userOptions.getJobFilters();
    }

    public FilterSelector getJobFilter(String name) {
        return this.m_userOptions.getJobFilter(name);
    }

    public FilterSelector getDefaultFlowsRule() {
        return this.m_userOptions.getDefaultFlowsRule();
    }

    public FilterSelector getDefaultJobsRule() {
        return this.m_userOptions.getDefaultJobsRule();
    }

    public boolean writeFlowFilter(FilterSelector filter) {
        return this.m_userOptions.writeFilter(filter, "RootNode");
    }

    public boolean updateFlowFilter(FilterSelector filter) {
        return this.m_userOptions.updateFilter(filter, "RootNode");
    }

    public boolean writeJobFilter(FilterSelector filter) {
        return this.m_userOptions.writeFilter(filter, "FlowNode");
    }

    public boolean updateJobFilter(FilterSelector filter) {
        return this.m_userOptions.updateFilter(filter, "FlowNode");
    }

    public boolean removeFlowFilter(FilterSelector filter) {
        return this.m_userOptions.removeFilter(filter, "RootNode");
    }

    public boolean removeJobFilter(FilterSelector filter) {
        return this.m_userOptions.removeFilter(filter, "FlowNode");
    }

    public String getLastSchedulingServer() {
        return this.m_userOptions.getLastSchedulingServer();
    }

    public boolean setLastSchedulingServer(String schedulingserver) {
        this.m_userOptions.setLastBatchServer(schedulingserver);
        return true;
    }

    public String getLastBatchServer() {
        return this.m_userOptions.getLastBatchServer();
    }

    public boolean setLastBatchServer(String batchserver) {
        this.m_userOptions.setLastBatchServer(batchserver);
        return true;
    }

    public String getLastDeploymentDirectory() {
        return this.m_userOptions.getLastDeploymentDirectory();
    }

    public boolean setLastDeploymentDirectory(String directory) {
        this.m_userOptions.setLastDeploymentDirectory(directory);
        return true;
    }

    public String getLastSourceDirectory() {
        return this.m_userOptions.getLastSourceDirectory();
    }

    public boolean setLastSourceDirectory(String directory) {
        this.m_userOptions.setLastSourceDirectory(directory);
        return true;
    }

    public String getLastFlowFolderLocation() {
        return this.m_userOptions.getLastFlowFolderLocation();
    }

    public boolean setLastFlowFolderLocation(String folder) {
        this.m_userOptions.setLastFlowFolderLocation(folder);
        return true;
    }

    public String getLastFolderLocation() {
        return this.m_userOptions.getLastFolderLocation();
    }

    public boolean setLastFolderLocation(String folder) {
        this.m_userOptions.setLastFolderLocation(folder);
        return true;
    }

    public boolean setAllowFlowPrefixForLogfile(UserOptions userOptions) {
        return this.m_serverUtil.setAllowFlowPrefixForLogfile(userOptions.isLogfilePrefixedWithFlowname());
    }

    public boolean setOutputfile(UserOptions userOptions) {
        return this.m_serverUtil.setOutputfile(userOptions.isOutputfile());
    }

    public boolean isAppServerResource() {
        return this.m_serverUtil.isAppServerResource();
    }

    public void setAppServerResource(boolean flag) {
        this.m_serverUtil.setAppServerResource(flag);
    }

    public boolean usePortableTimeEvent() {
        return this.m_userOptions.usePortableTimeEvent();
    }

    public void setPortableTimeEvent(boolean flag) {
        this.m_userOptions.setPortableTimeEvent(flag);
    }

    public UserOptions getUserOptions() {
        return this.m_userOptions;
    }

    public boolean saveUserOptions() {
        return this.m_userOptions.saveExisting();
    }

    public int deploy(DeployedJobCodeGenerationInterface codegen) throws RemoteException, SchedulerException {
        Frame frame = this.getMainFrame();
        JobDeployerInterface deployjobutil = this.m_serverUtil.getDeployedJobUtilities((PromptCallbackInterface)this, codegen);
        List batchservers = this.m_serverUtil.getBatchServers(1, 0);
        String folder = this.getLastFolderLocation();
        SASFolder defaultFolder = null;
        if (folder != null) {
            defaultFolder = deployjobutil.getFolder(folder);
        }
        DeployedJobDialog dialog = new DeployedJobDialog(frame, "", DeployedJobDialog.Default_Title, batchservers, deployjobutil, (PromptCallbackInterface)this, false, defaultFolder, null);
        if (this.getLastBatchServer() != null) {
            dialog.setDefaultBatchServer(this.getLastBatchServer());
        }
        if (this.getLastDeploymentDirectory() != null) {
            dialog.setDefaultDirectory(this.getLastDeploymentDirectory());
        }
        if (this.getLastSourceDirectory() != null) {
            dialog.setDefaultSourcePath(this.getLastSourceDirectory());
        }
        dialog.makeVisible();
        int rc = dialog.getReturnValue();
        if (rc == 1) {
            List jobs = dialog.getResults().getSources();
            if (jobs != null && jobs.size() > 0) {
                for (JobInfo job : jobs) {
                    this.addJobToList(job);
                }
            }
            if (dialog.getBatchServer() != null) {
                this.setLastBatchServer(dialog.getBatchServer().getName());
            }
            if (dialog.getDirectoryName() != null) {
                this.setLastDeploymentDirectory(dialog.getDirectoryName());
            }
            if (dialog.getSourcePath() != null) {
                this.setLastSourceDirectory(dialog.getSourcePath());
            }
            if (dialog.getFolder() != null) {
                this.setLastFolderLocation(dialog.getFolder());
            }
            this.saveUserOptions();
        }
        return rc;
    }

    public int redeploy(ServerJobInfo info, DisplayInfo jinfo, DeployedJobCodeGenerationInterface codegen) throws RemoteException, SchedulerException {
        Frame frame = this.getMainFrame();
        JobDeployerInterface deployjobutil = this.m_serverUtil.getDeployedJobUtilities((PromptCallbackInterface)this, codegen);
        List batchservers = this.m_serverUtil.getBatchServers(1, 0);
        RedeployedJobDialog dialog = new RedeployedJobDialog(frame, (JobInfo)jinfo, "", deployjobutil, (PromptCallbackInterface)this, batchservers);
        dialog.makeVisible();
        int rc = dialog.getReturnValue();
        return rc;
    }

    public int redeploy(List<?> djobs, DeployedJobCodeGenerationInterface codegen) throws RemoteException, SchedulerException {
        Frame frame = this.getMainFrame();
        JobDeployerInterface deployjobutil = this.m_serverUtil.getDeployedJobUtilities((PromptCallbackInterface)this, codegen);
        List batchservers = this.m_serverUtil.getBatchServers(1, 0);
        SASFolder defaultFolder = null;
        String folder = this.getLastFolderLocation();
        if (folder != null) {
            defaultFolder = deployjobutil.getFolder(folder);
        }
        RedeployedJobDialog dialog = new RedeployedJobDialog(frame, djobs, deployjobutil, (PromptCallbackInterface)this, batchservers, defaultFolder);
        dialog.makeVisible();
        int rc = dialog.getReturnValue();
        return rc;
    }

    public void clearJobsAndFlows() {
        this.m_fulljfjoblist = null;
    }

    public void clearServerCaches() {
        if (this.m_serverUtil != null) {
            this.m_serverUtil.clearServerCaches();
        }
    }

    public boolean addFlowToList(JobInfo subflow) {
        if (this.m_fulljfjoblist != null && !this.m_fulljfjoblist.contains(subflow)) {
            return this.m_fulljfjoblist.add(subflow);
        }
        return false;
    }

    public boolean addJobToList(JobInfo job) {
        if (this.m_fulljfjoblist != null && !this.m_fulljfjoblist.contains(job)) {
            return this.m_fulljfjoblist.add(job);
        }
        return false;
    }

    public boolean removeJobFromList(String id) {
        if (this.m_fulljfjoblist != null) {
            for (JobInfo info : this.m_fulljfjoblist) {
                if (info.getId().compareTo(id) != 0) continue;
                return this.m_fulljfjoblist.remove(info);
            }
        }
        return false;
    }

    public FlowInfo getFlowByName(String name) throws SchedulerException {
        for (JobInfo jinfo : this.m_fulljfjoblist) {
            if (!jinfo.isSubflow() || !jinfo.getName().equals(name)) continue;
            return this.m_serverUtil.getFlowInfoFromId(jinfo.getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobInfo> getAllJobsAndFlows() throws RemoteException, Exception {
        Object object = critsect;
        synchronized (object) {
            if (this.m_fulljfjoblist == null) {
                String fast = System.getProperty("schedulemgr.flowlist.fast");
                this.m_fulljfjoblist = fast == null ? this.m_serverUtil.getAllJobsAndFlowsByRoles(true) : this.m_serverUtil.getAllJobsAndFlows(true);
            }
        }
        return this.m_fulljfjoblist;
    }

    public FlowInfo createFlow(String flowname, SchedulerServerInfo scheduler, SASFolder folder, List<DisplayInfo> listofJobs) throws SchedulerException {
        return this.m_serverUtil.createFlow(flowname, scheduler, folder, listofJobs);
    }

    public boolean commitFlowToOMR(FlowInfo flow) throws SchedulerException, RemoteException {
        return this.m_serverUtil.commitFlowToOMR(flow);
    }

    public List<ServerFlowInfo> getFlows(FilterSelector select, List<?> itemsList) {
        return this.m_serverUtil.getFlows(select, itemsList);
    }

    public int deleteScheduledFlow(ServerFlowInfo flow) {
        int rc = this.m_serverUtil.deleteScheduledFlow(flow);
        return rc;
    }

    public int deleteUnscheduledFlow(ServerFlowInfo flow) {
        int rc = this.m_serverUtil.deleteUnscheduledFlow(flow);
        return rc;
    }

    public boolean deleteFlowFromMetadata(ServerFlowInfo flow) {
        return this.m_serverUtil.deleteFlowFromMetadata(flow);
    }

    public boolean fixUnableToDelete(ServerFlowInfo flow) {
        return this.m_serverUtil.fixUnableToDelete(flow);
    }

    public List<JobInfo> getAvailableJobsSubflowsByLocation(String folder, List<DisplayInfo> inFlow) {
        List avail = this.m_serverUtil.getAvailableJobsSubflowsByLocation(folder, inFlow);
        return avail;
    }

    public List<List<DisplayInfo>> getJobAndSubflowLists(String flowid, List<DisplayInfo> flowjoblist, boolean readFromServer) {
        ArrayList<List<DisplayInfo>> list = new ArrayList<List<DisplayInfo>>();
        ArrayList<JobInfo> joblist = new ArrayList<JobInfo>();
        ArrayList<JobInfo> flowlist = new ArrayList<JobInfo>();
        try {
            if (readFromServer) {
                this.clearJobsAndFlows();
            }
            String msg = m_bundle.getString("Common.BuildMetadataProgressIndicator.Message.txt");
            String title = m_bundle.getString("Common.BuildMetadataProgressIndicator.Title.txt");
            ProgressIndicator request = new ProgressIndicator((Frame)Workspace.getWorkspace(), msg, title);
            request.setDelayBeforeProgressCancelDialog(200);
            cRunnable_getJFJobs getJFJobs = new cRunnable_getJFJobs(true);
            request.execute((Runnable)getJFJobs);
            List<JobInfo> fulljfjoblist = getJFJobs.getList();
            if (this.m_fulljfjoblist == null && getJFJobs.getException() != null) {
                throw getJFJobs.getException();
            }
            int listsize = fulljfjoblist.size();
            for (int i = 0; i < listsize; ++i) {
                JobInfo job = fulljfjoblist.get(i);
                if (job.isSubflow()) {
                    if (flowjoblist != null) {
                        if (flowjoblist.contains(job.getName()) || job.getId().compareTo(flowid) == 0) continue;
                        flowlist.add(job);
                        continue;
                    }
                    if (job.getId().compareTo(flowid) == 0) continue;
                    flowlist.add(job);
                    continue;
                }
                if (flowjoblist != null) {
                    if (flowjoblist.contains(job.getName())) continue;
                    joblist.add(job);
                    continue;
                }
                joblist.add(job);
            }
        }
        catch (RemoteException re) {
            joblist = null;
        }
        catch (Exception mde) {
            joblist = null;
        }
        list.add(joblist);
        list.add(flowlist);
        return list;
    }

    public boolean isValidFlowName(String name, SchedulerServerInfo ssi) {
        return this.m_serverUtil.isValidFlowName(name, ssi);
    }

    public boolean isUniqueFlow(String name, String id) {
        return this.m_serverUtil.isUniqueFlow(name, id);
    }

    public void checkCircularDependencies(FlowInfo flow, String subflow) throws InvalidParameterException, SchedulerException {
        this.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.m_serverUtil.checkCircularDependencies(flow, subflow);
        }
        catch (InvalidParameterException ex) {
            throw ex;
        }
        catch (Exception ex) {
            SchedulerException se = new SchedulerException(ex.getLocalizedMessage());
            se.initCause((Throwable)ex);
            throw se;
        }
        this.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
    }

    public BatchServerInfo newBatchServer(String title) {
        BatchServerInfo sinfo = null;
        try {
            String[] listofServerTypes = new String[4];
            listofServerTypes[0] = "e20e54b3-e5f4-47ed-b21d-03109bf9a4b8";
            listofServerTypes[1] = "0069e914-b58c-4094-a686-a87df433ec4b";
            listofServerTypes[3] = "d6644527-7a09-4fe2-8bac-1caca2f6a46c";
            listofServerTypes[2] = "a1ff485f-9e44-4c82-90b5-062916cfa9b9";
            ServerWizard wizard = new ServerWizard((JFrame)Workspace.getWorkspace(), this.m_serverUtil.getDefaultMdRepository(), title, listofServerTypes);
            wizard.show();
            Server server = (Server)wizard.getWizardData("Server");
            if (wizard.getReturnValue() == 1 || wizard.getReturnValue() == 3) {
                ServerComponent sc = (ServerComponent)server.getDeployedComponent();
                if (sc instanceof ServerContext) {
                    sc = (LogicalServer)sc.getUsingComponents().get(0);
                }
                if (sc instanceof LogicalServer) {
                    sc = (ServerComponent)sc.getUsingComponents().get(0);
                }
                if (sc != null) {
                    sinfo = new BatchServerInfo(sc.getName(), sc.getClassIdentifier());
                    MetaUtilities.setBatchServerProperties((BatchServerInfo)sinfo, (ServerComponent)sc);
                } else {
                    sinfo = null;
                }
            } else {
                sinfo = null;
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sinfo;
    }

    public SchedulerServerInfo newSchedulerServer(String title) {
        SchedulerServerInfo sinfo = null;
        try {
            String[] listofServerTypes = new String[]{"a1661499-5d7d-4fcc-8fc3-c6509853e116", "8b4dc45a-f7c7-11e7-8c3f-9a214cf093ae", "b379c9c1-89e0-4e72-ba43-6a416899b5dd", "c8b4baf0-5f9f-488e-ba76-1201e1e81aef", "ff3aab60-8926-4e88-8af3-4287787d7d7", "c8b4baf0-5f9f-471e-ba76-1201e1e81aef"};
            ServerWizard wizard = new ServerWizard((JFrame)Workspace.getWorkspace(), this.m_serverUtil.getDefaultMdRepository(), title, listofServerTypes);
            wizard.show();
            Server server = (Server)wizard.getWizardData("Server");
            if (wizard.getReturnValue() == 1 || wizard.getReturnValue() == 3) {
                ServerComponent sc = (ServerComponent)server.getDeployedComponent();
                if (sc instanceof LogicalServer) {
                    sc = (ServerComponent)sc.getUsingComponents().get(0);
                }
                if (sc != null) {
                    sinfo = new SchedulerServerInfo(sc.getName(), sc.getClassIdentifier());
                    sinfo.setId(sc.getFQID());
                } else {
                    sinfo = null;
                }
            } else {
                sinfo = null;
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return sinfo;
    }

    public IWorkspace checkConnectionToWorkspaceServer(BatchServerInfo batchserver) throws RemoteException, InvalidParameterException, SchedulerException {
        try {
            return this.m_serverUtil.checkConnectionToWorkspaceServer(batchserver, (PromptCallbackInterface)this);
        }
        catch (CallbackCancelledException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IWorkspace checkConnectionToWorkspaceServer(SASAppServer appserver) throws RemoteException, InvalidParameterException, SchedulerException {
        try {
            return this.m_serverUtil.checkConnectionToWorkspaceServer(appserver, (PromptCallbackInterface)this);
        }
        catch (CallbackCancelledException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean checkSchedulerConnectionForProperties(ServerFlowInfo info) {
        SchedulerServerInfo sinfo = info.getInfo().getScheduler();
        if (sinfo == null) {
            return false;
        }
        try {
            if (this.m_serverUtil.isConnectionNeededForAdvanceProperties(sinfo)) {
                this.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                boolean rc = this.connectToSchedulingServer(info);
                this.getMainFrame().setCursor(Cursor.getPredefinedCursor(0));
                return rc;
            }
            return true;
        }
        catch (SchedulerException ex) {
            return false;
        }
    }

    public boolean checkSchedulerConnectionForFlowEvents(ServerFlowInfo info) {
        SchedulerServerInfo sinfo = info.getInfo().getScheduler();
        if (sinfo == null) {
            return false;
        }
        try {
            if (this.m_serverUtil.isConnectionNeededForTimeEvents(sinfo)) {
                return this.connectToSchedulingServer(info);
            }
            return true;
        }
        catch (SchedulerException ex) {
            return false;
        }
    }

    public boolean connectToSchedulingServer(ServerFlowInfo info) {
        UserOptions userOptions = new UserOptions();
        this.m_userOptions.setManager(this);
        String timeZone = userOptions.getTimezoneOrientation();
        String stdout = userOptions.getDefaultStandardOutfile();
        String stderr = userOptions.getDefaultStandardErrfile();
        boolean scoping = userOptions.useFlowScoping();
        String flowDefDir = userOptions.getFlowDefinitionDirectory();
        int statusCheckTimeout = userOptions.getStatusCheckTimeout();
        int statusCheckCycle = userOptions.getStatusCheckCycle();
        int maxHistory = userOptions.getMaxFlowHistory();
        int maxHistoryPerFlow = userOptions.getMaxHistoryForFlow();
        return this.m_serverUtil.connectToSchedulingServer(info, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
    }

    public boolean interactiveSubmit(ServerFlowInfo info) throws SchedulerException {
        return this.interactiveSubmit(info, false);
    }

    public boolean interactiveSubmit(ServerFlowInfo info, boolean modified) throws SchedulerException {
        SchedulerServerInfo scheduler = info.getInfo().getScheduler();
        if (scheduler == null) {
            return false;
        }
        Frame frame = this.getMainFrame();
        if (modified && !info.isFlowSubmitted()) {
            return true;
        }
        if (info.getJobCount() <= 0) {
            this.showResults(m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), new SchedulerResultSet(0, m_bundle.getString("ScheduleManager.ErrorMsg.EmptyFlowErrorMessage.txt"), (DisplayInfo)info));
            return false;
        }
        UserOptions userOptions = new UserOptions();
        this.m_userOptions.setManager(this);
        String timeZone = userOptions.getTimezoneOrientation();
        String stdout = userOptions.getDefaultStandardOutfile();
        String stderr = userOptions.getDefaultStandardErrfile();
        boolean scoping = userOptions.useFlowScoping();
        String flowDefDir = userOptions.getFlowDefinitionDirectory();
        int statusCheckTimeout = userOptions.getStatusCheckTimeout();
        int statusCheckCycle = userOptions.getStatusCheckCycle();
        int maxHistory = userOptions.getMaxFlowHistory();
        int maxHistoryPerFlow = userOptions.getMaxHistoryForFlow();
        this.m_serverUtil.resetSchedulerDefaults(info, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
        boolean connected = this.m_serverUtil.connectToSchedulingServer(info, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
        if (!connected) {
            MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.ErrorMsg.UnableToConnectToScheduler.msg.fmt", (Object)scheduler.getName()), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)0);
            return false;
        }
        FlowInfo finfo = info.getInfo();
        TriggerEventDialog dlg = new TriggerEventDialog(frame, finfo, m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (PromptCallbackInterface)this);
        TimeEventInterface timeDlg = this.getTimeEventDialog("", new TimeEventInfo(), finfo.getScheduler());
        if (timeDlg != null) {
            dlg.setTimeEventDialog(timeDlg);
        }
        dlg.makeVisible();
        if (2 == dlg.getReturnValue()) {
            return true;
        }
        String flowname = info.getName();
        String message = null;
        String msg = m_bundle.messageString("ScheduleManager.SubmitProgressIndicator.Message.fmt", (Object)info.getName());
        ProgressIndicator request = new ProgressIndicator(this.getMainFrame(), msg, m_bundle.getString("ScheduleManager.PluginNode.txt"));
        request.setDelayBeforeProgressCancelDialog(200);
        cRunnable_batchSubmit binit = new cRunnable_batchSubmit(info, userOptions.errorOnDeletionFromScheduler());
        request.execute((Runnable)binit);
        boolean changesWritten = binit.triggerChanges();
        SchedulerResultSet rc = binit.getResults();
        int value = rc != null ? rc.getReturnValue() : -1;
        switch (value) {
            case 1: {
                if (!changesWritten) {
                    message = m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Write.msg.fmt", (Object)flowname);
                    MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Confirmation.Warning.msg.fmt", (Object)flowname, (Object)scheduler.getName(), (Object)message), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)2);
                    break;
                }
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Confirmation.msg.fmt", (Object)flowname, (Object)scheduler.getName()), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)1);
                break;
            }
            case 2: {
                message = !changesWritten ? rc.getMessage() + "\n" + m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Write.msg.fmt", (Object)flowname) : rc.getMessage();
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Confirmation.Warning.msg.fmt", (Object)flowname, (Object)scheduler.getName(), (Object)message), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)2);
                break;
            }
            case 0: {
                message = !changesWritten ? rc.getMessage() + "\n" + m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Write.msg.fmt", (Object)flowname) : rc.getMessage();
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Parms.msg.fmt", (Object)flowname, (Object)message), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)0);
                break;
            }
            default: {
                String text = "UNKNOWN ERROR";
                if (!changesWritten) {
                    message = text + "\n" + m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Write.msg.fmt", (Object)flowname);
                    if (ScheduleManager.isDebug()) {
                        System.err.println(message);
                        System.err.println(changesWritten);
                    }
                } else {
                    if (ScheduleManager.isDebug()) {
                        System.err.println("INTERNAL ERROR: Changes written, but results is null.");
                    }
                    message = text;
                }
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Parms.msg.fmt", (Object)flowname, (Object)message), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)0);
            }
        }
        return true;
    }

    public boolean interactiveAutoSubmit(ServerFlowInfo info) throws SchedulerException {
        SchedulerServerInfo scheduler = info.getInfo().getScheduler();
        if (scheduler == null) {
            return false;
        }
        boolean submitted = info.isFlowSubmitted();
        boolean empty = info.getJobCount() <= 0;
        Frame frame = this.getMainFrame();
        if (!submitted) {
            return true;
        }
        if (empty) {
            this.showResults(m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), new SchedulerResultSet(0, m_bundle.getString("ScheduleManager.ErrorMsg.EmptyFlowErrorMessage.txt"), (DisplayInfo)info));
            return false;
        }
        UserOptions userOptions = new UserOptions();
        this.m_userOptions.setManager(this);
        String timeZone = userOptions.getTimezoneOrientation();
        String stdout = userOptions.getDefaultStandardOutfile();
        String stderr = userOptions.getDefaultStandardErrfile();
        boolean scoping = userOptions.useFlowScoping();
        String flowDefDir = userOptions.getFlowDefinitionDirectory();
        int statusCheckTimeout = userOptions.getStatusCheckTimeout();
        int statusCheckCycle = userOptions.getStatusCheckCycle();
        int maxHistory = userOptions.getMaxFlowHistory();
        int maxHistoryPerFlow = userOptions.getMaxHistoryForFlow();
        this.m_serverUtil.resetSchedulerDefaults(info, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
        boolean connected = this.m_serverUtil.connectToSchedulingServer(info, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
        if (!connected) {
            MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.ErrorMsg.UnableToConnectToScheduler.msg.fmt", (Object)scheduler.getName()), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)0);
            return false;
        }
        String flowname = info.getName();
        String message = null;
        boolean changesWritten = info.commitChangesToOMR();
        SchedulerResultSet rc = this.m_serverUtil.submitFlow(info, true, userOptions.errorOnDeletionFromScheduler());
        int value = rc != null ? rc.getReturnValue() : 0;
        String text = rc != null ? rc.getMessage() : "UNKNOWN ERROR";
        switch (value) {
            case 1: {
                if (!changesWritten) {
                    message = m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Write.msg.fmt", (Object)flowname);
                    MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Confirmation.Warning.msg.fmt", (Object)flowname, (Object)scheduler.getName(), (Object)message), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)2);
                    break;
                }
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Confirmation.msg.fmt", (Object)flowname, (Object)scheduler.getName()), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)1);
                break;
            }
            case 2: {
                message = !changesWritten ? text + "\n" + m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Write.msg.fmt", (Object)flowname) : text;
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Confirmation.Warning.msg.fmt", (Object)flowname, (Object)scheduler.getName(), (Object)message), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)2);
                break;
            }
            case 0: {
                message = !changesWritten ? text + "\n" + m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Write.msg.fmt", (Object)flowname) : text;
                MessageUtil.displayMessage((Frame)frame, (String)m_bundle.messageString("ScheduleManager.SubmitFlow.Failure.Parms.msg.fmt", (Object)flowname, (Object)message), (String)m_bundle.getString("ScheduleManager.SubmitFlow.Schedule.Title.txt"), (int)0);
            }
        }
        return true;
    }

    public List<FlowInfo> getSubmittedFlows(String message, String title, List<FlowInfo> notscheduled) throws RemoteException, SchedulerException {
        return this.m_serverUtil.getSubmittedFlows(message, title, notscheduled);
    }

    public SchedulerResultSet batchResubmit(FlowInfo info) throws SchedulerException {
        String msg = m_bundle.messageString("ScheduleManager.ResubmitProgressIndicator.Message.fmt", (Object)info.getName());
        ProgressIndicator request = new ProgressIndicator(this.getMainFrame(), msg, m_bundle.getString("ScheduleManager.PluginNode.txt"));
        request.setDelayBeforeProgressCancelDialog(200);
        cRunnable_batchResubmit binit = new cRunnable_batchResubmit(info, this, this.errorOnFlowDeletionFailure());
        request.execute((Runnable)binit);
        return binit.getResults();
    }

    public boolean isValidFilename(String filename) {
        return this.m_serverUtil.isValidFilename(filename);
    }

    public String getJCLFile(ServerJobInfo job) {
        return job.getJCLFile();
    }

    public boolean writeJCL(IWorkspace iworkspace, String jclfile, String text) {
        return this.m_serverUtil.writeJCL(iworkspace, jclfile, text);
    }

    public String readJCL(IWorkspace iworkspace, String jclfile) {
        return this.m_serverUtil.readJCL(iworkspace, jclfile);
    }

    public String getJobCommandline(JobInfo info) {
        return this.m_serverUtil.getJobCommandline(info);
    }

    public void showJobProperties(String title, ServerJobInfo job, ServerFlowInfo flow) {
        WAPropertyDialog propertydlg = new WAPropertyDialog(this.getMainFrame(), title, true);
        List<WAPropertyTab> tabs = JobNode.getPropertyTabs(this, job, flow);
        for (WAPropertyTab tab : tabs) {
            propertydlg.addTab(tab.getName(), tab);
        }
        propertydlg.pack();
        propertydlg.setEditable(false);
        WindowUtil.center((Window)propertydlg);
        propertydlg.show();
    }

    public void showSubflowProperties(String title, ServerFlowInfo subflow, ServerFlowInfo flow) {
        WAPropertyDialog propertydlg = new WAPropertyDialog(this.getMainFrame(), title, true);
        List<WAPropertyTab> tabs = JobNode.getPropertyTabs(this, subflow, flow);
        for (WAPropertyTab tab : tabs) {
            propertydlg.addTab(tab.getName(), tab);
        }
        propertydlg.pack();
        propertydlg.setEditable(false);
        WindowUtil.center((Window)propertydlg);
        propertydlg.show();
    }

    public int showJobAdvanceProperties(String title, JobInfo job, ServerFlowInfo flow, SchedulerServerInfo scheduler) {
        String userid = scheduler.getUsername();
        String cmdline = job.getCommandLine();
        if (cmdline == null && job.isCommandLineDerived()) {
            this.updateJobCommandline(job, flow.getName());
            cmdline = job.getCommandLine();
        }
        boolean editable = true;
        BatchServerInfo bsi = job.getBatchServer();
        if (bsi != null && bsi.getType() == 2 && bsi.getSubType() == 26) {
            LOGGER.debug(m_bundle.getString("ScheduleManager.VADesigner.CannotEdit.msg.txt"));
            editable = false;
        }
        AdvancePropertiesDialog dia = new AdvancePropertiesDialog(this, title, scheduler, userid, editable, flow.getName(), job, cmdline);
        dia.makeVisible();
        return dia.getReturnValue();
    }

    public void updateJobCommandline(JobInfo job, String flowname) {
        this.m_serverUtil.updateJobCommandline(job, flowname);
    }

    public void updateAppServerDirectories(SASAppServer server) {
        block2: {
            try {
                this.m_serverUtil.updateSASAppServerDirectories(server);
            }
            catch (SchedulerException e) {
                if (!ScheduleManager.isDebug()) break block2;
                e.printStackTrace();
            }
        }
    }

    public int showTimeEvent(String title, TimeEventInfo info, SchedulerServerInfo scheduler) throws SchedulerException {
        TimeEventInterface dlg = this.getTimeEventDialog(title, info, scheduler);
        dlg.makeVisible();
        return dlg.getReturnValue();
    }

    private TimeEventInterface getTimeEventDialog(String title, TimeEventInfo info, SchedulerServerInfo scheduler) throws SchedulerException {
        if (scheduler.getClassId().compareTo("a1661499-5d7d-4fcc-8fc3-c6509853e116") == 0) {
            Scheduler sch = this.m_serverUtil.getSchedulingServer(scheduler);
            LSFScheduler lsf = null;
            lsf = sch instanceof LSFScheduler ? (LSFScheduler)sch : new LSFScheduler(scheduler);
            if (!this.usePortableTimeEvent()) {
                LSFTimeEventDialog dlg = new LSFTimeEventDialog(this, title, lsf, info);
                return dlg;
            }
            boolean showTimezone = lsf.getTimeZoneOrientation().compareTo(Tzclient) == 0;
            TimeEventDialog dlg = new TimeEventDialog(this.getMainFrame(), title, info, showTimezone);
            return dlg;
        }
        TimeEventDialog dlg = new TimeEventDialog(this.getMainFrame(), title, info, false, scheduler.isLimitedSkipsDataBinding());
        return dlg;
    }

    public int showFileEvent(String title, FileEventInfo info) throws SchedulerException {
        FileEventDialog dlg = new FileEventDialog(this.getMainFrame(), title, info, (PromptCallbackInterface)this);
        dlg.makeVisible();
        return dlg.getReturnValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePluginChange(int eventType, NodeInterface parentNode, List pairList) {
        Vector targets;
        if (parentNode == null || this.m_pluginListenerList == null) {
            return;
        }
        ScheduleManager scheduleManager = this;
        synchronized (scheduleManager) {
            targets = (Vector)this.m_pluginListenerList.clone();
        }
        PluginChangeEvent event = new PluginChangeEvent((Object)this, eventType, parentNode, pairList);
        for (int index = 0; index < targets.size(); ++index) {
            PluginChangeListener target = (PluginChangeListener)targets.elementAt(index);
            target.pluginChange(event);
        }
    }

    public List<SchedulerServerInfo> getSchedulerServers(int type) {
        try {
            return this.m_serverUtil.getSchedulingServers(type);
        }
        catch (Exception ex) {
            if (ScheduleManager.isDebug()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public boolean isValidScheduler(SchedulerServerInfo scheduler) throws SchedulerException {
        return this.m_serverUtil.isValidScheduler(scheduler);
    }

    @Deprecated
    public boolean connectToSchedulingServer(SchedulerServerInfo scheduler, String user, String password) {
        return this.connectToSchedulingServer(scheduler, user, password != null ? new SealedString(password) : null);
    }

    public boolean connectToSchedulingServer(SchedulerServerInfo scheduler, String user, SealedString password) {
        int MaxCount = 3;
        ClassLoader classloader = ScheduleManager.class.getClassLoader();
        Thread currThread = Thread.currentThread();
        currThread.setContextClassLoader(classloader);
        int rc = 0;
        UserOptions userOptions = new UserOptions();
        this.m_userOptions.setManager(this);
        String timeZone = userOptions.getTimezoneOrientation();
        String stdout = userOptions.getDefaultStandardOutfile();
        String stderr = userOptions.getDefaultStandardErrfile();
        boolean scoping = userOptions.useFlowScoping();
        String flowDefDir = userOptions.getFlowDefinitionDirectory();
        int statusCheckTimeout = userOptions.getStatusCheckTimeout();
        int statusCheckCycle = userOptions.getStatusCheckCycle();
        int maxHistory = userOptions.getMaxFlowHistory();
        int maxHistoryPerFlow = userOptions.getMaxHistoryForFlow();
        int count = 0;
        while (rc == 0 && count < 3) {
            try {
                rc = this.m_serverUtil.makeSchedulerConnection(scheduler, user, password, timeZone, stdout, stderr, scoping, flowDefDir, statusCheckTimeout, statusCheckCycle, maxHistory, maxHistoryPerFlow);
                ++count;
            }
            catch (InvalidParameterException ex) {
                MessageUtil.displayMessage((Frame)Workspace.getWorkspace(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("ScheduleManager.CannotConnectToSchedulerTitle.txt"), (int)0);
                return false;
            }
            catch (SchedulerException ex) {
                ++count;
            }
        }
        return rc == 1;
    }

    public boolean isAutoReschedule() {
        UserOptions userOptions = new UserOptions();
        this.m_userOptions.setManager(this);
        return userOptions.isAutoRescheduleFlow();
    }

    public List<BatchServerInfo> getBatchServers(int type, int subtype) {
        try {
            return this.m_serverUtil.getBatchServers(type, subtype);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isValidBatchServer(BatchServerInfo batchserver) throws RemoteException {
        return this.m_serverUtil.isValidBatchServer(batchserver);
    }

    private static String getRepositoryID(ConsoleInterface console) {
        try {
            return console.getDefaultRepository().getFQID().substring(9);
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SASFolder selectFolders(String initfolder, SASFolder folder, String title) throws RemoteException {
        LinkedHashMap mapFileTypes = new LinkedHashMap();
        if (initfolder == null && folder != null) {
            initfolder = this.m_serverUtil.getFolderLocation(folder);
        }
        InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(initfolder, this.m_serverUtil.getDefaultUserContext(), mapFileTypes, true);
        panel.setSelectionMode(InformationServicesSelectorPanel.DIRECTORIES_ONLY);
        panel.setMultiSelectionEnabled(false);
        panel.setRootFolderSelectable(false);
        RemoteFileSelectorDialog dialog = null;
        dialog = new RemoteFileSelectorDialog(this.getMainFrame(), title, true, 2, (BaseRemoteFileSelectorPanel)panel);
        dialog.setAllowNonExistentSelections(false);
        dialog.setVisible(true);
        try {
            List lReturnedItems;
            if (!panel.isCancelled() && (lReturnedItems = panel.getReturnedInformation(true)) != null && !lReturnedItems.isEmpty()) {
                String value = lReturnedItems.get(0).toString();
                PathUrl pathUrl = new PathUrl(value);
                String folderPath = pathUrl.getDisplayPath();
                SASFolder sASFolder = this.m_serverUtil.getFolder(folderPath);
                return sASFolder;
            }
        }
        finally {
            dialog.dispose();
        }
        return null;
    }

    public String getFolderLocation(SASFolder finfo) throws RemoteException {
        return this.m_serverUtil.getFolderLocation(finfo);
    }

    public String XMLExport(ServerFlowInfo info, String name, DirectoryInfo dir, SASAppServer appServer) throws InvalidParameterException, SchedulerException {
        try {
            IWorkspace workspace = this.m_serverUtil.checkConnectionToWorkspaceServer(appServer, (PromptCallbackInterface)this);
            return this.m_serverUtil.XMLExport(workspace, info, name, appServer, dir);
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException(e.getLocalizedMessage());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (CallbackCancelledException e) {
            SchedulerException se = new SchedulerException(e.getLocalizedMessage());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public String XMLImport(IWorkspace workspace, String file, String title) throws RemoteException, IOException, SchedulerException {
        FlowInfo info = this.m_serverUtil.XMLImport(workspace, file, this.getMaximumPredecessorsPerJob());
        if (info == null) {
            MessageUtil.displayScrollableMessage((Frame)this.getMainFrame(), (String)m_bundle.messageString("ScheduleManager.CannotReadFromFile.Msg.fmt", (Object)file), (String)title, (int)0, (int)-1);
            return null;
        }
        if (this.commitFlowToOMR(info)) {
            return info.getName();
        }
        return null;
    }

    public String SASExport(ServerFlowInfo info, String name, DirectoryInfo dir, SASAppServer appServer) throws InvalidParameterException, SchedulerException {
        try {
            IWorkspace workspace = this.m_serverUtil.checkConnectionToWorkspaceServer(appServer, (PromptCallbackInterface)this);
            return this.m_serverUtil.SASExport(workspace, info, name, appServer, dir);
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException(e.getLocalizedMessage());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (CallbackCancelledException e) {
            SchedulerException se = new SchedulerException(e.getLocalizedMessage());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public String SASImport(IWorkspace workspace, String file, String title) throws RemoteException, IOException, SchedulerException {
        FlowInfo info = this.m_serverUtil.SASImport(workspace, file, this.getMaximumPredecessorsPerJob());
        if (info == null) {
            MessageUtil.displayScrollableMessage((Frame)this.getMainFrame(), (String)m_bundle.messageString("ScheduleManager.CannotReadFromFile.Msg.fmt", (Object)file), (String)title, (int)0, (int)-1);
            return null;
        }
        if (this.commitFlowToOMR(info)) {
            return info.getName();
        }
        return null;
    }

    public String CSVExport(ServerFlowInfo info, String name, DirectoryInfo dir, SASAppServer appServer) throws InvalidParameterException, SchedulerException {
        try {
            IWorkspace workspace = this.m_serverUtil.checkConnectionToWorkspaceServer(appServer, (PromptCallbackInterface)this);
            return this.m_serverUtil.CSVExport(workspace, info, name, appServer, dir);
        }
        catch (IOException e) {
            SchedulerException se = new SchedulerException(e.getLocalizedMessage());
            se.initCause((Throwable)e);
            throw se;
        }
        catch (CallbackCancelledException e) {
            SchedulerException se = new SchedulerException(e.getLocalizedMessage());
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public String CSVImport(IWorkspace workspace, String file, String title) throws RemoteException, IOException, SchedulerException {
        FlowInfo info = this.m_serverUtil.CSVImport(workspace, file, this.getMaximumPredecessorsPerJob());
        if (info == null) {
            MessageUtil.displayScrollableMessage((Frame)this.getMainFrame(), (String)file, (String)title, (int)0, (int)-1);
            return null;
        }
        if (this.commitFlowToOMR(info)) {
            return info.getName();
        }
        return null;
    }

    public boolean supportsDropOperations() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }

    public AboutInterface getAbout() {
        return new AboutScheduler();
    }

    public void dispose() {
        super.dispose();
        this.m_serverUtil.dispose();
        this.m_userOptions.closeExisting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SASFolder browseSASFolders(String initfolder) {
        LinkedHashMap mapFileTypes = new LinkedHashMap();
        InformationServicesSelectorPanel panel = new InformationServicesSelectorPanel(initfolder, this.m_serverUtil.getDefaultUserContext(), mapFileTypes, true);
        panel.setSelectionMode(InformationServicesSelectorPanel.DIRECTORIES_ONLY);
        panel.setMultiSelectionEnabled(false);
        panel.setRootFolderSelectable(false);
        RemoteFileSelectorDialog dialog = null;
        dialog = new RemoteFileSelectorDialog((Frame)null, m_bundle.getString("ScheduleManager.BrowseFolder.txt"), true, 2, (BaseRemoteFileSelectorPanel)panel);
        dialog.setAllowNonExistentSelections(false);
        dialog.setVisible(true);
        try {
            List lReturnedItems;
            if (!panel.isCancelled() && (lReturnedItems = panel.getReturnedInformation(true)) != null && !lReturnedItems.isEmpty()) {
                String value = lReturnedItems.get(0).toString();
                try {
                    SASFolder newFolder;
                    PathUrl pathUrl = new PathUrl(value);
                    String folder = pathUrl.getDisplayPath();
                    SASFolder sASFolder = newFolder = new SASFolder(folder);
                    return sASFolder;
                }
                catch (Exception e) {
                    SASFolder sASFolder = null;
                    dialog.dispose();
                    return sASFolder;
                }
            }
        }
        finally {
            dialog.dispose();
        }
        return null;
    }

    public boolean isFileSystemAccessible(SchedulerServerInfo sinfo) {
        return this.m_serverUtil.isFileSystemAccessible(sinfo);
    }

    public String browseFileSystem(SchedulerServerInfo sinfo, String title, String initpath, String filesepchar, boolean multiselect) {
        Frame frame = this.getMainFrame();
        LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
        fileTypes.put(m_bundle.getString("ScheduleManager.RemoteFileSelectorFileTypeText.txt"), "*");
        IWorkspace iworkspace = null;
        try {
            iworkspace = this.m_serverUtil.checkConnectionToWorkspaceServer(sinfo, (PromptCallbackInterface)this);
            if (iworkspace == null) {
                String message = m_bundle.getString("ScheduleManager.ErrorMsg.UnableToConnectToAppServer.txt");
                MessageUtil.displayMessage((Frame)frame, (String)message, (String)title, (int)0, (int)-1);
                return null;
            }
        }
        catch (RuntimeException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("ScheduleManager.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)frame, (String)message, (String)title, (int)0, (int)-1);
            return null;
        }
        catch (SchedulerException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("ScheduleManager.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)frame, (String)message, (String)title, (int)0, (int)-1);
            return null;
        }
        catch (CallbackCancelledException e) {
            e.printStackTrace();
            return null;
        }
        return this._browseFileSystem(iworkspace, -1, title, initpath, filesepchar, fileTypes, multiselect);
    }

    public String browseFileSystem(BatchServerInfo bsinfo, String title, String initpath, String filesepchar, boolean multiselect) {
        Frame frame = this.getMainFrame();
        LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
        fileTypes.put(m_bundle.getString("ScheduleManager.FileTypeDesc.txt"), m_bundle.getString("ScheduleManager.FileTypePattern.lcl"));
        IWorkspace iworkspace = null;
        try {
            iworkspace = this.m_serverUtil.checkConnectionToWorkspaceServer(bsinfo, (PromptCallbackInterface)this);
            if (iworkspace == null) {
                return null;
            }
        }
        catch (RuntimeException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("ScheduleManager.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)frame, (String)message, (String)title, (int)0, (int)-1);
            return null;
        }
        catch (SchedulerException e) {
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = m_bundle.getString("ScheduleManager.ErrorMsg.UnableToConnectToAppServer.txt");
            }
            MessageUtil.displayMessage((Frame)frame, (String)message, (String)title, (int)0, (int)-1);
            return null;
        }
        catch (CallbackCancelledException e) {
            e.printStackTrace();
            return null;
        }
        return this._browseFileSystem(iworkspace, bsinfo.getOperatingSystem(), title, initpath, filesepchar, fileTypes, multiselect);
    }

    private String _browseFileSystem(IWorkspace iworkspace, int os, String title, String initpath, String filesepchar, LinkedHashMap<String, String> fileTypes, boolean multiselect) {
        String file;
        IFileServiceSelectorPanel pnlSelector;
        Frame frame = this.getMainFrame();
        String msg = m_bundle.getString("ScheduleManager.BuildFileSelectorProgressIndicator.Message.txt");
        ProgressIndicator request = new ProgressIndicator(frame, msg, title);
        request.setDelayBeforeProgressCancelDialog(200);
        cRunnable_Files fileselector = new cRunnable_Files(iworkspace, os, initpath, fileTypes);
        request.execute((Runnable)fileselector);
        if (request.hasErrors()) {
            MessageUtil.displayMessage((Frame)frame, (String)request.getErrors(), (String)title, (int)0, (int)-1);
        }
        if ((pnlSelector = fileselector.getSelector()) == null) {
            MessageUtil.displayMessage((Frame)frame, (String)fileselector.getErrorMessage(), (String)title, (int)0, (int)-1);
            return null;
        }
        if (multiselect) {
            pnlSelector.setMultiSelectionEnabled(true);
        } else {
            pnlSelector.setMultiSelectionEnabled(false);
        }
        while (true) {
            ArrayList alFileList = null;
            try {
                alFileList = (ArrayList)IFileServiceSelectorPanel.showDialog((Frame)frame, (String)m_bundle.getString("ScheduleManager.FileSelection.txt"), (boolean)true, (int)0, (String)"", (IWorkspace)iworkspace, (boolean)true, (boolean)false, (IFileServiceSelectorPanel)pnlSelector);
            }
            catch (Exception ex) {
                MessageUtil.displayMessage((Frame)frame, (String)ex.getLocalizedMessage(), (String)title, (int)0, (int)-1);
                return null;
            }
            if (pnlSelector.isCancelled()) {
                return null;
            }
            if (alFileList == null || alFileList.size() <= 0) continue;
            file = (String)alFileList.get(0);
            for (int x = 1; x < alFileList.size(); ++x) {
                file = file + filesepchar + alFileList.get(x);
            }
            if (file != null && file.length() > 0) break;
            MessageUtil.displayMessage((Frame)frame, (String)m_bundle.getString("ScheduleManager.ErrorMsg.MissingProgram.txt"), (String)title, (int)0, (int)-1);
        }
        return file;
    }

    public String launchDirChooser(BatchServerInfo bsinfo, String title) {
        Frame frame = this.getMainFrame();
        IWorkspace iworkspace = null;
        try {
            iworkspace = this.m_serverUtil.checkConnectionToWorkspaceServer(bsinfo, (PromptCallbackInterface)this);
            if (iworkspace == null) {
                return null;
            }
        }
        catch (SchedulerException ex) {
            MessageUtil.displayMessage((Frame)frame, (String)ex.getLocalizedMessage(), (String)title, (int)0, (int)-1);
            return null;
        }
        catch (RuntimeException ex) {
            String message = ex.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = ex.toString();
            }
            MessageUtil.displayMessage((Frame)frame, (String)message, (String)title, (int)0, (int)-1);
            return null;
        }
        catch (CallbackCancelledException e) {
            e.printStackTrace();
            return null;
        }
        frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LinkedHashMap<String, String> fileTypes = new LinkedHashMap<String, String>();
            fileTypes.put(m_bundle.getString("ScheduleManager.RemoteFileSelectorFileTypeText.txt"), "*");
            IFileServiceSelectorPanel pnlSelector = null;
            pnlSelector = bsinfo.getOperatingSystem() == 2 ? new IFileServiceSelectorPanel(null, iworkspace, fileTypes, 2) : new IFileServiceSelectorPanel(null, iworkspace, fileTypes, true);
            pnlSelector.setSelectionMode(BaseRemoteFileSelectorPanel.DIRECTORIES_ONLY);
            pnlSelector.setMultiSelectionEnabled(false);
            ArrayList alFileList = (ArrayList)IFileServiceSelectorPanel.showDialog((Frame)frame, (String)m_bundle.getString("ScheduleManager.RemoteFileSelectorTitle.txt"), (boolean)true, (int)0, (String)"", (IWorkspace)iworkspace, (boolean)true, (boolean)true, (IFileServiceSelectorPanel)pnlSelector);
            if (alFileList != null && alFileList.size() > 0) {
                frame.setCursor(Cursor.getDefaultCursor());
                return (String)alFileList.get(0);
            }
        }
        catch (RuntimeException e) {
            frame.setCursor(Cursor.getDefaultCursor());
            String message = e.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = e.toString();
            }
            MessageUtil.displayMessage((Frame)frame, (String)message, (String)title, (int)0, (int)-1);
        }
        frame.setCursor(Cursor.getDefaultCursor());
        return null;
    }

    public void showResults(String title, SchedulerResultSet results) {
        Frame frame = this.getMainFrame();
        int rc = results.getReturnValue();
        if (rc != 2) {
            int count = results.getCount();
            switch (count) {
                case 0: 
                case 1: {
                    MessageUtil.displayMessage((Frame)frame, (String)results.getMessage(), (String)title, (int)results.getReturnValue(), (int)-1);
                    break;
                }
                default: {
                    MessageUtil.displayScrollableMessage((Frame)frame, (String)results.getMessage(), (String)title, (int)results.getReturnValue(), (int)-1);
                }
            }
        }
    }

    public int warningMessageOKCancel(String message, String title) {
        return MessageUtil.displayMessage((Frame)this.getMainFrame(), (String)message, (String)title, (int)2, (int)2);
    }

    public int promptMessage(String prompt, String title, Object[] options) {
        return JOptionPane.showOptionDialog(this.getMainFrame(), prompt, title, -1, 3, null, options, options[0]);
    }

    public String[] promptLogin(String title, String initUser, String initPassword) {
        LoginDialog dia = new LoginDialog(this.getMainFrame(), title);
        dia.setUserName(initUser);
        dia.setPasswordSealedString(initPassword != null ? new SealedString(initPassword) : null);
        dia.makeVisible();
        String[] rc = new String[]{String.valueOf(dia.getReturnValue()), dia.getUserName(), dia.getPasswordSealedString() != null ? String.valueOf(dia.getPasswordSealedString().getCharacters()) : null};
        return rc;
    }

    public void consoleChange(final ConsoleChangeEvent event) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    switch (event.getEventType()) {
                        case 3: {
                            AuthenticationClientHelper.setAuthentication((SessionContextInterface)Workspace.getWorkspace().getSessionContext());
                            DIPServiceProxy.clearAppContext((String)ScheduleManager.this.m_console.getServerUserId(), (SessionContextInterface)Workspace.getWorkspace().getSessionContext());
                            break;
                        }
                        case 4: {
                            AuthenticationClientHelper.clearAuthentication();
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Error setting security context for DIPServiceProxy", (Throwable)e);
                }
            }
        });
        t.start();
    }

    static {
        critsect = new Object();
        LOGGER = LogManager.getLogger(ScheduleManager.class);
    }

    protected static class cRunnable_Files
    implements Runnable {
        IWorkspace mc_workspace = null;
        int mc_os = -1;
        String mc_initialpath = null;
        IFileServiceSelectorPanel mc_fileList = null;
        LinkedHashMap<String, String> mc_fileTypes = null;
        String mc_errormsg = "";

        cRunnable_Files(IWorkspace iworkspace, int operatingsystem, String initpath, LinkedHashMap<String, String> fileTypes) {
            this.mc_workspace = iworkspace;
            this.mc_os = operatingsystem;
            this.mc_initialpath = initpath;
            this.mc_fileTypes = fileTypes;
        }

        public IFileServiceSelectorPanel getSelector() {
            return this.mc_fileList;
        }

        public String getErrorMessage() {
            return this.mc_errormsg;
        }

        @Override
        public void run() {
            try {
                this.mc_fileList = this.mc_os == 2 ? new IFileServiceSelectorPanel(this.mc_initialpath, this.mc_workspace, this.mc_fileTypes, 2) : new IFileServiceSelectorPanel(this.mc_initialpath, this.mc_workspace, this.mc_fileTypes, false);
                this.mc_fileList.setSelectionMode(BaseRemoteFileSelectorPanel.FILES_ONLY);
            }
            catch (Exception ex) {
                if (ScheduleManager.isDebug()) {
                    ex.printStackTrace();
                }
                this.mc_errormsg = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : ex.toString();
                this.mc_fileList = null;
            }
        }
    }

    private class cRunnable_batchResubmit
    implements Runnable {
        private FlowInfo mc_info;
        private PromptCallbackInterface mc_callback;
        private boolean mc_errorOnDelete;
        private SchedulerResultSet mc_results;

        public cRunnable_batchResubmit(FlowInfo info, PromptCallbackInterface callback, boolean errorOnDelete) {
            this.mc_info = info;
            this.mc_callback = callback;
            this.mc_errorOnDelete = errorOnDelete;
        }

        public SchedulerResultSet getResults() {
            return this.mc_results;
        }

        @Override
        public void run() {
            ServerFlowInfo flow = new ServerFlowInfo(this.mc_info, ScheduleManager.this.m_serverUtil, this.mc_callback);
            try {
                this.mc_results = ScheduleManager.this.m_serverUtil.batchResubmit(flow, this.mc_errorOnDelete);
            }
            catch (SchedulerException e) {
                this.mc_results = null;
            }
        }
    }

    private class cRunnable_batchSubmit
    implements Runnable {
        private ServerFlowInfo mc_info;
        private boolean mc_errorOnDelete;
        private SchedulerResultSet mc_results;
        private boolean mc_changesWritten;

        public cRunnable_batchSubmit(ServerFlowInfo info, boolean errorOnDelete) {
            this.mc_info = info;
            this.mc_errorOnDelete = errorOnDelete;
        }

        public SchedulerResultSet getResults() {
            return this.mc_results;
        }

        public boolean triggerChanges() {
            return this.mc_changesWritten;
        }

        @Override
        public void run() {
            try {
                this.mc_changesWritten = this.mc_info.updateTriggers();
                if (this.mc_changesWritten) {
                    this.mc_results = ScheduleManager.this.m_serverUtil.submitFlow(this.mc_info, true, this.mc_errorOnDelete);
                }
            }
            catch (SchedulerException e) {
                this.mc_changesWritten = false;
                if (ScheduleManager.isDebug()) {
                    e.printStackTrace();
                }
                this.mc_results = new SchedulerResultSet(0, e.toString(), (DisplayInfo)this.mc_info);
            }
        }
    }

    private class cRunnable_getJFJobs
    implements Runnable {
        List<JobInfo> mc_fulljfjoblist = null;
        boolean mc_readFromServer = false;
        Exception mc_exception = null;

        public cRunnable_getJFJobs(boolean readFromServer) {
            this.mc_readFromServer = readFromServer;
        }

        public List<JobInfo> getList() {
            return this.mc_fulljfjoblist;
        }

        public Exception getException() {
            return this.mc_exception;
        }

        @Override
        public void run() {
            try {
                this.mc_fulljfjoblist = ScheduleManager.this.getAllJobsAndFlows();
            }
            catch (Exception e) {
                this.mc_fulljfjoblist = null;
                this.mc_exception = e;
            }
        }
    }
}

