/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ScheduleFlowAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ScheduleFlowAction.class);
    private Object[] m_elementList;
    private ScheduleManager m_schmgr;
    private FlowNode m_node;

    public ScheduleFlowAction(ServerFlowInfo info, ScheduleManager plugin, FlowNode node) {
        this.m_elementList = new Object[1];
        this.m_elementList[0] = info;
        this.m_schmgr = plugin;
        this.m_node = node;
        this.setMenuItem();
    }

    public ScheduleFlowAction(Object[] flowList, ScheduleManager plugin) {
        this.m_elementList = flowList;
        this.m_schmgr = plugin;
        this.setMenuItem();
    }

    private void setMenuItem() {
        String nameText = m_bundle.getString("ScheduleFlowAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_ScheduleFlow));
        this.putValue("ShortDescription", m_bundle.getString("ScheduleFlowAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        int flows = this.m_elementList.length;
        for (int index = 0; index < flows; ++index) {
            String message;
            try {
                ServerFlowInfo info = (ServerFlowInfo)this.m_elementList[index];
                if (!this.m_schmgr.interactiveSubmit(info)) {
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("ScheduleFlowAction.CannotSchedule.Msg.fmt", (Object)info.getName()), (String)m_bundle.getString("ScheduleFlowAction.CannotSchedule.Title.txt"), (int)0, (int)-1);
                }
                try {
                    if (this.m_node == null) continue;
                    this.m_node.refreshIcons();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            catch (SchedulerException ex) {
                message = m_bundle.messageString("ScheduleFlowAction.CannotSchedule.Msg.fmt", (Object)ex.getMessage());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ScheduleFlowAction.CannotSchedule.Title.txt"), (int)0, (int)-1);
                continue;
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
                message = m_bundle.getString("ScheduleFlowAction.CannotSchedule.Msg.txt");
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ScheduleFlowAction.CannotSchedule.Title.txt"), (int)0, (int)-1);
                continue;
            }
            catch (RuntimeException ex) {
                message = m_bundle.messageString("ScheduleFlowAction.CannotSchedule.Msg.fmt", (Object)ex.toString());
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("ScheduleFlowAction.CannotSchedule.Title.txt"), (int)0, (int)-1);
            }
        }
    }
}

