/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.console.ConsoleChangeEvent;
import com.sas.console.ConsoleChangeListener;
import com.sas.console.ConsoleInterface;
import com.sas.console.filter.visuals.FilterTableView;
import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.AbstractNode;
import com.sas.console.plugins.CustomViewInterface;
import com.sas.console.plugins.IntObjPair;
import com.sas.console.plugins.NodeInterface;
import com.sas.console.plugins.PluginNavigationInterface;
import com.sas.console.plugins.TableModelInterface;
import com.sas.filter.model.FilterSelector;
import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.FlowColumnSelectorModel;
import com.sas.scheduler.model.FlowInfo;
import com.sas.scheduler.model.JobInfo;
import com.sas.scheduler.model.PromptCallbackInterface;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.ClearSchedulerCacheAction;
import com.sas.scheduler.schmgr.DataStepProgramDeployerAction;
import com.sas.scheduler.schmgr.DeploymentDirectoriesAction;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.ImportFlowAction;
import com.sas.scheduler.schmgr.ManageJobsAction;
import com.sas.scheduler.schmgr.NewFlowAction;
import com.sas.scheduler.schmgr.OptionsAction;
import com.sas.scheduler.schmgr.RescheduleAllFlowsAction;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.SchedulerConsoleAction;
import com.sas.scheduler.schmgr.ValidateCmdLineAction;
import com.sas.scheduler.schmgr.model.FlowsTableModel;
import com.sas.scheduler.schmgr.visuals.NewFlowDialog;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerUtilities;
import com.sas.scheduler.server.ServerUtilitiesListener;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.scheduler.visuals.swing.OperationThread;
import com.sas.scheduler.visuals.swing.ProgressIndicator;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class RootNode
extends AbstractNode
implements ServerUtilitiesListener {
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(RootNode.class);
    private ScheduleManager m_schmgr;
    private ConsoleInterface m_console;
    private Vector<FlowNode> m_flowNodeList;
    private Vector<ServerFlowInfo> m_infoList;
    private int m_flowGrouping = 0;
    private FlowsTableModel m_tableModel;
    private boolean m_hasinitialized = false;
    private FilterTableView m_pane = null;
    private FilterSelector m_filter = null;
    private ArrayList<AbstractAction> m_actionList = null;
    private UserContextInterface m_userContext = null;
    private boolean m_stupidUserOption = false;

    public RootNode(PluginNavigationInterface pInterface, String name) {
        super(pInterface, name);
        String idiot = System.getProperty("sas.schedule.nocirculardependencycheck");
        if (idiot != null && idiot.equals("true")) {
            this.m_stupidUserOption = true;
        }
        this.m_schmgr = (ScheduleManager)pInterface;
        this.m_console = this.m_schmgr.getConsole();
        this.m_console.addConsoleListener((ConsoleChangeListener)this);
        this.m_flowNodeList = new Vector();
        this.m_infoList = new Vector();
        this.m_filter = this.m_schmgr.getDefaultFlowsRule();
    }

    public boolean setFilter(FilterSelector filter) {
        if (filter != null) {
            this.m_filter = filter;
            this.m_pane.setFilter(this.m_filter);
            return true;
        }
        return false;
    }

    public List<AbstractAction> getContextMenuActions() {
        if (this.m_actionList == null) {
            this.m_actionList = new ArrayList(6);
            this.m_actionList.add(new NewFlowAction(this.m_schmgr, this.m_userContext));
            this.m_actionList.add(new DeploymentDirectoriesAction(this.m_schmgr));
            this.m_actionList.add(new RescheduleAllFlowsAction(this.m_schmgr));
            this.m_actionList.add(new DataStepProgramDeployerAction(this.m_schmgr));
            this.m_actionList.add(new ManageJobsAction(this.m_schmgr));
            this.m_actionList.add(new ClearSchedulerCacheAction(this.m_schmgr));
            if (this.m_schmgr.isImportActivated()) {
                this.m_actionList.add(new ImportFlowAction(this, this.m_schmgr));
            }
            if (this.m_schmgr.isValidateCmdlineActivated()) {
                this.m_actionList.add(new ValidateCmdLineAction(this.m_schmgr));
            }
            if (this.m_schmgr.isConsoleActivated()) {
                this.m_actionList.add(new SchedulerConsoleAction(this.m_schmgr, this.m_userContext));
            }
            this.m_actionList.add(new OptionsAction(this.m_schmgr));
        }
        return this.m_actionList;
    }

    public CustomViewInterface getCustomView() {
        if (this.m_pane == null) {
            this.m_pane = new FilterTableView(this.m_schmgr.getWorkspaceFile(), (NodeInterface)this, (NeoTableModelInterface)((FlowsTableModel)this.getListViewData()), this.m_filter);
        }
        return this.m_pane;
    }

    public Vector<FlowNode> getListofFlows() {
        return this.m_flowNodeList;
    }

    public void willExpand(TreeExpansionEvent event) throws ExpandVetoException {
        if (this.m_flowNodeList.size() == 0) {
            this.repopulateFlows();
        }
        if (this.m_flowNodeList.size() == 0) {
            this.m_hasinitialized = true;
            throw new ExpandVetoException(event, m_bundle.getString("RootNode.NoFlows.txt"));
        }
    }

    public void expanded(TreeExpansionEvent event) {
        this.m_hasinitialized = true;
    }

    public void collapsed(TreeExpansionEvent event) {
    }

    public TableModelInterface getListViewData() {
        if (this.m_tableModel == null) {
            try {
                if (!this.m_hasinitialized) {
                    this.refresh();
                    this.m_hasinitialized = true;
                }
                this.m_tableModel = new FlowsTableModel((NodeInterface)this, this.m_infoList, this.m_filter, new FlowColumnSelectorModel(0));
            }
            catch (RuntimeException ex) {
                String message = ex.toString();
                String lmessage = ex.getLocalizedMessage();
                if (lmessage != null && lmessage.length() > 0) {
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)lmessage, (String)m_bundle.getString("RootNode.ErrorMsg.Title.txt"), (int)0, (int)-1);
                }
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("RootNode.ErrorMsg.Title.txt"), (int)0, (int)-1);
            }
        }
        return this.m_tableModel;
    }

    public List<AbstractAction> getToolBarActions() {
        this.m_schmgr.clearChallengeCallbackHandler();
        return this.getContextMenuActions();
    }

    public void refresh() {
        if (!this.m_console.isConnected() || this.m_console.getDefaultRepository() == null) {
            return;
        }
        this.m_schmgr.clearJobsAndFlows();
        this.m_schmgr.clearServerCaches();
        NewFlowDialog.clearCache();
        this.repopulateFlows();
    }

    private void repopulateFlows() {
        block4: {
            if (!this.m_stupidUserOption) {
                try {
                    this.getAllFlowsAndJobs();
                }
                catch (Exception ex) {
                    if (!ScheduleManager.isDebug()) break block4;
                    ex.printStackTrace();
                }
            }
        }
        if (this.getChildCount() > 0) {
            this.removeAll();
        }
        this.populateFlowNodes();
    }

    public void refreshFlows() {
        for (FlowNode node : this.m_flowNodeList) {
            if (!node.hasInitialized()) continue;
            node.refresh();
        }
    }

    public void removeAll() {
        int count = this.m_flowNodeList.size();
        for (int index = count - 1; index >= 0; --index) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        FlowNode node = this.m_flowNodeList.get(index);
        this.m_flowNodeList.remove(index);
        this.m_infoList.remove(index);
        IntObjPair ioPair = new IntObjPair(index, (Object)node);
        Vector<IntObjPair> childList = new Vector<IntObjPair>();
        childList.add(ioPair);
        this.m_schmgr.firePluginChange(0, (NodeInterface)this, childList);
    }

    public boolean isLeaf() {
        return this.m_flowNodeList.size() > 0;
    }

    public boolean getAllowsChildren() {
        if (!this.m_hasinitialized) {
            return true;
        }
        return this.m_flowNodeList.size() > 0;
    }

    public Icon getIcon(int size) {
        return this.m_schmgr.getIcon(size);
    }

    public FlowNode addFlowNode(ServerFlowInfo flow) {
        int index = this.getChildCount();
        FlowNode node = new FlowNode((PluginNavigationInterface)this.m_schmgr, flow.getName(), flow);
        node.setParent((MutableTreeNode)((Object)this));
        this.m_flowNodeList.add(index, node);
        this.m_infoList.add(index, flow);
        this.insert((MutableTreeNode)((Object)node), index);
        Vector<IntObjPair> childList = new Vector<IntObjPair>(0);
        IntObjPair ioPair = new IntObjPair(index, (Object)node);
        childList.add(ioPair);
        this.m_schmgr.firePluginChange(1, (NodeInterface)this, childList);
        return node;
    }

    public void consoleChange(ConsoleChangeEvent event) {
        switch (event.getEventType()) {
            case 3: {
                this.initialize();
                break;
            }
            case 1: {
                if (this.m_userContext != null) break;
                this.initialize();
                break;
            }
            case 2: {
                SessionContextInterface sessionContext = this.m_console.getSessionContext();
                if (sessionContext == null || this.m_console.getDefaultRepository() == null) {
                    this.m_userContext = null;
                }
            }
            case 12: {
                if (this.m_hasinitialized) {
                    if (this.m_flowNodeList.size() > 0) {
                        this.removeAll();
                    }
                    this.m_hasinitialized = false;
                }
                this.cleanup();
            }
            case 9: {
                this.m_schmgr.getServerUtilities().removeFactoryListener((ServerUtilitiesListener)this);
                break;
            }
            case 4: {
                this.m_schmgr.getServerUtilities().setDefaultSessionContext(null);
                break;
            }
        }
    }

    private void initialize() {
        block10: {
            this.m_actionList = null;
            try {
                SessionContextInterface sessionContext = this.m_console.getSessionContext();
                if (sessionContext != null) {
                    UserContextInterface userContext = sessionContext.getUserContext();
                    ServerUtilities serverUtil = new ServerUtilities(sessionContext, userContext);
                    this.m_schmgr.setServerUtilities(serverUtil);
                } else {
                    this.m_userContext = null;
                }
            }
            catch (RemoteException re) {
                this.m_userContext = null;
            }
            catch (SchedulerException re) {
                this.m_userContext = null;
            }
            if (this.m_console.isConnected()) {
                try {
                    this.m_schmgr.secondaryInitialization(true);
                    if (!this.m_stupidUserOption) {
                        this.getAllFlowsAndJobs();
                    }
                }
                catch (Exception e) {
                    if (!ScheduleManager.isDebug()) break block10;
                    e.printStackTrace();
                }
            }
        }
        if (this.m_schmgr.getServerUtilities().setFactoryListener((ServerUtilitiesListener)this)) {
            this.getContextMenuActions();
        }
    }

    private void cleanup() {
        if (this.m_tableModel != null) {
            this.m_tableModel.cleanup();
        }
        this.m_schmgr.clearJobsAndFlows();
        this.m_schmgr.clearServerCaches();
        NewFlowDialog.clearCache();
        this.m_userContext = null;
        this.m_actionList = null;
    }

    public Enumeration<FlowNode> children() {
        return this.m_flowNodeList.elements();
    }

    public int getChildCount() {
        if (this.getPlugin().getConsole().getDefaultRepository() == null) {
            return 0;
        }
        return this.m_flowNodeList.size();
    }

    public TreeNode getChildAt(int index) {
        return this.m_flowNodeList.get(index);
    }

    private void populateFlowNodes() {
        if (this.m_console.isConnected()) {
            try {
                String str1 = m_bundle.getString("Common.BuildMetadataProgressIndicator.Message.txt");
                String str2 = m_bundle.getString("Common.BuildMetadataProgressIndicator.Title.txt");
                ProgressIndicator request = new ProgressIndicator(this.m_schmgr.getMainFrame(), str1, str2);
                request.setDelayBeforeProgressCancelDialog(1200);
                request.execute((Runnable)new cRunnable());
            }
            catch (RuntimeException ex) {
                String message = ex.toString();
                String lmessage = ex.getLocalizedMessage();
                if (lmessage != null && lmessage.length() > 0) {
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)lmessage, (String)m_bundle.getString("RootNode.ErrorMsg.Title.txt"), (int)0, (int)-1);
                }
                MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)message, (String)m_bundle.getString("RootNode.ErrorMsg.Title.txt"), (int)0, (int)-1);
            }
        }
        this.m_console.setStatusLineText(m_bundle.messageString("RootNode.StatusLine.fmt", (Object)String.valueOf(this.m_flowNodeList.size())));
    }

    public void ObjectsCreated(EventObject obj) throws RemoteException {
        FlowInfo info = (FlowInfo)obj.getSource();
        this.addFlowNode(new ServerFlowInfo(info, this.m_schmgr.getServerUtilities(), (PromptCallbackInterface)this.m_schmgr));
        JobInfo subflow = new JobInfo(info.getName(), info.getId(), null);
        subflow.setDisplayOnly(true);
        subflow.setAsSubflow();
        this.m_schmgr.addFlowToList(subflow);
    }

    public void ObjectsDeleted(EventObject obj) throws RemoteException {
        String strID = (String)obj.getSource();
        for (int j = 0; j < this.m_flowNodeList.size(); ++j) {
            FlowNode node = this.m_flowNodeList.get(j);
            if (!node.getFlowInfo().getId().equalsIgnoreCase(strID)) continue;
            this.m_schmgr.removeJobFromList(node.getFlowInfo().getId());
            this.remove(j);
            break;
        }
    }

    public void ObjectsModified(EventObject obj) throws RemoteException {
        String strID = (String)obj.getSource();
        for (int j = 0; j < this.m_flowNodeList.size(); ++j) {
            FlowNode node = this.m_flowNodeList.get(j);
            if (!node.getFlowInfo().isDataGathered() || !node.getFlowInfo().getId().equalsIgnoreCase(strID)) continue;
            node.refreshOnUpdate();
            break;
        }
    }

    public void dispose() {
        this.m_schmgr.getServerUtilities().removeFactoryListener((ServerUtilitiesListener)this);
        this.m_console.removeConsoleListener((ConsoleChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllFlowsAndJobs() {
        RootNode rootNode = this;
        synchronized (rootNode) {
            OperationThread threadOperation = new OperationThread("ALLFLOWSANDJOBS", (Runnable)new cRunnableGenerateInfo(), (Runnable)new cRunnableComplete());
            threadOperation.startThread();
        }
    }

    private class cRunnableComplete
    implements Runnable {
        cRunnableComplete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            cRunnableComplete cRunnableComplete2 = this;
            synchronized (cRunnableComplete2) {
            }
        }
    }

    private class cRunnableGenerateInfo
    implements Runnable {
        cRunnableGenerateInfo() {
        }

        @Override
        public void run() {
            try {
                RootNode.this.m_schmgr.getAllJobsAndFlows();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private class cRunnable
    implements Runnable {
        cRunnable() {
        }

        @Override
        public void run() {
            SortedSet list = RootNode.this.m_schmgr.getServerUtilities().getFlowsFromRepository(RootNode.this.m_flowGrouping, true);
            if (list == null) {
                MessageUtil.displayMessage((Frame)RootNode.this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("RootNode.PopulateFlowNodeException.fmt"), (String)m_bundle.getString("RootNode.ErrorMsg.Title.txt"), (int)0, (int)-1);
                return;
            }
            for (FlowInfo flow : list) {
                RootNode.this.addFlowNode(new ServerFlowInfo(flow, RootNode.this.m_schmgr.getServerUtilities(), (PromptCallbackInterface)RootNode.this.m_schmgr));
            }
        }
    }
}

