/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.GeneralOptionsTab;
import com.sas.scheduler.schmgr.visuals.OSSchedulerOptionsTab;
import com.sas.scheduler.schmgr.visuals.PlatformComputingOptionsTab;
import com.sas.scheduler.schmgr.visuals.ValidationOptionsTab;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class OptionsAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(OptionsAction.class);
    private ScheduleManager m_schmgr;

    public OptionsAction(ScheduleManager plugin) {
        this.m_schmgr = plugin;
        String nameText = m_bundle.getString("OptionsAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_Options));
        this.putValue("ShortDescription", m_bundle.getString("OptionsAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        WAPropertyDialog dialog = new WAPropertyDialog(this.m_schmgr.getMainFrame());
        dialog.setTitle(m_bundle.getString("OptionsAction.Title.txt"));
        dialog.setModal(true);
        dialog.setApplyButtonVisible(false);
        dialog.setHelpProduct("scheduler");
        dialog.setHelpTopic("window_flow_options");
        GeneralOptionsTab gtab = new GeneralOptionsTab(this.m_schmgr.getUserOptions(), this.m_schmgr);
        dialog.addTab(gtab.getName(), (WAPropertyTab)gtab);
        ValidationOptionsTab vtab = new ValidationOptionsTab(this.m_schmgr.getUserOptions());
        dialog.addTab(vtab.getName(), (WAPropertyTab)vtab);
        PlatformComputingOptionsTab ptab = new PlatformComputingOptionsTab(this.m_schmgr.getUserOptions());
        dialog.addTab(ptab.getName(), (WAPropertyTab)ptab);
        OSSchedulerOptionsTab otab = new OSSchedulerOptionsTab(this.m_schmgr, this.m_schmgr.getUserOptions());
        dialog.addTab(otab.getName(), (WAPropertyTab)otab);
        dialog.show();
        if (dialog.getReturnValue() == 1) {
            this.m_schmgr.setAllowFlowPrefixForLogfile(this.m_schmgr.getUserOptions());
            this.m_schmgr.setOutputfile(this.m_schmgr.getUserOptions());
        }
    }
}

